var container="";
Ext.define('ComponentMeasureTabSet.controller.TrendGraph', {
	extend: 'Ext.app.Controller',
	requires:['ComponentMeasureTabSet.view.TrendGraphFilters'],
	views:['ComponentMeasureTabSet.view.TrendGraph','ComponentMeasureTabSet.view.TrendGraphFilters','ComponentMeasureTabSet.view.SummaryGraphFilters','ComponentMeasureTabSet.view.MeasureGraphFilters'],
	refs:[{
		ref : 'descriptionCombo',
		selector : 'trendgraphfilters combo[itemId= "infolist"]'
	},{
		ref:'main',
		selector:'main'
	},{
		ref:'trendGraph',
		selector:'trendgraph'
	},{
		ref:'trendGraphFilters',
		selector:'trendgraphfilters'
	},{
		ref:'measureGraphFilters',
		selector:'measuregraphfilters'
	},{
		ref:'summaryGraphFilters',
		selector:'summarygraphfilters'
	},{
		ref:'graphMode',
		selector:'trendgraphfilters panel combo[action=graphmode]'
	},{
		ref:'graphDuration',
		selector:'trendgraphfilters panel combo[action=period]'
	},{
		ref:'graphStartHour',
		selector:'trendgraph panel combo[action=starthr]'
	},{
		ref:'graphEndHour',
		selector:'trendgraph panel combo[action=endhr]'
	},{
		ref:'graphStartDate',
		selector:'trendgraph panel datefield[action=fromdate]'
	},{
		ref:'graphEndDate',
		selector:'trendgraph panel datefield[action=todate]'
	},{
		ref:'DescriptionForGraph',
		selector:'trendgraphfilters panel combo[itemId= "infolist"]'
	},{
		ref:'descriptionValue',
		selector:'trendgraphfilters panel combo[action=infolist]'
	},{
		ref:'measureForGraph',
		selector:'trendgraphfilters panel combo[action=measurelist]'
	},{
		ref:'infolistCombo',
		selector:'trendgraphfilters panel combo[action=infolist]'
	},{
		ref:'graphTimeline',
		selector:'trendgraph panel slider'
	},{
		ref:'trendGraphButton',
		selector:'trendgraph panel button[action=graph]'
	}],	
	mode:'3D',
	init: function() {
		this.control({
			'trendgraphfilters':{
				render: function(){
					//this.enableHourCombos();
				}
			},
			'trendgraphfilters toolbar button[action=closewindow]':{
				click: function(){
					this.getTrendGraphFilters().up('container').hide();
					this.getTrendGraphFilters().close();
					
				}
			},
			//'trendgraph panel toolbar image[action=graphFilters]':{
			'image[action=trengraphFilters]':{
				click: function(image){
					this.trendFilters();
				},
				mouseover:this.displayTooltip
			},
			'trendgraph panel slider[action=timelinechange]':{
				changecomplete: function(slider, newValue, thumb, eOpts){
					//this.trendFilters();
					this.enableHourCombos();
					this.submitFilters(true, 'timelinechange');	
				},
				/*afterrender: function(){
					this.enableHourCombos();		
				}*/
			},
			//'trendgraph panel toolbar label[action=mode]':{
			'label[action=trenmode]':{
				click: function(label) {
					this.mode=label.ttext;
					this.submitFilters(true, 'trenmode' );
					var tabBar = Ext.getCmp('tabToolBar');
					if(!Ext.isEmpty(tabBar))
						tabBar.removeAll();
					var toolbar = this.getTrendGraph().tabToolBar;

					if(toolbar.items[0].ttext=='2D')
						toolbar.items[0].ttext = '3D';
					else
						toolbar.items[0].ttext = '2D';

					var tbar = this.getMain().tabBar;
					tbar.addTool([{xtype: "tbfill"},toolbar]);
				},
				//mouseover:this.displayTooltip
			},
			'trendgraphfilters toolbar button[action=graph]':{
				click: function(){					
					this.submitFilters(true, 'graph' );
				}
			},
			'trendgraph panel button[action=graph]':{
				click: function(){					
					this.submitFilters(true, 'graph' );
				}
			},
			'trendgraphfilters trigger[name="descriptionOpt"]':
			{
				'keyup': this.descriptorOptSelect
			},
			//'button[action=trendData]':{
				'image[action=trendData]':{
				click: function()
				{
					var graphmode='';
					if (!Ext.isEmpty(this.getGraphMode()))
					{
						graphmode=this.getGraphMode().getValue();
					}
					//var graphmode=this.getGraphMode().getValue();
					var url=requestParams.activeTabUrl;
					url=url.substring(url.indexOf("?")+1,url.indexOf("&tabSetPage=true"));
					url=this.appendToURL(url);
					if(url!=-1)
					{
						if(graphmode!=null & graphmode==='avg')
						{	
							window.open("/final/servlet/com.eg.AvgTrendGraph?" + (url +"&rType=Data&requestFrom=Avg"),"TrendReport","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes,location=no");
						}
						else if(graphmode!=null & graphmode==='sum')
						{
							window.open("/final/servlet/com.eg.AvgTrendGraph?" + (url +"&rType=Data&requestFrom=Sum"),"TrendReport","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes,location=no");
						}
						else
						{
							window.open("/final/servlet/com.eg.TrendGraph?" + (url +"&rType=Data"),"TrendReport","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes,location=no");
						}
					}
				}
			},
			/*
			'trendgraphfilters toolbar button[action=data]':{
				click: function(){
					var graphmode=this.getGraphMode().getValue();
					var url=requestParams.activeTabUrl;
					url=url.substring(url.indexOf("?")+1,url.indexOf("&tabSetPage=true"));					
					url=this.appendToURL(url);
					if(url!=-1){
						if(graphmode!=null & graphmode==='avg')
						{	
							window.openWindow("/final/servlet/com.eg.AvgTrendGraph?" + encodeURI(url +"&rType=Data&requestFrom=Avg"),"TrendReport","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes,location=no");
						}
						else if(graphmode!=null & graphmode==='sum')
						{
							window.openWindow("/final/servlet/com.eg.AvgTrendGraph?" + encodeURI(url +"&rType=Data&requestFrom=Sum"),"TrendReport","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes,location=no");
						}
						else
						{
							window.openWindow("/final/servlet/com.eg.TrendGraph?" + encodeURI(url +"&rType=Data"),"TrendReport","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes,location=no");
						}
					}
				}
			},*/
			'trendgraphfilters panel combo[action=period]': {
				select: function(){
					this.submitFilters(true, 'period');
				}
			}
		});
	},
	trendFilters:function(){
		if(!Ext.isEmpty(this.getSummaryGraphFilters()))
		{
			this.getSummaryGraphFilters().destroy();
			if(container != undefined)
				container.destroy();
		}
		if(!Ext.isEmpty(this.getMeasureGraphFilters()))
		{
			this.getMeasureGraphFilters().destroy();
			if(container != undefined)
				container.destroy();
		}
		if(!Ext.isEmpty(this.getTrendGraphFilters()))
		{
			this.getTrendGraphFilters().destroy();
			if(container != undefined)
				container.destroy();
		}

		var VWidth = Ext.Element.getViewportWidth( );
					
					if(!this.getTrendGraphFilters() || container.isHidden() ){
						
						var win=Ext.create('ComponentMeasureTabSet.view.TrendGraphFilters');
						win.createItems(this.getTrendGraph().data);
						win.show();
						
						container = Ext.create('Ext.container.Container',{
						padding:5,
						floating:true,
						frame:true,
						width:650,
						hidden:true,
						//height:500,
						floatable:true,
						//id:'configMod',
						cls:'configMode_popup',
						items:[
							{
								xtype:'container',
								cls:'configMode_popupArrow',
								style:{'top':'-13px','left':'581px'}
							},
							{
								xtype:'container',
								html:'<div style="float:left;margin:0px 0px 0px 4px;color: #f7f7f7;" class="settingsfont"><b>SETTINGS</b></div><div style="text-align:right;float:right;"><div class="iconClose3"></div></div>',
								style:{'top':'0px','margin':'2px'}
							},		
								win
							]
						});
						Ext.create('Ext.fx.Anim', {
									target: container,
									duration: 500,
									from: {
									   
										left: VWidth -655,
										top:-500
									},
									to: {
									   top:50,
										left: VWidth -655
									}
								});
						
						
						container.showAt(VWidth -655,5000);
						Ext.select('.iconClose3').on('click',function(){
							
								Ext.create('Ext.fx.Anim', {
									
									target: container,
									duration: 500,
									from: {
									   
										left: VWidth -655,
										top:50
									},
									to: {
									   top:-500,
										left: VWidth -655
									},
									callback: function(){
										container.destroy();
										
									   }
								});
							
						},this);
						
					
					}
					/*else if(container.isHidden()){
						var win=this.getTrendGraphFilters();
						win.show();
						Ext.create('Ext.fx.Anim', {
									target: container,
									duration: 500,
									from: {
									   
										left: VWidth -515,
										top:-500
									},
									to: {
									   top:50,
										left: VWidth -515
									}
								});
						
						
						container.showAt(VWidth -515,5000);
						//win.setPosition(image.x+20-win.getWidth(),image.y+60);
						//win.setPosition(this.getMain().getWidth() - win.getWidth(),image.y+40);
					}*/
					else{
						//this.getTrendGraphFilters().hide();
						//this.getTrendGraphFilters().up('container').hide();
						container.destroy();
					}
	},
	enableHourCombos: function(){
		var tLine=this.getTrendGraph().timelineData.items[this.getGraphTimeline().getValue()].value;
		if(!Ext.isEmpty(this.getTrendGraphFilters())){
			if(tLine==="Any"){
				this.getGraphStartHour().enable();
				this.getGraphEndHour().enable();
				this.getGraphStartDate().enable();
				this.getGraphEndDate().enable();
			}else{
				this.getGraphStartHour().disable();
				this.getGraphEndHour().disable();	
				this.getGraphStartDate().disable();
				this.getGraphEndDate().disable();
			}
		}		
	},

	submitFilters: function(graphBtnClicked, fromFunction){
		var url=requestParams.activeTabUrl;
		if(this.getInfolistCombo()!=null)
		{
			var infoObj =  this.getInfolistCombo().getValue();
			var compObj = this.getInfolistCombo();
			var valid=false;
			var defval=descriptorRawData[0].value;
		
			for(var i=0;i<descriptorRawData.length;i++){			
				if(descriptorRawData[i].name==infoObj)
					valid=true;
				else if(descriptorRawData[i].value==infoObj)
					valid=true;
			}


						
			if(infoObj == '-1' || infoObj==null || !valid)
			{
				Ext.MessageBox.show({
						title : 'Alert',
						msg : 'Please choose a valid descriptor',
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING,
						fn:function(buttonId){
						Ext.getCmp("descriptionOpt").setValue("");
						var compStore = descriptorRawData;
						compStore = descriptorRawData;
						compObj.getStore().removeAll(); 
						compObj.getStore().loadRawData(compStore);
						//var value = compObj.getStore().getAt(0).get('value');
						var value;
							if(Ext.isEmpty(compObj.getStore().getAt(0)))
								value =defval;
							else
								value = compObj.getStore().getAt(0).get('value');

							compObj.setValue(value);
						
						}
					});
				
				return false;
			}
		}
		url=this.appendToURL(url, fromFunction);
		//url = encodeURI(url);
		if (url!=null && url.indexOf('#')>-1)
		{
			url=url.replace('#','|hash|');
		}
		if(url!=-1){
			Ext.Ajax.request({
				url : url,
				method : 'POST',
				scope:this,
				success : function(response, opts){				
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					
					//if( !Ext.isEmpty( jQuery('#trendId') ) )
						//jQuery('#trendId').highcharts().destroy();

					this.getTrendGraph().removeAll();
					this.getTrendGraph().createTabUI(jsonData);
					if(graphBtnClicked===true){
						/*if(!Ext.isEmpty(this.getTrendGraphFilters().up('container')))
						{
							this.getTrendGraphFilters().up('container').hide();
							this.getTrendGraphFilters().close();
						}*/
						if(!Ext.isEmpty(container))
						{
							container.destroy();
						}
						
					}					
				},
				failure : function(){alert("failure");}
			});
		}		
	},
	appendToURL: function(url, actionFrom ){
		var tLine=this.getTrendGraph().timelineData.items[this.getGraphTimeline().getValue()].value;
		
		
		if(Ext.isEmpty(this.getTrendGraphFilters())){
			var win=Ext.create('ComponentMeasureTabSet.view.TrendGraphFilters');
			win.createItems(this.getTrendGraph().data);
		}	
		var period=this.getGraphDuration().getValue();
		var graphmode=this.getGraphMode().getValue();
		if(!Ext.isEmpty(actionFrom) && actionFrom == 'period')
			tLine = (period == 'D')?'1 week':(period == 'M' )?'6 months':'24 hours';
		url+='&timeLine='+tLine;
		var endtime=Ext.Date.format(this.getGraphEndDate().getValue(),'m/d/Y');
		var starttime=Ext.Date.format(this.getGraphStartDate().getValue(),'m/d/Y');
		var currTime=Ext.Date.format(new Date(),'m/d/Y');
		var starttimeDummy=Ext.Date.parse(this.getGraphStartDate().getValue(),'m/d/Y');
		var endtimeDummy=Ext.Date.parse(this.getGraphEndDate().getValue(),'m/d/Y');
		var currTimeDummy=new Date();
		
		var starthr = parseInt(this.getGraphStartHour().getValue());
		var endhr = parseInt(this.getGraphEndHour().getValue());
		var measure= this.getMeasureForGraph().getValue();

		if(tLine == 'Any' && dateValidation(starttime,endtime,starthr,endhr,0,0)==-1)
		{
			Ext.Msg.alert("Error",this.getTrendGraph().data.DateErrormsg);
			return -1;
		}


	/*	/////////////////////////
			var styear = parseInt(starttime.substring((starttime.lastIndexOf("/")+1)));
			var stday = parseInt(starttime.substring((starttime.indexOf("/")+1),starttime.lastIndexOf("/")));
			var stmon = parseInt(starttime.substring(0,starttime.indexOf("/")));
			var endyear = parseInt(endtime.substring((endtime.lastIndexOf("/")+1)));
			var endday = parseInt(endtime.substring((endtime.indexOf("/")+1),endtime.lastIndexOf("/")));
			var endmon = parseInt(endtime.substring(0,endtime.indexOf("/")));
			var state=0;

		
			if(styear > endyear)			
				state=-1;		
			else if(styear == endyear)			
				if(stmon > endmon)				
					state=-1;				
				else if(stmon == endmon)
					if(stday > endday)						
						state=-1;		
		
			if(state == -1 &&  tLine.toLowerCase() == 'any')
			{				
				Ext.Msg.alert("Error",this.getTrendGraph().data.DateErrormsg);
				return -1;
			}
*/


		/*if( tLine.toLowerCase() == 'any' )
		{
			if(starttime > currTime || endtime > currTime){
				//if(starttimeDummy > currTimeDummy || endtimeDummy > currTimeDummy){
					Ext.Msg.alert("Error",this.getTrendGraph().data.CurrentDateError);
					return -1;
				//}
			}
		      if(starttime > endtime){			
				Ext.Msg.alert("Error",this.getTrendGraph().data.DateErrormsg);
				return -1;
			}
			else if(starttime === endtime){
				if(starthr >= endhr){
					Ext.Msg.alert("Error",this.getTrendGraph().data.DateErrormsg);
					return -1;
				}
			}		
		}

		*/
		url+="&starttime="+starttime+"&endtime="+endtime+"&starthr="+starthr+"&endhr="+endhr+"&graphmode="+graphmode;
		url = url.replace(/(measure=)[^\&]+/, '$1' + measure);
		url = url.replace(/(period=)[^\&]+/, '$1' + period);
		url = url.replace(/(mode=)[^\&]+/, '$1' + this.mode);
		if(!Ext.isEmpty(this.getDescriptionForGraph())){
			url = url.replace(/(info=)[^\&]+/, '$1' + encodeURIComponent(this.getDescriptionForGraph().getValue()));
		}
		return url;
	},
	displayTooltip: function(image)
	{
		if(!Ext.isEmpty(this.getTrendGraph().toolTip))
		{
			var tip = this.getTrendGraph().toolTip;
			tip.setTarget(image.id);
			tip.update(image.tooltip);
			tip.show();
		}
	},
		descriptorOptSelect :function(obj, event)
	{
		var findVal = obj.getValue();
		var mainForm = this.getTrendGraphFilters();
		var compStore = descriptorRawData;
		//var compObj = this.getDetailediagnosis().getComponent("infolist");
		var compObj = this.getInfolistCombo();
		var isRecordFound = false;
		if ( Ext.isEmpty( obj.getValue() ) )
		{
			compStore = descriptorRawData;
			compObj.getStore().removeAll(); 
			compObj.getStore().loadRawData(compStore);
			var value = compObj.getStore().getAt(0).get('value');
			compObj.setValue(value);
		}
		else
		{
			var genStore = new Ext.data.Store({
									fields : ['name', 'value'],
									data : []
								});
			if(findVal!=null)
				findVal=findVal.toLowerCase();
			for ( var i = 0; i < compStore.length ; i++ )
			{
				var getRecord = compStore[i]['name'];
				if(getRecord!=null)
					getRecord=getRecord.toLowerCase();
				if ( getRecord.indexOf(findVal) > -1 )
				{
					isRecordFound = true;
					genStore.add({
						'name': compStore[i]['name'],
						'value': compStore[i]['value']
					});
				}
			}
			if ( isRecordFound )
			{
				compObj.getStore().removeAll(); 
				for ( var i = 0; i < genStore.getCount() ; i++ )
				{
					var getRecord = genStore.getAt(i);
					compObj.getStore().add(getRecord);
				}
				console.log("genStore",genStore.getAt(0).get('value'));
				compObj.setValue(genStore.getAt(0).get('value'));
			}
			else
			{
				compObj.getStore().removeAll();
				compObj.getStore().add({
					'name': 'Not Applicable!',
					'value': '-1'
				});
				if(findVal=="")
				{
					compObj.setValue(genStore.getAt(0).get('value'));
				}
				else
				{
					compObj.setValue("-1");
				}
			}
			obj.focus();
		 }
	}
});