var jsonTempData='';
Ext.require([ 
    'Ext.form.Panel',
    'Ext.ux.form.MultiSelect'
]);
Ext.define('ComponentMeasureTabSet.view.CitrixLogonFilters', {
	extend: 'Ext.window.Window',
	alias:'widget.CitrixLogonFilters',
	header:false,
	//padding:'5',
	flotable:false,
	floating:false,
	//id:'meaureFilter',
	itemId:'citrixLogonFilter',
	resizable: false,
	padding:'5 5 0 5',
	buttonAlign:'center',
	defaults:{labelSeparator:''},
	layout:{
		type: 'hbox',
		align: 'stretch'
	},
	//closable:false,

	cls:'tabsetsettingsWindow measure-graph-panel',	
	initComponent : function(){
	this.callParent();
	},
	createFilters:function(jsonData,timeData){
		// jp code started here
		if(Ext.isEmpty(jsonData) && !Ext.isEmpty(jsonTempData) )
		{   
			jsonTempDataCheck=true;
			jsonData=jsonTempData;
		}
		else
		{
			jsonTempData='';
			jsonTempDataCheck=false;
		}
		// jp code ended here
		var itemsArray=new Array();
		var cnt=0;
		var item=this.createCombo(timeData);
		var selTime = Ext.getCmp('innerDiagram').ctime;
		if(!Ext.isEmpty(selTime))
		{
			var isCon = false;
			for (var p in timeData['options'] )
			{
				var el = timeData['options'][p];
				var el_v = el.value;
				if(el_v == selTime)
				{
					item.value = selTime;
					isCon = true;
					break;
				}
			}
			if(!isCon)
				Ext.getCmp('innerDiagram').ctime=null;
			
		}
		if(!Ext.isEmpty(item)){
			itemsArray.push(item);
		}
		
		try
		{
				for(var i=0;i<jsonData.filters.length;i++){
				
				var filter=jsonData.filters[i];
				
				if(filter.id != 'timeline' && cnt == 0){
					continue;
				}
				
				item=this.createFilterItem(filter);
				
				if(!Ext.isEmpty(item)){
					itemsArray.push(item);
					cnt++;
				}
				
			}
		}
		catch (ee)
		{
		}
		
		return itemsArray;
	},
	
	createFilterItem:function(filter){
		var item=null;
		if(Ext.isEmpty(filter.type)){
			filter.type="label"
		}
		if(filter.id=="timeline"){
			this.timeLine = filter.selectedValue;
		}
		
		var data;
				
		if(filter.type=="date"){
			data = filter.selectedValue;			
			
			if(data == "Invalid Date"){
				data = new Date(filter.selectedValue);
			}
		}

		switch(filter.type){
			
			case "combo": 	item=this.createCombo(filter);
							break;
			case "scrollcombo":item=this.createCombo(filter);
								break;
			case "date": item={
								xtype:'datefield',
								cls : 'datepicker detailed-diagnosis-datefield',
								fieldLabel:filter.name,
								format:requestParams.mgr_dateFormat,
								value:data,
								width:100,
								itemId:filter.id,
								id:filter.id,
								columnWidth:0.1,
								labelAlign: 'top',
								editable : false,
								margin:'0 10 0 0',
								listeners:{
									change: function (combo) {
										ctxSubmitClick();
									}
								}
							};
							if(this.timeLine!="Any"){
								item.disabled = true;
							}
							break;
			/*case "button":
						 item={
							xtype:'button',
							text:filter.text,
							id:'submitCtx',
							//disabled:true,
							action : 'submit',
							cls : 'button20',
							margin:rumSubmit,
							padding:0,
							height:20,
							handler:function(){
									//ctxSubmitClick();
									var combo = Ext.getCmp('ctxTimeLine');
									ctxMsmtComboChange(combo);
							}
						 };
						 if(this.timeLine!="Any"){
								//item.disabled = true;
							}
				break;*/

			case "trigger":
						item={
							fieldLabel: 'Search',
							xtype: 'triggerfield',
							id:'descriptionOpt',
							hidden:true,
							name:'descriptionOpt',
							enableKeyEvents : true,
							labelAlign: 'top',
							cls: 'whitedropdown_search',
							width: 150,
						};
				break;
		}
		return item;
	},
	
	createCombo:function(filter){
		
		var isEdit=true;
		var type="scrollcombo";
		var comboStore = Ext.create('Ext.data.Store',{
			fields:['value','name'],
			proxy:{
				type: 'memory',
				reader: {
	            	type: 'json',
	            	root:'options'
	        	}
			},
			data:filter
		});

		var marginStr = "0 10 0 0";
		if(filter.id == 'ctxTimeLine')
			marginStr = "0 10 0 10";
		else if(filter.id == 'toMin')
			marginStr = "0 0 0 0";
		
		var v_val = filter.selectedValue;
		var t_time = Ext.getCmp('innerDiagram').ttime;
		if(!Ext.isEmpty(t_time)){
			if(filter.id == "timeline")
			{
				v_val = t_time;
				this.timeLine = t_time;
			}
		}
		var item={
				xtype:type,
				editable : isEdit,
				store:comboStore,
				cls : 'dropdown detailed-diagnosis-combo',
				displayField:'name',
				valueField:'value',
				trigerAction:'all',
				labelAlign: 'top',
				fieldLabel:filter.name,
				value:v_val,
				itemId:filter.id,
				id:filter.id,
				queryMode:'local',
				margin:marginStr,
		};
			
		switch(filter.id){
			case "timeline": 
							item.width=100;
							item.listeners = {
								select: function (combo) {
									ctxComboTimeLineChange(combo);
								}
							};
				break;
			case "ctxTimeLine":
							item.width=150;
							item.listeners = {
								select: function (combo) {
									ctxMsmtComboChange(combo);
								},
								afterrender:function()
									{
										if(jsonTempDataCheck)
										{
											if(filter.id == 'ctxTimeLine')
											{
												this.getStore().removeAll();
												this.getStore().loadRawData('');
												this.setValue('-1');
												this.setRawValue('Not Applicable');
												this.setDisabled(true);
											}
										}
								   }
							};
				break;
			case "fromHr":
							item.listeners = {
								select: function (combo) {
									ctxSubmitClick();
								}
							};
							item.width=60;
							if(this.timeLine !="Any"){
								item.disabled = true;
							}
				break;
			case "toHr":
							item.width=60;
							item.listeners = {
								select: function (combo) {
									ctxSubmitClick();
								}
							};
							if(this.timeLine !="Any"){
								item.disabled = true;
							}
				break;
			case "fromMin":
							item.width=60;
							if(this.timeLine !="Any"){
								item.disabled = true;
							}
							item.listeners = {
								select: function (combo) {
									ctxSubmitClick();
								}
							};
				break;
			case "toMin":
				 			item.width=60;
							item.listeners = {
								select: function (combo) {
									ctxSubmitClick();
								}
							};
							if(this.timeLine !="Any"){
								item.disabled = true;
							}
				break;
			}
			return item;
	}

});

function ctxComboTimeLineChange(combo){
	try
	{
		var timeLineCombo = combo.getValue();
		var ctx_tab = Ext.getCmp('innerDiagram');
		ctx_tab.ttime=timeLineCombo;
		var ctx_configMod=Ext.getCmp('ctx_configMod');
		try{
		   if(hidepdf)
			{
				Ext.getCmp('savedonutpdfId').show();
				Ext.getCmp('tbseparatorId').show();
			}
		}
		catch(e)
		{
			console.log(e);
		}
		if(timeLineCombo == 'Any')
		{
			Ext.getCmp('toMin').setDisabled(false);
			Ext.getCmp('fromMin').setDisabled(false);
			Ext.getCmp('toHr').setDisabled(false);
			Ext.getCmp('fromHr').setDisabled(false);
			Ext.getCmp('fromdate').setDisabled(false);
			Ext.getCmp('todate').setDisabled(false);
			//Ext.getCmp('submitCtx').setDisabled(false);
		}else{
			Ext.getCmp('toMin').setDisabled(true);
			Ext.getCmp('fromMin').setDisabled(true);
			Ext.getCmp('toHr').setDisabled(true);
			Ext.getCmp('fromHr').setDisabled(true);
			Ext.getCmp('fromdate').setDisabled(true);
			Ext.getCmp('todate').setDisabled(true);
			//Ext.getCmp('submitCtx').setDisabled(true);
			
			if(!Ext.isEmpty(ctx_tab.mask)){
				ctx_tab.mask.show();
			}
			var ctx_url = requestParams.activeTabUrl;
			ctx_url = reformUrl(ctx_url);
			ctx_url+='&timeline='+timeLineCombo+'&pageNo=1&tlineJsonOnly=No&reqType=regFromTimeline';
			ctxRefreshUrl = ctx_url; 
			var countURL = ctx_url+"&isCountRecords=Yes";
			ctx_tab.ctime=null;
			
			Ext.Ajax.request({
				url : countURL,
				method : 'POST',
				scope : this,
				timeout:1280000,
				success : function(response, opts) {
					var jsonText = response.responseText;
					var jsontimeData = Ext.decode(jsonText);
					if(!Ext.isEmpty(jsontimeData) && !Ext.isEmpty(jsontimeData.selectedValue) && jsontimeData.selectedValue != '-1' ){
						var ctxDataUrl = ctx_url+'&selectedCtxTime='+jsontimeData.selectedValue;
						//ctxRefreshUrl = ctxDataUrl;
						//ctxRefreshUrl = ctx_url;
						Ext.Ajax.request({
							url : ctxDataUrl,
							//url : ctx_url,
							method : 'POST',
							scope : this,
							timeout:280000,
							success : function(response, opts) {
								var jsonText = response.responseText;
								var jsonData = Ext.decode(jsonText);
								ctx_tab.createTabUI(jsonData,jsontimeData);
								ctx_tab.data = jsonData;
								ctx_tab.timeData = jsontimeData;
								if(!Ext.isEmpty(ctx_configMod))
									updateComboValues(jsonData,jsontimeData);

							},
							failure : function() {
								if(!Ext.isEmpty(ctx_tab.mask)){
									ctx_tab.mask.hide();
								}
							}
						});
					}else{
						ctx_tab.createTabUI(null);
						if(!Ext.isEmpty(ctx_configMod)){
							var ctxTimeLine = Ext.getCmp('ctxTimeLine');
							if(!Ext.isEmpty(ctxTimeLine) && !Ext.isEmpty(jsontimeData)){
								ctxTimeLine.getStore().removeAll();
								ctxTimeLine.getStore().loadRawData('');
								ctxTimeLine.setValue('-1');
								ctxTimeLine.setRawValue('Not Applicable');
								ctxTimeLine.setDisabled(true);
							}
						}

					}
					
				},
				failure : function() {
					if(!Ext.isEmpty(ctx_tab.mask)){
						ctx_tab.mask.hide();
					}
				}
			});
		}
	}
	catch (e)
	{
	}
}

function ctxSubmitClick(){
	try
	{
		var ctxTimeLine = Ext.getCmp('timeline');
		var msmtTimeLine = Ext.getCmp('ctxTimeLine');
		var timeLineCombo = ctxTimeLine.getValue();
		//By JP - code started 
		try{
		   if(hidepdf)
			{
				Ext.getCmp('savedonutpdfId').show();
				Ext.getCmp('tbseparatorId').show();
			}
		}
		catch(e)
		{
			console.log(e);
		}
		//By JP - code ended 
		if(timeLineCombo == 'Any'){
			var to_min = Ext.getCmp('toMin').getValue();
			var from_min = Ext.getCmp('fromMin').getValue();
			var to_hr = Ext.getCmp('toHr').getValue();
			var from_hr = Ext.getCmp('fromHr').getValue();
			var from_date = Ext.getCmp('fromdate').getValue();
			var to_date = Ext.getCmp('todate').getValue();
			if(!Ext.isEmpty(from_date))
				from_date=Ext.Date.format(from_date,'m/d/Y');
			if(!Ext.isEmpty(to_date))
				to_date=Ext.Date.format(to_date,'m/d/Y');
			 
			var ctx_tab = Ext.getCmp('innerDiagram');
			if(!Ext.isEmpty(ctx_tab.mask)){
				ctx_tab.mask.show();
			}
			
			if(dateValidation(from_date,to_date,from_hr,to_hr,from_min,to_min)==-1)
			{
				Ext.Msg.alert("Error","From date should be lesser than To date");
				if(!Ext.isEmpty(ctx_tab.mask)){
					ctx_tab.mask.hide();
				}
				return ;
			}
			
			var ctx_url = requestParams.activeTabUrl;
			ctx_url = reformUrl(ctx_url);
			ctx_url+='&timeline=Any&starttime='+from_date+'&endtime='+to_date+'&starthr='+from_hr+'&endhr='+to_hr+'&startmin='+from_min+'&endmin='+to_min+'&pageNo=1&tlineJsonOnly=No&reqType=regFromTimeline';
			ctxRefreshUrl = ctx_url; 
			var countURL = ctx_url+"&isCountRecords=Yes";
			Ext.Ajax.request({
				url : countURL,
				method : 'POST',
				scope : this,
				timeout:1280000,
				success : function(response, opts) {
					var jsonText = response.responseText;
					var jsontimeData = Ext.decode(jsonText);
					jsonTempData=jsontimeData;
					var selTime = ctx_tab.ctime;
					if(!Ext.isEmpty(jsontimeData) && !Ext.isEmpty(jsontimeData.selectedValue) && jsontimeData.selectedValue != '-1' ){
						try
						{
							if(!Ext.isEmpty(selTime)){
								for(var p in jsontimeData.options){
									var t_time = jsontimeData.options[p].value;
									if(t_time == selTime){
										jsontimeData.selectedValue = t_time;
										break;
									}
								}
							}
						}
						catch (e)
						{
						}
						var ctxDataUrl =ctx_url+'&selectedCtxTime='+jsontimeData.selectedValue;
						//ctxRefreshUrl = ctxDataUrl;
						Ext.Ajax.request({
							url : ctxDataUrl,
							//url : ctx_url,
							method : 'POST',
							scope : this,
							timeout:280000,
							success : function(response, opts) {
								var jsonText = response.responseText;
								var jsonData = Ext.decode(jsonText);
								ctx_tab.createTabUI(jsonData,jsontimeData);
								ctx_tab.data = jsonData;
								ctx_tab.timeData = jsontimeData;
								var ctx_configMod=Ext.getCmp('ctx_configMod');
								if(!Ext.isEmpty(ctx_configMod))
									updateComboValues(jsonData,jsontimeData);

							},
							failure : function() {
								if(!Ext.isEmpty(ctx_tab.mask)){
									ctx_tab.mask.hide();
								}
							}
						});
					}else{
						ctx_tab.createTabUI(null);
						if(!Ext.isEmpty(ctx_configMod)){
							if(!Ext.isEmpty(ctxTimeLine) && !Ext.isEmpty(jsontimeData)){
								ctxTimeLine.getStore().removeAll();
								ctxTimeLine.getStore().loadRawData('');
								ctxTimeLine.setValue('-1');
								ctxTimeLine.setRawValue('Not Applicable');
								ctxTimeLine.setDisabled(true);
							}
							if(!Ext.isEmpty(msmtTimeLine) && !Ext.isEmpty(jsontimeData)){
								msmtTimeLine.getStore().removeAll();
								msmtTimeLine.getStore().loadRawData('');
								msmtTimeLine.setValue('-1');
								msmtTimeLine.setRawValue('Not Applicable');
								msmtTimeLine.setDisabled(true);
							}
						}
						else
						{
							if(!Ext.isEmpty(msmtTimeLine) && !Ext.isEmpty(jsontimeData)){
								msmtTimeLine.getStore().removeAll();
								msmtTimeLine.getStore().loadRawData('');
								msmtTimeLine.setValue('-1');
								msmtTimeLine.setRawValue('Not Applicable');
								msmtTimeLine.setDisabled(true);
							}
						}
					}
				},
				failure : function() {
					if(!Ext.isEmpty(ctx_tab.mask)){
						ctx_tab.mask.hide();
					}
				}
			});
		}
		else{
			var ctx_tab = Ext.getCmp('innerDiagram');
			var ctx_configMod=Ext.getCmp('ctx_configMod');
			Ext.getCmp('toMin').setDisabled(true);
			Ext.getCmp('fromMin').setDisabled(true);
			Ext.getCmp('toHr').setDisabled(true);
			Ext.getCmp('fromHr').setDisabled(true);
			Ext.getCmp('fromdate').setDisabled(true);
			Ext.getCmp('todate').setDisabled(true);
			//Ext.getCmp('submitCtx').setDisabled(true);
			
			if(!Ext.isEmpty(ctx_tab.mask)){
				ctx_tab.mask.show();
			}
			var ctx_url = requestParams.activeTabUrl;
			ctx_url = reformUrl(ctx_url);
			ctx_url+='&timeline='+timeLineCombo+'&pageNo=1&tlineJsonOnly=No&reqType=regFromTimeline';
			ctxRefreshUrl = ctx_url; 
			var countURL = ctx_url+"&isCountRecords=Yes";
			ctx_tab.ctime=null;
			
			Ext.Ajax.request({
				url : countURL,
				method : 'POST',
				scope : this,
				timeout:1280000,
				success : function(response, opts) {
					var jsonText = response.responseText;
					var jsontimeData = Ext.decode(jsonText);
					if(!Ext.isEmpty(jsontimeData) && !Ext.isEmpty(jsontimeData.selectedValue) && jsontimeData.selectedValue != '-1' ){
						var ctxDataUrl = ctx_url+'&selectedCtxTime='+jsontimeData.selectedValue;
						//ctxRefreshUrl = ctxDataUrl;
						//ctxRefreshUrl = ctx_url;
						Ext.Ajax.request({
							url : ctxDataUrl,
							//url : ctx_url,
							method : 'POST',
							scope : this,
							timeout:280000,
							success : function(response, opts) {
								var jsonText = response.responseText;
								var jsonData = Ext.decode(jsonText);
								ctx_tab.createTabUI(jsonData,jsontimeData);
								ctx_tab.data = jsonData;
								ctx_tab.timeData = jsontimeData;
								if(!Ext.isEmpty(ctx_configMod))
									updateComboValues(jsonData,jsontimeData);

							},
							failure : function() {
								if(!Ext.isEmpty(ctx_tab.mask)){
									ctx_tab.mask.hide();
								}
							}
						});
					}else{
						ctx_tab.createTabUI(null);
						if(!Ext.isEmpty(ctx_configMod)){
							var ctxTimeLine = Ext.getCmp('ctxTimeLine');
							if(!Ext.isEmpty(ctxTimeLine) && !Ext.isEmpty(jsontimeData)){
								ctxTimeLine.getStore().removeAll();
								ctxTimeLine.getStore().loadRawData('');
								ctxTimeLine.setValue('-1');
								ctxTimeLine.setRawValue('Not Applicable');
								ctxTimeLine.setDisabled(true);
							}
						}

					}
					
				},
				failure : function() {
					if(!Ext.isEmpty(ctx_tab.mask)){
						ctx_tab.mask.hide();
					}
				}
			});
		}

	}
	catch (e)
	{
	}
	
}

function ctxMsmtComboChange(combo){
	try
	{
		var ctxTimeLine = Ext.getCmp('timeline');
		var msmtTimeLine = Ext.getCmp('ctxTimeLine');
		var timeLineCombo = ctxTimeLine.getValue();
		try{
		   if(hidepdf)
			{
				Ext.getCmp('savedonutpdfId').show();
				Ext.getCmp('tbseparatorId').show();
			}
		}
		catch(e)
		{
			console.log(e);
		}
		//By JP - code started 
		var to_min ="";
		var from_min ="";
		var to_hr ="";
		var from_hr ="";
		var from_date ="";
		var to_date ="";
		var isTimeLineAny = false;
		if(timeLineCombo == 'Any'){
			isTimeLineAny =true;
			to_min = Ext.getCmp('toMin').getValue();
			from_min = Ext.getCmp('fromMin').getValue();
			to_hr = Ext.getCmp('toHr').getValue();
			from_hr = Ext.getCmp('fromHr').getValue();
			from_date = Ext.getCmp('fromdate').getValue();
			to_date = Ext.getCmp('todate').getValue();

			if(!Ext.isEmpty(from_date))
				from_date=Ext.Date.format(from_date,'m/d/Y');
			if(!Ext.isEmpty(to_date))
				to_date=Ext.Date.format(to_date,'m/d/Y');
			 
			var ctx_tab = Ext.getCmp('innerDiagram');
			if(!Ext.isEmpty(ctx_tab.mask)){
				ctx_tab.mask.show();
			}

			if(dateValidation(from_date,to_date,from_hr,to_hr,from_min,to_min)==-1)
			{
				Ext.Msg.alert("Error","From date should be lesser than To date");
				if(!Ext.isEmpty(ctx_tab.mask)){
					ctx_tab.mask.hide();
				}
				return ;
			}
		}
		//By JP - code ended
		var selectedMsmtTime = combo.getValue();
		var ctx_tab = Ext.getCmp('innerDiagram');
		if(!Ext.isEmpty(ctx_tab.mask) && !Ext.isEmpty(ctxRefreshUrl) ) {
			ctx_tab.mask.show();
			var comboChangeUrl  = requestParams.activeTabUrl;

			//By JP - code started 
			if(isTimeLineAny)
			{
				comboChangeUrl = reformUrl(comboChangeUrl);
				comboChangeUrl+='&timeline=Any&starttime='+from_date+'&endtime='+to_date+'&starthr='+from_hr+'&endhr='+to_hr+'&startmin='+from_min+'&endmin='+to_min+'&pageNo=1&tlineJsonOnly=No&reqType=regFromTimeline';
			}
			else
			{
				comboChangeUrl=replaceUrlParam(comboChangeUrl,'timeline',timeLineCombo);
			}		
			//By JP - code end
			//if(ctxRefreshUrl.indexOf('&selectedCtxTime') != -1)
			//	comboChangeUrl =  ctxRefreshUrl.substring(0,ctxRefreshUrl.indexOf('&selectedCtxTime'));
			comboChangeUrl +='&selectedCtxTime='+selectedMsmtTime;
			ctx_tab.ctime=selectedMsmtTime;
			//ctxRefreshUrl = comboChangeUrl;
			Ext.Ajax.request({
				url : comboChangeUrl,
				//url : ctx_url,
				method : 'POST',
				scope : this,
				timeout:280000,
				success : function(response, opts) {
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);					
					//By JP - code started 
					if(isTimeLineAny)
					{
						ctx_tab.data = jsonData;
					}
					//By JP - code ended 

					ctx_tab.createTabUI(jsonData,0);
				},
				failure : function() {
					if(!Ext.isEmpty(ctx_tab.mask)){
						ctx_tab.mask.hide();
					}
				}
			});
			
		}
	}
	catch (e)
	{
		console.log('e-->',e)
	}
}

function updateComboValues(jsonData,jsontimeData){
	try
	{
		var ctxTimeLine = Ext.getCmp('ctxTimeLine');
		if(!Ext.isEmpty(ctxTimeLine) && !Ext.isEmpty(jsontimeData)){
			ctxTimeLine.getStore().removeAll();
			ctxTimeLine.getStore().loadRawData(jsontimeData.options);
			ctxTimeLine.setValue(jsontimeData.selectedValue);
			ctxTimeLine.setDisabled(false);
			var cnt = 0;
			for(var i=0;i<jsonData.filters.length;i++){
				var filter=jsonData.filters[i];
				if(filter.id != 'timeline' && cnt == 0)
					continue;
				try
				{
					cnt++;
					var el =  Ext.getCmp(filter.id);
					if(!Ext.isEmpty(el))
						el.setValue(filter.selectedValue);
				}
				catch (e)
				{
				}
			}
		}
	}
	catch (e)
	{
	}
}
var paramEscape = ['timeline','starttime','endtime','starthr','endhr','startmin','endmin'];
function reformUrl(url){
	try
	{
		var tempUrl = '';
		if(!Ext.isEmpty(url) && url.indexOf('?') != -1){
			var page=url.substring(0,url.indexOf('?')+1);
			var remains=url.substring(url.indexOf('?')+1);
			var params_arr = remains.split('&');
			var remains_url='';
			for(var a in params_arr){
				var param = params_arr[a];
				var paramKeyArr = param.split('=');
				if(paramEscape.indexOf(paramKeyArr[0]) != -1)
					continue;
				remains_url += param+'&';
			}
			if(!Ext.isEmpty(remains_url))
				remains_url = remains_url.substring(0,remains_url.length-1);

			tempUrl = page+remains_url;
			return tempUrl;
		}
	}
	catch (e)
	{
		console.log(e)
	}
	return url;

}
var anyParamEscape = ['starttime','endtime','starthr','endhr','startmin','endmin'];
function replaceUrlParam(url,key,value){ //&pageNo=1&tlineJsonOnly=No&reqType=regFromTimeline
	try
	{
		var isNeedRemoveParam = false;
		if(value != "Any")
		{
			isNeedRemoveParam = true;
		}
		var tempUrl = '';
		if(!Ext.isEmpty(url) && url.indexOf('?') != -1){
			var page=url.substring(0,url.indexOf('?')+1);
			var remains=url.substring(url.indexOf('?')+1);
			var params_arr = remains.split('&');
			var remains_url='';
			for(var a in params_arr){
				var param = params_arr[a];
				var paramKeyArr = param.split('=');

				if(isNeedRemoveParam && anyParamEscape.indexOf(paramKeyArr[0]) > -1)
					continue;

				if(key==paramKeyArr[0])
				{
					var paramKey  = key+"="+value;
					remains_url += paramKey+'&';
				}
				else
					remains_url += param+'&';
			}
			if(!Ext.isEmpty(remains_url))
				remains_url = remains_url.substring(0,remains_url.length-1);

			tempUrl = page+remains_url;
			return tempUrl;
		}
	}
	catch (e)
	{
		console.log(e)
	}
	return url;
}
