var container="";
Ext.define('ComponentMeasureTabSet.view.CompareGraph', {
	extend: 'Ext.panel.Panel',
	alias:'widget.compgraph',
	requires:['ComponentMeasureTabSet.store.Measures'],
	requires:['ComponentMeasureTabSet.view.CompareGraphFilters'],
	url:null,
	tabToolBar:null,
	items : [],
	//layout:'fit',
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	toolTip:Ext.create('Ext.tip.ToolTip',{anchor:'bottom'}),
	data:null,
	saveURL:null,
	dataURL:null,
	mask:null,
	graphInfoStore:null,
	timelineData:null,
	chartOption:null,
	cls:'compare-graph-panel',
	createTabUI:function(jsonData){
		var me=this;
		me.data=jsonData;
		me.saveURL=jsonData.saveURL;
		me.dataURL=jsonData.dataURL;
		var rightMiddlePanel = this.createPanelRightMiddle(jsonData);
		var labelText,timelineObj,timelineVal;
		for(var i=0; i< jsonData.FormFields.length; i++){
			if(jsonData.FormFields[i].name=="timeline"){	
				this.timelineData=jsonData.FormFields[i];
				timelineObj=jsonData.FormFields[i];
				for(var j=0;j<timelineObj.items.length;j++){
					if(timelineObj.items[j].value==timelineObj.selectvalue){
						timelineVal=j;
					}
				}
			}
			if(jsonData.FormFields[i].name=="mode"){		
				if(jsonData.FormFields[i].selectvalue=="2D"){
					labelText="3D";
				}else{
					labelText="2D";
				}
			}			
		}
		chartOption = jsonData.ChartType;
		var isHidden = (chartOption !="" && chartOption.indexOf("highchart") > -1)?true:false;
		this.tabToolBar = {
				xtype:'toolbar',
				id:'tabToolBar',
				//padding:'5 5 0 5',
				items:[{
					xtype:'label',
					ttext: labelText,
					padding:'5 5 0 5',
					trackLabels: true,
					hidden:true,
					cls:"icon3d",
					style:{'color':'#fff','cursor':'pointer'},
					//tooltip: ,
					action:'compmode',
					listeners : {
					render : function(c) {
							c.text=labelText;
							if(c.text=='2D'){
								c.addCls('icon2d');
								c.removeCls('icon3d');
							}else{
									c.addCls('icon3d');
									c.removeCls('icon2d');
								}
							c.getEl().on('click', function(){ this.fireEvent('click', c); }, c);
							Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html:labelText
												
																});
							//c.getEl().on('mouseover', function(){ this.fireEvent('mouseover', c);}, c);
						}
					}
				},{
					hidden:true,
					xtype:'tbseparator',					
				},{
					xtype:'image',
					cls:'iconSave',
					padding:'5 5 0 5',
					action:'compsave',
					hidden:isHidden,
					style:{'cursor':'pointer'},
					//tooltip: 'Save',
					listeners : {
						render : function(c) {
							c.getEl().on('click', function(){ this.fireEvent('click', c); }, c);
							//c.getEl().on('mouseover', function(){ this.fireEvent('mouseover', c);}, c);
							Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html:saveLbl
												
																});
						}
					}
				},{
					xtype:'tbseparator',					
					hidden:isHidden
				},{
					xtype:'image',
					cls:'iconPrinter',
					padding:'5 5 0 5',
					hidden:isHidden,
					action:'compprint',
					style:{'cursor':'pointer'},
					//tooltip: 'Print',
					listeners : {
						render : function(c) {
							c.getEl().on('click', function(){ this.fireEvent('click', c); }, c);
							//c.getEl().on('mouseover', function(){ this.fireEvent('mouseover', c);}, c);
							Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html:'Print'
																});
						}
					}
				},{
					xtype:'tbseparator',					
					hidden:isHidden
				},{
					xtype:'image',
					padding:'5 5 0 5',
					cls:'iconSettings',
					style:{'cursor':'pointer'},
					//iconCls:'iconSettings',
					action:'compgraphFilters',
					//tooltip:'Setings',
					listeners : {
						afterrender : function(c) {
							c.getEl().on('click', function(){ this.fireEvent('click', c); }, c);
							//c.getEl().on('mouseover', function(){ this.fireEvent('mouseover', c);}, c);
							Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html:'Settings'
												
																});
						}
					}
				},
				{
					xtype:'tbseparator',
					//hidden:true
				},
				{
			xtype : 'button',
			iconCls : 'iconHelp3',									
			//tooltip : '<b>New Window</b>',
			listeners: {
			afterrender: function () {
			Ext.create('Ext.tip.ToolTip', {
			target: this.id,
			anchor: 'top',
			cls: 'yellowTip',										
			trackMouse: true,
			html: 'Help'
			});
			}
			},
			style : {
				'background' : 'none',
				'border' : '0px',
				'margin':'0 10 0 0',
			},
			handler : function()
			{
				HelpWin();
			}
		}]
		};
		var graphPanel= Ext.create('Ext.panel.Panel',{
			//height:'100%',
			//width:'100%',
			layout: {
				type:'vbox',
				align:'stretch'
			},
			border:false,
			cls:'graph-panel',
			id: 'graphcmp',
			autoScroll:true,
			scroll:true,
			overflowX:'hidden',
			items: [{
				xtype: 'panel',
				cls: 'formOuter',
				//flex:1,
				width: '100%',
				layout: {
					type: 'column',
					align: 'stretch'
				}, 
				items:[
				{
					xtype:'container',
					layout:{
						type:'column',
							align: 'stretch'
						},
					margin: '10 10 10 10',
					frame: true,
					//height:50,
					items:[
					{
						xtype:'slider',
						//padding: '20 30 5 30',
						autoHeight:true,
						width:300,
						cls:'mesrslider',
						plugins:[Ext.create('Ext.ux.FillSlider', {clicksToEdit: 1})],
						value: timelineVal,
						increment: 1,
						minValue: 0,
						maxValue: timelineObj.items.length-1,
						constrainThumbs: false,
						fieldLabel: timelineObj.Label+" : "+timelineObj.selectvalue,
						labelSeparator:'' ,
						labelAlign:'top',
						animation: true,
						tipText: function (t) {
							return Ext.String.format('{0}', timelineObj.items[t.value].value)
						},
						action:'timelinechange'
					}]
				},
				rightMiddlePanel
				]
			}]
		});	

		if(!Ext.isEmpty(jsonData.error)){
			var noMeasure = Ext.create('utilities.ErrorPanel',{
				style:{'border':'0px !important'},
				border:false,
				errorMsg : '<div style="text-align:center;"><img src="/final/images/clear.png" class="list-empty" /><br/><div class="list-empty-text">'+jsonData.error+'</div></div>'
			});
			graphPanel.add({
				xtype:'panel',
				border:false,
				layout:'fit',
				flex:1,
				width:'100%',
				items: noMeasure
			});			
		}		
		else{
			
			if(!Ext.isEmpty(jsonData.imageURL)){
				if(chartOption !=null && chartOption.indexOf("highchart") > -1)
				{
					var imgdiv = '<div id="highChartDiv" style="border 1px solid red;"></div>';
					var panelID = "highChartDiv";
					var url = jsonData.imageURL;
					graphPanel.add({
						xtype: 'panel',
						minHeight:400,
						padding: '0 0 0 30',
						minWidth:900,
						items : [{
									xtype : 'container',
									style : {
										'text-align' : 'center'
									},
									id: panelID,
									html : imgdiv
								}]
						/*xtype:'image',
						padding: '0 0 0 30', 
						height:320,
						src: jsonData.imageURL*/
					});
					loadHSChart(url,panelID,400,900,"",true,true);
				if(!Ext.isEmpty(me.mask)){
					me.mask.hide();
				}
			}	
			else
			{
				graphPanel.add({
						xtype:'image',
						padding: '0 0 0 30', 
						height:320,
						src: jsonData.imageURL
					});
				}
				
				if(!Ext.isEmpty(me.mask)){
					me.mask.hide();
				}
			}	
			else
			{
				if(chartOption !=null && chartOption.indexOf("highchart") > -1)
				{
					var imgdiv = '<div id="highChartDiv" style="border 1px solid red;"></div>';
					var panelID = "highChartDiv";
					var url = jsonData.imageURL;
					graphPanel.add({
						xtype: 'panel',
						minHeight:400,
						padding: '0 0 0 30',
						minWidth:900,
						items : [{
									xtype : 'container',
									style : {
										'text-align' : 'center'
									},
									id: panelID,
									html : imgdiv
								}]
						/*xtype:'image',
						padding: '0 0 0 30', 
						height:320,
						src: jsonData.imageURL*/
					});
					loadHSChart(url,panelID,320,900,"",true,true);
				}
				else
				{
					graphPanel.add({
							xtype:'image',
							padding: '0 0 0 30', 
							height:320,
							src: jsonData.imageURL
						});
				}
				if(!Ext.isEmpty(me.mask)){
					me.mask.hide();
				}
			}
		}
		me.add(graphPanel);
	},
	createPanelRightMiddle : function(jsonData){
		var filterArray=new Array();
		for(var i=0; i< jsonData.FormFields.length; i++){
			var filterData=jsonData.FormFields[i];
			var filterComp=null;
			if(filterData.name=="starthr" || filterData.name=="endhr" || filterData.name=="FromDate" || filterData.name=="todate" || filterData.name == "graph"){
				switch(filterData.type){
				case "combo": 
					filterComp=this.createCombo(filterData);
					break;
				case "date": 
					filterComp=this.createDateField(filterData);
					break;
				case "button":
					filterComp = this.createGraphButton(filterData, jsonData);
					break;
				}
			}
			if(!Ext.isEmpty(filterComp)){
				filterArray.push(filterComp);
			}
		}
		var rightMiddlePanel = {
				xtype : 'panel',
				layout: {
                    type: 'hbox',
					 align: 'stretch'
                },
				bodyStyle:{'background':'transparent!important'},
				//flex:1,
				//padding:'1 5 5 15',
				margin:'5 0 0 0',
				//frame:true, //right middle 3
				width: 540,
				border: true,
				defaults: {
					labelAlign: 'top',
					labelSeparator: ''
				},
				items  : filterArray
		}	
		return rightMiddlePanel;
	},
	createCombo:function(comboData){
		if(comboData.name!="timeline" && comboData.name!="mode"){
			var comboStore = Ext.create('Ext.data.Store',{
				fields:['name','value'],
				proxy:{
					type: 'memory',
					reader: {
						type: 'json',
						root:'items'
					}
				},
				data:comboData
			});
			var compCombo={
					xtype:'combo',
					editable : false,
					store:comboStore,
					cls : 'dropdown',
					displayField:'name',
					valueField:'value',
					padding: '0 5',
					labelWidth: 80,
					fieldLabel:comboData.Label,
					value:comboData.selectvalue ? comboData.selectvalue : comboData.items[0].value,
					itemId:comboData.name,
					action:comboData.name,
					queryMode:'local'
			};
			if(comboData.name=="starthr" || comboData.name=="endhr"){
				compCombo.labelWidth=20;
				compCombo.width=75;
				compCombo.defaultListConfig = {
					minWidth: 55,
					loadingHeight: 55
				};
				compCombo.disabled=true;
			}
			return compCombo;
		}
	},
	createDateField:function(fieldData){
		var data;
		data = fieldData.selectedValue;
		if(data == "Invalid Date"){
			data = new Date(fieldData.selectedValue);
		}
		var dateField={
				xtype:'datefield',
				cls : 'datepicker',
				fieldLabel:fieldData.Label,
				//format:'M d,Y',
				format:requestParams.mgr_dateFormat,
				//value:new Date(fieldData.selectedValue),
				//value:fieldData.selectedValue,
				value:data,
				labelWidth:50,
				editable:false,
				disabled:true,
				padding: '0 5',
				width:210,
				itemId:fieldData.name,
				action:fieldData.name
		}	
		if(fieldData.name=="FromDate"){
			dateField.labelWidth=35;
			dateField.width=110;
		}else if(fieldData.name=="todate"){
			dateField.labelWidth=20;
			dateField.width=115
		}
		return dateField;
	},
	createGraphButton:function(buttonData, jsonData){
		var isHidden = true;
		for(var i = 0; i < 4; i++) {
			var filterData = jsonData.FormFields[i];
			if( filterData.name.toLowerCase() == "timeline" )
			{
				isHidden = ( filterData.selectvalue.toLowerCase() == 'any' )?false:true;
			}
		}
		if(buttonData.name == "graph")
		{
			var button={
				xtype:'container',items:[{
					xtype: 'button',
					cls:'button20',
					//height:22,
					//padding:'2 3 2 3',
					margin: '22 0 0 0',
					text: buttonData.text,
					name: buttonData.name,
					//cls : 'buttonalarm measurbutton',
					action: buttonData.name+'btn',
					hidden: isHidden
				}]
			}
			return button;
		}
	},
});