Ext.require([
    'Ext.form.Panel',
    'Ext.ux.form.MultiSelect'
]);
Ext.define('ComponentMeasureTabSet.view.CompareGraphFilters', {
	extend: 'Ext.window.Window',
	alias:'widget.comparegraphfilters',
	header:false,
	padding:'5 5 0 5',
	flotable:false,
	floating:false,
	resizable: false,
	id:'compareFilter',
	layout:{
		type: 'vbox',
		align: 'stretch'
	},
	jsonData:null,
	cls:'tabsetsettingsWindow measure-graph-panel',	
	initComponent : function(){
		this.callParent();
	},
	createItems : function(jsonData){
		if(!Ext.isEmpty(jsonData.FormFields) && jsonData.FormFields.length>0){
			var filterPanelLeft = this.createPanelLeft(jsonData);		

			var rightBottomPanel = this.createPanelRightBottom(jsonData);

			var filterPanelRight = ('utilities.ScrollPanel',{
				flex:1,
				bodyCls:'top-right-radius',
				cls:'filter-top-right-panel',
				autoScroll:true,
				height:'100%',
				layout:{
					type: 'vbox',
					align: 'stretch'
				},
				items:[rightBottomPanel]
			});
			var topPanel = ('Ext.panel.Panel',{
				layout:'vbox',
				header:false,
				border:false,
				items:[filterPanelLeft,filterPanelRight]			
			});

			var buttonArray = this.createButtonPanel(jsonData);
			this.addDocked({
				xtype: 'toolbar',
				cls:'toolbarPositionManual',
				buttonAlign:'center',
				layout:	{type:'hbox',
						pack:'center',
					align:'stretch'},
			    dock: 'bottom',
				ui:'footer',
			    items: buttonArray
			});
			this.add(topPanel);
			this.doLayout();
		}
	},

	createPanelLeft : function(jsonData) {	
		var filterArray=new Array();
		for(var i=0; i< jsonData.FormFields.length; i++){
			var filterData=jsonData.FormFields[i];
			var filterComp=null;
			if(filterData.name=="measurelist" || filterData.type=="label"){
				switch(filterData.type){
				case "combo": 
					filterComp=this.createCombo(filterData);
					break;
				case "label": 
					filterComp=this.createLabel(filterData);
					break;				
				}
			}
			if(!Ext.isEmpty(filterComp)){
				filterArray.push(filterComp);
			}
		}

		var leftPanel = {
				xtype : 'panel',
				layout:'vbox',
				margin:'10 10 0 10',
				bodyCls:'top-left-radius',
				cls:'filter-top-panel',
				items  : filterArray
		}	
		return leftPanel;
	},

	createPanelRightBottom : function(jsonData) {	
		var filterArray=new Array();
		for(var i=0; i< jsonData.FormFields.length; i++){
			var filterData=jsonData.FormFields[i];
			var filterComp=null;
			if(filterData.name=="er_interval" || filterData.name=="er_integrate" || filterData.name=="er_otherTime"){
				filterComp=this.createCombo(filterData);
			}

			if(!Ext.isEmpty(filterComp)){
				filterArray.push(filterComp);
			}
		}

		var rightBottomPanel = {
				xtype : 'panel',
				layout:'hbox',
				flex:1,
				border:false,
				defaults:{
				labelAlign:'top',
				labelSeparator:''
			},
				items  : filterArray
		}	
		return rightBottomPanel;
	},
	createButtonPanel : function(jsonData) {	
		var filterArray=new Array();
		//filterArray.push('->');
		for(var i=0; i< jsonData.FormFields.length; i++){
			var filterData=jsonData.FormFields[i];
			var filterComp=null;
			if(filterData.type=="button"){					
				filterComp=this.createButton(filterData);					
			}
			if(!Ext.isEmpty(filterComp)){
				filterArray.push(filterComp);
			}
		}
		
		return filterArray;
	},

	createCombo:function(comboData){
		if(comboData.name!="timeline" && comboData.name!="mode"){
			var comboStore = Ext.create('Ext.data.Store',{
				fields:['name','value'],
				proxy:{
					type: 'memory',
					reader: {
						type: 'json',
						root:'items'
					}
				},
				data:comboData
			});
			
			var compCombo={
					xtype:'combo',
					editable : false,
					store:comboStore,				
					cls : 'dropdown',
					displayField:'name',
					valueField:'value',
					padding: 10,
					labelWidth:80,
					fieldLabel:comboData.Label,
					value:comboData.selectvalue ? comboData.selectvalue : comboData.items[0].value,
					itemId:comboData.name,
					action:comboData.name,
					queryMode:'local'
			};	
			if(!Ext.isEmpty(comboData.Label))
			{
				if(comboData.Label=='Measure')
				{
					compCombo={
						xtype:"combo",
						editable : false,
						cls : 'dropdown',
						fieldLabel:comboData.Label,
						labelAlign:"left",
						store:comboStore,
						value:comboData.selectvalue ? comboData.selectvalue : comboData.items[0].value,
						displayField:"name",
						valueField:"value",
						//queryMode:"local",
						itemId:"measurelist"
						};
				}
			}
			if(comboData.name=="er_interval" || comboData.name=="er_integrate"){
				compCombo.disabled=true;
			}
			if(comboData.name=="er_otherTime"){
				compCombo.width=95;
				compCombo.disabled=true;
				compCombo.hidden=true;
			}
			return compCombo;	
		}		
	},
	createLabel:function(labelData){
		var label={
				xtype:'label',
				html: '<div><b>'+labelData.Label+'</b> : '+labelData.measureValue+'</div>',
				cls:'lookup-field',
				padding:'5 0 0 0'
		}		
		return label;
	},
	createButton:function(buttonData){
		var button={
				xtype:'button',
				text: buttonData.text,
				name: buttonData.name,
				cls : 'buttonalarm measurbutton',
				action: buttonData.name
		}	
		
		return button;
	},
});