var seqHideFlag = false;
Ext.define('ComponentMeasureTabSet.view.DetailedDiagnosisAnalysis', {
	extend: 'Ext.panel.Panel',
	alias:'widget.detailediagnosisanalysis',
	requires : ['ComponentMeasureTabSet.view.DetailedDiagnosisGrid','Ext.layout.container.Column','utilities.ErrorPanel'],
	mask:null,
	//cls:'datapanel',
	cls:'ddHtmlTableHead',
	border:'none',
	jsonData :null,
	bodyCls : 'diagnosis-upper-panel',
	layout : {
		type:'vbox',
		align:'stretch'
	},
	autoDestroy:true,
	initComponent : function(){
		this.callParent();
	},
	createTabUI:function(jsonData){
		seqHideFlag = false;
		this.jsonData = jsonData;
		this.removeAll();
		var me=this;
		
		var upperPanel = "";
		var gridPanel = "";
		var errorPanel = "";
		var toolbar = "";
		var pagingPanel="";
		upperPanel = this.createDiagnosisUpperPanel(jsonData);
		pagingPanel= this.createPagingPanel(jsonData);

		if(!Ext.isEmpty(jsonData.errorMsg) && Ext.isEmpty(jsonData.gridInfo))
		{
			errorPanel = this.createErrorPanel(jsonData);
			this.add([upperPanel,errorPanel]);
		}
		else
		{
			gridPanel = this.createGridPanel(jsonData);
			this.add([upperPanel,gridPanel,pagingPanel]);
		}
		this.doLayout();
	},
	createDiagnosisUpperPanel : function(jsonData){
		var itemsArray = this.createFilters(jsonData);
		var upperPanel ={
			xtype : 'panel',
			id:'analysisUpperPanelId',
			cls : 'diagnosis-panel diagnosis-upper-panel  bottom-left-radius bottom-right-radius',
			bodyCls:'diagnosis-upper-panel bottom-left-radius bottom-right-radius',
			layout:'column',
			defaults:{
				labelAlign:'top',
				labelSeparator:'',
				margin:'0 20 5 0'
			},
			margin : '10 10',
			items : itemsArray
		}
		return upperPanel;
	},
	createPagingPanel:function(jsonData)
	{
		var data = jsonData.sbPagination;
		var footer={
				xtype:'panel',
				id:'tableViewAnalysisFoot',
				margin:'-10 0 0 10',
				itemId:'tableViewAnalysisFoot',
				hideMode: 'visibility',
				//flex:0.2,
				//width:'100%',
				//width:200,
				height:25,
				autoScroll:false,
				scroll:false,
				html:jsonData.sbPagination,
			};

		return footer;
	},
	createGridPanel : function(jsonData)
	{
		//var data = jsonData.sbPagination;

			/*var totalPageNo = document.getElementById("totalPages").innerHTML;
			data = data.replace("Calculating total pages...",totalPageNo);
			jsonData.sbPagination=data;

			if(jsonData.sbPagination.lastIndexOf("<form")>1)
			{

				jsonData.sbPagination = jsonData.sbPagination.substring(0,jsonData.sbPagination.lastIndexOf("<form"));
			}

			 if(data!=null && data!="" && data!="undefined")
			 {
				 var pcount = totalPageNo.replace("of"," ");
				 var talPages = parseInt(pcount.trim());
				 if(talPages < 2)
				 {
					if(data.indexOf("<td id='next'")>=0)
					 {
					var data1 = data.substring(0,data.indexOf("<td id='next'"));
					var data2 = data.substring(data.lastIndexOf("</td>")+5);
					data = data1+data2;
					jsonData.sbPagination=data;
					 }
				}
			 }
				*/
		/*var grid = {
				xtype : 'detaileddiagnosisgrid',
				jsonData : jsonData,
				flex:1,
				margin:'10',
				cls : 'gridSkin'
		}
		return grid;*/
		var table ={
			xtype:'outerPanel',
			extend:'utilities.ScrollPanel',
			cls:'dataPanel externalDetailsOuterBox',
			layout:{type:'fit'},
			id:'datapanel',
			//title:'Lists the top 10 CPU consuming processes',
			title:this.jsonData.hiddenFields.title,
			//style:{'border':'1px solid red'},
			//height:200,
			flex:1,
			frame:false,
			padding:0,
			scroll:false,
			autoScroll:false,
			margin:'0 10 10 10',
			border:true,
			defaults:{
				labelAlign:'top',
				labelSeparator:'',
				margin:'0 0 0 0'
			},
			//style:{'border':'1px solid green'},
			handlePercentWidthsAfterScroll:function(){
				this.callParent();
			},
			items:[{
				xtype:'container',
				id:'tableViewAnalysis',
				itemId:'tableViewAnalysis',
				//width:'100%',
				//flex:1,
				border:false,
				//style:{'border':'0px solid blue'},
				//extend:'ScrollPanel',
				//width:200,
				height:300,
				autoScroll:true,
				scroll:true,
				//hide:true,
				html:jsonData.tableData,
				/*listeners:{
					"resize": {
						fn: function(el) {
							var width = Ext.getBody().getViewSize().width-130 ;
							var height = Ext.getBody().getViewSize().height - 165;//165
							var winH =0;
							if(isRUM)
							{
								if(Ext.isChrome)
								{
									winH = Ext.getCmp("ddwindow").getHeight()-260;//180
									height = Ext.getBody().getViewSize().height - 110;
									Ext.getCmp("datapanel").setHeight(height);
								}
								if(Ext.isGecko)
								{
									winH = Ext.getCmp("ddwindow").getHeight()-290;//180
									height = Ext.getBody().getViewSize().height - 100;
									Ext.getCmp("datapanel").setHeight(height);
									Ext.getCmp("tableViewAnalysis").setSize(width, winH);
								}
								else
								{
									winH = Ext.getCmp("ddwindow").getHeight()-255;//180
									height = Ext.getBody().getViewSize().height - 80;
									Ext.getCmp("datapanel").setHeight(height);
								}
							}
							else
							{
								winH = Ext.getCmp("ddwindow").getHeight()-155;//180
							}

							if(Ext.getCmp("analysisUpperPanelId").getHeight()>100)
							{
								height = Ext.getCmp("ddwindow").getHeight() - 240; //240
							}
							
							var topPanelHeight=Ext.getCmp("analysisUpperPanelId").getHeight();
							Ext.getCmp("tableViewAnalysis").setHeight((Ext.getBody().getViewSize().height - topPanelHeight)-140);
							Ext.getCmp("datapanel").setHeight((Ext.getBody().getViewSize().height - topPanelHeight)-240);
							//this.setSize(width, winH);
							//Ext.getCmp("tableViewAnalysis").setSize(width, winH);
							Ext.getCmp("datapanel").setHeight(height);
							//Ext.getCmp("tableViewAnalysis").doLayout();
						}
					}
				}*/
			},
			]
		};
		return table;
	},
	createErrorPanel : function(jsonData){
	    	var errorPanel = {
					xtype : 'errorpanel',
					cls:'error_panel_body top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
					bodyCls:'error_panel_body top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
					height : '50%',
					width : '100%',
					style:{'border':'0px !important'},
					border:false,
					autoScroll:true,
					margin : 5,
					errorMsg : '<div class="iconInformation" style="margin:5% auto 0px auto"></div><div style="text-align:center">' + jsonData.errorMsg
							+ '</div>',
					flex : 1
	    					
	    	}
	    	return errorPanel;
	},
	createFilters:function(jsonData){
		var itemsArray=new Array();
		var cnt=0;
		var currentRow=0;
		for(var i=0;i<jsonData.filters.length;i++){
			var filter=jsonData.filters[i];
			if(filter.id=="fromHr" || filter.id=="toHr" || filter.id=="fromMin" || filter.id=="toMin" || filter.id=="fromdate" || filter.id=="todate")
			{
				continue;
			}
			if(filter.type=='nextLine'){
				if(cnt!=0){
					var columnWidth=1/cnt;
					//to calculate column widths
					for(var j=0;j<cnt;j++){
						if(Ext.isEmpty(itemsArray[currentRow+j].width)){
							//itemsArray[currentRow+j].columnWidth=0.5;
							
						}
					}
					//currentRow=currentRow+cnt;
					cnt=0;
				}
			}else{
				var item=this.createFilterItem(filter,jsonData);
				if(!Ext.isEmpty(item)){
					itemsArray.push(item);
					cnt++;
				}
			}
		}
		return itemsArray;
	},
	
	createFilterItem:function(filter,jsonData){
		var item=null;
		if(filter.id=="sortby")
		{
			if(filter.hidden==true){
				
				return;
			}
		}
		if(filter.id=='compList' || filter.id == 'compTypeList'|| filter.id=="searchTextId" || filter.id=="searchComboId")
		{
			if(filter.isHidden==true || filter.isHidden=='true'){
				
				return;
			}
		}
		if(filter.id=="timeline")
		{
			this.timeLine = filter.selectedValue;
			item=this.createCombo(filter,jsonData);
		}
		else
		{
			var selectValue = null;
			var hide = false;
			if(!Ext.isEmpty(filter.selectedValue))
			{
				var toolTipvalue = '';
				selectValue = filter.selectedValue;
				if(filter.selectedValue.indexOf('*')==0)
					selectValue = selectValue.substring(1);
				if(filter.id=='measureHostList'){
					toolTipvalue = selectValue;
					//selectValue = "<div style='overflow:hidden;text-overflow:ellipsis;width:50px;cursor:pointer;cursor:hand;'>"+selectValue+"</div>";
					selectValue = "<div style='overflow:hidden;text-overflow:ellipsis;width:100px;cursor:pointer;white-space:nowrap;'>"+selectValue+"</div>";
					
				}
				if(filter.id=='measurelist' || filter.id=='sortby' || filter.id=='testList')
				{
					selectValue = filter.selectedOriginalValue;
					toolTipvalue = filter.selectedOriginalValue;
				}
				if(filter.id=='compList'){
					selectValue = "<div style='overflow:hidden;text-overflow:ellipsis;width:125px;cursor:pointer;white-space:nowrap;' >"+filter.selectedOriginalValue+"</div>";
					toolTipvalue = filter.selectedOriginalValue;
				}				
				if(filter.id=='compTypeList'){
					selectValue = "<div style='overflow:hidden;text-overflow:ellipsis;width:130px;cursor:pointer;white-space:nowrap;' >"+filter.selectedOriginalValue+"</div>";
					toolTipvalue = filter.selectedOriginalValue;
				}				
				if(filter.id=='infolist' && filter.selectedValue == '-1' )
				{
					hide = true;
				}
				else if(filter.id=='infolist')
				{
					var tempSelectValue = filter.selectedValue;
					if(filter.selectedValue.indexOf('*')==0)
						tempSelectValue = tempSelectValue.substring(1);
					filter.value = null;
					selectValue = "<div style='overflow:hidden;text-overflow:ellipsis;width:200px;cursor:pointer;white-space:nowrap;' >"+tempSelectValue+"</div>";
					toolTipvalue = tempSelectValue;

				}
				if(toolTipvalue == '')
				{
					if(selectValue!=undefined && selectValue.indexOf("*")>=0)
						selectValue = selectValue.substring(selectValue.indexOf("*")+1);
					else
						toolTipvalue = selectValue;
					
				}
				//alert(filter.id+toolTipvalue) 
			}
			item={
					xtype:'displayfield',
					value:filter.value?filter.value:selectValue,
					fieldLabel:filter.name,
					cls : 'display-field',
					margin:'0 20 20 0',
					//width:250,
					//columnWidth: 0.25,
					listeners: {
							afterrender: function () {
								 Ext.create('Ext.tip.ToolTip', {
									target: this.id,
									anchor: 'top',
									cls: 'yellowTip',
									trackMouse: true,
									html: filter.value?filter.value:toolTipvalue
								});
							}
						}
				 };
			switch(filter.id){
			case "compTypeList": 
							item.labelWidth=50;
							item.width=50;
							item.minWidth=130;
							break;
			case "compList": 
							item.labelWidth=50;
							item.width=50;
							item.minWidth=120;
							break;
			case "testList": 
							item.labelWidth=50;
							item.width=50;
							item.minWidth=120;
							break;
			case "infolist": 
							item.labelWidth=50;
							item.width=200;
							item.hidden=hide;
							break;
			case "search": 
							item.hidden = true;
							break;			
			}
			return item;
		}
		return item;
	},
	
	createCombo:function(filter,jsonData){
		var comboStore = Ext.create('Ext.data.Store',{
			fields:['value','name'],
			proxy:{
				type: 'memory',
				reader: {
	            	type: 'json',
	            	root:'options'
	        	}
			},
			//data:filter
			data:jsonData.hiddenFields.filterBy
		});
			var item={
					xtype:'combo',
					editable : false,
					store:comboStore,
					cls : 'dropdown detailed-diagnosis-combo',
					displayField:'name',
					valueField:'value',
					trigerAction:'all',
					fieldLabel:filterByLbl,
					value:jsonData.hiddenFields.selectFilter?jsonData.hiddenFields.selectFilter:'All',
					//value:filter.selectedValue?'All':selectedValue,
					id:filter.id,
					itemId:filter.id,
					queryMode:'local'
			};
			switch(filter.id){
			case "timeline": // item.columnWidth=0.2;
							  item.width=170;
							  item.maxWidth=200;
				break;
			}
			return item;
	}
});