Ext.define('ComponentMeasureTabSet.view.FeedBack', {
	extend: 'Ext.panel.Panel',
	alias:'widget.feedback',
	margin:0,
	requires:['ComponentMeasureTabSet.model.timeCombo'],
	items : [],
	tabToolBar:null,
	jsonDatas : null,
	mask:null,
	bodyCls : 'feedback-no-border',
	layout : 'column',
	
	
	createTabUI:function(jsonData){
		this.jsonDatas = jsonData;
		this.removeAll();
		if(!Ext.isEmpty(jsonData.screenLabels.error))
		{
			var statusPanel = this.returnStatusPanel(jsonData.screenLabels.error);

			this.add(statusPanel);
			
		}
			
		if(!Ext.isEmpty(jsonData.screenLabels.success))
		{
			var statusPanel = this.returnStatusPanel(jsonData.screenLabels.success);
			this.add(statusPanel);
		}
			
		var headerItems = new Array();
		for(var i=0 ; i<jsonData.headerArray.length ; i++){
			headerItems.push(this.returnLabel(jsonData.headerArray[i] , i));
		}

		this.tabToolBar = {
			xtype:'toolbar',
			id:'tabToolBar',
			items:[
			{
				xtype : 'button',
				iconCls : 'iconHelp3',
				//tooltip : '<b>Help</b>',
				listeners: {
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Help'
						});
					}
				},
				style : {
					'background' : 'none',
					'border' : '2px',
					'margin':'0 10 0 0',
				},
				handler:function()
				{
					HelpWin();
				}
			}]
		};
		var upperPanel = {
				xtype : 'panel',
				layout : 'column',
				margin:'10 10 5 10',
				align: 'center',
				//height :70,
				itemId:'upper',
				columnWidth :1,
				bodyPadding:10,
				border:true,
				bodyCls : 'feedback-no-border',
				cls : 'formOuter',  //1
				items : headerItems

		};
		
		var calendarItems = new Array();
		for(var i=0 ; i<jsonData.calendarRowArray.length ; i++){
			calendarItems.push(this.returnCalendarRow(jsonData.calendarRowArray[i],i));
		}
		calendarItems.push({
			xtype:'container',
			width:1000,
			defaults:{
					
					labelSeparator:''
				},
			layout:'column',
			items:[
				{
			xtype : 'textarea',
			margin:'0 20 0 0',
			labelAlign:'top',
			fieldLabel : jsonData.screenLabels.problemReason,
			itemId:'problemReason',
			
           
			width:310,
			cls: 'text-area',
			flex :1,
			maxHeight :200
		},{
			xtype : 'textarea',
			labelAlign:'top',
			fieldLabel : jsonData.screenLabels.problemFix,
			itemId:'problemFix',
			width:310,
			margin:'0 20 0 0',
			//cls : 'feedback-textarea',
			cls: 'text-area',
			flex :1,
			maxHeight :200
		},{
			xtype : 'textfield',
			  cls: 'textbox',
				margin:'0 20 0 0',
			labelAlign:'top',
			fieldLabel : jsonData.screenLabels.problemFixBy,
			minWidth:300,
			readOnly:isFixedByReadOnly,
			width:200,
           
			//cls : 'feedback-textarea',
			//maxHeight:30,
			flex :1,
			itemId:'problemFixBy',
			value : jsonData.screenLabels.problemFixByText
		}
			]
		});
		
		var lowerPanel = {
				xtype : 'panel',
				layout : 'column',
				align: 'center',
				bodyPadding:10,
				margin:'5 10 5 10',
				cls : 'formOuter',  
				//cls:'feedback-lower-panel',
				//height :500,
				bodyCls : 'feedback-no-border feedback-lower-panel-body ', //2
				itemId:'lower',
				columnWidth : 1,
				buttonAlign:'center',
				items : calendarItems,
				dockedItems:[
				{
					xtype:'toolbar',
					dock:'bottom',
					ui:'footer',
					style:{'background':'none !important','margin':'0px 0 0px 0','padding':'0px 0px 10px 0px'},
					layout:	{
						type:'hbox',
						pack:'center',
						align:'stretch'
					},
					buttonAlign:'center',
					defaults:{xtype:'button'},
					items:[{
					text:jsonData.screenLabels.saveText,
					action:'feedbacksave',
					cls:'button20',
					style:{'margin':'5px'}
				},
				{
					text:jsonData.screenLabels.clearText,
					action:'cleardata',
					cls:'button20',
					style:{'margin':'5px'}
				}]
				}	
				]
				
		};
		
		this.add(upperPanel);
		this.add(lowerPanel);
		if(!Ext.isEmpty(this.mask)){
			this.mask.hide();
		}
		
	},
	createNoAccessTabUI:function(errorMsg){
		var me=this;
		me.removeAll();

		this.tabToolBar = {
			xtype : 'toolbar',
			id:'tabToolBar',
			items : []
		};

		if(!Ext.isEmpty(me.mask)){
			me.mask.hide();
		}
		errorPanel = this.createAccessErrorPanel(errorMsg);
		this.add([errorPanel]);
	},
	createAccessErrorPanel : function(errorMsg){
	    	var errorPanel = {
					xtype : 'errorpanel',
					cls:'error_panel_body top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
					bodyCls:'error_panel_body top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
					height : '100%',
					width : '100%',
					border : 0,
					style:{'border':'0px !important'},
					border:false,
					autoScroll:true,
					margin : 5,
					errorMsg : '<div style="text-align:center;margin-top:15%"><div class="iconInformation" style="margin:0px auto"></div><div>' + errorMsg+ '</div>',
					flex : 1
	    					
	    	}
	    	return errorPanel;
	},
	returnLabel : function(labelData , i){
		var labelPanel = {
				xtype : 'panel',
				layout : 'vbox',
				cls:(i==0||i==2)?'feedback-label-padding':'feedback-label-panel',
				bodyCls : 'feedback-no-border',
				//columnWidth :.1,
				margin:'0 20 0 0',
				defaults:{
					labelAlign:'top'
					
				},
				items:[{
					xtype  :'label',
					//maxWidth :100,
					cls:'feedback-upperlabel-style',
					margin:'0 0 8 0',
					html : '<div class="f11-normal">'+labelData.label+'</div>',					
					flex:.2
				},{
					xtype  :'label',
					html : '<div class="f11-bold">'+Ext.String.htmlDecode(labelData.value)+'</div>',
					flex:.2
				}]
		};
		return labelPanel;
	},
	returnCalendarRow : function(calendarData , i){

			var data;
		
			data = calendarData.displayDate;	
			
			if(data == "Invalid Date"){
				data = new Date(calendarData.displayDate);
			}

		var hrComboStore=Ext.create('Ext.data.Store',{
			model:'ComponentMeasureTabSet.model.timeCombo',
		    proxy: {
		        type: 'memory',
		        reader: {
		            type: 'json',
		            root:'hrComboArray'
		        }
		    },
		    data:calendarData.hrComboArray
		});
		var minComboStore=Ext.create('Ext.data.Store',{
			model:'ComponentMeasureTabSet.model.timeCombo',
		    proxy: {
		        type: 'memory',
		        reader: {
		            type: 'json',
		            root:'minComboArray'
		        }
		    },
		    data:calendarData.minComboArray
		});
		var calendarPanel = {
				xtype : 'panel',
				layout : 'column',
				//bodyPadding:10,
				margin:'5 30 5 0',
				cls : 'formOuter', 
				bodyCls : 'feedback-no-border ',
				itemId:'calendar'+i,
				cls :i==0?'feedback-calender-panel-first':'feedback-calender-panel',
				//maxHeight :35,
				defaults:{
					labelAlign:'top',
					margin:'0 20 20 0',
					labelSeparator:''
				},
				//columnWidth :1,
				flex :1,
				items:[{
			        xtype: 'datefield',
			        fieldLabel: calendarData.label1,
			        //flex:1,
			        editable:false,
					
					width:120,
			        cls:'datepicker',
					//format:'M d, Y',
					format:requestParams.mgr_dateFormat,
			        //value : new Date(calendarData.displayDate)
					value:data	

					//value:calendarData.displayDate
			    },{
					xtype:'combo',
					store:hrComboStore,
					 labelStyle: 'font-weight:bold;width:120px',
					//flex:1,
		    	   fieldLabel:calendarData.label2,
		    	   editable:false,
		    	  padding:'5 0 0 0',
		    	   itemId : 'hr',
					width:60,
					
		    	   displayField:'name',
		    	   valueField:'value',
		    	   labelCls :'feedback-lower-combo',
		    	   cls:'dropdown ',
		    	   value : calendarData.selectedHr,
				   queryMode:'local'
		    	},{
					xtype:'combo',
					store:minComboStore,
		    	   fieldLabel:calendarData.label3,
		    	 //  flex:1,
					width:60,
		    	   editable:false,
		    	   itemId : 'min',
		    	  padding:'5 0 0 0',
		    	   displayField:'name',
		    	   valueField:'value',
		    	   labelCls :'feedback-lower-combo',
		    	   cls:'dropdown ',
		    	   value : calendarData.selectedMin,
				   queryMode:'local'
		    	}]
		};
		return calendarPanel;
	},
	returnStatusPanel:function(data){
	
		var statusPanel = {
				xtype : 'panel',
				
				align:'center',
				minHeight:25,
				style:{'line-height':'25px'},
				columnWidth :1,
				html:'<div style="text-align:center;font-weight:bold;">'+data+'</div>',
				listeners:{
					afterrender:function(c){
						c.body.highlight('#f7b618', {block:true});
						
					}
				}
		};
		return statusPanel;
	}
});