Ext.define('ComponentMeasureTabSet.view.FixHistory', {
	extend : 'Ext.panel.Panel',
	requires:['Ext.layout.container.Column'],
	alias : 'widget.fixhistory',
	//margin:'10',
	layout : {
		type : 'vbox',
		align : 'stretch'
	},
	
	url : null,
	data : null,
	tabToolBar:null,
	title:'',
	jsonData : null,
	initComponent : function() {
		this.callParent();
	},
	createTabUI : function(jsonData) {
		var me = this;
		this.jsonData = jsonData;
		this.removeAll();
		
		var tabBar = Ext.getCmp('tabToolBar');
		if(!Ext.isEmpty(tabBar))
			tabBar.removeAll();

		this.tabToolBar = {
			xtype:'toolbar',
			id:'tabToolBar',
			items:[
			{
				xtype : 'button',
				iconCls : 'iconHelp3',
				listeners: {
					afterrender: function(){
						Ext.create('Ext.tip.ToolTip',{
							target: this.id,
							anchor: 'top',
							cls: 'yellowTip',
							trackMouse: true,
							html: 'Help'
						});
					}
				},
				style : {
					'background' : 'none',
					'border' : '2px',
					'margin':'0 10 0 0',
				},
				handler:function()
				{
					HelpWin();
				}
			}]
		};
		
		var headerItems = new Array();
		if(!Ext.isEmpty(jsonData.upperHeaderText)){
			for (var i = 0; i < jsonData.upperHeaderText.length; i++) {
				headerItems.push(this.returnLabel(jsonData.upperHeaderText[i], i));
			}
		}

		var colWidth = 1 / jsonData.combos.length;
		var comboItems= new Array();
		for (var i = 0; i < jsonData.combos.length; i++) {
			comboItems.push(this.returnCombo(jsonData.combos[i], colWidth,i));
		}
		var comboPanel = {
			xtype : 'panel',
			columnWidth:1,
			
			defaults:{
		labelAlign:'top',
		margin:'0 20 10 0'
	},
			layout : 'column',
			align : 'center',
			//height : 50,

			bodyCls : 'fixHistoryUpperPanel',
			itemId : 'combopanel',
			items : comboItems

		};
		headerItems.push(comboPanel);

		headerItems.push({
					xtype : 'checkbox',
					labelSeparator:'',
					boxLabel : jsonData.screenLabels.checkbox,
					columnWidth : .5,					
					cls:'lookup-field checkbt',
					checked : (jsonData.screenLabels.checked == 'checked=checked')? true: false,
					padding : '15 0 5 5'
				});
		headerItems.push({
			xtype : 'button',
			text : jsonData.screenLabels.button,
			columnWidth : .5,
			action : 'submit',
			margin:'15 10 10 0',
			//padding : '15 5 5 5',
			maxWidth :80,
			cls : 'button20'
		});
		
		var upperPanel = {
			xtype : 'panel',
			layout : 'column',
			align : 'center',
			//height : 120,
			border:true,
			itemId : 'upper',
			itemId:'upperheader',
			cls:'formOuter',
			margin:'10 10 5 10',
			bodyPadding : 10,
			bodyCls : 'fixHistoryUpperPanel feedback-lower-panel-items-padding',
			items : headerItems

		};
		this.add(upperPanel);

		if (!Ext.isEmpty(jsonData.selectedComp)) {
			var selectedItems = new Array();
			if (!Ext.isEmpty(jsonData.selectedComp.error)) {
				selectedItems.push({
					xtype : 'panel',
					columnWidth :1,

					bodyCls : 'fixHistoryUpperPanel',
					html : '<div style="text-align:center;margin:5% 0px 0px 0px" class="system-error-bg"><div class="iconInformation" style="margin:0px auto"></div><div class="list-empty-text system-error-bg">'
							+ jsonData.selectedComp.error + '</div></div>'
				});
			} else if(!Ext.isEmpty(jsonData.selectedComp.innerTabArray)){
				for (var i = 0; i < jsonData.selectedComp.innerTabArray.length; i++) {
					var miniHistoryPanel = this
							.createMiniHistory(jsonData.selectedComp.innerTabArray[i]);
					selectedItems.push(miniHistoryPanel);
				}
			}
			var flexHeight = 4;
			if(!Ext.isEmpty(jsonData.screenLabels.checked))
				flexHeight = 2;
			var s= jsonData.screenLabels;
			var selectedPanel = {
				xtype : 'scrollpanel',
				cls:'datapanel',
				frame:true,
				padding:'0',
				margin:'5 10 5 10',
				bodyCls : 'fixHistoryUpperPanel',
				autoscroll:true,
				itemId:'selected',
			/*	layout : {
					type : 'vbox',
					align : 'stretch'
				},*/
				layout:'column',
				title : '<p style="padding-left:0px;padding-top:3px;">'+jsonData.selectedComp.header+'</p>',
				flex : flexHeight,
				items : selectedItems,
				info : s.info,
				isVM:s.isVM,
				measure : s.measure,
				test : s.test,
				hid_comp_name : s.hid_comp_name,
				source:(Ext.isEmpty(s.source))?'null':s.source,
				component:(Ext.isEmpty(s.component))?null:s.component,
				descriptor:(Ext.isEmpty(jsonData.combos[1]))?'':jsonData.combos[1].selected
				

			};
			this.add(selectedPanel);
		}
		if(!Ext.isEmpty(jsonData.screenLabels.checked))
		{
			if (!Ext.isEmpty(jsonData.otherComp)) {
				var otherItems = new Array();
				if (!Ext.isEmpty(jsonData.otherComp.error)) {
					otherItems.push({
						xtype : 'panel',
						
						bodyCls : 'fixHistoryUpperPanel',
						columnWidth :1,
						html : '<div style="text-align:center;margin:5% 0px 0px 0px" class="system-error-bg"><div class="iconInformation" style="margin:0px auto"></div><div class="list-empty-text system-error-bg">'
								+ jsonData.otherComp.error + '</div></div>'
					});
				} else if(!Ext.isEmpty(jsonData.otherComp.innerTabArray)){
					for (var i = 0; i < jsonData.otherComp.innerTabArray.length; i++) {
						var miniHistoryPanel = this
								.createMiniHistory(jsonData.otherComp.innerTabArray[i]);
						otherItems.push(miniHistoryPanel);
					}
				}
				
				var s= jsonData.screenLabels;
				var otherPanel = {
					xtype : 'scrollpanel',
					layout:'column',
					cls:'datapanel ',
					frame:true,
					margin:'5 10 5 10',
					padding:'0',
					bodyCls : 'fixHistoryUpperPanel',
					autoscroll:true,
					//align : 'center',
					//height : 200,
					itemId:'other',
					title : '<p style="padding-left:0px;padding-top:3px;">'+jsonData.otherComp.header+'</p>',
					flex : 2,
					items : otherItems,
					info : s.info,
					isVM:s.isVM,
					measure : s.measure,
					test : s.test,
					hid_comp_name : s.hid_comp_name,
					source:(Ext.isEmpty(s.source))?null:s.source,
					component:(Ext.isEmpty(s.component))?null:s.component,
					descriptor:(Ext.isEmpty(jsonData.combos[1]))?'':jsonData.combos[1].selected

				};
				this.add(otherPanel);
			}
		}
		if(!Ext.isEmpty(me.mask)){
			me.mask.hide();
		}
	},
	createNoAccessTabUI:function(errorMsg){
		var me=this;
		me.removeAll();

		this.tabToolBar = {
			xtype : 'toolbar',
			id:'tabToolBar',
			items : []
		};

		if(!Ext.isEmpty(me.mask)){
			me.mask.hide();
		}
		errorPanel = this.createAccessErrorPanel(errorMsg);
		this.add([errorPanel]);
	},
	createAccessErrorPanel : function(errorMsg){
	    	var errorPanel = {
					xtype : 'errorpanel',
					cls:'error_panel_body top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
					bodyCls:'error_panel_body top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
					height : '100%',
					width : '100%',
					border : 0,
					style:{'border':'0px !important'},
					border:false,
					autoScroll:true,
					margin : 5,
					errorMsg : '<div style="text-align:center;margin-top:15%"><div class="iconInformation" style="margin:0px auto"></div><div>' + errorMsg+ '</div>',
					flex : 1
	    					
	    	}
	    	return errorPanel;
	},
	returnLabel : function(labelData, i) {
		var labelPanel = {
			xtype : 'panel',
			style:{'text-align':'center'},
			defaults:{
				labelAlign:'top',
				margin:'0 20 10 0'
			},
			layout : 'vbox',
			//padding :5,
			bodyCls : 'feedback-no-border',
			//columnWidth : .2,
			items : [{
						xtype : 'label',
						maxWidth : 100,
						labelSeparator:'',
						cls : 'feedback-upperlabel-style',
						html : '<div class="f11-normal">'+labelData.name+'</div>',
						flex : 1
					}, {
						xtype : 'label',
						html : '<div class="f11-bold">'+labelData.value+'</div>',
						flex : 1
					}]
		};
		return labelPanel;
	},
	returnCombo : function(comboData, width ,i) {

		var comboStore = Ext.create('Ext.data.Store', {
					fields : [{name:'values',convert:function(value, record){
								return Ext.String.htmlDecode(value);
							}}, 'value'],
					proxy : {
						type : 'memory',
						reader : {
							type : 'json',
							root : 'tokens'
						}
					},
					data : comboData
				});

		var compCombo = {
			xtype : 'scrollcombo',
			editable : true,
			store : comboStore,
			labelSeparator:'',
			cls : 'dropdown',
			displayField : 'values',
			valueField : 'value',
			//columnWidth : width,
			itemId:(i==0)?'component':'description',
			width : 250,
			trigerAction : 'all',
			fieldLabel : comboData.name,
			value : comboData.selected,
			queryMode:'local'
			//padding : (i==1)?'5 5 5 90' : '5 5 5 5 '
		};
		return compCombo;
	},
	createMiniHistory : function(data) {
		var historyItems = new Array();
		historyItems.push({
					xtype : 'toolbar',
					//cls : 'measureToolbar',
					layout : 'hbox',
					//height:25,
					//maxHeight : 35,
					flex : 1,
					items : [{
								xtype : 'label',
								html : '<div class="fontnormal_css">&nbsp;&nbsp;&nbsp;'+data.infoDisp+'</div>'
							}, '->',(!Ext.isEmpty(data.deleteUrl))?{
								xtype : 'button',
								text : 'Delete',
								action : 'delete',
								style:{'border':'none !important'},
								cls: 'button20',
								//padding:'0 10 0 10',
								deleteUrl : data.deleteUrl
							}:'']
				});

		var labelPanel = {
			xtype : 'panel',
			bodyCls : 'fixHistoryUpperPanel',
			flex : 1,
			layout : 'hbox',
			items : [this.returnHistoryLabel(data.probTimeText, data.probTime),
					this.returnHistoryLabel(data.fixTimeText, data.fixTime),
					this.returnHistoryLabel(data.compoTypeText, data.compType)]
		}
		historyItems.push(labelPanel);

		var textAreaPanel = {
			xtype : 'panel',
			bodyCls : 'fixHistoryUpperPanel',
			flex : 4,
			layout : 'hbox',
			items : [{
						xtype : 'textarea',
						labelSeparator:'',
						labelWidth:150,
						fieldLabel : data.problemTypeText,
						value : data.problemType,
						padding:'5 5 5 10',
						readOnly:true,
						cls: 'text-area',
						flex : 1,
						minHeight : 100
					}, {
						xtype : 'panel',
						minWidth : 50,
						bodyCls : 'fixHistoryUpperPanel'
					}, {
						xtype : 'textarea',
						labelSeparator:'',
						labelWidth:150,
						fieldLabel : "<div style='padding-right:10px;'>"+data.fixTypeText+"</div>",
						padding:'5 5 5 10',
						cls: 'text-area',
						readOnly:true,
						value : data.fixType,
						flex : 1,
						minHeight : 100
					}]
		}
		historyItems.push(textAreaPanel);

		var historyMiniPanel = {
			xtype : 'panel',
			//flex : 1,
			defaults:{
				//cls:'datapanel',
				margin:'0 0'
			},
			columnWidth:1,
			layout : {
				type : 'vbox',
				align : 'stretch'
			},
			items : historyItems
		}
		return historyMiniPanel;

	},
	returnHistoryLabel : function(name, value) {
		if(Ext.isEmpty(name) || Ext.isEmpty(value))
			return;
		var labelPanel = {
			xtype : 'panel',
			flex : 1,

			defaults:{
				labelAlign:'top'
			},
			layout : 'vbox',
			bodyCls : 'feedback-no-border fixHistoryUpperPanel',
			padding : '5 5 5 10',
			items : [{
						xtype : 'label',
						labelSeparator:'',
						cls : 'feedback-upperlabel-style',
						margin:'0 0 3 0',
						html : '<div class="f11-bold">'+name+'</div>',
						flex : 1
					}, {
						xtype : 'label',
						text : value,
						labelSeparator:'',
						flex : 2
					}]
		};
		return labelPanel;
	}

});