Ext.define('ComponentMeasureTabSet.view.Main', {
	extend: 'Ext.tab.Panel',
	//cls:'tablayout measurtop',
	ui:'newTabPanelBasic',
	requires : ['utilities.OuterPanel','Ext.ux.form.MultiSelect','ComponentMeasureTabSet.view.DetailedDiagnosis','ComponentMeasureTabSet.view.FeedBack','ComponentMeasureTabSet.view.FixHistory','ComponentMeasureTabSet.view.MeasureGraph',
	         'ComponentMeasureTabSet.view.SummaryGraph','ComponentMeasureTabSet.view.TrendGraph','ComponentMeasureTabSet.view.CompareGraph','ComponentMeasureTabSet.view.DetailedDiagnosisAnalysis','ComponentMeasureTabSet.view.CtxLogon','utilities.ErrorPanel'],
	alias:'widget.main',
	//bodyCls:'bottom-right-radius bottom-left-radius',
	tabsInfo:null,
	id:'compMeasTabs',
	margin:'10',
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	initComponent : function() {
		var mask = null;
		var wholeViewport = document.getElementsByTagName("body")[0];
		if(!Ext.isEmpty(Ext.get(wholeViewport))){
			mask = new Ext.LoadMask(Ext.get(wholeViewport), {msg:"Loading...",cls:'maskDash'});
			mask.show();
		}
		var itemsArray=new Array();


		if(isLicenseViolatedType || isLicenseViolatedType == 'true'){
			Ext.destroy(mask);
			itemsArray.push({
						xtype : 'errorpanel',
						cls:'error_panel_body top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
						bodyCls:'error_panel_body top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
						height : '100%',
						width : '100%',
						border : 0,
						style:{'border':'0px !important'},
						border:false,
						autoScroll:true,
						margin : 5,
						errorMsg : '<div style="text-align:center;margin-top:15%"><div class="iconInformation" style="margin:0px auto"></div><div> You are monitoring more concurrent users than permitted by the eG Enterprise license. eG agents for user licensed components will not work properly any longer. Please contact license@eginnovations.com to purchase additional user licenses at the earliest. </div>',
						flex : 1
								
				});
		}
		else if(!Ext.isEmpty(requestParams.tabsInfo)){
			if(reporter_evtHstry)
			{
				//for(var i=0;i<requestParams.tabsInfo.length;i){
					 var type=this.tabsInfo[0].type;
					 var cmpXtype=this.getTabXtype(this.tabsInfo[0].type);
					 itemsArray.push({
						 xtype:cmpXtype,
						 mask: mask,
						 title:this.tabsInfo[0].name,
						 itemId:this.tabsInfo[0].id,
						 tabUrl:this.tabsInfo[0].tabUrl,
						 type:type
					 });
				//}
			}
			else
			{
				for(var i=0;i<requestParams.tabsInfo.length;i++){
					 var type=this.tabsInfo[i].type;
					 var cmpXtype=this.getTabXtype(this.tabsInfo[i].type);
					 itemsArray.push({
						 xtype:cmpXtype,
						 mask: mask,
						 title:this.tabsInfo[i].name,
						 itemId:this.tabsInfo[i].id,
						 tabUrl:this.tabsInfo[i].tabUrl,
						 containsDD:this.tabsInfo[i].containsDD,
						 ddUrl:this.tabsInfo[i].ddUrl,
						 misc:this.tabsInfo[i].misc,
						 type:type
					 });
				}
			}
		}
		this.items=itemsArray;
		this.callParent();
	},
	addTools:function(){
		
	},
	getTabXtype:function(type){
		var cmpXtype='panel';
		switch(type.toLowerCase()){
			case 'ddiagnosis': cmpXtype='detailediagnosis';
				           break;
			case 'ctxlogon': cmpXtype='ctxlogon';
				           break;
			case 'graph': cmpXtype='measuregraph';
	           			   break;
			case 'summarygraph': cmpXtype='summarygraph';
	           			    break;
			case 'trendgraph': cmpXtype='trendgraph';
							break;
			case 'history': cmpXtype='fixhistory';
						    break;
			case 'feedback': cmpXtype='feedback';
		    			    break;	
			case 'compgraph': cmpXtype='compgraph';
		    			    break;	
		}
		return cmpXtype;
	}
});