var ddRedirect;
Ext.define('ComponentMeasureTabSet.view.MeasureGraph', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.measuregraph',
    requires: ['ComponentMeasureTabSet.store.Measures'],
    //	store: 'ComponentMeasureTabSet.store.Measures',
    requires: ['ComponentMeasureTabSet.view.MeasureGraphFilters'],
    tabToolBar: null,
    url: null,
    items: [],
	//overflowX:'auto',
	//overflowY:'scroll',	
	layout: {
		type: 'vbox',
		align: 'stretch'
	},
	//flex:1,
	//height:500,
	scroll:true,
	autoScroll:true,		
    toolTip: Ext.create('Ext.tip.ToolTip', {anchor: 'bottom'}),
    data: null,
    mask: null,
    graphInfoStore: null,
    timelineData: null,
    chartOption: null,
    showLeg: null,
    cls: 'measure-graph-panel',
	ddRedirect:null,
    createTabUI: function (jsonData) {

		try
		{
			if(this.containsDD != undefined && this.containsDD != null && (this.containsDD == true || this.containsDD == 'true')){
				this.ddRedirect = new Object();
				this.ddRedirect.containsDD=this.containsDD;
				this.ddRedirect.ddUrl=this.ddUrl;
				ddRedirect = this.ddRedirect;
			}
		}
		catch (ee)
		{
			ddRedirect = null;
		}
		
		var selectedTimeLine = '';
        var rightMiddlePanel = this.createPanelRightMiddle(jsonData);
        var me = this;
        me.data = jsonData;
        var labelText, timelineObj, timelineVal;
        for (var i = 0; i < jsonData.FormFields.length; i++) {
            if (jsonData.FormFields[i].name == "timeline") {
                this.timelineData = jsonData.FormFields[i];
                timelineObj = jsonData.FormFields[i];
				selectedTimeLine =  timelineObj.selectvalue;
                for (var j = 0; j < timelineObj.items.length; j++) {
                    if (timelineObj.items[j].value == timelineObj.selectvalue) {
                        timelineVal = j;
                    }
                }
            }
            if (jsonData.FormFields[i].name == "mode") {
                if (jsonData.FormFields[i].selectvalue == "2D") {
                    labelText = "3D";
                } else {
                    labelText = "2D";
                }
            }
        }
        chartOption = jsonData.ChartType;
        showLeg = jsonData.showLegend;
        var isHidden = (chartOption != "" && chartOption.indexOf("highchart") > -1) ? true : false;
        this.tabToolBar = {
            xtype: 'toolbar',
            id: 'tabToolBar',
            //padding: '5 5 0 5',
            items: [{
                    xtype: 'label',
                    ttext: labelText,
					hidden:true,
					//padding:'5 5 0 5',
                    trackLabels: true,
                    cls: "icon3d",
                    style: {
                        'color': '#fff',
                        'cursor': 'pointer'
                    },
                    //tooltip: ,
                    action: 'measmode',
                    listeners: {
                        afterrender: function () {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: labelText,
								hidden:true,
                            });
                        },
                        render: function (c) {
                            c.text = labelText;
							c.hidden=true;
                            if (c.text == '2D') {
                                c.addCls('icon2d');
                                c.removeCls('icon3d');
                            } else {
                                c.addCls('icon3d');
                                c.removeCls('icon2d');
                            }
                            c.getEl().on('click', function () {
                                this.fireEvent('click', c);
                            }, c);
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: labelText

                            });
                            //c.getEl().on('mouseover', function(){ this.fireEvent('mouseover', c);}, c);
                        }
                    }
                },
                //				},{
                //					xtype:'label',
                //					text: labelText,
                //					cls:'mode-field',
                //					style:{'color':'#000'},
                //					tooltip: labelText,
                //					action:'measmode',
                //					hidden:isHidden,
                //					listeners : {
                //						render : function(c) {
                //							
                //							c.getEl().on('click', function(){ this.fireEvent('click', c); }, c);
                //							c.getEl().on('mouseover', function(){ this.fireEvent('mouseover', c);}, c);
                //						}
                //					}
                //				},
                {
                    xtype: 'tbseparator',
					hidden:true
                }, {
                    xtype: 'image',
                    cls: 'iconSave',
                    style: {
                        'cursor': 'pointer'
                    },
					//padding:'5 5 0 5',
					itemId:'saveId',
                    action: 'meassave',
                    //tooltip: 'Save',
                    hidden: isHidden,
                    listeners: {

                        render: function (c) {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: saveLbl

                            });
                            c.getEl().on('click', function () {
                                this.fireEvent('click', c);
                            }, c);
                            //c.getEl().on('mouseover', function(){ this.fireEvent('mouseover', c);}, c);
                        }
                    }
                }, {
                    xtype: 'tbseparator',					
                    hidden: isHidden,
					itemId:'saveSep'
                }, {
                    xtype: 'image',
					//padding:'5 5 0 5',
                    cls: 'iconPrinter',
                    action: 'measprint',
					itemId:'printId',
                    style: {
                        'cursor': 'pointer'
                    },
                    //tooltip: 'Print',
                    hidden: isHidden,
                    listeners: {
                        render: function (c) {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: 'Print'

                            });
                            c.getEl().on('click', function () {
                                this.fireEvent('click', c);
                            }, c);
                            //c.getEl().on('mouseover', function(){ this.fireEvent('mouseover', c);}, c);
                        }
                    }
                },{
					xtype:'tbseparator',											
					hidden:isHidden,
					itemId:'printSep'
				},
				{
					xtype:'image',
					//padding:'5 5 0 5',
					cls:'iconData',
					action:'measureData',
					itemId:'imageId',
					style:{'cursor':'pointer'},
					tooltip:dataLbl,
					listeners:{
						render : function(c)
						{
							Ext.create('Ext.tip.ToolTip',{
															target:this.id,
															anchor:'top',
															cls: 'yellowTip',
															trackMouse: true,
															html:dataLbl
															}
								);
								c.getEl().on('click', function () {
                                this.fireEvent('click', c);
                            }, c);
						}
					}
				},
				{
                    xtype: 'tbseparator',					
                    //hidden: isHidden,
                }, {
                    xtype: 'image',
					//padding:'5 5 0 5',
                    cls: 'iconSettings',
                    action: 'measgraphFilters',
                    style: {
                        'cursor': 'pointer'
                    },
                    tooltip: 'Settings',
                    listeners: {
                        render: function (c) {
                            Ext.create('Ext.tip.ToolTip', {
                                target: this.id,
                                anchor: 'top',
                                cls: 'yellowTip',
                                trackMouse: true,
                                html: 'Settings'

                            });
                            c.getEl().on('click', function () {
                                this.fireEvent('click', c);
                            }, c);
                            //c.getEl().on('mouseover', function(){ this.fireEvent('mouseover', c);}, c);
                        }
                    }
                },
				{
                    xtype: 'tbseparator',					
                    //hidden: isHidden,
                },
				{
			xtype : 'button',
			iconCls : 'iconHelp3',									
			//tooltip : '<b>New Window</b>',
			listeners: {
			afterrender: function () {
			Ext.create('Ext.tip.ToolTip', {
			target: this.id,
			anchor: 'top',
			cls: 'yellowTip',										
			trackMouse: true,
			html: 'Help'
			});
			}
			},
			style : {
				'background' : 'none',
				'border' : '0px',
				'margin':'0 10 0 0',
			},
			handler : function()
			{
				HelpWin();
			}
		}
            ]
        };
		var measureListObj = Ext.ComponentQuery.query('#printId');
		if( !Ext.isEmpty( measureListObj ))
		{
			if( isHidden )
			{
				 Ext.ComponentQuery.query('#printId')[(measureListObj.length -1)].hide();
				 Ext.ComponentQuery.query('#printSep')[(measureListObj.length -1)].hide();
				Ext.ComponentQuery.query('#saveId')[(measureListObj.length -1)].hide();
				Ext.ComponentQuery.query('#saveSep')[(measureListObj.length -1)].hide();
			}
			else
			{
				Ext.ComponentQuery.query('#printId')[(measureListObj.length -1)].show();
				Ext.ComponentQuery.query('#printSep')[(measureListObj.length -1)].show();
				Ext.ComponentQuery.query('#saveId')[(measureListObj.length -1)].show();
				Ext.ComponentQuery.query('#saveSep')[(measureListObj.length -1)].show();
				
			}
		}
        var graphPanel = Ext.create('Ext.panel.Panel', {
            layout: {
                type: 'vbox',
                align: 'stretch'
            },
			//flex:1,
            border: false,           
            cls: 'graph-panel',
            id: 'graphone',
			autoScroll:true,
			scroll:true,
			overflowX:'hidden',
            items: [{
                xtype: 'panel',
                
                cls: 'formOuter',
                //flex:1,
                width: '100%',
                layout: {
                    type: 'column',
					 align: 'stretch'
                },               
                items: [{
                        xtype: 'container',
                       layout: {
                    type: 'column',
					 align: 'stretch'
                },
                        margin: '10 10 10 10',
                        frame: true,
                        items: [{
                            xtype: 'slider',
							cls:'mesrslider',
                            plugins: [Ext.create('Ext.ux.FillSlider', {
                                clicksToEdit: 1
                            })],
                            autoHeight: true,
                            width: 300,
                            value: timelineVal,
                            increment: 1,
                            minValue: 0,
                            maxValue: timelineObj.items.length - 1,
                            constrainThumbs: false,
                            fieldLabel: timelineObj.Label + " : " + timelineObj.selectvalue,
                            labelSeparator: '',
                            labelAlign: 'top',
                            animation: true,
                            tipText: function (t) {
                                return Ext.String.format('{0}', timelineObj.items[t.value].value)
                            },
                            action: 'timelinechange'
                        }]
                    },
                    rightMiddlePanel
                ]
            }]
        });


        if (!Ext.isEmpty(jsonData.error)) {
            var noMeasure = Ext.create('utilities.ErrorPanel', {
				style:{'border':'0px !important'},
				border:false,				
                errorMsg: '<div style="text-align:center;margin-top:15%"><div class="iconInformation" style="margin:0px auto"></div><div class="list-empty-text">' + jsonData.error + '</div></div>'
            });
            graphPanel.add({
                xtype: 'panel',
                border: false,
				layout: {
				type: 'vbox',
				align: 'stretch'
				},
                flex: 1,				
                width: '100%',
                items: noMeasure
            });
        } else {
            if (!Ext.isEmpty(jsonData.MultipleGraphsUrl)) {
                if (chartOption != null) {

					if (chartOption.indexOf("highchart") > -1) {
						var isAxisTimeReq = true;
						var title = jsonData.HiddenFields.chartPanelTitle;
						var titleArray = [];
						if (Ext.isEmpty(title))
							title = "";
						else
						{
							titleArray = title.split("^sep^");
						}
						var legendPos = "right";
						for (var j = 0; j < jsonData.MultipleGraphsUrl.length; j++) {
							var url = jsonData.MultipleGraphsUrl[j].Graphs;
							var imgdiv = '<div id="highChart"' + j + '" style="width:100%;height:90%;border 0px solid red;"></div>';
							var panelID = "highChart" + j;
							var titleStr = titleArray[j];
							var containerHeight = ( jsonData.MultipleGraphsUrl.length > 1)?350:(Ext.getBody().getViewSize().height-260);
							titleStr = (!Ext.isEmpty(titleStr))?titleStr:'';
							graphPanel.add([
							{
								xtype:'panel',
								cls:'dataPanel containerShadow',
								margin:'10 10 5 10',
								header:{
									style:{'border':'none'},
								},
								//flex:1,
								title:titleStr,
								layout:{
									type:'vbox',	
									align:'stretch'
								},
								items:[
								{
									xtype: 'container',
									flex:1,
									height: containerHeight,
									padding: '0 10 0 10',
									id: panelID,
									html: imgdiv,
									chartUrl:url,
									inc:j,
									listeners: {
										'afterrender': function (curObj) {
											var chartWidth = ($('.x-container').parent().width()) - 100;
											var chartHeight = ($('#'+curObj.id).height()) - 10;
											loadHSChart(curObj.chartUrl, curObj.id, chartHeight, chartWidth, '', isAxisTimeReq, legendPos, titleStr,true);
										},
										/*'resize': function( tthis, width, height, oldWidth, oldHeight, eOpts )
										{
											if(jsonData.MultipleGraphsUrl.length == 1)
											{
												Ext.getCmp(panelID).setHeight(Ext.getBody().getViewSize().height-260);
												var chartWidth = ($('.x-container').parent().width()) - 100;
												var chartHeight = ($('#'+panelID).height()) - 10;
												 resizeHighChart(panelID,chartWidth,Ext.getBody().getViewSize().height-260);
											}
										}*/
									}
								}]
							}]);
                            if (!Ext.isEmpty(jsonData.GridData.MultipleMeasureGridData[j].MeasureGridData)) {
                                me.graphInfoStore = Ext.create('ComponentMeasureTabSet.store.Measures', {
                                    data: jsonData.GridData.MultipleMeasureGridData[j].MeasureGridData
                                });

                                var graph = {
                                    xtype: 'grid',
                                    header: false,
                                    autoHeight: true,
                                    cls: '',
									ui:'newGridPanel',
									border:true,
									margin: '5 10 0 10',
                                    autoScroll: true,
                                    width: '100%',                                    
                                    store: me.graphInfoStore,
                                    columns: [{
                                        header: jsonData.GridData.MultipleMeasureGridData[j].MeasureGridColumns.MeasureLabel,
										menuDisabled:true,
                                        dataIndex: 'MeasuresDisplay',
                                        flex: 1,
                                        renderer: function (value, metaData, record, rowIndex) {
                                            if (!Ext.isEmpty(jsonData.GridData.MeasureGridData)) {
                                                for (i = 0; i < jsonData.GridData.MeasureGridData.length; i++) // Kaliraj
                                                {
                                                    var returnValue = value + " " + record.raw.MeasuresDisplayUnit; // Kaliraj
                                                }
                                                return returnValue;
                                            } else {
                                                return value;
                                            }
                                        }
                                    }, {
                                        header: jsonData.GridData.MultipleMeasureGridData[j].MeasureGridColumns.MeasureAvgLabel,
                                        dataIndex: 'MeasureAvgDisplay',
										menuDisabled:true,
                                        flex: 1
                                    }, {
                                        header: jsonData.GridData.MultipleMeasureGridData[j].MeasureGridColumns.MeasureMaxLabel,
                                        dataIndex: 'MeasureMaxDisplay',
										menuDisabled:true,
                                        flex: 1
                                    }, {
                                        header: jsonData.GridData.MultipleMeasureGridData[j].MeasureGridColumns.MeasureMinLabel,
                                        dataIndex: 'MeasureMinDisplay',
										menuDisabled:true,
                                        flex: 1
                                    }]
                                };
                                graphPanel.add(graph);
                            }
                        }
                    } else {
                        var title = jsonData.HiddenFields.chartPanelTitle;
                        if (Ext.isEmpty(title))
                            title = "";
                        for (var j = 0; j < jsonData.MultipleGraphsUrl.length; j++) {
                            graphPanel.add([{
                                xtype: 'container',
                                //html:'<b>GraphTitle</b>', //HIGH CHART Title 
                                html: '<b style="font-size:15px;">' + title + '</b>', //HIGH CHART Title 
                                padding: '20 10 0 10',
                                columnWidth: .95
                            }, {
                                xtype: 'image',
                                padding: '0 0 0 30',
                                //height: 320,
                                src: jsonData.MultipleGraphsUrl[j].Graphs
                            }]);
                            if (!Ext.isEmpty(jsonData.GridData.MultipleMeasureGridData[j].MeasureGridData)) {
                                me.graphInfoStore = Ext.create('ComponentMeasureTabSet.store.Measures', {
                                    data: jsonData.GridData.MultipleMeasureGridData[j].MeasureGridData
                                });

                                var graph = {
                                    xtype: 'grid',
                                    header: false,
                                    autoHeight: true,
                                    cls: '',
									ui:'newGridPanel',
									border:true,
                                    autoScroll: true,
                                    width: '100%',
                                    margin: '10',
                                    store: me.graphInfoStore,
                                    columns: [{
                                        header: jsonData.GridData.MultipleMeasureGridData[j].MeasureGridColumns.MeasureLabel,
										menuDisabled:true,
                                        dataIndex: 'MeasuresDisplay',
                                        flex: 1,
                                        renderer: function (value, metaData, record, rowIndex) {
                                            if (!Ext.isEmpty(jsonData.GridData.MeasureGridData)) {
                                                for (i = 0; i < jsonData.GridData.MeasureGridData.length; i++) // Kaliraj
                                                {
                                                    var returnValue = value + " " + record.raw.MeasuresDisplayUnit; // Kaliraj
                                                }
                                                return returnValue;
                                            } else {
                                                return value;
                                            }
                                        }
                                    }, {
                                        header: jsonData.GridData.MultipleMeasureGridData[j].MeasureGridColumns.MeasureAvgLabel,
										menuDisabled:true,
                                        dataIndex: 'MeasureAvgDisplay',
                                        flex: 1
                                    }, {
                                        header: jsonData.GridData.MultipleMeasureGridData[j].MeasureGridColumns.MeasureMaxLabel,
										menuDisabled:true,
                                        dataIndex: 'MeasureMaxDisplay',
                                        flex: 1
                                    }, {
                                        header: jsonData.GridData.MultipleMeasureGridData[j].MeasureGridColumns.MeasureMinLabel,
										menuDisabled:true,
                                        dataIndex: 'MeasureMinDisplay',
                                        flex: 1
                                    }]
                                };
                                graphPanel.add(graph);
                            }
                        }
                        if (!Ext.isEmpty(me.mask)) {
                            me.mask.hide();
                        }
                    }
                    if (!Ext.isEmpty(me.mask)) {
                        me.mask.hide();
                    }
                }
            } else {
                if (Ext.isEmpty(jsonData.GridData.MeasureGridData)) {
                    var noMeasure = Ext.create('utilities.ErrorPanel', {
						style:{'border':'0px !important'},
						border:false,						
                        errorMsg: '<div style="text-align:center;margin-top:15%"><div class="iconInformation" style="margin:0px auto"></div><div class="list-empty-text">No measures available</div></div>'
                    });
                    graphPanel.add({
                        xtype: 'panel',
                        border: false,
						layout: {
						type: 'vbox',
						align: 'stretch'
						},
                        flex: 1,						
                        width: '100%',
                        items: noMeasure
                    });
                    if (!Ext.isEmpty(me.mask)) {
                        me.mask.hide();
                    }
                } else {
                    /*if (!Ext.isEmpty(me.mask)) {
                        me.mask.hide();
                    }*/
                    if (chartOption != null && chartOption.indexOf("highchart") > -1) {
                        var title = jsonData.HiddenFields.chartPanelTitle;
                        if (Ext.isEmpty(title))
                            title = "";
                        var isAxisTimeReq = true;
                        var legendPos = "right";
                        var existPanel = Ext.getCmp('panelone');
                        var existContainer = Ext.getCmp('highChart2');
                        if (!Ext.isEmpty(existPanel))
                            graphPanel.remove(existPanel);
                        if (!Ext.isEmpty(existContainer))
                            graphPanel.remove(existContainer);

                        var imgdiv = '<div id="measHighChart" class="timelineDiv" style="width:100%;height:100%;border 1px solid red;"></div>';
						
                        var url = jsonData.GraphUrl;
                        graphPanel.add([
						{
							xtype:'panel',
							cls:'dataPanel containerShadow',
							margin:'10 10 5 10',
							header:{
								style:{'border':'none'},
							},
							flex:1,
							title:'<p style="padding-top:2px;">'+title+'</p>',
							//title:'<div>'+title+'</div>',
							layout:	{
							type:'vbox',	
							align:'stretch'
							},
							items:[
							{
                            xtype: 'container',
							//flex:1,
							height : Ext.getBody().getViewSize().height-240,
							padding: '2 10 0 10',
                            //width: '100%',
                            id: 'highChart2',
                            html: imgdiv,
                            listeners: {
                                'afterrender': function (imgdiv) {
									var chartWidth = ($('.x-container').parent().width()) - 100;
									var chartHeight = ($('#highChart2').height()) -5;
                                    loadHSChart(url, 'measHighChart', chartHeight,chartWidth, '', isAxisTimeReq, legendPos, title,false,me.mask,ddRedirect);
                                },
								/*'resize': function( tthis, width, height, oldWidth, oldHeight, eOpts )
								{
									Ext.getCmp('highChart2').setHeight(Ext.getBody().getViewSize().height-240);
									var chartWidth = ($('.x-container').parent().width()) - 100;
									var chartHeight = ($('#highChart2').height()) -5;
									 resizeHighChart('measHighChart',chartWidth,Ext.getBody().getViewSize().height-240);
								}*/
                            }

                        }]}]);

                        if (!Ext.isEmpty(jsonData.GridData.MeasureGridData)) {
                            me.graphInfoStore = Ext.create('ComponentMeasureTabSet.store.Measures', {
                                data: jsonData.GridData.MeasureGridData
                            });
                            var graph = {
                                xtype: 'grid',
                                header: false,
                                cls: '',
								ui:'newGridPanel',
								border:true,
                                autoHeight: true,
                                autoScroll: true,
                                width: '100%',
                                margin: '10',
                                store: me.graphInfoStore,
                                columns: [{
                                    header: jsonData.GridData.MeasureGridColumns.MeasureLabel,
									menuDisabled:true,
                                    dataIndex: 'MeasuresDisplay',
                                    flex: 1,
                                    renderer: function (value, metaData, record, rowIndex) {
                                        if (!Ext.isEmpty(jsonData.GridData.MeasureGridData)) {
                                            for (i = 0; i < jsonData.GridData.MeasureGridData.length; i++) // Kaliraj
                                            {
                                                var returnValue = value + " " +
                                                    record.raw.MeasuresDisplayUnit; // Kaliraj				
                                            }
                                            return returnValue;
                                        } else {
                                            return value;
                                        }
                                    }
                                }, {
                                    header: jsonData.GridData.MeasureGridColumns.MeasureAvgLabel,
									menuDisabled:true,
                                    dataIndex: 'MeasureAvgDisplay',
                                    flex: 1
                                }, {
                                    header: jsonData.GridData.MeasureGridColumns.MeasureMaxLabel,
									menuDisabled:true,
                                    dataIndex: 'MeasureMaxDisplay',
                                    flex: 1
                                }, {
                                    header: jsonData.GridData.MeasureGridColumns.MeasureMinLabel,
									menuDisabled:true,
                                    dataIndex: 'MeasureMinDisplay',
                                    flex: 1
                                }]
                            };
                            graphPanel.add(graph);
                        }
                        /*if (!Ext.isEmpty(me.mask)) {
                            me.mask.hide();
                        }*/
                    } else {
                        var title = jsonData.HiddenFields.chartPanelTitle;
                        if (Ext.isEmpty(title))
                            title = "";
                        graphPanel.add([{
                            xtype: 'container',
                            //html:'<b>GraphTitle</b>', //HIGH CHART Title 
                            html: '<b style="font-size:15px;">' + title + '</b>', //HIGH CHART Title 
                            padding: '20 10 0 10',
                            columnWidth: .95
                        }, {
                            xtype: 'image',
                            padding: '0 0 0 30',
                            autoHeight: true,
                            src: jsonData.GraphUrl,
                            listeners: {
                                afterrender: function (img) {
                                    img.el.on({
                                        load: function (evt, ele, opts) {
                                            if (!Ext.isEmpty(jsonData.GridData.MeasureGridData)) {
                                                me.graphInfoStore = Ext.create('ComponentMeasureTabSet.store.Measures', {
                                                    data: jsonData.GridData.MeasureGridData
                                                });
                                                var graph = {
                                                    xtype: 'grid',
                                                    header: false,
                                                    cls: '',
													ui:'newGridPanel',
													border:true,
                                                    autoHeight: true,
                                                    autoScroll: true,
                                                    width: '100%',
                                                    margin: '10',
                                                    //padding:30,
                                                    store: me.graphInfoStore,
                                                    columns: [{
                                                        header: jsonData.GridData.MeasureGridColumns.MeasureLabel,
														menuDisabled:true,
                                                        dataIndex: 'MeasuresDisplay',
                                                        flex: 1,
                                                        renderer: function (value, metaData, record, rowIndex) {
                                                            if (!Ext.isEmpty(jsonData.GridData.MeasureGridData)) {
                                                                for (i = 0; i < jsonData.GridData.MeasureGridData.length; i++) // Kaliraj
                                                                {
                                                                    var returnValue = value + " " + record.raw.MeasuresDisplayUnit; // Kaliraj

                                                                }
                                                                return returnValue;
                                                            } else {
                                                                return value;
                                                            }
                                                        }
                                                    }, {
                                                        header: jsonData.GridData.MeasureGridColumns.MeasureAvgLabel,
														menuDisabled:true,
                                                        dataIndex: 'MeasureAvgDisplay',
                                                        flex: 1
                                                    }, {
                                                        header: jsonData.GridData.MeasureGridColumns.MeasureMaxLabel,
														menuDisabled:true,
                                                        dataIndex: 'MeasureMaxDisplay',
                                                        flex: 1
                                                    }, {
                                                        header: jsonData.GridData.MeasureGridColumns.MeasureMinLabel,
														menuDisabled:true,
                                                        dataIndex: 'MeasureMinDisplay',
                                                        flex: 1
                                                    }]
                                                };
                                                graphPanel.add(graph);
                                            }
                                            if (!Ext.isEmpty(me.mask)) {
                                                me.mask.hide();
                                            }
                                        }
                                    });
                                }
                            }
                        }]);
                    }
                }
            }
        }
        me.add(graphPanel);
        if (!Ext.isEmpty(tempApp.getController("MeasureGraph")))
		{
            tempApp.getController("MeasureGraph").measureFilter('create');
			if(!Ext.isEmpty(selectedTimeLine) && selectedTimeLine ==="Any")
				tempApp.getController("MeasureGraph").enableHourCombos();
		}
        /*if(!Ext.isEmpty(me.mask)){
			me.mask.hide();
		}*/
    },
	createNoAccessTabUI:function(errorMsg){
		var me=this;
		me.removeAll();

		this.tabToolBar = {
			xtype : 'toolbar',
			id:'tabToolBar',
			items : []
		};

		if(!Ext.isEmpty(me.mask)){
			me.mask.hide();
		}
		errorPanel = this.createAccessErrorPanel(errorMsg);
		this.add([errorPanel]);
	},
	createAccessErrorPanel : function(errorMsg){
	    	var errorPanel = {
					xtype : 'errorpanel',
					cls:'error_panel_body top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
					bodyCls:'error_panel_body top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
					height : '100%',
					width : '100%',
					border : 0,
					style:{'border':'0px !important'},
					border:false,
					autoScroll:true,
					margin : 5,
					errorMsg : '<div style="text-align:center;margin-top:15%"><div class="iconInformation" style="margin:0px auto"></div><div>' + errorMsg+ '</div>',
					flex : 1
	    					
	    	}
	    	return errorPanel;
	},
	createGraphButton:function(buttonData, jsonData){
		var isHidden = true;
		 for (var i = 0; i < 4; i++) {
            var filterData = jsonData.FormFields[i];
			if( filterData.name.toLowerCase() == "timeline" )
			 {
					isHidden = ( filterData.selectvalue.toLowerCase() == 'any' )?false:true;
			 }
		 }
		if (buttonData.name == "graph")
		{
			var button={xtype:'container',items:[{
					xtype: 'button',
					cls:'button20',
					//height:22,
				    //padding:'2 3 2 3',
					margin: '22 0 0 0',
					text: buttonData.text,
					name: buttonData.name,
					//cls : 'buttonalarm measurbutton',
					action: buttonData.name+'btn',
					hidden: isHidden
			}]}	
			return button;
		}
	},
    createPanelRightMiddle: function (jsonData) {
		var isChecked = jsonData.LegendInChart;
		isChecked = (isChecked == 'false' || isChecked == 'no' || isChecked==false )?0:1;
		
		var filterArray = new Array();
        for (var i = 0; i < jsonData.FormFields.length; i++) {
            var filterData = jsonData.FormFields[i];
            var filterComp = null;
			//if (filterData.name == "starthr" || filterData.name == "endhr" || filterData.name == "FromDate" || filterData.name == "todate" || filterData.name == "graph") {
			//added by ramesh
	         if (filterData.name == "startmin" || filterData.name == "endmin" || filterData.name == "starthr" || filterData.name == "endhr" || filterData.name == "FromDate" || filterData.name == "todate" || filterData.name == "graph" || filterData.name=="showLegend") {
                switch (filterData.type) {
                case "combo":
                    filterComp = this.createCombo(filterData);
                    break;
                case "date":
                    filterComp = this.createDateField(filterData);
                    break;
                case "button":
                    filterComp = this.createGraphButton(filterData, jsonData);
                    break;
				case "checkboxgroup":
					 filterComp = {xtype:'container',items:[{
							xtype:'checkboxgroup',
							margin: '22 0 0 0',
							width:120,
							//cls: 'checkbt',
							id: 'er_chart_checkbox',
							//margin:'0 5 0 5',
							items: [{
								//boxLabel: 'Show Legends',
								boxLabel: filterData.text,
								inputValue: 'true',
								itemId: 'showLegend',
								cls: 'showLegend checkbt',
								checked:isChecked
							}]
						}]
					}
					 break;
                }
            }

            if (!Ext.isEmpty(filterComp)) {
                filterArray.push(filterComp);
            }
        }

        var rightMiddlePanel = {
            xtype: 'panel',
            layout: {
                    type: 'hbox',
					 align: 'stretch'
                },
			bodyStyle:{'background':'transparent!important'},
            //flex:1,
            //padding:'1 5 5 15',
            margin:'5 0 0 0',
            //frame:true, //right middle 3
            width: 680,
            border: true,
            defaults: {
                labelAlign: 'top',
                labelSeparator: ''

            },
            items: filterArray
        }
        return rightMiddlePanel;
    },
    createCombo: function (comboData) {
        if (comboData.name != "timeline" && comboData.name != "mode") {
            var comboStore = Ext.create('Ext.data.Store', {
                fields: ['name', 'value'],
                proxy: {
                    type: 'memory',
                    reader: {
                        type: 'json',
                        root: 'items'
                    }
                },
                data: comboData
            });

            var compCombo = {
                xtype: 'combo',
                editable: false,
                store: comboStore,
                cls: 'dropdown',
                displayField: 'name',
                valueField: 'value',
                padding: '0 5',
                labelWidth: 80,

                fieldLabel: comboData.Label,
                value: comboData.selectvalue ? comboData.selectvalue : comboData.items[0].value,
                itemId: comboData.name,
                action: comboData.name,
                queryMode: 'local'
            };
            if (!Ext.isEmpty(comboData.Label)) {
                if (comboData.Label == tmp_measureTextt) {
                    compCombo = {
                        xtype: "multiselectfield",
                        fieldLabel: comboData.Label,
                        allowBlank: false,
                        labelAlign: "top",
                        labelStyle: 'position:absolute;top:-3px',
                        margin: '5 10 0 3',
                        autoScroll: false,
                        scroll: false,
                        width: 230,
                        height: 90,
                        store: comboStore,
                        value: comboData.selectvalue ? comboData.selectvalue : comboData.items[0].value,
                        displayField: "name",
                        valueField: "value",
                        listConfig: {
                            simpleSelect: true
                        },
                        queryMode: "local",
                        action: comboData.name
                    };
                }
            }
            if (comboData.name == "starthr" || comboData.name == "endhr") {
                compCombo.labelWidth = 20;
                compCombo.width = 55;
                compCombo.defaultListConfig = {
                    minWidth: 55,
                    loadingHeight: 55
                };
                compCombo.disabled = true;
            }

		
			if (comboData.name == "startmin" || comboData.name == "endmin") {
                compCombo.labelWidth = 20;
                compCombo.width = 55;
                compCombo.defaultListConfig = {
                    minWidth: 55,
                    loadingHeight: 55
                };
				compCombo.hidden = false;
				compCombo.disabled = true;
            }

			//

            if (comboData.name == "er_interval" || comboData.name == "er_integrate") {
                compCombo.disabled = true;
            }
            if (comboData.name == "er_otherTime") {
                compCombo.width = 95;
                compCombo.disabled = true;
                compCombo.hidden = true;
            }
            if (comboData.name == "infolist") {
                compCombo.width = 205;
                //compCombo.disabled=true;
                //compCombo.hidden=true;
            }

            /*if(comboData.name=="measurelist"){
				compCombo.multiSelect=true;
				if(comboData.selectvalue.indexOf(",")>-1){
					var values=comboData.selectvalue.split(',');
					compCombo.value=values;
				}								
			}*/
            return compCombo;
        }
    },
    createDateField: function (fieldData) {
			var data;
		
			data = fieldData.selectedValue;			
			
			if(data == "Invalid Date"){
				data = new Date(fieldData.selectedValue);
			}
		
				
		
		var dateField = {
            xtype: 'datefield',
            cls: 'datepicker',
            fieldLabel: fieldData.Label,
            format: requestParams.mgr_dateFormat,
            //format:'M d,Y',
            //value:fieldData.selectedValue,
            value:data, 
			//value: new Date(fieldData.selectedValue),
            labelWidth: 50,
            editable: false,
            disabled: true,
            padding: '0 5',
            width: 110,
            itemId: fieldData.name,
            action: fieldData.name
        }

        if (fieldData.name == "FromDate") {
            dateField.labelWidth = 35;
            //dateField.width=150;
        } else if (fieldData.name == "todate") {
            dateField.labelWidth = 20;
            //dateField.width=135
        }
        return dateField;
    }
});