Ext.require([ 
    'Ext.form.Panel',
    'Ext.ux.form.MultiSelect'
]);
Ext.define('ComponentMeasureTabSet.view.MeasureGraphFilters', {
	extend: 'Ext.window.Window',
	alias:'widget.measuregraphfilters',
	header:false,
	//padding:'5',
	flotable:false,
	floating:false,
	//id:'meaureFilter',
	itemId:'meaureFilter',
	resizable: false,
	padding:'5 5 0 5',
	buttonAlign:'center',
	defaults:{labelSeparator:''},
	layout:{
		type: 'vbox',
		align: 'stretch'
	},
	//closable:false,

	cls:'tabsetsettingsWindow measure-graph-panel',	
	initComponent : function(){
	this.callParent();
	},
	createItems : function(jsonData){
		if(!Ext.isEmpty(jsonData.FormFields)){
			var filterPanelLeft = this.createPanelLeft(jsonData);		

			var rightTopPanel = this.createPanelRightTop(jsonData);
			var rightLegendPanel = this.createPanelRightLegend(jsonData);
			var rightMiddlePanel = this.createPanelRightMiddle(jsonData);
			var rightBottomPanel = this.createPanelRightBottom(jsonData);		

			var filterPanelRight = ('utilities.ScrollPanel',{
				flex:1,
				bodyCls:'top-right-radius',
				cls:'filter-top-right-panel',
				autoScroll:true,
				height:'100%',
				layout:{
					type: 'vbox',
					align: 'stretch'
				},
				items:[{
					xtype:'container',
					layout:{
					type: 'hbox',
					align: 'stretch'
				},
					margin:'0 0 0 0',
					items:[
					rightTopPanel,rightLegendPanel]
				},{
					xtype:'container',					
					layout:{
					type: 'hbox',
					align: 'stretch'
				},
					items:[
					rightBottomPanel]
				}]
			});
			var topPanel = ('Ext.panel.Panel',{
				layout:{
					type: 'vbox',
					align: 'stretch'
				},
				header:false,
				border:false,
				items:[filterPanelLeft,filterPanelRight]			
			});

			//var buttonPanel = this.createButtonPanel(jsonData);
		
				var buttonArray = this.createButtonPanel(jsonData);
			
			this.add(topPanel);
			this.addDocked({
				xtype: 'toolbar',
				cls:'toolbarPositionManual',
				ui:'footer',
				buttonAlign:'center',
				layout:	{type:'hbox',
						pack:'center',
					align:'stretch'},
			    dock: 'bottom',
			   // baseCls:'graph-toolbar',
			    items: buttonArray
			});
			this.doLayout();
		}
	},

	createPanelLeft : function(jsonData) {	
		var filterArray=new Array();
		for(var i=0; i< jsonData.FormFields.length; i++){
			var filterData=jsonData.FormFields[i];
			var filterComp=null;
			
			if(filterData.name=="timeline" || filterData.name=="measurelist" || filterData.name=="infolist" || filterData.name=="er_history" || filterData.type=="label"){
				switch(filterData.type){
				case "combo": 
					filterComp=this.createCombo(filterData);
					break;
				/*case "label": 
					filterComp=this.createLabel(filterData);
					break;
				case "checkbox": 
					filterComp=this.createCheckbox(filterData);
					break;*/					
				}
			}
			else if(filterData.type=="trigger")
			{
				filterComp=this.createTrigger(filterData);
			}
			if(!Ext.isEmpty(filterComp)){
				filterArray.push(filterComp);
			}
		}

		var leftPanel = {
				xtype : 'panel',
				layout:'column',
				width:'100%',
				height:100,
				padding:'5 5 0 5',
				//flex:1, 
				bodyCls:'top-left-radius',
				//frame:true, //left
				cls:'filter-top-panel',
				defaults:{
				labelAlign:'top',
				labelSeparator:''
			},
				items  : filterArray
		}	
		return leftPanel;
	},
	createPanelRightLegend: function(jsonData) {
		var isChecked = jsonData.LegendInChart;
		isChecked = (isChecked == 'false' || isChecked == 'no' )?0:1;
		var rightTopLegendPanel = Ext.create('Ext.panel.Panel',{
			xtype : 'panel',
			flex:0.5,
			padding:'0 5 0 5',
			margin:'25 5 0 0',
			height:30,
			//frame:true, //right top 2
			layout:'fit',
			border:false,
			defaults:{
				labelSeparator:''
			}
		});
		//rightTopPanel.add(filterComp);
		/*rightTopLegendPanel.add({
			xtype:'checkboxgroup',
			margin:'10 0 0 0',
			//cls: 'checkbt',
			//id: 'er_mgf_checkbox',
			//margin:'0 5 0 5',
			items: [{
				boxLabel: 'Show Legends',
				inputValue: 'true',
				itemId: 'showLegend',
				cls: 'showLegend checkbt',
				checked:isChecked
				}]
		});*/
		return rightTopLegendPanel;
	},
	createPanelRightTop : function(jsonData) {	
		var isChecked = jsonData.LegendInChart;
		isChecked = (isChecked == 'false' || isChecked == 'no' )?0:1;
		var rightTopPanel = Ext.create('Ext.panel.Panel',{
			xtype : 'panel',
			width:230,
			padding:'0 0 0 5',
			margin:'5 5 0 5',
			//frame:true, //right top 2
			layout:'hbox',
			border:false,
			defaults:{
				labelSeparator:''
			}
		});
		var filterArray=new Array();
		for(var i=0; i< jsonData.FormFields.length; i++){
			var filterData=jsonData.FormFields[i];
			if(Ext.isEmpty(jsonData.HiddenFields.maxValue))
			{
				jsonData.HiddenFields.maxValue=10000;
			}
			if(Ext.isEmpty(jsonData.HiddenFields.minValue))
			{
				jsonData.HiddenFields.minValue=0;
			}
			var filterComp=null;
			if(filterData.type=="slider"){
				filterComp={
						xtype:'slider',
						padding:5,
						width:200,
						//plugins:[Ext.create('Ext.ux.FillSlider', {clicksToEdit: 1})],
						values: [filterData.minvalue ? filterData.minvalue : jsonData.HiddenFields.minValue,filterData.maxvalue ? filterData.maxvalue : jsonData.HiddenFields.maxValue],
						increment: 1,
						minValue:jsonData.HiddenFields.minValue,
						maxValue: jsonData.HiddenFields.maxValue,
						constrainThumbs: false,					
						fieldLabel: filterData.Label,
						labelAlign:'top',
						animation: true,
						tipText: function (t) {
							return Ext.String.format('{0}', t.value)
						},
						action:'datarangeSlider'
				};	
				//rightTopPanel.add(filterComp);
				rightTopPanel.add({
					xtype:'label',
					padding: '25 0 0 0',
					labelStyle:'font-weight:bold',
					html:'<div style="font-weight:bold">Data Range</div>'
				},{
					xtype: 'textfield',
					padding: '5 10 10 10',
					minWidth:60,
					fieldLabel:minLbl,
					labelAlign:'top',
					maxWidth:60,
					cls: 'textbox',
					action:'datarangeMin',
					itemId:'rangeMin',
					//readOnly:true,
					value:filterData.minvalue ? filterData.minvalue : ""
				},{
					xtype: 'textfield',
					padding: '5 10 10 10',
					minWidth:60,
					labelAlign:'top',
					fieldLabel:maxLbl,
					maxWidth:60,
					cls: 'textbox',
					action:'datarangeMax',
					itemId:'rangeMax',
					//readOnly:true,
					value:filterData.maxvalue ? filterData.maxvalue : ""
				});
			}
		}			
		return rightTopPanel;
	},

	createPanelRightMiddle : function(jsonData) {	
		var filterArray=new Array();
		for(var i=0; i< jsonData.FormFields.length; i++){
			var filterData=jsonData.FormFields[i];
			var filterComp=null;
			if(filterData.name=="starthr" || filterData.name=="endhr" || filterData.name=="FromDate" || filterData.name=="todate"){
				switch(filterData.type){
				case "combo": 
					filterComp=this.createCombo(filterData);
					break;
				case "date": 
					filterComp=this.createDateField(filterData);
					break;					
				}
			}

			if(!Ext.isEmpty(filterComp)){
				filterArray.push(filterComp);
			}
		}		
		
		var rightMiddlePanel = {
				xtype : 'panel',
				layout:'hbox',
				flex:1,
				padding:'0 5 5 5',
				margin:'0 0 0 0',
				//frame:true, //right middle 3
				border:false,
				defaults:{
					labelAlign:'top',
					labelSeparator:''
					
				},
				items  : filterArray
		}	
		return rightMiddlePanel;
	},

	createPanelRightBottom : function(jsonData) {	
		var filterArray=new Array();
		for(var i=0; i< jsonData.FormFields.length; i++){
			var filterData=jsonData.FormFields[i];
			var filterComp=null;
			if(filterData.name=="er_history" || filterData.type=="label" || filterData.name=="er_interval" || filterData.name=="er_integrate" || filterData.name=="er_otherTime"){
				//filterComp=this.createCombo(filterData);

				switch(filterData.type){
				case "combo": 
					filterComp=this.createCombo(filterData);
					break;
				case "label": 
					filterComp=this.createLabel(filterData);
					//filterComp.width =150;
					break;
				case "checkbox": 
					filterComp=this.createCheckbox(filterData);
					break;					
				}


			}
			
			if(!Ext.isEmpty(filterComp)){
				filterArray.push(filterComp);
			}

		}

		var rightBottomPanel = {
				xtype : 'panel',
				layout:'hbox', 
				//flex:1,
				//frame:true,//bottom
				padding:'0 5 0 5',
				
				border:false,
				defaults:{
					labelAlign:'top',
					labelSeparator:'',
					width:70
					
				},
				items  : filterArray
		}	
		
		return rightBottomPanel;
	},
	createButtonPanel : function(jsonData) {	
		var filterArray=new Array();
		//filterArray.push('->');
		for(var i=0; i< jsonData.FormFields.length; i++){
			var filterData=jsonData.FormFields[i];
			var filterComp=null;
			if (filterData.name!='data' && filterData.type=="button")
			{
				filterComp=this.createButton(filterData);
			}
			if(!Ext.isEmpty(filterComp)){
				filterArray.push(filterComp);
			}
		}
		//filterArray.push();
		
		return filterArray;
	},

	createCombo:function(comboData){
		var isHidden = (comboData.name == 'timeline')?true:false;
		var type="combo";
		var isEdit=false;
		
		
		if(comboData.name=="infolist")
		{
			descriptorRawData=comboData.items;
			type="scrollcombo";
			isEdit=true;

		}
		if(comboData.name!="mode"){
			var comboStore = Ext.create('Ext.data.Store',{
				fields:['name','value'],
				proxy:{
					type: 'memory',
					reader: {
						type: 'json',
						root:'items'
					}
				},
				data:comboData
			});
			var compCombo={
					xtype:type,
					editable : isEdit,
					store:comboStore,	
					typeAhead: true,
					forceSelection: true,
					cls : 'dropdown',
					displayField:'name',
					valueField:'value',
					padding: '5 5 0 5',
					labelWidth:80,
					hidden:isHidden,
					fieldLabel:comboData.Label,
					value:comboData.selectvalue ? comboData.selectvalue : comboData.items[0].value,
					itemId:comboData.name,
					action:comboData.name,
					queryMode:'local'
			};	
			if(!Ext.isEmpty(comboData.Label))
			{
				if(comboData.Label==tmp_measureTextt)
				{
					compCombo={
						xtype:"multiselectfield",
						fieldLabel:comboData.Label,
						allowBlank:false,
						labelAlign:"top",
						labelStyle:'position:absolute;top:-6px',
						margin:'5 10 0 3',
						autoScroll:false,
						scroll:false,
						width:230,
						height:100,
						store:comboStore,
						value:comboData.selectvalue ? comboData.selectvalue : comboData.items[0].value,
						displayField:"name",
						valueField:"value",
						listConfig: {simpleSelect: true},
						queryMode:"local",
						action:comboData.name,
						itemId:comboData.name
						};
				}
			}
			if(comboData.name=="starthr" || comboData.name=="endhr"){
				compCombo.labelWidth=20;
				compCombo.width=75;
				compCombo.defaultListConfig={
						minWidth: 55,
						loadingHeight: 55
				};
				compCombo.disabled=true;
			}
			
			if(comboData.name=="er_interval"){
				compCombo.width=95;
				if(comboData.selectvalue != null && comboData.selectvalue=="180"){
					isNeeded=false;
				}else{
					isNeeded=true;
				}
			}
			if(comboData.name=="er_integrate"){
				compCombo.width=95;				
				if(isNeeded != null && isNeeded == false){
					compCombo.disabled=true;
					compCombo.hidden=true;
				}
			}
			if(comboData.name=="er_otherTime"){
				compCombo.margin="25 0 0 5";
				compCombo.width=95;
				if(isNeeded != null && isNeeded == true){
					compCombo.disabled=true;
					compCombo.hidden=true;
				}
			}
			if(comboData.name=="infolist"){
				compCombo.width=205;
				//compCombo.disabled=true;
				//compCombo.hidden=true;
			}
			
			/*if(comboData.name=="measurelist"){
				compCombo.multiSelect=true;
				if(comboData.selectvalue.indexOf(",")>-1){
					var values=comboData.selectvalue.split(',');
					compCombo.value=values;
				}								
			}*/
			return compCombo;	
		}		
	},
	createTrigger :function(fieldData)
	{
		var compCombo={ 
		fieldLabel: 'Search',
		hidden:true,
		xtype: 'triggerfield',
		id:'descriptionOpt',
		name:'descriptionOpt',
		enableKeyEvents : true,
		labelAlign: 'top',
		cls: 'whitedropdown_search',
		width: 150,
		};
		return compCombo;
	},
	createDateField:function(fieldData){
			var data;
		
			data = fieldData.selectedValue;			
			
			if(data == "Invalid Date"){
				data = new Date(fieldData.selectedValue);
			}

		var dateField={
				xtype:'datefield',
				cls : 'datepicker',
				fieldLabel:fieldData.Label,
				format:requestParams.mgr_dateFormat,
				//format:'M d,Y',
				//value:fieldData.selectedValue,
				//value:new Date(fieldData.selectedValue),
				value:data,
				labelWidth:50,
				editable:false,
				disabled:true,
				padding: '0 5',
				width:110,
				itemId:fieldData.name,
				action:fieldData.name
		}	

		if(fieldData.name=="FromDate"){
			dateField.labelWidth=35;
			//dateField.width=150;
		}else if(fieldData.name=="todate"){
			dateField.labelWidth=20;
			//dateField.width=135
		}	
		return dateField;
	},

	createLabel:function(labelData){
		var label={
				xtype:'label',
				labelSeparator:'',
				width:230,
				html: '<div style="font-weight:bold;float: left">'+labelData.Label+'</div><div class="handSymbol"  data-qtip="'+labelData.measureValueTooltip+'" data-qclass="yellowTip">'+" : "+labelData.measureValue+'</div>',
				cls:'lookup-field',
				padding:'30 10 0 10'
		}		
		return label;
	},

	createButton:function(buttonData){
		var button={
				xtype:'button',
				text: buttonData.text,
				name: buttonData.name,
				cls : 'buttonalarm measurbutton',
				action: buttonData.name
		}	
		
		return button;
	},

	createCheckbox:function(boxData){
		var checkbox={
				xtype:'checkbox',
				padding:'5 0 10 10',
				itemId: 'lookBackId',
				cls:'lookback checkbt',
				boxLabel  : boxData.Label,
				boxLabelAlign:'before',
				action:'lookback',
				checked:boxData.checked
		}		
		return checkbox;
	}

});