Ext.define('ComponentMeasureTabSet.view.SummaryGraph', {
	extend: 'Ext.panel.Panel',
	alias:'widget.summarygraph',
	requires : ['ComponentMeasureTabSet.view.SummaryGraphFilters'],
	url:null,
	tabToolBar:null,
	items : [],
	layout:'fit',
	cls:'measure-graph-panel',
	toolTip:Ext.create('Ext.tip.ToolTip',{anchor:'bottom'}),
	data:null,
	mask:null,
	timelineData:null,
	createTabUI:function(jsonData){
		var filterlength = jsonData.Filters.length;
		var middlePanel = '';		
		if(filterlength === 12)
		{
			middlePanel = this.createMiddlePanel(jsonData,4,8);
		}else 
		if(filterlength === 11)
		{
			middlePanel = this.createMiddlePanel(jsonData,2,7);
		}
		else
		{
			middlePanel = this.createMiddlePanel(jsonData,2,6);
		}
		var me=this;
		me.data=jsonData;	
		
		var labelText,timelineObj,timelineVal;
		if(!Ext.isEmpty(jsonData.Filters))
		{
			for(var i=0; i< jsonData.Filters.length; i++){
				if(jsonData.Filters[i].name=="timeline"){	
					this.timelineData=jsonData.Filters[i];
					timelineObj=jsonData.Filters[i];
					for(var j=0;j<timelineObj.items.length;j++){
						if(timelineObj.items[j].value==timelineObj.selectvalue){
							timelineVal=j;
						}
					}
				}
				if(jsonData.Filters[i].name=="mode"){		
					if(jsonData.Filters[i].selectvalue=="3D"){
						labelText="2D";
					}else{
						labelText="2D";
					}
				}
			}
		}
		this.tabToolBar = {
				xtype:'toolbar',
				id:'tabToolBar',
				//padding:'0',
			items:[
//				{
//					xtype:'label',
//					text: labelText,
//					cls:'mode-field',
//					style:{'color':'#000'},
//					tooltip:labelText,
//					action:'summode',
//					listeners : {
//						render : function(c) {
//							c.getEl().on('click', function(){this.fireEvent('click', c); }, c);
//							c.getEl().on('mouseover', function(){ this.fireEvent('mouseover', c);}, c);
//						}
//					}
//				},
				{
					xtype:'label',
					ttext: labelText,
					
					trackLabels: true,
					cls:"icon3d",
					style:{'cursor':'pointer'},
					//tooltip: ,
					action:'summode',
					hidden:true,
					listeners : {
					
						render : function(c) {

							c.text=labelText;
							if(c.text=='2D'){
								c.addCls('icon2d');
								c.removeCls('icon3d');
							}else{
									c.addCls('icon3d');
									c.removeCls('icon2d');
								}
							c.getEl().on('click', function(){ this.fireEvent('click', c); }, c);
							Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html:labelText
												
																});
							//c.getEl().on('mouseover', function(){ this.fireEvent('mouseover', c);}, c);
						}
					}},
					{
					xtype:'tbseparator',
					hidden:true
					
				},{
					xtype:'image',
					style:{'cursor':'pointer'},
					cls:'iconSettings',
					action:'graphFilters',
					//tooltip:'Settings',
					listeners : {
						
						render : function(c) {
							Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html: 'Settings'
																});
							c.getEl().on('click', function(){ this.fireEvent('click', c); }, c);
							//c.getEl().on('mouseover', function() { this.fireEvent('mouseover',c); }, c);
						}
					}
				},
				{
					xtype:'tbseparator',
					//hidden:true
					
				},
				{
			xtype : 'button',
			iconCls : 'iconHelp3',									
			//tooltip : '<b>New Window</b>',
			listeners: {
			afterrender: function () {
			Ext.create('Ext.tip.ToolTip', {
			target: this.id,
			anchor: 'top',
			cls: 'yellowTip',										
			trackMouse: true,
			html: 'Help'
			});
			}
			},
			style : {
				'background' : 'none',
				'border' : '0px',
				'margin':'0 10 0 0',
			},
			handler : function()
			{
				HelpWin();
			}
		}]
			};
		var title = jsonData.hiddeninfo.chartTitle;
		if(Ext.isEmpty(title))
			title = "";
		var graphPanel= Ext.create('Ext.panel.Panel',{
			height:'100%',
			layout: {type:'vbox',align:'stretch'},
			border:false,
			//height:800,
			cls:'graph-panel',
			items:[{
			xtype:'container',
			layout:{type:'column'},
			//height:200,
			items:[{
				xtype:'panel',
				layout:'column',
				margin:'10 10 0 10',
				border:true,
				columnWidth:1,
				cls:'formOuter',
				items:[{
					xtype:'slider',
					margin: '10 10 10 10',
					cls:'mesrslider',
					width:300,
					//columnWidth:1,
					plugins:[Ext.create('Ext.ux.FillSlider', {clicksToEdit: 1})],
					autoHeight:true,
					value: timelineVal,
					increment: 1,
					minValue: 0,
					maxValue: timelineObj.items.length-1,
					constrainThumbs: false,
					fieldLabel: timelineObj.Lable+" : "+timelineObj.selectvalue,
					labelSeparator:'' ,
					labelAlign:'top',
					animation: true,
					action:'timelinechange',
					tipText: function (t) {
						return Ext.String.format('{0}', timelineObj.items[t.value].value)
					}
				},middlePanel]
			}]
			}]
		});
		if(!Ext.isEmpty(jsonData.Errormsg)){
			var noMeasure = Ext.create('utilities.ErrorPanel',{
				style:{'border':'0px !important'},
				border:false,
				errorMsg : '<div style="text-align:center;margin-top:15%"><div class="iconInformation" style="margin:0px auto"></div><div class="list-empty-text">'+jsonData.Errormsg+'</div></div>'
			});
			
			graphPanel.add({
				xtype:'panel',
				border:false,
				layout:'fit',
				flex:1,
				width:'100%',
				items: noMeasure
			});
			
		}
		else{
		
			/*var htmlstring = '<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="960" height="420" id="StackedColumn" >'
				+'<param name="FlashVars" value="&dataXML='+jsonData.GraphData.xmldata+'">'
				+'<param name="quality" value="high" />'
				+'<param name="WMode" value="Transparent">'
				+'<param name="movie" value="/final/FusionCharts/swf/StackedColumn'+jsonData.GraphData.modename+'.swf" />'
				+'<embed wmode="transparent" src="/final/FusionCharts/swf/StackedColumn'+jsonData.GraphData.modename +'.swf" flashVars="&dataXML='+jsonData.GraphData.xmldata+'" quality="high" width="960" height="400" name="Column" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />'
				+'<param name="WMode" value="Transparent">'
				+'</object>';*/

			var cdId="summaryGraphPanelId";
			var cfId="summaryGraphPanelId";
			var highChartIns = null;
			htmlstring='<div style="margin:auto;padding:3px;display:inline-block;"><div id="'+cdId+'" class="timelineDiv" style="height:90%;"></div></div>';
			var barChartHeight = Ext.getBody().getViewSize().height;
			graphPanel.add([
				{
					xtype:'panel',
					cls:'dataPanel containerShadow',
					margin:10,				
					title:'<p style="padding-top:2px;">'+title+'</p>',
					header:{
						style:{'border':'none'},
					},
					layout:	{
					type:'vbox',	
					align:'stretch'
					},
					items:[{
						xtype:'container',
						border:false,
						//layout:'fit',
						style:{'text-align':'center'},
						//autoHeight:true,
						height:Ext.getBody().getViewSize().height-170,
						html: htmlstring,
						cdId:cdId,
						cfId:cfId,
						id:'stackedId',
						padding: '10 10 10 10',
						fcwidth:jsonData.GraphData.width,
						fcheight:jsonData.GraphData.height,
						fctype:jsonData.GraphData.modename,
						fcXmlData:jsonData.GraphData.xmldata,
						listeners:{
							 'afterrender': function(currObj)
							{
								if (fusionChartsApiEnabled)
								{
									if  ( FusionCharts( currObj.cfId ) )
										FusionCharts( currObj.cfId ).dispose();
									var myChart = new FusionCharts( "/final/FusionCharts/swf/StackedColumn"+currObj.fctype+".swf",currObj.cfId, currObj.fcwidth,currObj.fcheight,"0","1");
									myChart.setXMLData(currObj.fcXmlData);
									myChart.setTransparent(true);
									myChart.render(currObj.cdId);
								}
								else
								{
									try
									{
										currObj.up('panel').setTitle('<p style="padding-top:2px;">'+currObj.fcXmlData['panelTitle']+'</p>');
										var barHeight = ($('#stackedId').height());
										var barWidth = ($('.x-container').parent().width()) - 100;
										var barChart = {};
										barChart = jQuery.extend(true, {}, getHighChartsBarInstance(currObj.cdId,barHeight,barWidth), barChart);
										barChart.setData(currObj.fcXmlData, currentDateFormat, '','stackedColumn',true);
										barChart.drawChart();
										highChartIns = barChart;
									}
									catch (barChartEx)
									{
										console.log(barChartEx);
									}
								}
							},
							'resize': function( tthis, width, height, oldWidth, oldHeight, eOpts )
							{
								if( highChartIns != null )
								{
									Ext.getCmp('stackedId').setHeight(Ext.getBody().getViewSize().height-170);
									var barHeight = ($('#stackedId').height());
									var hCHart='';
									if(highChartIns.highchart!=null)
										hCHart= highChartIns.highchart.chart;
									var renderTo = hCHart.renderTo;
									if (hCHart.container) {
										hCHart.width = width-30;
										hCHart.height = barHeight;
									}
									hCHart.width = width-30;
									hCHart.height = barHeight;
									Ext.select('#' + tthis.cdId + ' .timelineDiv').setHeight(barHeight - 70);
									Ext.select('#' + tthis.cdId + ' .timelineDiv > div').setHeight(barHeight - 70);
									Ext.select('#' + tthis.cdId + ' > .highcharts-container').setHeight(barHeight - 70);
									Ext.select('#' + tthis.cdId + ' .highcharts-container > svg').setHeight(barHeight - 70);
									highChartIns.drawChart();

								}
							}
						}
			}]}]);
		}
			
		me.add(graphPanel);
		
		if(!Ext.isEmpty(me.mask)){
			me.mask.hide();
		}
	},
	createNoAccessTabUI:function(errorMsg){
		var me=this;
		me.removeAll();

		this.tabToolBar = {
			xtype : 'toolbar',
			id:'tabToolBar',
			items : []
		};

		if(!Ext.isEmpty(me.mask)){
			me.mask.hide();
		}
		errorPanel = this.createAccessErrorPanel(errorMsg);
		this.add([errorPanel]);
	},
	createAccessErrorPanel : function(errorMsg){
	    	var errorPanel = {
					xtype : 'errorpanel',
					cls:'error_panel_body top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
					bodyCls:'error_panel_body top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
					height : '100%',
					width : '100%',
					border : 0,
					style:{'border':'0px !important'},
					border:false,
					autoScroll:true,
					margin : 5,
					errorMsg : '<div style="text-align:center;margin-top:15%"><div class="iconInformation" style="margin:0px auto"></div><div>' + errorMsg+ '</div>',
					flex : 1
	    					
	    	}
	    	return errorPanel;
	},
	createMiddlePanel : function(jsonData,startitem,enditem) {
		filters=this.createComponents(jsonData,startitem,enditem);
		
		var middlePanel = {
				xtype : 'panel',
				layout : 'hbox',
				bodyStyle:{'background':'transparent!important'},
				margin:'5 0 0 0',
				//margin:'0 0 0 0',
				//frame:true, //right middle 3
				width:540,
				defaults:{
					//margin:'0 10 0 0',
					labelAlign:'top',
					labelSeparator :''
				},
				//height : 40,
				items  : filters,
				border:false
		}	
		return middlePanel;
	},
	createComponents : function(jsonData,startItem,endItem) {	
		if(!Ext.isEmpty(jsonData.Filters) && jsonData.Filters.length>0){
			
			var filterArray=new Array();
			//for(var i=startItem ; i<endItem ; i++){
			for(var i=startItem ; i<jsonData.Filters.length ; i++){
				 
				var filterData=jsonData.Filters[i];
				if( i >= endItem )
				{
					if( filterData.type != 'button' )
						continue;
				}
				var filterComp=null;
				switch(filterData.type){
				
				case "combo": 
					filterComp=this.createCombo(filterData);
					break;
				case "date": 
					filterComp=this.createDateField(filterData);
					break;
				case "lable": 
					filterComp=this.createLabel(filterData);
					break;
				case "button": 
					filterComp=this.createButton(filterData,jsonData);
					break;				
				}
				if(!Ext.isEmpty(filterComp)){
					filterArray.push(filterComp);
				}
			}
		}
		return filterArray;
	},
		createCombo:function(comboData){
		if(comboData.name!="timeline" && comboData.name!="mode"){
			var comboStore = Ext.create('Ext.data.Store',{
				fields:['name','value'],
				proxy:{
					type: 'memory',
					reader: {
						type: 'json',
						root:'items'
					}
				},
				data:comboData
			});

			var compCombo={
					xtype:'combo',
					editable : false,
					store:comboStore,				
					cls : 'dropdown',
					displayField:'name',
					valueField:'value',
					padding: '0 5',
					//padding: 20,
					labelWidth:80,
					//width:210,
					fieldLabel:comboData.Lable,
					value:comboData.selectvalue,
					itemId:comboData.name,
					action:comboData.name,
					queryMode:'local'
			};	
					
			 if(comboData.name=="starthr" || comboData.name=="endhr"){
				compCombo.labelWidth=20;
				compCombo.width=55;
				compCombo.defaultListConfig={
						minWidth: 55,
						loadingHeight: 55
				}
				
				if(this.timeLine!="Any"){
					compCombo.disabled=true;
				}
			}
			if(comboData.name=="period"){
				compCombo.width=90
				}
			return compCombo;	
		}		
	},
	createDateField:function(fieldData){
		
			var data;
		
			data = fieldData.selectedValue;			
			
			if(data == "Invalid Date"){
				data = new Date(fieldData.selectedValue);
			}
		
		
		var dateField={
				xtype:'datefield',
				cls : 'datepicker',
				fieldLabel:fieldData.Lable,
				//format:'M d,Y',
				format:requestParams.mgr_dateFormat,
				value:data,
				//value:new Date(fieldData.selectedValue),
				labelWidth:50,
				padding: '0 5',
				width:210,
				editable:false,
				itemId:fieldData.name,
				action:fieldData.name
		}	

		if(fieldData.name=="fromdate"){
			dateField.labelWidth=35;
			dateField.width=110
		}else if(fieldData.name=="todate"){
			dateField.labelWidth=20;
			dateField.width=110
		}

		if(this.timeLine!="Any"){
			dateField.disabled=true;
		}

		return dateField;
	},
	createLabel:function(labelData){
		var label={
				xtype:'label',
				html: '<div><b>'+labelData.Lable+'</b> : '+labelData.measureValue+'<div>',
				cls:'lookup-field',
				padding:'25 10 0 0'
		}		
		return label;
	},

	createButton:function(buttonData,jsonData){
		var timelineVal = jsonData.Filters[2];
		var currentSelection = timelineVal.selectvalue;
		var isHidden = true;
		 for (var i = 0; i < 4; i++) {
            var filterData = jsonData.Filters[i];
			if( filterData.name.toLowerCase() == "timeline" )
			 {
					isHidden = ( filterData.selectvalue.toLowerCase() == 'any' )?false:true;
			 }
		 }
		var button={
				xtype:'button',
				text: buttonData.text,
				name: buttonData.buttonname,
				cls : 'button20',
				action:buttonData.buttonname ,
				height:22,
				padding:'2 3 2 3',
				margin: '20 0 0 0',
				hidden: isHidden
		}		
		return button;
	}

});