Ext.define('ComponentMeasureTabSet.view.SummaryGraphFilters', {
	extend: 'Ext.window.Window',
	alias:'widget.summarygraphfilters',
	header:false,
	flotable:false,
	floating:false,
	resizable: false,
	//id:'summaryFilter',
	itemId:'summaryFilter',
	padding:'5 5 0 5',
	cls:'tabsetsettingsWindow measure-graph-panel',
	layout:{
		type: 'vbox',
		align: 'stretch'
	},
	
	jsonData : null,
	
	initComponent : function() {
		this.callParent();
	},
	createItems : function(jsonData){
		if(!Ext.isEmpty(jsonData.Filters))
		{
			var filterlength = jsonData.Filters.length;
			if(filterlength === 12)
			{
				var topPanel = this.createTopPanel(jsonData,0,3);
				this.add(topPanel);	
				//var middlePanel = this.createMiddlePanel(jsonData,2,7);
				//this.add(middlePanel);		
				var bottomPanel = this.createBottomPanel(jsonData,8,11);
				this.add(bottomPanel);		
			
				var buttonArray = this.createButtonPanel(jsonData,11,12);
				this.addDocked({
					xtype: 'toolbar',
					dock: 'bottom',
					cls:'toolbarPositionManual',
					buttonAlign:'center',
				layout:	{type:'hbox',
						pack:'center',
					align:'stretch'},
					ui:'footer',
					items: buttonArray
				});
			
				this.doLayout();
			}
			else
			{
				var topPanel = this.createTopPanel(jsonData,0,2);
				this.add(topPanel);	
				//var middlePanel = this.createMiddlePanel(jsonData,2,6);
				//this.add(middlePanel);	
				var bottomPanel = this.createBottomPanel(jsonData,6,9);
				this.add(bottomPanel);			
				var  buttonArray = this.createButtonPanel(jsonData,9,10);
				this.addDocked({
					xtype: 'toolbar',
					dock: 'bottom',
					cls:'toolbarPositionManual',
					buttonAlign:'center',
				layout:	{type:'hbox',
						pack:'center',
					align:'stretch'},
					ui:'footer',
					items: buttonArray
				});
			
				this.doLayout();				
			}
		}
	},
	
	createComponents : function(jsonData,startItem,endItem) {	
		if(!Ext.isEmpty(jsonData.Filters) && jsonData.Filters.length>0){
			
			var filterArray=new Array();
			for(var i=startItem ; i<endItem ; i++){
				 
				var filterData=jsonData.Filters[i];
				
				var filterComp=null;
				switch(filterData.type){
				
				case "trigger": 
					filterComp=this.createTrigger(filterData);
					break;
				case "combo": 
					filterComp=this.createCombo(filterData);
					break;
				case "date": 
					filterComp=this.createDateField(filterData);
					break;
				case "lable": 
					filterComp=this.createLabel(filterData);
					break;
				case "button": 
					filterComp=this.createButton(filterData);
					break;				
				}
				if(!Ext.isEmpty(filterComp)){
					filterArray.push(filterComp);
				}
			}
		}
		
		return filterArray;
	},
	createTopPanel : function(jsonData,startitem,enditem) {	
		filters=this.createComponents(jsonData,startitem,enditem);
		
		var topPanel = {
				xtype : 'panel',
				layout : 'hbox',
				//height : 40,
				defaults:{
					labelAlign:'top',
					labelSeparator :'',
					margin:'0 10 0 0',
					width:210
				},
				margin:'10 10 8 10',
				border:false,
				items  : filters,
				bodyCls:'top-left-radius top-right-radius'
		}	
		return topPanel;
	},
	createMiddlePanel : function(jsonData,startitem,enditem) {
		filters=this.createComponents(jsonData,startitem,enditem);
		
		var middlePanel = {
				xtype : 'panel',
				layout : 'hbox',
				margin:'10',
				defaults:{
					margin:'0 10 0 0',
					labelAlign:'top',
					labelSeparator :''
				},
				//height : 40,
				items  : filters,
				border:false
		}	
		return middlePanel;
	},
	createBottomPanel : function(jsonData,startitem,enditem) {	
		filters=this.createComponents(jsonData,startitem,enditem);
		
		var bottomPanel = {
				xtype : 'panel',
				layout : 'hbox',
				margin:'0 10 8 10',
				defaults:{
					margin:'0 10 0 0',
					labelAlign:'top',
					labelSeparator :''
				},
				//height : 60,
				items  : filters,
				cls : 'bottom-panel-border'
				
		}	
		return bottomPanel;
	},
	createButtonPanel : function(jsonData,startitem,enditem) {	
		var filtersArray = new Array();
		//filtersArray.push('->');
		var filter = this.createComponents(jsonData,startitem,enditem);
		filtersArray[1]= filter[0];
	
		
//		filtersArray.push({
//			xtype : 'button',
//			cls : 'close-window-icon',
//			action:'closewindow'			
//		});				
		return filtersArray;
	},
	createTrigger :function(comboData)
	{
		var compCombo={ 
		fieldLabel: 'Search',
		xtype: 'triggerfield',
		id:'descriptionOpt',
		name:'descriptionOpt',
		hidden:true,
		enableKeyEvents : true,
		labelAlign: 'top',
		cls: 'whitedropdown_search',
		width: 150
		};
		return compCombo;
	},
	createCombo:function(comboData){
		var isEdit=false;
		var type="combo";
		if(comboData.name=="infolist")
		{
			descriptorRawData=comboData.items;
			isEdit=true;
			type="scrollcombo";
		}
		if(comboData.name!="timeline" && comboData.name!="mode"){
			var comboStore = Ext.create('Ext.data.Store',{
				fields:['name','value'],
				proxy:{
					type: 'memory',
					reader: {
						type: 'json',
						root:'items'
					}
				},
				data:comboData
			});

			var compCombo={
					xtype:type,
					editable : isEdit,
					store:comboStore,				
					cls : 'dropdown',
					displayField:'name',
					valueField:'value',
					//padding: 20,
					labelWidth:70,
					//width:210,
					fieldLabel:comboData.Lable,
					value:comboData.selectvalue,
					itemId:comboData.name,
					action:comboData.name,
					queryMode:'local'
			};	
					
			 if(comboData.name=="starthr" || comboData.name=="endhr"){
				compCombo.labelWidth=20;
				compCombo.width=60;
				compCombo.defaultListConfig={
						minWidth: 55,
						loadingHeight: 55
				}
				
				if(this.timeLine!="Any"){
					compCombo.disabled=true;
				}
			}
			if(comboData.name=="period"){
				compCombo.width=90
				}
			return compCombo;	
		}		
	},
	createDateField:function(fieldData){
			var data;
		
			data = fieldData.selectedValue;			
			
			if(data == "Invalid Date"){
				data = new Date(fieldData.selectedValue);
			}


		var dateField={
				xtype:'datefield',
				cls : 'datepicker',
				fieldLabel:fieldData.Lable,
				//format:'M d,Y',
				format:requestParams.mgr_dateFormat,
				//value:new Date(fieldData.selectedValue),
				value:data,
				//value:new Date(fieldData.selectedValue),
				labelWidth:50,
				//padding: 20,
				width:210,
				editable:false,
				itemId:fieldData.name,
				action:fieldData.name
		}	

		if(fieldData.name=="fromdate"){
			dateField.labelWidth=35;
			dateField.width=110
		}else if(fieldData.name=="todate"){
			dateField.labelWidth=20;
			dateField.width=110
		}

		if(this.timeLine!="Any"){
			dateField.disabled=true;
		}

		return dateField;
	},
	createLabel:function(labelData){
		var label={
				xtype:'label',
				html: '<div><b>'+labelData.Lable+'</b> : '+labelData.measureValue+'<div>',
				cls:'lookup-field',
				padding:'25 10 0 0'
		}		
		return label;
	},

	createButton:function(buttonData){
		var button={
				xtype:'button',
				text: buttonData.text,
				name: buttonData.buttonname,
				cls : 'buttonalarm measurbutton',
				action:buttonData.buttonname 
		}		
		return button;
	}


	
	
});