Ext.define('ComponentMeasureTabSet.view.TrendGraph', {
	extend: 'Ext.panel.Panel',
	alias:'widget.trendgraph',
	mask:null,
	data:null,
	tabToolBar:null,
	toolTip:Ext.create('Ext.tip.ToolTip',{anchor:'bottom'}),
	layout:	{
	type:'vbox',	
	align:'stretch'
	},
	cls:'measure-graph-panel',
	timelineData:null,
	createTabUI:function(jsonData){
		var middlePanel = '';
		var selectedTimeLine = '';
		if(!Ext.isEmpty(jsonData.Filters) && jsonData.Filters.length>0){
			middlePanel = this.createMiddlePanel(jsonData);
		}
		var me=this;
		me.data=jsonData;
		var labelText,timelineObj,timelineVal;
		if(!Ext.isEmpty(jsonData.Filters))
		{
			for(var i=0; i< jsonData.Filters.length; i++){
				if(jsonData.Filters[i].name=="timeline"){	
					this.timelineData=jsonData.Filters[i];
					timelineObj=jsonData.Filters[i];
					selectedTimeLine =  timelineObj.selectvalue;
					for(var j=0;j<timelineObj.items.length;j++){
						if(timelineObj.items[j].value==timelineObj.selectvalue){
							timelineVal=j;
						}
					}
				}
				if(jsonData.Filters[i].name=="mode"){		
					if(jsonData.Filters[i].selectvalue=="2D"){
						labelText="2D";
					}else{
						labelText="2D";
					}
				}
			}
		}
		this.tabToolBar = {
				xtype:'toolbar',
				id:'tabToolBar',
				//padding:'5 5 0 5',
				items:[
//					{
//					xtype:'label',
//					text: labelText,
//					cls:'mode-field',
//					style:{'color':'#000'},
//					tooltip:labelText,
//					action:'trenmode',
//					listeners : {
//						render : function(c) {
//							c.getEl().on('click', function(){ this.fireEvent('click', c); }, c);
//							c.getEl().on('mouseover',function(){this.fireEvent('mouseover',c);},c);
//						}
//					}
//				}
				{
					xtype:'label',
					ttext: labelText,
					cls:"icon3d",
					style:{'cursor':'pointer'},
					//tooltip: ,
					action:'trenmode',
					hidden:true,
					listeners : {
					
						render : function(c) {
							//c.text=labelText;
							if(labelText=='2D'){
								c.addCls('icon2d');
								c.removeCls('icon3d');
							}else{
									c.addCls('icon3d');
									c.removeCls('icon2d');
								}
							c.getEl().on('click', function(){ this.fireEvent('click', c); }, c);
							Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html:labelText
												
																});
							//c.getEl().on('mouseover', function(){ this.fireEvent('mouseover', c);}, c);
						}
					}},
				{
					xtype:'tbseparator',					
					hidden:true,
				},
				{
					xtype:'image',
					cls:'iconData',
					action:'trendData',
					itemId:'imageId',
					style:{'cursor':'pointer'},
					tooltip:dataLbl,
					listeners:{
						render : function(c)
						{
							Ext.create('Ext.tip.ToolTip',{
															target:this.id,
															anchor:'top',
															cls: 'yellowTip',
															trackMouse: true,
															html:dataLbl
															}
								);
							c.getEl().on('click', function(){ this.fireEvent('click', c); }, c);
						}
					}
				}
				,{
					xtype:'tbseparator',					
				},{
					xtype:'image',
					cls:'iconSettings',
					action:'trengraphFilters',
					//tooltip:'Settings',
					listeners : {
						render : function(c) {
								Ext.create('Ext.tip.ToolTip', {
																	target: this.id,
																	anchor: 'top',
																	cls: 'yellowTip',
																	trackMouse: true,
																	html:'Settings'
												
																});
							c.getEl().on('click', function(){ this.fireEvent('click', c); }, c);
							//	c.getEl().on('mouseover', function(){ this.fireEvent('mouseover', c); }, c);
						}
					}
				},
				{
					xtype:'tbseparator',
					//hidden:true
					
				},
				{
			xtype : 'button',
			iconCls : 'iconHelp3',									
			//tooltip : '<b>New Window</b>',
			listeners: {
			afterrender: function () {
			Ext.create('Ext.tip.ToolTip', {
			target: this.id,
			anchor: 'top',
			cls: 'yellowTip',										
			trackMouse: true,
			html: 'Help'
			});
			}
			},
			style : {
				'background' : 'none',
				'border' : '0px',
				'margin':'0 10 0 0',
			},
			handler : function()
			{
				HelpWin();
			}
		}]
			};
		var title = jsonData.hiddeninfo.chartTitle;
		if(Ext.isEmpty(title))
			title = "";
		var graphPanel= Ext.create('Ext.panel.Panel',{
			height:'100%',
			width:'100%',
			layout: {type:'vbox',align:'stretch'},
			border:false,
			height:800,
			cls:'graph-panel',
			items:[{
				xtype:'panel',
				layout:{type:'column'},
				//height:60,
				items:[{
					xtype:'container',
					layout:'column',
					margin:'10 10 5 10',
					frame:false,
					border:true,
					columnWidth:1,
					cls:'formOuter',
					items:[{
						xtype:'slider',
						margin: '10 10 0 10',
						cls:'mesrslider',
						width:300,
						value: timelineVal,
						plugins:[Ext.create('Ext.ux.FillSlider', {clicksToEdit: 1})],
						increment: 1,
						minValue: 0,
						maxValue: timelineObj.items.length-1,
						constrainThumbs: false,
						fieldLabel: timelineObj.Label+" : "+timelineObj.selectvalue,
						labelSeparator:'' ,
						labelAlign:'top',
						animation: true,
						action:'timelinechange',
						tipText: function (t) {
							return Ext.String.format('{0}', timelineObj.items[t.value].value)
						}
					},middlePanel]
				}]
			}]
		});		
		if(!Ext.isEmpty(jsonData.Errormsg)){
			var noMeasure = Ext.create('utilities.ErrorPanel',{
				style:{'border':'0px !important'},
				border:false,
				errorMsg : '<div style="text-align:center;margin-top:15%"><div class="iconInformation" style="margin:0 auto"></div><div class="list-empty-text">'+jsonData.Errormsg+'</div></div>'
			});			
			graphPanel.add({
				xtype:'panel',
				border:false,
				layout:'fit',
				flex:1,
				width:'100%',
				items: noMeasure
			});
		}else{
			//var htmlstring = '<object classid="clsid:d27cdb6e-ae6d-11cf-96b8-444553540000" codebase="//fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=8,0,0,0" width="'+jsonData.GraphData.width+'" height="'+jsonData.GraphData.height+'" id="'+jsonData.GraphData.id+'">'+'<param name="movie" value="/final/FusionCharts/swf/'+jsonData.GraphData.modename+'.swf" />'+'<param name="FlashVars" value="&dataXML='+ jsonData.GraphData.xmldata+'">'+'<param name="quality" value="high" />'+'<param name="WMode" value="Transparent"/>'+'<embed wmode="Transparent" src="/final/FusionCharts/swf/'+jsonData.GraphData.modename+'.swf" flashVars="&dataXML='+jsonData.GraphData.xmldata+' quality="high" width="'+jsonData.GraphData.width+'" height="'+jsonData.GraphData.height+'" name="'+jsonData.GraphData.id+'" type="application/x-shockwave-flash" pluginspage="//www.macromedia.com/go/getflashplayer" />'+'</object>';

			var cdId="trendGraphPanelId_"+jsonData.GraphData.id;
			var cfId="trendGraphChartId_"+jsonData.GraphData.id;

			var htmlstring='<div style="margin:auto;padding:3px;display:inline-block;"><div id="'+cdId+'" style="height:100%;"></div></div>';
			
			graphPanel.add([
				{
				xtype:'panel',
				cls:'dataPanel containerShadow',
				margin:10,				
				title:'<p style="padding-top:2px;">'+title+'</p>',
				header:{
					style:{'border':'none'},
				},
				layout:	{
				type:'vbox',	
				align:'stretch'
				},
				items:[								
				{
					xtype:'container',
					border:false,
					layout:'fit',
					style:{'text-align':'center'},
					//autoHeight:true,
					height:Ext.getBody().getViewSize().height-170,
					html: htmlstring,
					cdId:cdId,
					cfId:cfId,
					id:'trendId',
					padding: '2 10 10 10',
					fcwidth:jsonData.GraphData.width,
					fcheight:jsonData.GraphData.height,
					fctype:jsonData.GraphData.modename,
					fcXmlData:jsonData.GraphData.xmldata,
					listeners:{
						 'afterrender': function(currObj){
							if (fusionChartsApiEnabled)
							{
								if  ( FusionCharts( currObj.cfId ) )
									FusionCharts( currObj.cfId ).dispose();

								var myChart = new FusionCharts( "/final/FusionCharts/swf/"+currObj.fctype+".swf",currObj.cfId, currObj.fcwidth,currObj.fcheight,"0","1");
								myChart.setXMLData(currObj.fcXmlData);
								myChart.setTransparent(true);
								myChart.render(currObj.cdId);
							}
							else
							{
								try
								{
									var lineChartHeight = ($('#trendId').height()) - 50;
									currObj.up('panel').setTitle('<p style="padding-top:2px;">'+currObj.fcXmlData['panelTitle']+'</p>');
									currObj.fcXmlData['chartTypeH'] = true;
									currObj.fcXmlData['chartExport'] = true;
									var lineChart = {};
									lineChart = jQuery.extend(true, {}, createLineChart(currObj.id,lineChartHeight,currObj.fcwidth), lineChart);
									lineChart.setData(currObj.fcXmlData, currentDateFormat,'' ,'line',true);
									lineChart.drawChart();
									highChartIns = lineChart;
								}
								catch (lineChartEx)
								{
									console.log(lineChartEx);
								}
							}
						},
						'resize': function( tthis, width, height, oldWidth, oldHeight, eOpts )
						{
							if( highChartIns != null )
							{
								Ext.getCmp('trendId').setHeight(Ext.getBody().getViewSize().height-170);
								var lineHeight = ($('#trendId').height());
								var hCHart='';
								if(highChartIns.highchart!=null)
									hCHart= highChartIns.highchart.chart;
								var renderTo = hCHart.renderTo;
								if (hCHart.container) {
									hCHart.width = width-30;
									hCHart.height = lineHeight;
								}
								hCHart.width = width-30;
								hCHart.height = lineHeight;
								Ext.select('#' + tthis.cdId + ' .timelineDiv').setHeight(lineHeight - 70);
								Ext.select('#' + tthis.cdId + ' .timelineDiv > div').setHeight(lineHeight - 70);
								Ext.select('#' + tthis.cdId + ' > .highcharts-container').setHeight(lineHeight - 70);
								Ext.select('#' + tthis.cdId + ' .highcharts-container > svg').setHeight(lineHeight - 70);
								highChartIns.drawChart();
							}
						}
					}
			}]}]);
		}
		me.add(graphPanel);
		if(!Ext.isEmpty(me.mask)){
			me.mask.hide();
		}
		if (!Ext.isEmpty(tempApp.getController("TrendGraph")))
		{
			//tempApp.getController("TrendGraph").trendFilters();
			//tempApp.getController("TrendGraph").trendFilters().hide();
			if(!Ext.isEmpty(selectedTimeLine) && selectedTimeLine === "Any")
				tempApp.getController("TrendGraph").enableHourCombos();
		}
	},
	createNoAccessTabUI:function(errorMsg){
		var me=this;
		me.removeAll();

		this.tabToolBar = {
			xtype : 'toolbar',
			id:'tabToolBar',
			items : []
		};

		if(!Ext.isEmpty(me.mask)){
			me.mask.hide();
		}
		errorPanel = this.createAccessErrorPanel(errorMsg);
		this.add([errorPanel]);
	},
	createAccessErrorPanel : function(errorMsg){
	    	var errorPanel = {
					xtype : 'errorpanel',
					cls:'error_panel_body top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
					bodyCls:'error_panel_body top-left-radius top-right-radius bottom-left-radius bottom-right-radius',
					height : '100%',
					width : '100%',
					border : 0,
					style:{'border':'0px !important'},
					border:false,
					autoScroll:true,
					margin : 5,
					errorMsg : '<div style="text-align:center;margin-top:15%"><div class="iconInformation" style="margin:0px auto"></div><div>' + errorMsg+ '</div>',
					flex : 1
	    					
	    	}
	    	return errorPanel;
	},
	createMiddlePanel : function(jsonData) {	
		var filterArray=new Array();
		for(var i=0;i<jsonData.Filters.length;i++){
			var filterData=jsonData.Filters[i];
			if(filterData!=null){
				var filterComp=null;
				if(filterData.type=="date" || /*filterData.type=="label" ||*/ filterData.name=="starthr" || filterData.name=="endhr" || filterData.name == "graph"){
					switch(filterData.type){
					case "combo": 
						filterComp=this.createCombo(filterData);
						filterComp.width=50;
						break;
					case "date": 
						filterComp=this.createDateField(filterData);
						filterComp.width=110;
						break;
					 case "button":
						filterComp = this.createButton(filterData,jsonData);
						break;
					/*case "label": 
						filterComp=this.createLabel(filterData);
						break;*/							
					}					
				}
				if(!Ext.isEmpty(filterComp)){
					filterArray.push(filterComp);
				}	
			}				
		}

		var middlePanel = {
				xtype : 'panel',
				layout : 'hbox',
				bodyStyle:{'background':'transparent!important'},
				padding:'0 5 0 15',
				items  : filterArray,
				border:false,
				width:540,
				defaults:{
					labelAlign:'top',
					labelSeparator :''
				}
		}	
		return middlePanel;
	},
	createCombo:function(comboData){
		if(comboData.name!="timeline" && comboData.name!="mode"){
			var comboStore = Ext.create('Ext.data.Store',{
				fields:['name','value'],
				proxy:{
					type: 'memory',
					reader: {
						type: 'json',
						root:'items'
					}
				},
				data:comboData
			});

			var compCombo={
					xtype:'combo',
					editable : false,
					store:comboStore,				
					cls : 'dropdown',
					displayField:'name',
					valueField:'value',
					padding: '5 10 0 5',
					labelWidth:70,
					fieldLabel:comboData.Label,
					value:comboData.selectvalue,
					itemId:comboData.name,
					action:comboData.name,
					queryMode:'local'
			};	

			if(comboData.name=="starthr" || comboData.name=="endhr"){
				compCombo.labelWidth=20;
				compCombo.width=75;
				compCombo.defaultListConfig={
						minWidth: 55,
						loadingHeight: 55
				};
				compCombo.disabled=true;
			}

			return compCombo;	
		}		
	},
	createDateField:function(fieldData){
		
			var data;
		
			data = fieldData.selectedValue;			
			
			if(data == "Invalid Date"){
				data = new Date(fieldData.selectedValue);
			}
		
		
		var dateField={
				xtype:'datefield',
				cls : 'datepicker',
				fieldLabel:fieldData.Label,
				editable:false,
				disabled:true,
				//format:'M d,Y',
				format:requestParams.mgr_dateFormat,
				value:data,
				//value:new Date(fieldData.selectedValue),
				labelWidth:50,
				padding: '5 10 10 5',
				width:210,
				itemId:fieldData.name,
				action:fieldData.name
		}	

		if(fieldData.name=="fromdate"){
			dateField.labelWidth=35;
			dateField.width=150
		}else if(fieldData.name=="todate"){
			dateField.labelWidth=20;
			dateField.width=135
		}

		return dateField;
	},

	createLabel:function(labelData){
		var label={
				xtype:'label',
				html: '<b>'+labelData.Label+'</b>'+" : "+labelData.measureValue,
				cls:'lookup-field',
				padding: '30 10 0 10'
		}		
		return label;
	},

	createButton:function(buttonData,jsonData){

		var isHidden = true;
		 for (var i = 0; i < 4; i++) {
            var filterData = jsonData.Filters[i];
			if( filterData.name.toLowerCase() == "timeline" )
			 {
					isHidden = ( filterData.selectvalue.toLowerCase() == 'any' )?false:true;
			 }
		 }
		var button={
				xtype:'button',
				text: buttonData.text,
				name: buttonData.name,
				cls : 'button20',
				action: buttonData.name,
				height:22,
				padding:'2 3 2 3',
				margin: '25 0 0 0',
				hidden: isHidden
		}
		if(buttonData.name === 'data')
		{
			//button.cls ='button20 trend-data-btn';
		}
		if(buttonData.name === 'graph')
		{
			//button.cls ='button20 trend-graph-btn';
		}
		return button;
	}
});