Ext.define('ComponentMeasureTabSet.view.TrendGraphFilters', {
	extend: 'Ext.window.Window',
	alias:'widget.trendgraphfilters',
	header:false,
	flotable:false,
	floating:false,
	resizable: false,
	//id:'trendFilter',
	itemId:'trendFilter',
	padding:'5 5 0 5',
	layout:{
		type: 'vbox',
		align:'stretch'
	},
	jsonData:null,
	cls:'tabsetsettingsWindow measure-graph-panel',
	initComponent : function(){
		this.callParent();
	},

	createItems : function(jsonData){
		if(!Ext.isEmpty(jsonData.Filters) && jsonData.Filters.length>0){
			var topPanel = this.createTopPanel(jsonData);
			this.add(topPanel);		
			var middlePanel = this.createMiddlePanel(jsonData);
			//this.add(middlePanel);	
			var bottomPanel = this.createBottomPanel(jsonData);
			this.add(bottomPanel);		
			var buttonArray = this.createButtonPanel(jsonData);
			this.addDocked({
				xtype: 'toolbar',
				cls:'toolbarPositionManual',
				buttonAlign:'center',
				layout:	{type:'hbox',
						pack:'center',
					align:'stretch'},
			    dock: 'bottom',
				ui:'footer',
			    items: buttonArray
			});
			this.doLayout();
		}
	},

	createTopPanel : function(jsonData) {	
		var filterArray=new Array();
		for(var i=0;i<jsonData.Filters.length;i++){
			var filterData=jsonData.Filters[i];
			if(filterData!=null){
				var filterComp=null;
				if(filterData.name=="measurelist" || filterData.name=="infolist"){
					filterComp=this.createCombo(filterData);
					filterComp.width=200;
				}
				else if(filterData.type=="trigger")
				{
					filterComp=this.createTrigger(filterData);
				}
				if(!Ext.isEmpty(filterComp)){
					filterArray.push(filterComp);
				}	
			}				
		}


		var topPanel = {
				xtype : 'panel',
				layout : 'hbox',
				border:false,
				items  : filterArray,
				bodyCls:'top-left-radius top-right-radius',
				defaults:{
					labelAlign:'top',
					labelSeparator :''
				}
		}	
		return topPanel;
	},
	createMiddlePanel : function(jsonData) {	
		var filterArray=new Array();
		for(var i=0;i<jsonData.Filters.length;i++){
			var filterData=jsonData.Filters[i];
			if(filterData!=null){
				var filterComp=null;
				if(filterData.name=="timeline" || filterData.type=="date" || filterData.type=="label" || filterData.name=="starthr" || filterData.name=="endhr"){
					switch(filterData.type){
					case "combo": 
						filterComp=this.createCombo(filterData);
						filterComp.width=50;
						break;
					case "date": 
						filterComp=this.createDateField(filterData);
						filterComp.width=110;
						break;
					/*case "label": 
						filterComp=this.createLabel(filterData);
						break;*/							
					}					
				}
				if(!Ext.isEmpty(filterComp)){
					filterArray.push(filterComp);
				}	
			}				
		}

		var middlePanel = {
				xtype : 'panel',
				layout : 'hbox',
				items  : filterArray,
				border:false,
				defaults:{
					labelAlign:'top',
					labelSeparator :''
				}
		}	
		return middlePanel;
	},
	createBottomPanel : function(jsonData) {	
		var filterArray=new Array();
		for(var i=0;i<jsonData.Filters.length;i++){
			var filterData=jsonData.Filters[i];
			if(filterData!=null){
				var filterComp=null;
				if(filterData.type=="label"){
				filterComp=this.createLabel(filterData);
				}
				if(filterData.name=="graphmode" || filterData.name=="period"){
					filterComp=this.createCombo(filterData);
					filterComp.width=110;
				}
				
				if(!Ext.isEmpty(filterComp)){
					filterArray.push(filterComp);
				}	
			}				
		}

		var bottomPanel = {
				xtype : 'panel',
				layout : 'hbox',
				items  : filterArray,
				cls:'filter-top-right-panel',
				defaults:{
					labelAlign:'top',
					labelSeparator :''
				}
		}	
		return bottomPanel;
	},
	createButtonPanel : function(jsonData) {	
		var filterArray=new Array();
		//filterArray.push('->');
		for(var i=0;i<jsonData.Filters.length;i++){
			var filterData=jsonData.Filters[i];
			if(filterData!=null){
				var filterComp=null;
				if (filterData.name!='data' && filterData.type=="button")
				{
					filterComp=this.createButton(filterData);
				}
				if(!Ext.isEmpty(filterComp)){
					filterArray.push(filterComp);
				}	
			}				
		}
		return filterArray;
	},
	createTrigger :function(fieldData)
	{
		var compCombo={ 
		fieldLabel: 'Search',
		xtype: 'triggerfield',
		id:'descriptionOpt',
		name:'descriptionOpt',
        hidden:true,
 		enableKeyEvents : true,
		margin:'7 3 0 4',
		labelAlign: 'top',
		cls: 'whitedropdown_search',
		width: 150,
		};
		return compCombo;
	},
	createCombo:function(comboData){
		//console.log('createCombo method');
		//console.log(comboData.name);
		var isEdit=false;
		var type="combo";
		if(comboData.name=="infolist")
		{
			descriptorRawData=comboData.items;
			isEdit=true;
			type="scrollcombo";
		}
		if(comboData.name!="mode")
		{
			var comboStore = Ext.create('Ext.data.Store',{
				fields:['name','value'],
				proxy:{
					type: 'memory',
					reader: {
						type: 'json',
						root:'items'
					}
				},
				data:comboData
			});

			var compCombo={
					xtype:type,
					editable : isEdit,
					store:comboStore,				
					cls : 'dropdown',
					displayField:'name',
					valueField:'value',
					padding: '8 5 8 10',
					labelWidth:70,
					fieldLabel:comboData.Label,
					value:comboData.selectvalue,
					itemId:comboData.name,
					action:comboData.name,
					queryMode:'local'
			};	

			if(comboData.name=="starthr" || comboData.name=="endhr" || comboData.name=="timeline"){
				compCombo.labelWidth=20;
				compCombo.width=75;
				compCombo.defaultListConfig={
						minWidth: 55,
						loadingHeight: 55
				};
				compCombo.disabled=true;
			}

			return compCombo;	
		}		
	},
	createDateField:function(fieldData){
			var data;
		
			data = fieldData.selectedValue;			
			
			if(data == "Invalid Date"){
				data = new Date(fieldData.selectedValue);
			}
		var dateField={
				xtype:'datefield',
				cls : 'datepicker',
				fieldLabel:fieldData.Label,
				editable:false,
				disabled:true,
				//format:'M d,Y',
				format:requestParams.mgr_dateFormat,
				//value:new Date(fieldData.selectedValue),
				//value:new Date(fieldData.selectedValue),
				value:data,
				labelWidth:50,
				padding: 10,
				width:210,
				itemId:fieldData.name,
				action:fieldData.name
		}	

		if(fieldData.name=="fromdate"){
			dateField.labelWidth=35;
			dateField.width=150
		}else if(fieldData.name=="todate"){
			dateField.labelWidth=20;
			dateField.width=135
		}

		return dateField;
	},

	createLabel:function(labelData){
		var label={
				xtype:'label',
				html: '<b>'+labelData.Label+'</b>'+" : "+labelData.measureValue,
				cls:'lookup-field',
				padding: '30 10 0 10'
		}		
		return label;
	},

	createButton:function(buttonData){
		var button={
				xtype:'button',
				text: buttonData.text,
				name: buttonData.name,
				cls : 'buttonalarm measurbutton',
				action: buttonData.name
				//padding:10
		}
		if(buttonData.name === 'data')
		{
			//button.cls ='button20 trend-data-btn';
		}
		if(buttonData.name === 'graph')
		{
			//button.cls ='button20 trend-graph-btn';
		}
		return button;
	}

});