Ext.Loader.setConfig({
    enabled: true,
    disableCaching: false,
    garbageCollect: true,
    preserveScripts: false
});
Ext.Loader.setPath("Ext.ux", "/final/scripts/ux");
Ext.Loader.setPath("utilities", "/final/scripts/utilities");

function execute() {
    ComponentMeasureTabSet.app.getController("Main").refresh(requestParams.activeTab);
}
Ext.application({
    name: "ComponentMeasureTabSet",
    requires: ["Ext.window.MessageBox", "Ext.form.field.ComboBox", "Ext.data.NodeStore", "ComponentMeasureTabSet.view.Main", "ComponentMeasureTabSet.controller.Main", "ComponentMeasureTabSet.controller.MeasureGraph", "ComponentMeasureTabSet.controller.TrendGraph", "ComponentMeasureTabSet.controller.SummaryGraph", "ComponentMeasureTabSet.controller.DetailedDiagnosis", "ComponentMeasureTabSet.controller.FixHistory", "ComponentMeasureTabSet.controller.FixFeedback", "ComponentMeasureTabSet.controller.CompareGraph", "ComponentMeasureTabSet.controller.DetailedDiagnosisAnalysis", "ComponentMeasureTabSet.controller.ThreadDetails"],
    appFolder: "../monitor/eg_scripts/ComponentMeasureTabSet",
    controllers: ["Main", "MeasureGraph", "TrendGraph", "SummaryGraph", "DetailedDiagnosis", "FixHistory", "FixFeedback", "CompareGraph", "DetailedDiagnosisAnalysis", "ThreadDetails"],
    launch: function () {
        var a = Ext.get("componentMeasureTabSet");
        a.hide();
        ComponentMeasureTabSet.app = this;
        Ext.create("Ext.container.Viewport", {
            layout: "fit",
            cls: "viewport-panel",
            items: [{
                xtype: "main",
                tabsInfo: requestParams.tabsInfo,
                activeTab: requestParams.activeTab
            }]
        });
    }
});