var cmd = Ext.create('ConfigureControlAction.view.ConfigureControlActionCmd')
Ext.define('ConfigureControlAction.controller.Main',{
	extend:'Ext.app.Controller',
	views:['Main'],
	refs:[
		{selector:'main', ref:'main'},
		{selector:'configurecontrolactionForm',ref:'configurecontrolactionForm'},
		{selector:'cmd',ref:'cmd'}
	],
	init:function(){
		this.control({
			'configurecontrolactionForm button[name="execute"]':{
				'click':this.showResult
			},
			'configurecontrolactionForm combo[id="commandOpts"]':{
				'select':this.changeCommand
			},
			'main' :
			{
				'boxready' : this.loadDefaultFormData
			},
			'main  #upbutton':
			{
				'click':this.toggleForm
			},
			'main button[id="bckBtn"]':
			{
				'click' : this.goBack
			}
		});
	},
	goBack : function()
	{
		var backButtonUrl = publicJson['pageParams']['backButtonUrl'];

		if(backButtonUrl!=null && backButtonUrl=='historyBack')
		{
			//window.history.go(-2);
			window.location.href='/final/monitor/ControlAgentsp.jsp';
		}
		else
		{
			window.location.href= backButtonUrl;
		}
	},
	toggleForm:function(){
		var ornt = Ext.getCmp('configcontrolform');
		ornt.toggleCollapse(true);
	},
	showResult : function()
	{
		var thisForm = this.getConfigurecontrolactionForm().getForm();
		var AgentIp = thisForm.findField('AgentIp').getValue();
		var AgentMode = thisForm.findField('AgentMode').getValue();
		var commandOpts = thisForm.findField('commandOpts').getValue();
		var cmdSyntax = thisForm.findField('cmdSyntax').getValue();
		var aruguments = thisForm.findField('arugumentsTextBox').getValue();
		var outputRqrd = thisForm.findField('outputRqrd').getValue();
		var timeOut = thisForm.findField('timeOutTextbox').getValue();

		

		if(commandOpts == "-1"){
			Ext.Msg.show({
			title:'Alert',
			 msg: commandAlert,
			buttons: Ext.Msg.CANCEL,
			icon: Ext.Msg.ERROR
			});
			return;
		}

		if(commandOpts=='-2') // this is for other option
		{
			commandOpts = cmdSyntax;
			if(cmdSyntax == "")
			{
				Ext.Msg.show({
				title:'Alert',
				 msg: commandAlert,
				buttons: Ext.Msg.CANCEL,
				icon: Ext.Msg.ERROR
				});
				//document.ControlAction.txtCmd1.setFocus();
				return;
			}
		}
		else
		{
			if(aruguments!=null && (aruguments!="none" && aruguments!=""))
				commandOpts = commandOpts+ " "+aruguments;
		}

		if(!checkNumberVal("+",timeOut) || timeOut.indexOf(".")>-1)
		{
			Ext.Msg.show({
			title:'Alert',
			 msg: timeoutInpAlert,
			buttons: Ext.Msg.CANCEL,
			icon: Ext.Msg.ERROR
			});
			return false;
		}
		else
		{
			var remoteCmd = this.getCmd();
			remoteCmd.removeAll();
			var commandOpts1 = commandOpts.replace(/\r\n|\r|\n/g,'#');

			var hiddenQStr = publicJson['hiddenQStr'];
			var paramsForReq = "isJsonResp=true&response1=yes&&agentIP="+encodeURIComponent(AgentIp)+"&agentMode1="+encodeURIComponent(AgentMode)
			+"&selCmd="+encodeURIComponent(commandOpts)+"&txtCmd1="+encodeURIComponent(commandOpts)
			+"&arguments="+encodeURIComponent(aruguments)+"&txtCmd="+encodeURIComponent(commandOpts1)+"&response="+outputRqrd+"&txtTimeout="+timeOut+hiddenQStr;
			var timeOutValForAjax = (parseInt(timeOut)*1000)+10000;
			rcLoadMask.show();
			Ext.Ajax.request({
				url : '/final/monitor/ConfigureControlActionp.jsp',
				method : 'POST',
				params: paramsForReq,
				timeout:timeOutValForAjax,
				scope:this,
				success: function(response)
				{
					rcLoadMask.hide();
					var jsonText = response.responseText;					
					var jsonData=Ext.decode(jsonText);
					if(!Ext.isEmpty(jsonData))
					{
						var errorMessage = jsonData['errorMessage'];
						if(errorMessage!=null && errorMessage!="-")
						{
							var emptyPanelContainer = Ext.getCmp('emptyPanelContainer');
							errorMessage = "Agent not reporting to this manager";
							emptyPanelContainer.update('<div class = "iconInformation" style="margin:0 auto"></div><div>'+errorMessage+'</div>');
							Ext.getCmp('emtyPanel').show();
						}
						else
						{
							Ext.getCmp('emtyPanel').hide();
							var newMode = jsonData['newMode'];

							if(newMode!=null && newMode=='true')
							{
								window.location.href = jsonData['forwardUrl'];
							}
							else
							{
								//Ext.getCmp("upbutton").setDisabled(false);
								if(!Ext.isEmpty(Ext.getCmp("upbutton")) && Ext.getCmp("upbutton")!=null && Ext.getCmp("upbutton")!=undefined)
									Ext.getCmp("upbutton").hide();
								var result = jsonData['output'];
								var updatepanel=Ext.getCmp('remote_cmd');
								updatepanel.add({
								xtype: 'panel',
								margin:10,
								height:425,
								style:{'border':'1px solid #000000 !important'},
								bodyStyle:{'background':'#054277','overflow':'auto'},
								id:'updatepanel',
								html:result
								});
								updatepanel.doLayout();
								//remoteCmd.update(result);
								remoteCmd.show();
							}
						}
					}


				},
				failure:function()
				{
					rcLoadMask.hide();
					//Ext.getCmp("upbutton").setDisabled(false);
					if(!Ext.isEmpty(Ext.getCmp("upbutton")) && Ext.getCmp("upbutton")!=null && Ext.getCmp("upbutton")!=undefined)
						Ext.getCmp("upbutton").hide();
					var updatepanel=Ext.getCmp('remote_cmd');
					var output="<ul class='f11-bold' style='color:#fff;margin:10px'><li>Command execution was timed out<\/li><\/ul>";
					updatepanel.add({
					xtype: 'panel',
					margin:10,
					height:425,
					style:{'border':'1px solid #000000 !important'},
					bodyStyle:{'background':'#054277','overflow':'auto'},
					id:'updatepanel',
					html:output
					});
					updatepanel.doLayout();
					//remoteCmd.update(result);
					remoteCmd.show();
				}

				//	thisForm.execute.value="<egui:intnl text='monitor.configurecontrolaction.Executing'/>...";
				//	thisForm.execute.disabled=true;
				 //   thisForm.action='<%=response.encodeURL("../monitor/ConfigureControlActionp.jsp?")%>'+"fromDashBoardLayerModel=<%=fromDashBoardLayerModel%>";
				//	thisForm.submit();
					//alert(document.ControlAction.txtCmd.value);
				});
		}
	},
	changeCommand :  function(combo)
	{
		var thisForm = this.getConfigurecontrolactionForm().getForm();
		if(combo.getValue()=='-2')
		{
			thisForm.findField('cmdSyntax').show();
			thisForm.findField('arugumentsTextBox').hide();
		}
		else
		{
			thisForm.findField('cmdSyntax').hide();
			thisForm.findField('arugumentsTextBox').show();
		}
	},
	resizeMe:function(){
		cmd.setWidth(Ext.getBody().getViewSize().width -10);
		cmd.setHeight(Ext.getBody().getViewSize().height -10)
	},
	showCmd:function(){
		cmd.show();
		
		
	},
	cmdBack:function(bt){
		cmd.hide();
	},
	loadDefaultFormData : function()
	{
		this.getConfigurecontrolactionForm().loadFormData();
	}
});