Ext.define('ConfigureControlAction.view.ConfigureControlActionForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.configurecontrolactionForm',
    collapseMode: 'mini',
    id: 'configcontrolform',
    initComponent: function () {
        this.buttonAlign = "center";
        this.callParent();
    },
    collapseMode: "mini",
    layout: "column",
    defaults: {
        labelAlign: "top",
        labelSeparator: "",
		height:44
    },
    items: [{
        xtype: 'textfield',
        fieldLabel: 'Agent IP / Nick name',
        cls: 'textbox',
        id: 'AgentIp',
        name: 'AgentIp',
        width: 180,
        margin: 10,
		readOnly: true
    }, {

        xtype: 'textfield',
        fieldLabel: 'Mode of operation',
        cls: 'textbox',
        id: 'AgentMode',
        name: 'AgentMode',
        margin: 10,
        width: 150,
		readOnly: true
    }, {
        xtype: 'scrollcombo',
        cls: 'dropdown',
        fieldLabel: 'Command',
        editable: false,
        store: new Ext.data.Store({
            fields: ['displayField', 'valueField'],
            data: []
        }),
		margin: 10,
        displayField: 'displayField',
        valueField: 'valueField',
        queryMode: 'local',
        id: 'commandOpts',
        name: 'commandOpts',
        width: 210,

    }, {
        xtype: 'textareafield',
        grow: true,
        cls: 'text-area',
        fieldLabel: 'Command Syntax',
        id: 'cmdSyntax',
        name: 'cmdSyntax',
        hidden: true,
		height:90,
        cols:45,
        margin: 10,

    }, {
        xtype: 'textfield',
        fieldLabel: 'Arguments',
        cls: 'textbox',
        width: 130,
        id: 'arugumentsTextBox',
        name: 'arugumentsTextBox',
        margin: 10,

    }, {
        xtype: "scrollcombo",
        width: 150,
        margin: 10,
        cls: "dropdown",
        fieldLabel: 'Output Required',
        editable: false,
        store: new Ext.data.Store({
            fields: ['displayField', 'valueField'],
            data: []
        }),
        displayField: 'displayField',
        valueField: 'valueField',
        queryMode: 'local',
        id: 'outputRqrd',
        name: 'outputRqrd'
    }, {

        xtype: 'textfield',
        fieldLabel: 'Timeout (in sec)',
        cls: 'textbox',
        width: 130,
        margin: 10,
        id: 'timeOutTextbox',
        name: 'timeOutTextbox',
    }, {
        xtype: 'button',
        text: 'Execute',
        cls: 'button20',
        id: 'execute',
		height:20,
        margin: "32 0 10 10",
        name: 'execute',
    }],
    loadFormData: function () {
        var thisForm = this.getForm();
        var screenLabels = publicJson['screenLabels'];

        var AgentIp = thisForm.findField('AgentIp');
        AgentIp.setValue(publicJson['pageParams']['selectedAgent']);
        AgentIp.setFieldLabel(screenLabels['monitor.remotecontrol.Agent IP']);

        var AgentMode = thisForm.findField('AgentMode');
        AgentMode.setValue(publicJson['pageParams']['selectedAgentMode']);
        AgentMode.setFieldLabel(screenLabels['monitor.remotecontrol.Mode of operation']);

        var commandOpts = thisForm.findField('commandOpts');
        commandOpts.getStore().loadRawData(publicJson['commandOpts']);
        commandOpts.setValue(publicJson['pageParams']['selectedCmd']);


        var arugumentsTextBox = thisForm.findField('arugumentsTextBox');
        arugumentsTextBox.setValue(publicJson['pageParams']['arguments']);
        arugumentsTextBox.setFieldLabel(screenLabels['monitor.remotecontrol.Arguments']);

        var outputRqrdCombo = thisForm.findField('outputRqrd');
        outputRqrdCombo.getStore().loadRawData(publicJson['yesNoOpts']);
        outputRqrdCombo.setValue(publicJson['pageParams']['outputRequired']);
        outputRqrdCombo.setFieldLabel(screenLabels['monitor.remotecontrol.Output required']);

        var timeOutTextbox = thisForm.findField('timeOutTextbox');
        timeOutTextbox.setValue(publicJson['pageParams']['selectedTimeOutPeriod']);
        timeOutTextbox.setFieldLabel(screenLabels['monitor.remotecontrol.Timeout']);

        Ext.getCmp('execute').setText(screenLabels['monitor.remotecontrol.Execute']);

        var backButtonNeeded = publicJson['pageParams']['backButtonNeeded'];
        if (backButtonNeeded != null && backButtonNeeded == 'Yes') {
            Ext.getCmp('bckBtn').show();
            Ext.getCmp('helpbtnSeparator').show();
        }
    }
})