Ext.define('CustomGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.customgrid',
	autoScroll :false,
	scroll:false,
	
	initComponent : function() {
		this.callParent();
		this.addListener('sortchange',this.sortChangeHandler,this);
	},
	
	
	sortChangeHandler: function( ct, column, direction, eOpts ){
		ct.doLayout();
	},
	
	columnResizeHandler:function(){
		this.useFancyScroll(this);
	},
	
	onViewReady:function(){	
				this.addListener('resize',this.onResizeHandler,this);
				this.addListener('columnresize',this.columnResizeHandler,this);
				this.useFancyScroll(this);
				this.callParent();
	},
	
	onResizeHandler:function(){
		this.useFancyScroll(this);
	},
	
	useFancyScroll:function(grid){
		$('#'+grid.id+' .x-grid-view').jScrollPane();
		$('#'+grid.id+' .x-grid-view').scroll(function(e){
			var api=$(this).data('jsp');
			$('#'+grid.id+' .x-grid-header-ct').scrollLeft(api.getContentPositionX());
			});
	}

});