var descRawData;
var searchObj;
var totalRecords=0;
var totalDataRecords=0;
var currentPage=0;
Ext.define('DD.controller.Main', {
	extend : 'Ext.app.Controller',
	views : ['Main'],
	requires:['utilities.ScrollPanel','DD.controller.ThreadDetails','DD.controller.ProcessDetails',"utilities.ErUtils","DD.view.ddGridView"],
	refs : [{
				selector : 'main',
				ref : 'main'
			}, {
				selector : 'settings',
				ref : 'settings'
			}, {
				selector : 'utilitiestool',
				ref : 'utilitiestool'
			}, {
				selector : 'settingsForm',
				ref : 'settingsForm'
			}, {
				ref : 'settingsFormView',
				selector : 'settingsForm timeline combo[id="er_mode"]'
			}, {
				selector : 'ddOptionsForm',
				ref : 'ddOptionsForm'
			},{
				selector : 'ddOptionsForm button[id="submit"]',
				ref : 'submitButton'
			},{
                selector : 'newwindow',
                ref : 'newwindow'
            }],
	jsonData:null,
	init : function() {
		this.control({
					/*'main' : {
						'boxready' : this.afterMainRender
					},*/
					'ddOptionsForm' : {
						'boxready' : this.loadForm
					},
					'settingsForm' : {
						'afterrender' : this.settingsFormRender
					},
					'ddOptionsForm  scrollcombo[id="hostlist"]' : {
						'select' : this.component_onchange
					},
					'ddOptionsForm  scrollcombo[id="layerlist"]' : {
						'select' : this.layer_onchange
					},
					'ddOptionsForm  scrollcombo[id="testlist"]' : {
						'select' : this.test_onchange
					},'ddOptionsForm  scrollcombo[id="desclist"]' : {
					},
					'ddOptionsForm  scrollcombo[id="sitelist"]' : {
						'select' : this.site_onchange
					},
					'ddOptionsForm  scrollcombo[id="comptypelist"]' : {
						'select' : this.comptype_onchange
					},
					'settingsForm combo[id="er_timeline"]' : {
						'select' : this.changeTimeline
					},
					'main utilitiestool' : {
						'afterrender' : this.hideTools
					},
					'ddOptionsForm button[id="submit"]' : {
						'click' : this.showResult
					},
					'main utilitiestool > #saveTool > button' : {
                        'click' : this.saveFileTool
                    },
                    'main utilitiestool > #printTool > button' : {
                        'click' : this.printFile
                    },
                    'main utilitiestool > #csvTool > button' : {
                        'click' : this.dataFile
                    },
                    'ddOptionsForm trigger[name="filterOpt"]':
                    {
                        'keyup': this.filterMultiselect
                    },'ddOptionsForm trigger[name="searchOpt"]':
                    {
                        'keyup': this.searchOptSelect
                    },
					'utilitiestool > #upbutton':
						{
							'click':this.toggleForm
						}
				});
	},
	searchOptSelect :function(obj, event)
	{
		searchObj=obj;
		var findVal = obj.getValue();
		var compStore = descRawData;
		var form = this.getDdOptionsForm().getForm();
		var compObj = form.findField('descriptionlist')
		var isRecordFound = false;
		if ( Ext.isEmpty( obj.getValue() ) )
		{
			compStore = descRawData;
			compObj.getStore().removeAll(); 
			compObj.getStore().loadRawData(compStore);
			var value = compObj.getStore().getAt(0).get('valueField');
			compObj.setValue(value);
		}
		else
		{
			var genStore = new Ext.data.Store({
									fields : ['displayField', 'valueField'],
									data : []
								});
			if(findVal!=null)
				findVal=findVal.toLowerCase();
			for ( var i = 1; i < compStore.length ; i++ )
			{
				var getRecord = compStore[i]['displayField'];
				
				if(getRecord!=null)
					getRecord=getRecord.toLowerCase();
				if ( getRecord.indexOf(findVal) > -1 )
				{
			
					isRecordFound = true;
					genStore.add({
						'displayField': compStore[i]['displayField'],
						'valueField': compStore[i]['valueField']
					});
				}
			}
	
			if ( isRecordFound )
			{
				compObj.getStore().removeAll(); 
				for ( var i = 0; i < genStore.getCount() ; i++ )
				{
					var getRecord = genStore.getAt(i);
					compObj.getStore().add(getRecord);
				}

				compObj.setValue(genStore.getAt(0).get('valueField'));
			}
			else
			{
				compObj.getStore().removeAll();
				compObj.getStore().add({
					'displayField': 'Not Applicable!',
					'valueField': '-1'
				});
				if(findVal=="")
				{
					compObj.setValue(genStore.getAt(0).get('valueField'));
				}
				else
				{
					compObj.setValue("-1");
				}
			}
			obj.focus();
		 }
	},
	toggleForm:function(){
		
		var ornt = this.getDdOptionsForm();
		ornt.toggleCollapse(true);
		 if (ornt.collapsed) {
			ornt.removeCls('formOuter');
		 }else{
			ornt.addCls('formOuter');
		 }
	},
	hideTools : function() {
		this.getUtilitiestool().loadIcon(true, //save
				true, //print
				false, //mail
				false, //data
				true, //cvs
				false, // fav
				false,// schedule
				false, //daignosis
				false, //togglebutton
				false //close
				);		
							Ext.getCmp('csvToolSeparator').hide();
	},
	loadForm : function(thisObj) {
		var form = thisObj.getForm();

		if (isSubmit != undefined && isSubmit == 'true') {
			this.loadServices(form);
			this.loadComponents(form);
			this.doFilter('sitelist', form, 'getUserSites', '&p0=' + site,site);
			if(site=='-1')
			{
			  this.doFilter('hostlist', form, 'getUserComponentsForDD', '&p0=' + site,comp);
			}
			else
			{
			  this.doFilter('hostlist', form, 'getComponentsForSiteDD', '&P0=' + site,comp);
			}
			this.doFilter('layerlist', form, 'getLayersForComponent', '&P0='+ comp, layer);
			this.doFilter('testlist', form, 'getTestsForDD', '&P0=' + site+ '&P1=' + comp + '&P2=' + layer, stest);
			this.doFilter('msmt_host', form, 'selectMsmtHostForGraph', '&P0='+ site + '&P1=' + comp + '&P2=' + layer + '&P3='+ encodeURIComponent(test), msmt_host);
			this.doFilter('measurelist', form, 'getMeasuresForDD', '&P0='+ encodeURIComponent(test) + '&P1=' + layer + '&P2=true&',measure);
			this.doFilter('descriptionlist', form, 'getTestDescriptorsForGraph', '&P0=' + site + '&P1=' + comp +'&P2=' + layer + '&P3=' + test +'&','-');
			Ext.getCmp('settings').queryString = queryString;
		    this.renderResult(queryString);
		
		} else {
			this.loadServices(form);
			this.loadComponentTypes(form);
			this.loadComponents(form);
			this.setNotApplicable(form,'layerlist',defaultJSON.screenLabels['monitor.common.DefaultLayerOption']);
			this.setNotApplicable(form,'testlist',defaultJSON.screenLabels['monitor.common.DefaultTestOption']);
			this.setNotApplicable(form,'msmt_host',defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
			this.setNotApplicable(form,'measurelist',defaultJSON.screenLabels['monitor.common.DefaultMeasureOption']);
		}
	},
	settingsFormRender : function() {
		var settingsForm = this.getSettingsForm().getForm();
		Ext.getCmp('er_stmin').setVisible(true);
		Ext.getCmp('er_endmin').setVisible(true);
		var screenLabels = defaultJSON['screenLabels'];
		var objectArr = new Array();
		objectArr['er_timeline'] = screenLabels['monitor.common.Timeline'];
		objectArr['er_stdate'] = screenLabels['monitor.common.From'];
		objectArr['er_sthr'] = screenLabels['monitor.common.Hr'];
		objectArr['er_stmin'] = screenLabels['monitor.common.Min'];
		objectArr['er_enddate'] = screenLabels['monitor.common.To'];
		objectArr['er_endhr'] = screenLabels['monitor.common.Hr'];
		objectArr['er_endmin'] = screenLabels['monitor.common.Min'];
		var view = this.getSettingsFormView();
		view.hide();
		//objectArr['er_mode'] = screenLabels['monitor.common.View'];
		this.loadScreenLabels(settingsForm, objectArr);

		var selectedData = defaultJSON.timelinedetails['timelineSelections'];
		var timelineCombo = defaultJSON.timelinedetails['timeline'];
		if (!Ext.isEmpty(timelineCombo)) {
			var timelineSelected = selectedData['selectedTimeline']
			this.setComboOptionsInList(settingsForm, 'er_timeline',
					timelineCombo, timelineSelected);
		}

		var startDateSelected = selectedData['selectedStartDate'];
		if (!Ext.isEmpty(startDateSelected)) {

			//Ext.getCmp('er_stdate').setValue(new Date(startDateSelected));
			Ext.getCmp('er_stdate').setValue(startDateSelected);
		}
		var endDateSelected = selectedData['selectedEndDate'];
		if (!Ext.isEmpty(endDateSelected)) {

			//Ext.getCmp('er_enddate').setValue(new Date(endDateSelected));
			Ext.getCmp('er_enddate').setValue(endDateSelected);

		
		}

		var startHrSelected = selectedData['selectedStartHour'];
		if (!Ext.isEmpty(startHrSelected)) {
			settingsForm.findField('er_sthr').setValue(startHrSelected);
		}

		var endHrSelected = selectedData['selectedEndHour'];
		if (!Ext.isEmpty(endHrSelected)) {
			settingsForm.findField('er_endhr').setValue(endHrSelected);
		}
		var startHrSelected = selectedData['selectedStartMin'];
		if (!Ext.isEmpty(startHrSelected)) {
			settingsForm.findField('er_stmin').setValue(startHrSelected);
		}

		var endHrSelected = selectedData['selectedEndMin'];
		if (!Ext.isEmpty(endHrSelected)) {
			settingsForm.findField('er_endmin').setValue(endHrSelected);
		}

		this.changeTimeline();

		var durationCombo = defaultJSON.timelinedetails['durationCombo'];
		
		if (!Ext.isEmpty(durationCombo)) {
			var durationSelected = selectedData['durationSelected'];
			this.setComboOptionsInList(settingsForm, 'period', durationCombo,
					durationSelected);
		}

		if (isSubmit != undefined && isSubmit == 'true') {
			Ext.getCmp('er_stdate').setValue(starttime);
			Ext.getCmp('er_timeline').setValue(decodeURIComponent(time));
			//er_timeline
			Ext.getCmp('er_enddate').setValue(endtime);
			settingsForm.findField('er_sthr').setValue(starthr);
			settingsForm.findField('er_endhr').setValue(endhr);
			//settingsForm.findField('er_mode').setValue(mode);

		}
	},
	changeTimeline : function(obj) {
		var getTimelineVal = Ext.getCmp('er_timeline').getValue();
		var stDateObj = Ext.getCmp('er_stdate');
		var endDateObj = Ext.getCmp('er_enddate');
		var stHrObj = Ext.getCmp('er_sthr');
		var endHrObj = Ext.getCmp('er_endhr');
		if (getTimelineVal == 'Any') {
			stDateObj.setDisabled(false);
			endDateObj.setDisabled(false);
			stHrObj.setDisabled(false);
			endHrObj.setDisabled(false);
		} else {
			stDateObj.setDisabled(true);
			endDateObj.setDisabled(true);
			stHrObj.setDisabled(true);
			endHrObj.setDisabled(true);
		}
		if(getTimelineVal!='Any')
		{
			
    		var strtdt = Ext.Date.dateFormat(stDateObj.getValue(), mgrDateFormat);
    		var enddt = Ext.Date.dateFormat(endDateObj.getValue(), mgrDateFormat);
			//var strtdt = Ext.Date.dateFormat(stDateObj.getValue(), 'm/d/Y');
    		//var enddt = Ext.Date.dateFormat(endDateObj.getValue(), 'm/d/Y');
    		if (!Ext.isEmpty(obj)) {
    			var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getTime&P0='
    					+ getTimelineVal
    					+ '&P1='
    					+ encodeURIComponent(strtdt)
    					+ '&P2='
    					+ encodeURIComponent(enddt)
    					+ '&P3='
    					+ stHrObj.getValue()
    					+ '&P4='
    					+ endHrObj.getValue()
    					+ '&P5=' + encodeURIComponent(currentDateFormat);
    			var me = this;
    
    			Ext.Ajax.request({
    						url : '/final/servlet/com.eg.RemoteScriptingServlet',
    						params : param,
    						success : function(response) {

    							var formdata = Ext.decode(response.responseText);
									
								if(formdata[2].length==1)
									formdata[2]="0"+formdata[2];
								if(formdata[3].length==1)
									formdata[3]="0"+formdata[3];
							
    							stDateObj.setValue(formdata[0]);
    							endDateObj.setValue(formdata[1]);
    							stHrObj.setValue(formdata[2]);
    							endHrObj.setValue(formdata[3]);
    						}
    					});
    		}
		}
	},
	loadScreenLabels : function(form, ObjectArr) {
		var obj = '';
		for (var key in ObjectArr) {

			obj = !Ext.isEmpty(form.findField(key)) ? form.findField(key) : Ext
					.getCmp(key);

			if (obj.getXType() != 'label') {
				form.findField(key).setFieldLabel(ObjectArr[key]);
			} else {
				Ext.getCmp(key).setText(ObjectArr[key]);
			}
		}
	},
	loadServices : function(form) {
		var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getUserSites';
		var me = this;
		Ext.Ajax.request({
					url : '/final/servlet/com.eg.RemoteScriptingServlet',
					params : param,
					success : function(response) {
						var formdata = Ext.decode(response.responseText);
						me.setComboOptionsInList(form, 'sitelist', formdata,
								'-1');
					}
				});
	},
	loadComponentTypes:function(form) {
		var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getComponentTypesForSite&P0=no';
		var me = this;
		Ext.Ajax.request({
			url : '/final/servlet/com.eg.RemoteScriptingServlet',
			params : param,
			success : function(response) {
				var formdata = Ext.decode(response.responseText);
				componentsRawData = formdata;
				me.setComboOptionsInList(form, 'comptypelist', formdata,
						'-1');
			}
		});
	},
	loadComponents : function(form) {
		var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getUserComponentsForDD';
		var me = this;
		Ext.Ajax.request({
					url : '/final/servlet/com.eg.RemoteScriptingServlet',
					params : param,
					success : function(response) {
						var formdata = Ext.decode(response.responseText);
						componentsRawData = formdata;
						me.setComboOptionsInList(form, 'hostlist', formdata,
								'-1');
					}
				});
	},
	setComboOptionsInList : function(form, fieldName, list, value) {
		form.findField(fieldName).getStore().loadRawData(list);
		if(fieldName=='descriptionlist')
		{
			
			if(list.length>1){
			//enable the fields
			var obj = Ext.getCmp("searchOpt");
			Ext.get('searchOpt-inputEl').setStyle('width', '130');
			//obj.getEl().show();
			var decObj = Ext.getCmp("descriptionlist");
			Ext.get('descriptionlist-inputEl').setStyle('width', '210');
			decObj.getEl().show();
			this.getMain().doLayout();
			
			}
			else{			
			//disable the fields
			var obj = Ext.getCmp("searchOpt");
			obj.getEl().hide();
			var decObj = Ext.getCmp("descriptionlist");
			decObj.getEl().hide();
			var form = this.getDdOptionsForm().getForm();
			this.getMain().doLayout();
			}
			descRawData = list;
		}
		form.findField(fieldName).suspendEvents(false);
		
		if(fieldName=='measurelist')
		{
			if(value.indexOf(",")>-1)
			{
				var meas=[];
				var tmp = value.split(',');
				for(var i=0;i<tmp.length;i++)
				{
					meas.push(tmp[i]);
				}
				form.findField(fieldName).setValue(meas);
			}
			else
			{
				if(value=='-')
                {
                    value = form.findField(fieldName).getStore().getAt(0).get('valueField');
                }
				form.findField(fieldName).setValue(value);
			}
			this.doMeasureListChange();
		}
		else
		{
			if(value=='-')
            {
                  	if(length>1)
					{
						value = form.findField(fieldName).getStore().getAt(1).get('valueField');
					}else
					{
						value = form.findField(fieldName).getStore().getAt(0).get('valueField');
					}
				
			}

			form.findField(fieldName).setValue(value);
		}
		
		form.findField(fieldName).resumeEvents();
	},
	setComboValue : function(form, fieldName, value) {
		form.findField(fieldName).suspendEvents(false);
		form.findField(fieldName).setValue(value);
		form.findField(fieldName).resumeEvents();
	},
	setNotApplicable : function(form, fieldname, option) {
		form.findField(fieldname).getStore().removeAll();
		form.findField(fieldname).getStore().loadRawData([{
					"displayField" : option,
					"valueField" : "-1"
				}]);
		form.findField(fieldname).setValue("-1");
	},
	component_onchange : function(thisObj) {
		var val = thisObj.getValue();
		var tempVal= val.substring(val.lastIndexOf(':') + 1)
		
		/*if(tempVal=='Real_user_monitor')
		{
			var decObj = Ext.getCmp("sortby");
			Ext.get('sortby-inputEl').setStyle('width', '210');
			decObj.getEl().show();
			this.getMain().doLayout();
		}
		else
		{
			var decObj = Ext.getCmp("sortby");
			Ext.get('sortby-inputEl').setStyle('width', '210');
			decObj.getEl().hide();
			this.getMain().doLayout();
		}*/
		var form = thisObj.up('.form').getForm();
		this.setNotApplicable(form,'layerlist',defaultJSON.screenLabels['monitor.common.DefaultLayerOption']);
		this.setNotApplicable(form,'testlist',defaultJSON.screenLabels['monitor.common.DefaultTestOption']);
		this.setNotApplicable(form,'msmt_host',defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
		this.setNotApplicable(form,'measurelist',defaultJSON.screenLabels['monitor.common.DefaultMeasureOption']);
		var no_param = '&P0=' + val;
		this.doFilter('layerlist', form, 'getLayersForComponent', no_param,'-1');
	},
	layer_onchange : function(thisObj) {
		var val = thisObj.getValue();
		var form = thisObj.up('.form').getForm();

		this.setNotApplicable(form, 'testlist',defaultJSON.screenLabels['monitor.common.DefaultTestOption']);
		this.setNotApplicable(form,'msmt_host',defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
		this.setNotApplicable(form,'measurelist',defaultJSON.screenLabels['monitor.common.DefaultMeasureOption']);
		var siteName = form.findField('sitelist').getValue();
		siteName = (siteName == '-1') ? 'NULL' : siteName;
		var hostName = form.findField('hostlist').getValue();

		var no_param = '&P0=' + siteName + '&P1=' + hostName + '&P2=' + val + '';

		this.doFilter('testlist', form, 'getTestsForDD', no_param, '-1');
	},
	doMeasureListChange:function(){
		try
		{
			var testName = Ext.getCmp('testlist').getValue();
			var mesname = Ext.getCmp('measurelist').getValue();
			var searchCombo= Ext.getCmp('searchComboId');
			var	searchText = Ext.getCmp('searchTextId');
			if(testName != undefined && testName != null && testName.indexOf("-+"))
				testName = testName.substring(0,testName.indexOf("-+"));
			var param1 = 'beanName=getSearchOptions&mesname='+mesname+'&testName='+testName;
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.RemoteScriptingServlet',
				params : param1,
				success : function(response) {
					
					try
					{
						var formdata = Ext.decode(response.responseText);
						console.log(formdata)

						if(formdata != undefined && formdata['options'] != undefined && formdata['options'].length > 0 ){
							searchCombo.setVisible(true);
							searchText.setVisible(true);
							searchCombo.getStore().removeAll();
							searchCombo.getStore().loadRawData(formdata['options']);
							var value = searchCombo.getStore().getAt(0).get('value');
							searchCombo.setValue(value);
							searchText.setValue('');
						}else
						{
							searchCombo.setVisible(false);
							searchText.setVisible(false);
						}
					}
					catch (e)
					{
						console.log('e--->',e)
						searchCombo.setVisible(false);
						searchText.setVisible(false);
					}
				},
				failure : function(){
					searchCombo.setVisible(false);
					searchText.setVisible(false);
				}
			});
		}
		catch (e)
		{
			console.log('error--->',e)
		}
	},
	test_onchange : function(thisObj) {
		var val = thisObj.getValue();
		var form = thisObj.up('.form').getForm();

		this.setNotApplicable(form,'msmt_host',defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
		this.setNotApplicable(form,'measurelist',defaultJSON.screenLabels['monitor.common.DefaultMeasureOption']);
		var siteName = form.findField('sitelist').getValue();
		siteName = (siteName == '-1') ? 'NULL' : siteName;
		var hostName = form.findField('hostlist').getValue();
		var layerName = form.findField('layerlist').getValue();
		var s_compTy= hostName.substring(hostName.lastIndexOf(':') + 1)
		val = val.substring(0, val.indexOf('-'));
		

		var searchCombo= Ext.getCmp('searchComboId');
		var	searchText = Ext.getCmp('searchTextId');
		searchCombo.setVisible(false);
		searchText.setVisible(false);

		try
		{
			
			var decObj = Ext.getCmp("sortby");
			Ext.get('sortby-inputEl').setStyle('width', '210');
			decObj.getEl().show();
			this.getMain().doLayout();
			var param1 = 'beanName=getSortOptions&compType='+s_compTy+'&testName='+val;
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.RemoteScriptingServlet',
				params : param1,
				success : function(response) {
					var formdata = Ext.decode(response.responseText);
					if(formdata != undefined && formdata['options'] != undefined && formdata['options'].length > 0 ){
						form.findField('sortby').getStore().removeAll();
						form.findField('sortby').getStore().loadRawData(formdata);
						var value = formdata.defaultsort;
						form.findField('sortby').setValue(value);
						decObj.getEl().show();
					}else{
						decObj.getEl().hide();
					}
				},
				failure:function(){
					decObj.getEl().hide();
				}
			});
		}
		catch (eeee)
		{
			decObj.getEl().hide();
		}
		

		var no_param = '&P0=' + siteName + '&P1=' + hostName + '&P2=' + val + '';

		this.doFilter('msmt_host', form, 'selectMsmtHostForGraph', '&P0=' + siteName + '&P1=' + hostName + '&P2=' + layerName + '&P3=' + encodeURIComponent(val), '-');
		this.doFilter('measurelist', form, 'getMeasuresForDD', '&P0=' + encodeURIComponent(val) + '&P1=' + layerName + '&P2=true&','-');
		this.doFilter('descriptionlist', form, 'getTestDescriptorsForGraph', '&P0=' + siteName + '&P1=' + hostName +'&P2=' + layerName + '&P3=' + val +'&','-');
						
		form.findField('measurelist').getStore().getAt(0).get('valueField');
		//this.doMeasureListChange();
		//form.findField('descriptionlist').getStore().getAt(0).set('-1');
	},
	site_onchange : function(thisObj) {
		var val = thisObj.getValue();
		var form = thisObj.up('.form').getForm();
		this.setNotApplicable(form,'hostlist',defaultJSON.screenLabels['monitor.common.DefaultComponentOption']);
		this.setNotApplicable(form,'layerlist',defaultJSON.screenLabels['monitor.common.DefaultLayerOption']);
		this.setNotApplicable(form,'testlist',defaultJSON.screenLabels['monitor.common.DefaultTestOption']);
		this.setNotApplicable(form,'msmt_host',defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
		this.setNotApplicable(form,'measurelist',defaultJSON.screenLabels['monitor.common.DefaultMeasureOption']);

		val = (val == '-1') ? 'no' : val;
		this.doFilter('comptypelist', form, 'getComponentTypesForSite', '&P0=' + val + '', '-1');
		this.doFilter('hostlist', form, 'getComponentsForSiteDD', '&P0=' + val + '', '-1');
	},
	comptype_onchange : function(thisObj){
		var val = thisObj.getValue();
		var form = thisObj.up('.form').getForm();
		this.setNotApplicable(form,'hostlist',defaultJSON.screenLabels['monitor.common.DefaultComponentOption']);
		this.setNotApplicable(form,'layerlist',defaultJSON.screenLabels['monitor.common.DefaultLayerOption']);
		this.setNotApplicable(form,'testlist',defaultJSON.screenLabels['monitor.common.DefaultTestOption']);
		this.setNotApplicable(form,'msmt_host',defaultJSON.screenLabels['monitor.common.DefaultMsmthostOption']);
		this.setNotApplicable(form,'measurelist',defaultJSON.screenLabels['monitor.common.DefaultMeasureOption']);
	
		var site_val = '';
		if(!Ext.isEmpty(Ext.getCmp('sitelist')) && Ext.getCmp('sitelist')!=null && Ext.getCmp('sitelist')!=undefined)
			site_val = Ext.getCmp('sitelist').getValue();
		
		val = (val == '-1') ? 'no' : val;
		site_val = (site_val == '-1') ? 'NULL' : site_val;
		var no_param = '&P0=' + site_val + '&P1=' + val;
		//if((!Ext.isEmpty(val)&& val!=null && val!=undefined && val=='-1') && ((!Ext.isEmpty(site_val)&& site_val!=null && site_val!=undefined && site_val!='-1')))
			//this.doFilter('hostlist', form, 'getComponentsForSiteDD', '&P0=' + site_val + '', '-1');
		//else
			this.doFilter('hostlist', form, 'getComponentsForType', no_param, '-1');
	},
	doFilter : function(fieldname, form, method, no_param, val) {

		var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method='
				+ method + no_param;
				
		var me = this;
		Ext.Ajax.request({
					url : '/final/servlet/com.eg.RemoteScriptingServlet',
					params : param,
					success : function(response) {
						var formdata = Ext.decode(response.responseText);

						me.setComboOptionsInList(form, fieldname,formdata, val);
					}
				});
	},
	beforeFormSubmit : function() {
		var mainForm = this.getDdOptionsForm().getForm();
		var hostObj = mainForm.findField('hostlist');
		var layerObj = mainForm.findField('layerlist');
		var testObj = mainForm.findField('testlist');
		var msmt_Obj = mainForm.findField('msmt_host');
		var measureObj = mainForm.findField('measurelist');
		var descObj = mainForm.findField('descriptionlist');	
		var valid=false;
		
		var defVal="";
		
		if(descRawData!=null && descRawData!="")
		{
			defVal = descRawData[0].displayField;
			for(var i=0;i<descRawData.length;i++)
			{			
				if(descRawData[i].displayField==descObj.getValue())
					valid=true;
				else if(descRawData[i].valueField==descObj.getValue())
					valid=true;			
			}
		}
		var msg = '';
		if (hostObj.getValue() == '-1') {
			msg = chooseComp;
		} else if (layerObj.getValue() == '-1') {
			msg = chooseLayer;
		} else if (testObj.getValue() == '-1') {
			msg = chooseTest;
		}else if ((descObj.getValue() =='-1' || descObj.getValue() ==null || !valid) && descObj.getValue() !='-2') {
		
			msg = chooseDescriptor;
			var form = this.getDdOptionsForm().getForm();
			if (!Ext.isEmpty(msg)) 
			{
				Ext.MessageBox.show({
						title : 'Alert',
						msg : msg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING,
						fn : function (buttonId) {
						 if (buttonId == 'ok') {
							if(searchObj!=null)
							{
								searchObj.setValue("");
							}
							var compStore = descRawData;
							var compObj = form.findField('descriptionlist');			
							compObj.getStore().removeAll(); 
							compObj.getStore().loadRawData(compStore);
							var value;
							if(Ext.isEmpty(compObj.getStore().getAt(0)))
								value=defVal;
							else
								value = compObj.getStore().getAt(0).get('valueField');
							
							compObj.setValue(value);				
						}
					} });
				return false;
				} 
			
			else			
				return true;	
			
		} else if (msmt_Obj.getValue() == '-1') {
			msg = chooseMsmtHost;
		} else if (measureObj.getValue() == '-1') {
			msg = chooseMeasure;
		}
		var settingsForm = this.getSettingsForm().getForm();
		var starttime = Ext.Date.format(settingsForm.findField('er_stdate').getValue(), 'm/d/Y');
		var endtime = Ext.Date.format(settingsForm.findField('er_enddate').getValue(), 'm/d/Y');
		var starthr = parseInt(settingsForm.findField('er_sthr').getValue());
		var endhr = parseInt(settingsForm.findField('er_endhr').getValue());
		var stmin = parseInt(settingsForm.findField('er_stmin').getValue());
		var endmin = parseInt(settingsForm.findField('er_endmin').getValue());
		if(dateValidation(starttime,endtime,starthr,endhr,stmin,endmin)==-1)
		{
			msg ="From date should be lesser than to date";
		}
		if (!Ext.isEmpty(msg)) {
			Ext.MessageBox.show({
						title : 'Alert',
						msg : msg,
						buttons : Ext.MessageBox.OK,
						icon : Ext.MessageBox.WARNING
					});
			return false;
		} else {
			return true;
		}

		
	},
		
	showResult : function(pageNo,msg) {
		currentPage=1;
		var fromSubmit = true;
		if (!this.beforeFormSubmit()) {
			return;
		}
		//var queryString = 'resultpage=measure';
		var queryString = '';
		var mainForm = this.getDdOptionsForm().getForm();
		var settingsForm = this.getSettingsForm().getForm();
		//var objectArr = new Array();
		var objectArr = [];
		objectArr['comp'] = mainForm.findField('hostlist').getValue();
		var compType = mainForm.findField('hostlist').getValue();
		compType = compType.substring(compType.lastIndexOf(':') + 1);
		objectArr['comptype'] = compType;
		//objectArr['endhr'] = settingsForm.findField('er_sthr').getValue();
		objectArr['endhr'] = settingsForm.findField('er_endhr').getValue();
		objectArr['endmin'] = settingsForm.findField('er_endmin').getValue();
		objectArr['endtime'] = Ext.Date.format(settingsForm
						.findField('er_enddate').getValue(), 'm/d/Y');
		var host = mainForm.findField('hostlist').getValue();
		host = host.substring(0, host.indexOf(':'));
		objectArr['host'] = host;
		var hostlist = mainForm.findField('hostlist').getValue();
		var testlist = mainForm.findField('testlist').getValue();
		var infotest =mainForm.findField('descriptionlist').getValue();

		
		if(infotest==-2){
		infotest="";
		}
		
		//var info = '*' + testlist.substring(testlist.indexOf('+') + 1);
		var info = '*' + infotest;
		
		if (info.indexOf('&') > -1)
			info = info.replace('&', '|amp|');
		if (info.indexOf('+') > -1)
			info = info.replace('+', '|plus|');
		if (info.indexOf('%') > -1)
			info = info.replace('%', '|pct|');
		if (info.indexOf('#') > -1)
			info = info.replace('#', '|hash|');

		objectArr['hostlist'] = hostlist;

		var oraclesidCheck = mainForm.findField('hostlist').getValue();
		if(oraclesidCheck != null && oraclesidCheck != undefined && oraclesidCheck != 'undefined'){
			
			if(oraclesidCheck.indexOf("Oracle_server") != -1 && info == '*' )
			{
				var temp = oraclesidCheck.substring(0,oraclesidCheck.lastIndexOf(":"));
				var infotemp = temp.substring(temp.lastIndexOf(":")+1);
				info = infotemp+"*";
			}
			else if(oraclesidCheck.indexOf("Oracle_server") != -1 && info.indexOf('*') != -1 ){
				info=info.substring(1);
			}
		}
		objectArr['info'] = info;
		objectArr['layer'] = mainForm.findField('layerlist').getValue();
		objectArr['measure'] = mainForm.findField('measurelist').getValue();
		//objectArr['mode'] = settingsForm.findField('er_mode').getValue();
		objectArr['msmt_host'] = mainForm.findField('msmt_host').getValue();
		objectArr['sortBy'] = mainForm.findField('sortby').getValue();
		
		var tmphostlist = hostlist.substring(hostlist.indexOf(':') + 1);
		var port = tmphostlist.substring(0, tmphostlist.indexOf(':'));

		objectArr['port'] = port;
		objectArr['site'] = mainForm.findField('sitelist').getValue();
		if(mainForm.findField('sitelist').getValue()=='-1')
			objectArr['site'] = 'NULL';
		
		objectArr['starthr'] = settingsForm.findField('er_sthr').getValue();
		objectArr['startmin'] = settingsForm.findField('er_stmin').getValue();
		objectArr['starttime'] = Ext.Date.format(settingsForm
						.findField('er_stdate').getValue(), 'm/d/Y');
		var stest = mainForm.findField('testlist').getValue();
		var test = stest.substring(0, stest.indexOf('+') - 1);
		var time = settingsForm.findField('er_timeline').getValue();
		
		stest = stest.replace('+', '*');
		objectArr['stest'] = stest;
		objectArr['test'] = test;
		
		ctxParams['site']= objectArr['site'];
		ctxParams['host'] = objectArr['host'];
		ctxParams['port'] = objectArr['port'];
		ctxParams['test'] = objectArr['test'];
		ctxParams['isPopUp'] = 'true';
		ctxParams['info'] = objectArr['info'];
		ctxParams['msmt_host'] = objectArr['msmt_host'];
		ctxParams['from'] = '0';
		ctxParams['measure'] = objectArr['measure'];
		ctxParams['flag'] = '1';
		ctxParams['firsttime'] = 'true';
		ctxParams['comptype'] = objectArr['comptype'];
		ctxParams['clicked'] = 'dd';
		ctxParams['fromLayer'] = 'true';
		ctxParams['comeFrom'] = 'true';
		ctxParams['isFromCtxHist'] = 'true';
		objectArr['time'] = encodeURIComponent(time);
		objectArr['timeline'] = time;
		//objectArr['gtype'] = "0";
		//objectArr['gformat'] = "graph";
		
		if (stest.indexOf('\\') > -1) {
			var tmpTest = stest.split('\\');
			var encodeTest = '';
			for (var i = 0; i < tmpTest.length; i++) {
				if (i == (tmpTest.length - 1)) {
					encodeTest += tmpTest[i];
				} else {
					encodeTest += tmpTest[i] + '/';
				}
			}
			objectArr['encodetest'] = encodeTest;
		}
		if (isSubmit != undefined && isSubmit == 'true')
			objectArr['isSubmit'] = 'true';
		//var measureName = this.measureName(mainForm.findField('measurelist').getValue(),test,objectArr,pageNo);
		var measureName = this.newGridChanges(mainForm.findField('measurelist').getValue(),test,objectArr,pageNo);
	},
	newGridChanges : function (measureColumnName,test,objectArr,pageNo,msg){
		var me = this;
		var grid = Ext.getCmp('ddGridView');
		if(grid != null && grid != undefined && grid != 'undefined')
			grid.destroy();
		
		var seqHideFlag = false;
		if(seqHideTests != null && seqHideTests.indexOf(test+"_DDD") > -1 )
			seqHideFlag = true;

		
		Ext.Ajax.request({
			url : '../monitor/EgDispDD.jsp?measure='+measureColumnName+'&from=optionsDD&test='+test,
			scope:this,
			success:function(response)
			{
				var jsontext = response.responseText;
				var jsonObject = Ext.decode(jsontext);
				if (!Ext.isEmpty(jsonObject)) {
					objectArr['measure'] = jsonObject.measureName;
					ctxParams['measure'] = objectArr['measure'];
					var queryString = this.genQueryString(objectArr);
					var searchLink='';
					var searchCombo= Ext.getCmp('searchComboId');		
					if(searchCombo != undefined && searchCombo != null){
						var	searchText = Ext.getCmp('searchTextId');
						var seatrchComboval = searchCombo.getValue();
						var searchTextVal = searchText.getValue();
						if(searchTextVal != undefined && searchTextVal != null && searchTextVal.trim() != "" ){
							searchLink+='&searchfield='+encodeURIComponent(seatrchComboval)+'&searchText='+encodeURIComponent(searchTextVal);
						}			
					}
					queryString = queryString+searchLink;
					//queryString+="&startmin="+stmin+"&endmin="+enmin;
					queryString = queryString +'&isVM=false&flag=1&firsttime=true&from=0&fromPage=layMod&newWindow=true&comeFrom=true&comesForDD=comesForDD'+'&pageNo='+encodeURIComponent(pageNo);
					var wholeViewport = document.getElementsByTagName("body")[0];
					var mask = new Ext.LoadMask(wholeViewport, {msg:"Loading...",cls:'maskLoad'});
					mask.show();
					//Ext.getCmp('upbutton').setDisabled(false);
					Ext.getCmp('measure_graph').queryString=queryString;
					if(Ext.isEmpty(msg))
						msg="newReq";
					

					msg="newReq";
					if(queryString.indexOf("&") == 0)
						queryString = queryString.slice(1);

					var countURL = '../monitor/EgDispDD.jsp?'+queryString+"&isCountRecords=Yes&reqType="+msg;
					Ext.Ajax.request({
						url : countURL,
						method : 'POST',
						scope : this,
						success : function(response, opts) {
							var jsonText = response.responseText;											
							var pageNumber='';
							var totRec='';
							if(jsonText != null && jsonText.indexOf('@') != -1){
								pageNumber = jsonText.substring(0,jsonText.indexOf('@'));
								totRec = jsonText.substring(jsonText.indexOf('@')+1);

								totalRecords = parseInt(pageNumber.trim());	
								totalDataRecords = parseInt(totRec.trim());	
							}
						
							Ext.Ajax.request({	
								//url : '../monitor/EgDiagnosis.jsp?'+queryString,
								url : '../monitor/EgDispDD.jsp?'+queryString+"&reqType="+msg+"&totalRecords="+totalRecords,
								success : function(response) {
								var jsontext = response.responseText;
								var jsonData = Ext.decode(jsontext); 
								
								if (!Ext.isEmpty(jsonData)) 
								{ 
									me.jsonData=jsonData;
									if(!Ext.isEmpty(Ext.getCmp('tablePanel')))
										Ext.getCmp('tablePanel').destroy();
									if(!Ext.isEmpty(Ext.getCmp('errorDD')))
										Ext.getCmp('errorDD').destroy();
									if(!Ext.isEmpty(jsonData.errorMsg))
									{
										var errorPanel = {
										xtype : 'errorpanel',
										id:'errorDD',
										height : 380,
										//width : '100%',
										border : true,
										autoScroll:true,
										align:'center',
										margin : '0 5 5 5',
										border : true,
										errorMsg : '<table height="100%" width="100%"><tr><td align="center" style="font-size:9pt"><div class="iconInformation"></div><div class="errormsgdd">' + jsonData.errorMsg
												+ '</div></td></tr></table>',
										};
										var panel = {xtype : 'panel',margin:'0 5 5 5',items:[errorPanel]};
										me.getMain().add(panel);
										
									}
									else
									{
										
										// grid entry here
										var totalPage = 1;
										if(totalRecords != null && totalRecords != undefined && totalRecords != 'undefined')
											totalPage=totalRecords;

										if(pageNo != null && pageNo != undefined && pageNo != 'undefined' && typeof(pageNo) == 'number')
											currentPage=pageNo;
										
										if(currentPage == '0' || currentPage == 0)
											currentPage = 1;

										
										var gridMsg = '';
										var sizeEl = 10;
										var startIn = 1;
										var endIn = 10;
										
										startIn = (currentPage -1)*sizeEl;
										endIn = startIn + sizeEl;
										startIn = startIn+1;
										if(endIn > totalDataRecords )
											endIn = totalDataRecords;
										
										
										var gridInfo = jsonData['gridInfo'];
										var title = gridInfo['gridHeader'];
										var header =gridInfo['headers'] ;
										var datas =gridInfo['data'];
										
										var groupFiled = 'time';
										if(jsonData.isRUM != undefined && jsonData.isRUM != null && (jsonData.isRUM == true || jsonData.isRUM == 'true') )
											groupFiled = '';

										var endIndex = pageCount+(datas.length-1);
										if(totalDataRecords < endIndex)
											totalDataRecords = endIndex;
										//gridMsg = startIn+ ' - '+endIn+' of '+totalDataRecords;
										prevArray.push(pageCount);
										gridMsg = pageCount+ ' - '+endIndex+' of '+totalDataRecords;
										
										pageCount = endIndex+1;
										//gridMsg = startIn+ ' - '+endIn+' of '+totalDataRecords;
										gridMsg = startIn+ ' - '+endIn+' of '+totalDataRecords;

										var fields = [];
										for(var l=0;l<header.length;l++){
											var dataIndexVal = header[l].dataIndex;
											fields.push(dataIndexVal);
										}

										var storeCreate = Ext.create('DD.store.ddGridStore', 
											{
												fields:fields,
												groupField: groupFiled
											}
										);
										
										var groupingFeature = Ext.create('Ext.grid.feature.Grouping',{
											groupHeaderTpl:'{groupValue}',
											collapsible:false
										});
										storeCreate.loadData(datas,false);
										var	gridDetails =  Ext.create('DD.view.ddGridView', {
										plugins:Ext.create('Ext.ux.AutoColumnWithLockingPlugin'),
										//plugins:Ext.create('AutoWidthColumnsPlugin'),
											//plugins:Ext.create('AutoColumnPlugin'),
											store: storeCreate,
											features:[groupingFeature],
											cls:'gridSkin ddGridView',
											id:'ddGridView',
											title: title,
											columns: header,
											flex:1,
											tools:[{
												type:'button',
												itemId:'healthy',
												hidden:true,
												cls:'healthybtn',
												tooltip:'Healthy',
												margin:'0 2',
												handler: function(){
													btmFilterCall("Healthy_trans_count");
												}
												
												},{
												type:'button',
												itemId:'slow',
												hidden:true,
												cls:'slowbtn',
												tooltip:'Slow',
												margin:'0 2',
												handler: function(btn){
													btmFilterCall("Slow_urls_count");
												}
												},{
												type:'button',
												itemId:'stalled',
												hidden:true,
												tooltip:'Stalled',
												cls:'stalledbtn',
												margin:'0 2',
												handler: function(btn){
													btmFilterCall("Stalled_urls_count");
												}
												},{
												type:'button',
												itemId:'error',
												hidden:true,
												tooltip:'Error',
												cls:'errorbtn',
												margin:'0 2',
												handler: function(btn){
													btmFilterCall("Error_urls_count");
												}
												}
												],
											dockedItems: [{
												xtype: 'pagingtoolbar',
												id:'pagingtoolbarCustom',
												store: storeCreate,   // same store GridPanel is using
												dock: 'bottom',
												cls:'pagingtoolbar',
												//..afterTextItem:2,
												afterPageText:'of '+totalPage,
												displayInfo: true,
												//displayMsg: 'Displaying '+gridMsg,
												displayMsg: '',
												moveFirst:function(){
													pageCount = 1;
													prevArray = new Array();
													DD.app.getController("Main").newGridChanges(measureColumnName,test,objectArr,1,msg);
												},
												movePrevious:function(){
													if(prevArray.length > 2)
													{
														pageCount = prevArray[prevArray.length-2];
														var a = new Array();
														for(var i=0;i<prevArray.length-2;i++)
															a.push(prevArray[i]);
														
														prevArray = new Array();
														prevArray = a;
													}
													else
														pageCount =1;

													if(currentPage > 1)
														DD.app.getController("Main").newGridChanges(measureColumnName,test,objectArr,currentPage-1,msg);
													else
														DD.app.getController("Main").newGridChanges(measureColumnName,test,objectArr,1,msg);
												},
												moveNext : function(){
													DD.app.getController("Main").newGridChanges(measureColumnName,test,objectArr,currentPage+1,msg);
													//DD.app.getController("Main").showResult(currentPage+1,msg);
												},
												moveLast : function(){
													if(!seqHideFlag)
														DD.app.getController("Main").newGridChanges(measureColumnName,test,objectArr,totalPage,msg);
													else{
														Ext.Msg.alert('Status','Direct Page Movement Not Applicable for this Test');
														return;
													}
												},
												doRefresh:function(){
													DD.app.getController("Main").newGridChanges(measureColumnName,test,objectArr,1,msg);
												},
												onPagingKeyDown:function(field, e){
													var me = this,
													k = e.getKey();
													if (k == e.RETURN) {
														var pageVal = Ext.getCmp('afterTextColumn').getValue();
														if(pageVal == null || pageVal == '' || pageVal == undefined || pageVal == 'undefined')
															return;
														else if(pageVal > totalPage)
														{
															Ext.Msg.alert('Error','Exceeds Maximum Page Numbers');
															return;
														}
														else
														{
															if(!seqHideFlag)
																DD.app.getController("Main").newGridChanges(measureColumnName,test,objectArr,pageVal,msg);
															else{
																Ext.Msg.alert('Status','Direct Page Movement Not Applicable for this Test');
																return;
															}
														}
													}
												},
												emptyMsg: "No topics to display"
											}]
										});
										//Ext.getCmp('lastRec').setVisible(false);
										var gridCol = gridDetails.columns;
										var gettingState = [];
										var maxText =[];

										var state;
										gridCol.forEach(function(d,i){
											d.renderer = function(value, meta, record,rowIndex, columnIndex) {

										//Mailer Content
											if(header[i].text == 'ALERT MESSAGE' ){
												meta.tdCls = 'mailer_content';
												var str =  '<textarea class= "grid_textarea" readonly style="resize:none;width:100%;min-height: 150px;border:0px;background:transparent;display:inline-block;white-space: pre-wrap;word-wrap: break-word" wrap="hard">'+value+'</textarea>';
												return str;
											}
										//@checking the btm data indexOf : "topologyBuild"
												var btmUserExperience = record.raw['0col'];
												var btmUserExperienceIndexOf = btmUserExperience.indexOf("topologyBuild"); 
												var rumUserExperienceIndexOf = btmUserExperience.indexOf("rumTopologyBuild"); 
												if(btmUserExperienceIndexOf != -1 || rumUserExperienceIndexOf!= -1){
														gridCol[1].width = 190;
														}
													
												
												//meta.style = "white-space: normal";
												gridCol[0].hidden = true;
												str =  value;
												return str;
											}
											
											
										});

										me.getMain().add(gridDetails);
										Ext.getCmp('afterTextColumn').setValue(currentPage);
										if(currentPage == 1 || currentPage == '1'){
											Ext.getCmp('firstRec').setDisabled(true);
											Ext.getCmp('prevRec').setDisabled(true);
											if(currentPage == totalRecords){
												Ext.getCmp('nextRec').setDisabled(true);
												Ext.getCmp('lastRec').setDisabled(true);
											}
										}else if(currentPage == totalRecords){
											Ext.getCmp('nextRec').setDisabled(true);
											Ext.getCmp('lastRec').setDisabled(true);
										}
										Ext.getCmp('saveTool').setDisabled(false);
										Ext.getCmp('printTool').setDisabled(false);
										Ext.getCmp('csvTool').setDisabled(false);
										me.getMain().doLayout();
										
									}  
									mask.hide();

								}
								else
								{
									alert("no data found");
								}
							}
						});
						},
						failure : function() {
							alert("failure in component dashboard render");
						}
					});
					
				}
			}
		});
	},
	measureName : function (measureColumnName,test,objectArr,pageNo,msg)
	{
		var me = this;
		var foot=null;
		//Ext.getCmp('upbutton').setDisabled(false);
		Ext.Ajax.request({
			url : '../monitor/EgDispDD.jsp?measure='+measureColumnName+'&from=optionsDD&test='+test,
			scope:this,
			success:function(response)
			{
				var jsontext = response.responseText;
				var jsonObject = Ext.decode(jsontext);
				if (!Ext.isEmpty(jsonObject)) {
					objectArr['measure'] = jsonObject.measureName;
					ctxParams['measure'] = objectArr['measure'];
					var queryString = this.genQueryString(objectArr);
					queryString+="&startmin="+stmin+"&endmin="+enmin;
					queryString = queryString +'&isVM=false&flag=1&firsttime=true&from=0&fromPage=layMod&newWindow=true&comeFrom=true&comesForDD=comesForDD'+'&pageNo='+pageNo;
					var wholeViewport = document.getElementsByTagName("body")[0];
					var mask = new Ext.LoadMask(wholeViewport, {msg:"Loading...",cls:'maskLoad'});
					mask.show();
					//Ext.getCmp('upbutton').setDisabled(false);
					Ext.getCmp('measure_graph').queryString=queryString;
					if(Ext.isEmpty(msg))
						msg="newReq";
					
					Ext.Ajax.request({	
						//url : '../monitor/EgDiagnosis.jsp?'+queryString,
							url : '../monitor/EgDispDD.jsp?'+queryString+"&reqType="+msg+"&totalRecords="+totalRecords,
							success : function(response) {
							var jsontext = response.responseText;
							var jsonData = Ext.decode(jsontext); 
							
							if (!Ext.isEmpty(jsonData)) 
							{ 
								me.jsonData=jsonData;
								if(!Ext.isEmpty(Ext.getCmp('tablePanel')))
									Ext.getCmp('tablePanel').destroy();
								if(!Ext.isEmpty(Ext.getCmp('errorDD')))
									Ext.getCmp('errorDD').destroy();
								if(!Ext.isEmpty(jsonData.errorMsg))
								{
									var errorPanel = {
									xtype : 'errorpanel',
									id:'errorDD',
									height : 380,
									//width : '100%',
									border : true,
									autoScroll:true,
									align:'center',
									margin : '0 5 5 5',
									border : true,
									errorMsg : '<table height="100%" width="100%"><tr><td align="center" style="font-size:9pt"><div class="iconInformation"></div><div class="errormsgdd">' + jsonData.errorMsg
											+ '</div></td></tr></table>',
									};
									var panel = {xtype : 'panel',margin:'0 5 5 5',items:[errorPanel]};
									me.getMain().add(panel);
									
								}
								else
								{
									/*var result_Panel = Ext.create(
											'DD.view.DetailedDiagnosisGrid', {
												id:'gridpanel',
												layout:'auto',
												jsonData : jsonData,
												flex:1,
												bodyCls:'bottom-left-radius bottom-right-radius',
												cls : 'diagnosis-grid-grouping-row'
											});
									me.getMain().add(result_Panel);*/
									var table = {
										xtype:'panel',
										//cls:'panelwithoutheader',
										//extend:'ScrollPanel',
										cls:'datapanel borderDD',			
										//title:'Lists the hop-by-hop connectivity and delay',
										title:jsonData.hiddenFields.title,
										scroll:true,
										autoScroll:false,
										margin:'0 10 10 10',
										frame:true,
										border:true,
										bodyPadding:0,
										padding:0,
										flex:0.9,
										layout:{
											type:'anchor',
											align:'stretch'
										},
										id:'tablePanel',
										listeners:{
											resize:{
												fn:function(width,height)
												{
													var me=this;
													var width = Ext.getBody().getViewSize().width - 160;
													var height = Ext.getBody().getViewSize().height - 250;
													me.setSize(width, height);
												}
											}
										},
										html:jsonData.tableData,
										
										dockedItems:[{ 
													xtype: 'toolbar',
													dock: 'bottom',
													items: [{
														xtype:'container',
														id:'tableViewFt',
														itemId:'tableViewFt',
														hideMode: 'visibility',
														height:25,
														autoScroll:false,
														scroll:false,
														html:jsonData.sbPagination
														}]
													}]
									};
										
								/*	foot={	xtype:'container',
											id:'tableViewFt',
											itemId:'tableViewFt',
											hideMode: 'visibility',
											//flex:1,
											//width:'100%',
											//width:200,
											height:25,
											autoScroll:false,
											scroll:false,
											//hide:false,
											html:jsonData.sbPagination
											
							  			listeners:{
												"resize": { 
													fn: function(el) {
										
												var width = Ext.getBody().getViewSize().width-230 ;
												var height = Ext.getBody().getViewSize().height - 180;
										
									
												//var tableViewH = Ext.getBody().getViewSize().height -100;
												if(Ext.getCmp("tablePanel").getHeight()>100)
												{
												height = Ext.getBody().getViewSize().height - 250;
												}
												this.setSize(width, height);
												Ext.getCmp("tablePanel").setSize(width, height);

												Ext.EventManager.onWindowResize(function(w, h){
												Ext.getCmp("tablePanel").setSize(width, height);
												});
												}
											}
													
											}	
									}; 		 */	
									
									me.getMain().add(table);
									//me.getMain().add(foot);
								//	Ext.getCmp('tablePanel').addTool(foot);
									
									Ext.getCmp('saveTool').setDisabled(false);
									Ext.getCmp('printTool').setDisabled(false);
									Ext.getCmp('csvTool').setDisabled(false);
									me.getMain().doLayout();
									var sbPagination=jsonData.sbPagination;
											if(Ext.isEmpty(sbPagination))
											{
												Ext.ComponentQuery.query('#tableViewFt')[0].hide();
											// Ext.getCmp('tableViewFoot').hide();
											}
								}  
								//me.getMain().add(foot);
								mask.hide();


								if(msg!="fromPagination")
								{
									msg="newReq";
								var countURL = '../monitor/EgDispDD.jsp?'+queryString+"&isCountRecords=Yes&reqType="+msg;

									Ext.Ajax.request({
										url : countURL,
										method : 'POST',
										scope : this,
										success : function(response, opts) {
											var jsonText = response.responseText;
											var pageNumber='';
											var totRec='';
											if(jsonText != null && jsonText.indexOf('@') != -1){
												pageNumber = jsonText.substring(0,jsonText.indexOf('@'));
												totRec = jsonText.substring(0,jsonText.indexOf('@'));

												totalRecords = parseInt(pageNumber.trim());	
											}
																				
											 var c=document.getElementById("totalPages");
											 if(c!=null && c!="" && c!="undefined")
											 {
												
												 var totRec = parseInt(pageNumber.trim());												
												 if(totRec < 2 || totRec == pageNo )
												 {
													var nxt = document.getElementById("next");
													if(nxt!=null && nxt!="undefined")
														nxt.style.visibility="hidden";
													var lst = document.getElementById("last");
													if(lst!=null && lst!="undefined")	
														lst.style.visibility="hidden";
												 }
												else
												{
												var nxt = document.getElementById("next");
												if(nxt!=null && nxt!="undefined")
													nxt.style.visibility="visible";
												var lst = document.getElementById("last");
												if(lst!=null && lst!="undefined")	
													lst.style.visibility="visible";
												}
												c.innerHTML=" of "+pageNumber;
											 }
											 
										},
										failure : function() {
											alert("failure in component dashboard render");
										}
									});
								}

								//

							}
							else
							{
								alert("no data found");
							}
						}
					});
					//me.getMain().add(foot);
				}
			}
		});
		
	},
	renderResult : function(queryString){
		var wholeViewport = document.getElementsByTagName("body")[0];
		var mask = new Ext.LoadMask(wholeViewport, {msg:"Loading...",cls:'maskLoad'});
		mask.show();
		//Ext.getCmp('upbutton').setDisabled(false);
		var me = this;
		queryString+="&startmin="+stmin+"&endmin="+enmin;
		queryString = queryString +'&isVM=false&flag=1&firsttime=true&from=0&fromPage=layMod&newWindow=true&comeFrom=true&comesForDD=comesForDD';
		Ext.Ajax.request({	
				url : '../monitor/EgDispDD.jsp?'+queryString,
			scope:this,
			success : function(response) {
			var jsontext = response.responseText;
			var jsonData = Ext.decode(jsontext);   
				if (!Ext.isEmpty(jsonData)) 
					{
					var itemsArray=[];
					/* var results = {
								xtype : 'detaileddiagnosisgrid',
								layout:'auto',
								jsonData : jsonData,
								flex:1,
								bodyCls:'bottom-left-radius bottom-right-radius',
								cls : 'diagnosis-grid-grouping-row'
								};
							itemsArray.push(results);*/
							var table = {xtype:'panel',html:jsonData.tableData};
							itemsArray.push(table);

                   var resultObj = Ext.getCmp('resultpanel');
                    if(!Ext.isEmpty(resultObj))
                    {
                        resultObj.removeAll();
                        resultObj.add(itemsArray);
                        me.getMain().doLayout();
                        me.getMain().add(resultObj);
                        me.getMain().doLayout();
                    }
                    else
                    {
                       /* var result_Panel = Ext.create(
                            'DD.view.DetailedDiagnosisGrid', {
                                id:'gridpanel',
                                layout:'auto',
								jsonData : jsonData,
								flex:1,
								bodyCls:'bottom-left-radius bottom-right-radius',
								cls : 'diagnosis-grid-grouping-row'
                            });
                            me.getMain().add(result_Panel);
							*/
							var table = {xtype:'panel',
									//style:{'border':'1px solid red'},
									html:jsonData.tableData};
							me.getMain().add(table);
                    }
                    
                    Ext.getCmp('saveTool').setDisabled(false);
                    Ext.getCmp('printTool').setDisabled(false);
                    Ext.getCmp('csvTool').setDisabled(false);
                    
                    me.getMain().doLayout();
                       
                }
				//mask.hide();
				Ext.destroy(mask);
            }
        });
	},
	genQueryString : function(Arr) {
		var qStr = '';
		for (var key in Arr) 
		{
			if(key=='stest' || key=='encodetest')
			{
				var en_Test= parent.filterEncode(Arr[key]);
				qStr += '&' + key + '=' + encodeURIComponent(en_Test);
			}
			else if(key != 'pageNo' && key != 'time' && key != 'stest' && key != 'encodetest')
				qStr += '&' + key + '=' + encodeURIComponent(Arr[key]);
			else
				qStr += '&' + key + '=' + Arr[key];
		}
		Ext.getCmp('settings').queryString = qStr;
		return qStr;
	},
	saveFileTool : function(){
		var mainForm = this.getDdOptionsForm().getForm();
		var testName = mainForm.findField('testlist').getValue();

		if(testName != null && testName != 'undefined' && testName != undefined && testName.indexOf('-') != -1)
			testName = testName.substring(0,testName.indexOf('-'));

		var seqHideFlagCheck = false;
		if(seqHideTests != null && seqHideTests.indexOf(testName+"_DDD") > -1 )
			seqHideFlagCheck = true;
		
		var jsonData =this.jsonData;
		if(!Ext.isEmpty(jsonData.errorMsg) && Ext.isEmpty(jsonData.gridInfo)){
			Ext.Msg.alert('Error',jsonData.errorMsg);
			return;
		}

		var url='../monitor/EgDiagnosis.jsp?';
		var queryStr = Ext.getCmp('settings').queryString;	
		var searchLink='';
		var searchCombo= Ext.getCmp('searchComboId');		
		if(searchCombo != undefined && searchCombo != null){
			var	searchText = Ext.getCmp('searchTextId');
			var seatrchComboval = searchCombo.getValue();
			var searchTextVal = searchText.getValue();
			if(searchTextVal != undefined && searchTextVal != null && searchTextVal.trim() != "" ){
				searchLink+='&searchfield='+encodeURIComponent(seatrchComboval)+'&searchText='+encodeURIComponent(searchTextVal);
			}			
		}
		queryStr = queryStr+searchLink;
		url=url+queryStr+'&tlineJsonOnly=No&reqType=newReq&from=0&maxNo=undefined&isCountRecords=no&reqType=newReq&comesFrom=tabsetDD&pdf=pdf&comesForDD=comesForDD';
		url = url+"&startmin="+stmin+"&endmin="+enmin;
		if(!Ext.isEmpty(csrfToken) && csrfToken!=undefined && csrfToken!=null)
			url = url + "&com.eg.CSRF_NONCE="+csrfToken;
		Ext.Ajax.request({
			url : url,
			scope : this,
			timeout: 60000,
			success : function(response){
				var a = "/final/servlet/com.eg.EgPdfDownloadC?from=egDiagnosis";
				var c = Ext.widget("erutils");
				c.savePDF(a);
			}
					
		});

		//var erUtilsObj = Ext.widget('erutils');
				//erUtilsObj.savePDF('/final/servlet/com.eg.EgPdfDownloadC?');
		

	/*	var win=Ext.MessageBox.progress({
			title: 'Download PDF',
			value: 5,
			width: 350,
			increment: 15,
			closable: false,
			
			progressText: 'Connecting..',
		   
			wait: true,
			waitConfig: {
				interval: 200
			},
			msg: 'We are connecting to our agent. Please wait...',
			text: 'Updating...',
			scope: this,
			fn: function () {
				this.updateText('Done!');
			},
			buttons: Ext.MessageBox.CANCEL,
		});*/
		//win.show();

        /*var a = "";
        if (location.protocol == "https:") {
            a = "/final/blank.html";
        }
        var c = parent.openWindow(a, "SaveWindow", "width=400,height=150,left=300,top=200,scrollbars=no,resizable=no");
        c.document.write("<html>");
        c.document.write("<title>Downloading</title>");
        c.document.write("<frameset rows= '0%,0%,*' frameborter='NO' border='0' framespacing='0'>");
        c.document.write("<frame src='/final/servlet/com.eg.EgPdfDownloadC' frameborder=0 noresize scrolling=no name='Data'>");
        c.document.write("<frame src='/final/reporter/ErSaveStatus.jsp?from=egDiagnosis' frameborder=0 noresize scrolling=auto>");
        c.document.write("<frame src='" + a + "' frameborder=0 noresize scrolling=auto name='statusPanel'>");
        c.document.write("</frameset>");
        c.document.write("</html>");
        c.frames[2].document.open("text/html", "replace");
        c.frames[2].document.write("<html><head>");
        c.frames[2].document.write('<link rel="stylesheet" href="/final/monitor/eg_styles/monstyle_<%=monitor_Skin%>.css" />');
        c.frames[2].document.write('</head><body id="eg_morelight"><br><br><h4 align="center" style="font-family: Verdana,Arial; font-size: 15px; color: #000000;"><img src="/final/reporter/images/load_round.gif"><br><br>Downloading! Please wait...</h4></body></html>');
        c.frames[2].document.close();*/
		if(seqHideFlagCheck)
		{
			DD.app.getController("Main").showResult();
		}
	},
	printFile : function(){
		var mainForm = this.getDdOptionsForm().getForm();
		var testName = mainForm.findField('testlist').getValue();

		if(testName != null && testName != 'undefined' && testName != undefined && testName.indexOf('-') != -1)
			testName = testName.substring(0,testName.indexOf('-'));

		var seqHideFlagCheck = false;
		if(seqHideTests != null && seqHideTests.indexOf(testName+"_DDD") > -1 )
			seqHideFlagCheck = true;

		var jsonData =this.jsonData;
		if(!Ext.isEmpty(jsonData.errorMsg) && Ext.isEmpty(jsonData.gridInfo)){
			Ext.Msg.alert('Error',jsonData.errorMsg);
			return;
		}

		var url='../monitor/EgDiagnosis.jsp?';
		var queryStr = Ext.getCmp('settings').queryString;	
		var searchLink='';
		var searchCombo= Ext.getCmp('searchComboId');		
		if(searchCombo != undefined && searchCombo != null){
			var	searchText = Ext.getCmp('searchTextId');
			var seatrchComboval = searchCombo.getValue();
			var searchTextVal = searchText.getValue();
			if(searchTextVal != undefined && searchTextVal != null && searchTextVal.trim() != "" ){
				searchLink+='&searchfield='+encodeURIComponent(seatrchComboval)+'&searchText='+encodeURIComponent(searchTextVal);
			}			
		}
		queryStr = queryStr+searchLink;
		url=url+queryStr+'&tlineJsonOnly=No&reqType=newReq&from=0&maxNo=undefined&isCountRecords=no&reqType=newReq&comesFrom=tabsetDD&pdf=pdf';
		url =url+"&startmin="+stmin+"&endmin="+enmin;
		if(!Ext.isEmpty(csrfToken) && csrfToken!=undefined && csrfToken!=null)
			url = url + "&com.eg.CSRF_NONCE="+csrfToken;
		Ext.Ajax.request({
			url : url,
			scope : this,
			timeout: 60000,
			success : function(response)
			{
				var url = Ext.getCmp('settings').queryString;
				url = url.replace("measure", "s_mes");
				url = url.replace("info", "s_info");
				url = url.replace("test", "s_test");
				url = url.replace("port", "s_port");
				url = url.replace("host", "s_host");
				url = url.replace("site", "s_site");
				url = url.replace("starthr", "s_st_hr");
				url = url.replace("endhr", "s_en_hr");
		
		
				url +=url+"&s_st_min="+stmin+"&s_end_min="+enmin;
				/*window.openWindow("/final/monitor/Egprintdata.jsp?isDDdata=yes&"+url+"&messwills_val="+jsonData.hiddenFields.messwills_val+"&messwills=1&"+"strValue=Process_ID%252CUtil%252CProcess_details&proceed="+jsonData.hiddenFields.proceed+"&layer=null&isVM="+jsonData.hiddenFields.isVM ,jsonData.hiddenFields.detailedDiagnosis,
						"width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes,location=no");*/
				
				var url="/final/monitor/Egprintdata.jsp?isDDdata=yes&"+url+"&messwills_val="+jsonData.hiddenFields.messwills_val+"&messwills=1&"+"strValue=Process_ID%252CUtil%252CProcess_details&proceed="+jsonData.hiddenFields.proceed+"&layer=null&isVM="+jsonData.hiddenFields.isVM+"&comesForDD=comesForDD";
				
				var a = new Ext.Window({
					modal: true,  
					cls:'btmWindow',
					ghost: false,
					closeAction: "destroy",
					constrain: true,
					title: 'Print',
					height: 500,
					width: 1010,             
					padding: "5 10 10 10",              
					layout: 'fit',
					listeners: {
						show: function (h) {
							if (this.modal) {                       
								var i = Ext.dom.Query.select(".x-mask");
								for (var j = 0; j < i.length; j++) {
									var g = Ext.fly(i[j]);
								}
								g.addCls("windowModal");
							}
						},
						hide: function (h) {
							var i = Ext.dom.Query.select(".x-mask");
							if (this.modal) {
								var g = Ext.fly(i[0]);
								g.removeCls("windowModal");
							}
						},
						afterrender: function () {
							Ext.EventManager.onWindowResize(function () {
								var g = this;
								g.center();
							}, this);
						}
					},
					layout: "fit",
					margin: "0 0 0 0",
					items: [{
					   xtype: 'panel',
						scroll:true,
						autoScroll:true,
						html:'<iframe src=\"'+url+'\" width="100%" height="100%" frameborder="0"></iframe>'                   
					}]
				}).show();
			}
		});
	/*	Ext.create('Ext.window.Window', {
				title: 'Print',
				height: 500,
				width: 900,
				padding:'5 10 10 10',
				layout: 'fit',
				items: [{ 
					xtype: 'panel',
					scroll:true,
					autoScroll:true,
					html:'<iframe src=\"'+url+'\" width="100%" height="100%" frameborder="0"></iframe>'
					
				}]
			}).show();*/
		
		if(seqHideFlagCheck)
		{
			DD.app.getController("Main").showResult();
		}
	},
	
	dataFile : function(){
			var mainForm = this.getDdOptionsForm().getForm();
			var testName = mainForm.findField('testlist').getValue();

		if(testName != null && testName != 'undefined' && testName != undefined && testName.indexOf('-') != -1)
			testName = testName.substring(0,testName.indexOf('-'));

		var seqHideFlagCheck = false;
		if(seqHideTests != null && seqHideTests.indexOf(testName+"_DDD") > -1 )
			seqHideFlagCheck = true;

			var jsonData =this.jsonData;
			if(!Ext.isEmpty(jsonData.errorMsg) && Ext.isEmpty(jsonData.gridInfo)){
				Ext.Msg.alert('Error',jsonData.errorMsg);
				return;
			}			
			var url='../monitor/EgDispDD.jsp?';
			var queryStr = Ext.getCmp('settings').queryString;	
			var searchLink='';
			var searchCombo= Ext.getCmp('searchComboId');		
			if(searchCombo != undefined && searchCombo != null){
				var	searchText = Ext.getCmp('searchTextId');
				var seatrchComboval = searchCombo.getValue();
				var searchTextVal = searchText.getValue();
				if(searchTextVal != undefined && searchTextVal != null && searchTextVal.trim() != "" ){
					searchLink+='&searchfield='+encodeURIComponent(seatrchComboval)+'&searchText='+encodeURIComponent(searchTextVal);
				}			
			}
			queryStr = queryStr+searchLink;
			url=url+queryStr+'&isVM=false&flag=1&firsttime=true&from=0&fromPage=layMod&newWindow=true&comeFrom=true&comesForDD=comesForDD'+'&csv='+jsonData.hiddenFields.csv;
			url = url+"&startmin="+stmin+"&endmin="+enmin;
			Ext.Ajax.request({
				url : url,
				scope : this,
				timeout: 60000,
				success : function(response){
				var jsonText = response.responseText;
				jsonData = Ext.decode(jsonText);
				 // if(!Ext.isEmpty(jsonData.CSV) && jsonData.CSV=='CSV_FINISHED')
					//{
					window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?fromDD=true","CSVFormat","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes";
					//}
				}
						
			});
			//Existing Code
			/*window.location.href="../servlet/egurkha.reporter.SaveInCSVFormat?fromDD=true","CSVFormat","w	idth=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes"; */
			if(seqHideFlagCheck)
			{
				DD.app.getController("Main").showResult();
			}
		
	},
	filterMultiselect:function(obj, event)
    {
        var findVal = obj.getValue();
        var compStore = componentsRawData;
        var compObj = Ext.getCmp('hostlist');
        if ( Ext.isEmpty( obj.getValue() ) )
        {
            compObj.getStore().loadRawData(compStore);
            if ( compObj.getStore().findExact('valueField', '-1', 0) == -1 )
            {
                compObj.getStore().insert(0, {'valueField': '-1', 'displayField': chooseComp});
            }
            if ( !Ext.isEmpty( comp ) && comp!="null")
            {
                compObj.setValue(comp);    
            }
            else
            {
                compObj.setValue('-1');
            }
        }
        else
        {
            var isRecordFound = false;
            var genStore = new Ext.data.Store({
                                    fields : ['displayField', 'valueField'],
                                    data : []                               
                                });
            for ( var i = 1; i < compStore.length ; i++ )
            {
                var getRecord = compStore[i]['displayField'];
                if ( getRecord.indexOf(findVal) > -1 )
                {
                    isRecordFound = true;
                    genStore.add({
                        'displayField': compStore[i]['displayField'],
                        'valueField': compStore[i]['valueField']
                    });
                }
            }
           
            if ( isRecordFound )
            {
                compObj.getStore().removeAll(); 
                for ( var i = 0; i < genStore.getCount() ; i++ )
                {
                    var getRecord = genStore.getAt(i);
                    compObj.getStore().add(getRecord);
                }
                compObj.setValue(genStore.getAt(0).get('valueField'));
            }
            else
            {
                compObj.getStore().removeAll();
                compObj.getStore().add({
                    'displayField': 'Not Applicable!',
                    'valueField': '-1'
                });
                compObj.setValue('-1');
            }
            obj.focus();
        }
        if ( parseInt( event.getCharCode() ) == 13 )
        {
            this.component_onchange(Ext.getCmp('hostlist'));
            this.hideResult();
        }
    },
	loadLocFieldValues : function(latlang,loc_details){

		var titleforLogon='Modify Location';
		if(latlang!=null && latlang!=undefined && latlang!="" && loc_details!=null && loc_details!=undefined && loc_details!="")
		{
			var tmp_details_arr=loc_details.split("~#~");

			var disableCountry=true;
			var heightWin=200;
			if(tmp_details_arr[0]!=null && tmp_details_arr[0]!=undefined && (tmp_details_arr[0].toUpperCase()=="UNKNOWN" || tmp_details_arr[0]=="-" || tmp_details_arr[0]==""))
			{
				disableCountry=false;
				heightWin=300;
			}

			Ext.widget('window', {
				id:'locwindow',
				height:heightWin,
				width:250,
				bodyBorder:true,
				bodyPadding:'9 10 10 10',
				cls:'UxLogonInnerWindow',
				//padding:'4 10 10 10',
				//padding:'0 0 0 0',
				frame:false,
				title:titleforLogon,
				//autoScroll:true,
				modal: true,
				ghost:false,
				frame:true,
				resizable:false,
				closable:true,
				draggable:true,
				closeAction:'destroy',
				layout:'anchor',
				shadow:'sides',
				shadowOffset:60,
				items: [
					{
						xtype     : 'textfield',
						maxLength: 35,
						labelSeparator:'',
						enforceMaxLength: true,
						name      : "CountryId",
						id        : "CountryId",
						fieldLabel: "Country",
						value:"",
						hidden:disableCountry,
						cls:'textbox',
						padding:'5 10 5 5',
						labelAlign:'top',
						width:215
					},
					{
						xtype     : 'textfield',
						maxLength: 35,
						labelSeparator:'',
						enforceMaxLength: true,
						name      : "CountryCodeId",
						id        : "CountryCodeId",
						fieldLabel: "Country Code",
						value:"",
						hidden:disableCountry,
						cls:'textbox',
						padding:'5 10 5 5',
						labelAlign:'top',
						width:215
					},
					{
						xtype     : 'textfield',
						maxLength: 35,
						labelSeparator:'',
						enforceMaxLength: true,
						name      : "RegionId",
						id        : "RegionId",
						fieldLabel: "Region",
						value:"",
						cls:'textbox',
						padding:'5 10 5 5',
						labelAlign:'top',
						width:215
					},
					{
						xtype     : 'textfield',
						maxLength: 35,
						labelSeparator:'',
						enforceMaxLength: true,
						name      : "CityId",
						id        : "CityId",
						fieldLabel: "City",
						value:"",
						cls:'textbox',
						padding:'5 10 5 5',
						labelAlign:'top',
						width:215
					},
					{
						xtype : 'button',
						cls : 'button20',
						margin: '5 0 0 82',
						text: "Update",
						name: "Submit",
						handler : function()
						{
							if(Ext.getCmp("RegionId")!=undefined && (Ext.getCmp("RegionId").value=="" || Ext.getCmp("RegionId").value=='-1' || Ext.getCmp("RegionId").value=='Unknown'))
							{
								Ext.Msg.alert('Save Location', 'Invalid Locations');
								return;
							}

							if(Ext.getCmp("RegionId")!=undefined && (Ext.getCmp("RegionId").value=="" || Ext.getCmp("RegionId").value=='-1' || Ext.getCmp("RegionId").value=='Unknown'))
							{
								Ext.Msg.alert('Save Location', 'Please type valid Region');
								return;
							}

							if(Ext.getCmp("CityId")!=undefined && (Ext.getCmp("CityId").value=='' || Ext.getCmp("CityId").value=='-1' || Ext.getCmp("CityId").value=='Unknown'))
							{
								Ext.Msg.alert('Save Location', 'Please type valid City');
								return;
							}

							var paramVal="latlang="+latlang+"&countryName="+Ext.getCmp("CountryId").value+"&regionName="+Ext.getCmp("RegionId").value+"&cityName="+Ext.getCmp("CityId").value+"&countryCode="+Ext.getCmp("CountryCodeId").value;
							var param1 = 'beanName=setLoctionDetails&'+paramVal;
							Ext.Ajax.request({
								url : '/final/servlet/com.eg.RemoteScriptingServlet',
								params : param1,
								success : function(response) {
									var formdata = Ext.decode(response.responseText);
									try
									{
										if(formdata != undefined && formdata['Res'] != undefined && formdata['Res']=='Saved')
										{
											Ext.Msg.alert('Location Details', 'Saved successfully');
										}
										else
										{
											Ext.Msg.alert('Location Details', 'Failure to save the values');
										}
									}
									catch (e)
									{
										Ext.Msg.alert('Location Details', 'Failure to save the values');
									}
								},
								failure : function(ee){
									Ext.Msg.alert('Location Details', 'Failure to save the values');
									console.log("Failure->",ee);
								}
							});
						}
					}
				]
			}).show()
		}
	}
});

var y =21,x= 10;
function baseStackTrace(url , windowId, child)
{
	y = ++y + 30;
	x = ++x + 12;
	/*if(Ext.getCmp(windowId) != null)
	{
		Ext.getCmp(windowId).toFront();
		return;
	}*/
	url = url+'&prevWindowId='+encodeURIComponent(windowId);
	var win = Ext.create('Ext.window.Window', {
		title: '',
		cls:'btmWindow',
		height: Ext.getBody().getViewSize().height -50,
		width: Ext.getBody().getViewSize().width-50,
		//width:900,
		//height:0,
		minimizable : false,
		layout: 'fit',
		//header:false,
		modal:true,
		closeAction:'destroy',
		ghost:false,
		id: windowId,
		resizable:true,
		parentNodeName: child,
		isBaseStackTrace : true,
		html: '<iframe src="' + url+ '" scrolling="no" frameborder="0"style="width:100%;height:100%" ></iframe>',
		listeners: {
			"minimize": function (window, opts) {
				window.collapse();
			},
			"close": function (win, eOpts ) {
				destroyInnerChilds(win);
				y = --y - 30;
				x = --x - 12;
				if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						if(el){
							el.removeCls('windowModal');
							el.hide();
						}
					}
			},
			show: function(win)
				{
					if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[0]);
						if(el){
							el.show();
							el.addCls('windowModal');
						}
					}
				}
		}

		/*tools: [{
			type: 'restore',
			handler: function (evt, toolEl, owner, tool) {
				var window = owner.up('window');
				window.setWidth(980);
				window.expand('', false);
				window.center();
			}
		}]*/
	//}).showAt(x,y);
	}).show();


	//win.setPosition(i,i);
	Ext.EventManager.onWindowResize(function()
				{
					//var me = this;
					//Ext.suspendLayouts();
					//win.setSize(Ext.getBody().getViewSize().width-10,Ext.getBody().getViewSize().height-10);
					win.setSize(900,Ext.getBody().getViewSize().height-50);
                    win.center();
					win.doComponentLayout();
					//Ext.resumeLayouts();
					//win.setPosition(0, 0);
					//location.reload();
				}, win);
}

function topologyBuild(guidString, test, nodeOrder, overallExperience)
{
	if(Ext.getCmp('topologyBuildWindow') != null)
	{
		Ext.getCmp('topologyBuildWindow').close();
	}
	var urlToGo = 'eGBTMd3Topology.jsp?EG_GUID='+guidString+"&testName="+test+"&fromNodeOrder="+nodeOrder+"&overallExperience="+overallExperience;
	var win = Ext.create('Ext.window.Window', {
		//title: 'Business Transaction Topology',
		height: Ext.getBody().getViewSize().height -10,
		width: Ext.getBody().getViewSize().width-10,
		//modal:true,
		//cls:'btmnewWindow',
		header:false,
		padding:0,
		resizable:false,
		style:{'text-transform':'none !important'},
		ghost:false,
		constrain:true,
		minimizable : false,
		maximizable:false,
		flex:1,
		layout:{
			type:'fit',
			align:'stretch'
		},
		id: 'topologyBuildWindow',

		//layout: 'fit',
		onEsc: function()
		{


			/** -----------------
				Checking where tooltip is in topology is visibile or not
				tooltip is in iframe so getting iframe instance, body and the selector
			-----------------**/

			var frm = $("iframe").get(0),
			doc = (frm.contentDocument ? frm.contentDocument : frm.contentWindow.document),
			bdy = doc.body,
			dv = $('.tooltipx', bdy).get(0);
			if (!$(dv).is(':visible')) {
				closeChildWindow();
			}else{
				$(dv).hide();

			}
		},
		items: {
            xtype: 'component',
			flex:1,
            autoEl: {
                tag: 'iframe',
				scrolling:"no",
				height:'100%',
				width:'100%',
				frameBorder:0,
                style: 'height: 100%; width: 100%; border: none;',
                src: urlToGo
            },
            listeners: {
                load: {
                    element: 'el',
                    fn: function () {
						this.parent().unmask();
						/*if($(".x-mask")){
							$(".x-mask").remove();
							$(".x-mask-msg").remove();
							$(".x-css-shadow").remove();

						}*/

                    }
                },

                render: function (c) {
					this.up("window").body.mask("Loading...","egMask");
					//c.setLoading(true);

                }

            }
        },

		//html: '<iframe src="' + urlToGo+ '" scrolling="no" frameborder="0" style="width:100%;height:100%;margin:0" ></iframe>',

		/*tools: [{
			type: 'restore',
			handler: function (evt, toolEl, owner, tool) {
				var window = owner.up('window');
				window.setWidth(980);
				window.expand('', false);
				window.center();
			}
		}]*/
	}).show();
	Ext.EventManager.onWindowResize(function()
				{
					//var me = this;
					//Ext.suspendLayouts();
					win.setSize(Ext.getBody().getViewSize().width-10,Ext.getBody().getViewSize().height-10);
                    win.center();
					win.doComponentLayout();
					//Ext.resumeLayouts();
					//win.setPosition(0, 0);
					//location.reload();
				}, win);
}

function setTitle(title , id)
{
	var tracewindowTitle = title;
	if(title.indexOf('^%^')>0)
	{
		tracewindowTitle = title.substring(0,title.indexOf('^%^'));
		//Ext.getCmp('topologyBuildWindow').setTitle(title.substring(title.indexOf('^%^')+3));
	}
	if(Ext.getCmp(id) != null && Ext.getCmp(id) != undefined)
	{
		Ext.getCmp(id).setTitle(tracewindowTitle);
	}
}

function closeChildWindow()
{
	var panelsArray = Ext.ComponentQuery.query('window');
	if (panelsArray != null && panelsArray.length>0)
	{
		for(var i=0;i<panelsArray.length;i++)
		{
			if(panelsArray[i].isBaseStackTrace)
			{
				var windowId = panelsArray[i].id;
				if(Ext.getCmp(windowId) != null && Ext.getCmp(windowId) != undefined)
				{
					Ext.getCmp(windowId).destroy();
				}
			}
		}
	}
	Ext.getCmp('topologyBuildWindow').destroy();
}

function destroyInnerChilds(win)
{
	var panelsArray = Ext.ComponentQuery.query('window');
	if (panelsArray != null && panelsArray.length>0)
	{
		for(var i=0;i<panelsArray.length;i++)
		{
			if(panelsArray[i].isBaseStackTrace && panelsArray[i].parentNodeName == win.id)
			{
				var windowId = panelsArray[i].id;
				if(Ext.getCmp(windowId) != null && Ext.getCmp(windowId) != undefined)
				{
					traverseInnerChilds(panelsArray, win, panelsArray[i].parentNodeName, panelsArray[i].id);
					Ext.getCmp(windowId).destroy();
				}
			}
		}
	}

	if(win.parentNodeName != null && win.parentNodeName != undefined)
	{
		Ext.getCmp(win.parentNodeName).focus();
	}
	else
	{
		Ext.getCmp('topologyBuildWindow').focus();
	}

}
var arrayWinObjStore = new Array();
function traverseInnerChilds(panelsArray, win , parentName, currentWindowId)
{
	for(var i=0;i<panelsArray.length;i++)
	{
		if(panelsArray[i].isBaseStackTrace && panelsArray[i].parentNodeName == currentWindowId)
		{
			var windowId = panelsArray[i].id;
			if(Ext.getCmp(windowId) != null && Ext.getCmp(windowId) != undefined)
			{
				arrayWinObjStore.push(Ext.getCmp(windowId));
				Ext.getCmp(windowId).destroy();
			}
		}
	}
	if(arrayWinObjStore.length>0)
	{
		for(var j=0;j<arrayWinObjStore.length;j++)
		{
			var tempId = arrayWinObjStore[j].id;
			arrayWinObjStore.pop(arrayWinObjStore[j]);
			destroyInnerChilds(panelsArray, win , parentName, tempId);
		}
	}
	else
		return;
}

function setFocusToWindow(currentWindowId)
{
	var panelsArray = Ext.ComponentQuery.query('window');
	var temp = Ext.getCmp(currentWindowId).getEl();
	if(Ext.getCmp(currentWindowId) != null)
	{
		Ext.getCmp(currentWindowId).focus();
	}

}
function setTitleTopologyPage(title)
{
	if(Ext.getCmp('topologyBuildWindow') != null)
	{
		Ext.getCmp('topologyBuildWindow').setTitle(title);
	}
}

function rumTopologyBuild(guidString,test)
{
	if(Ext.getCmp('rumTopologyBuildWindow') != null)
	{
		Ext.getCmp('rumTopologyBuildWindow').close();
	}
	var urlToGo = 'EgRUMTopology.jsp?rumGuid='+guidString+"&testName="+test;
	var win = Ext.create('Ext.window.Window', {
		//title: 'Business Transaction Topology',
		height: Ext.getBody().getViewSize().height -10,
		width: Ext.getBody().getViewSize().width-10,
		//modal:true,
		//cls:'btmnewWindow',
		header:false,
		bodyPadding:'8 10 8 8',
		title:"&nbsp;",
		padding:0,
		resizable:false,
		style:{'text-transform':'none !important'},
		ghost:false,
		constrain:true,
		minimizable : false,
		maximizable:false,
		constrain:true,
		flex:1,
		layout:{
			type:'fit',
			align:'stretch'
		},
		id: 'rumTopologyBuildWindow',
		//layout: 'fit',
		onEsc: function()
		{


			/** -----------------
				Checking where tooltip is in topology is visibile or not
				tooltip is in iframe so getting iframe instance, body and the selector
			-----------------**/

			var frm = $("iframe").get(0),
			doc = (frm.contentDocument ? frm.contentDocument : frm.contentWindow.document),
			bdy = doc.body,
			dv = $('.tooltipx', bdy).get(0);
			if (!$(dv).is(':visible')) {
				closeChildWindow();
			}else{
				$(dv).hide();

			}
		},
		items: {
            xtype: 'component',
			//minWidth : 1024,
			
			flex:1,
            autoEl: {
                tag: 'iframe',
				scrolling:"no",
				height:'100%',
				width:'100%',
				frameBorder:0,
                style: 'height: 100%; width: 100%; border: none;',
                src: urlToGo
            },
            listeners: {
                load: {
                    element: 'el',
                    fn: function () {
						this.parent().unmask();
						/*if($(".x-mask")){
							$(".x-mask").remove();
							$(".x-mask-msg").remove();
							$(".x-css-shadow").remove();

						}*/

                    }
                },

                render: function (c) {
					this.up("window").body.mask("Loading...","egMask");
					//c.setLoading(true);
				
                }

            }
        },

		//html: '<iframe src="' + urlToGo+ '" scrolling="no" frameborder="0" style="width:100%;height:100%;margin:0" ></iframe>',

		/*tools: [{
			type: 'restore',
			handler: function (evt, toolEl, owner, tool) {
				var window = owner.up('window');
				window.setWidth(980);
				window.expand('', false);
				window.center();
			}
		}]*/
	}).show();
	Ext.EventManager.onWindowResize(function()
				{
					//var me = this;
					//Ext.suspendLayouts();
					win.setSize(Ext.getBody().getViewSize().width-10,Ext.getBody().getViewSize().height-10);
                    win.center();
					win.doComponentLayout();
					//Ext.resumeLayouts();
					//win.setPosition(0, 0);
					//location.reload();
				}, win);
}

function dateValidation(starttime,endtime,starthr,endhr,startmin,tomin)
{	
	var styear = parseInt(starttime.substring((starttime.lastIndexOf("/")+1)));		
	var stday = parseInt(starttime.substring((starttime.indexOf("/")+1),starttime.lastIndexOf("/")));
	var stmon = parseInt(starttime.substring(0,starttime.indexOf("/")));
	var endyear = parseInt(endtime.substring((endtime.lastIndexOf("/")+1)));
	var endday = parseInt(endtime.substring((endtime.indexOf("/")+1),endtime.lastIndexOf("/")));
	var endmon = parseInt(endtime.substring(0,endtime.indexOf("/")));
	var state=0;	
	if(styear > endyear)			
		state=-1;		
	else if(styear == endyear)			
		if(stmon > endmon)				
			state=-1;				
		else if(stmon == endmon)
			if(stday > endday)						
				state=-1;
			else if(stday == endday)
				if(starthr > endhr)
					state = -1;
				else if(starthr == endhr)
					if(startmin >= tomin)
						state = -1;
	
	return state;
}
