Ext.define('DD.controller.ThreadDetails', {
    extend: 'Ext.app.Controller',
    requires:['DD.view.ThreadDetails'],
    views:['ThreadDetails'],
    
	refs : [
			{
				ref:'threaddetails',
				selector:'threaddetails'
			},{
				ref : 'threadName',
				selector : 'threaddetails multiselect'
			}
	],

    init: function() {
    	this.control({
					'threaddetails':{
						'boxready':this.loadform
					},
					'threaddetails combo[id="time"]':{
							'select':this.timeOnChange
					},
					'threaddetails combo[id="measure"]':{
							'select':this.measureOnChange
					},
					'threaddetails combo[id="sortByOrder"]':{
						'select':this.sortOnChange
					},
					'threaddetails #threadname':{
						'change':this.sortOnThread
					},

		});
	},
	timeOnChange:function(obj)
	{
		this.loadform(obj);
	},
	measureOnChange:function(obj)
	{
		this.loadform(obj);
	},
	sortOnChange:function(obj)
	{
		this.loadform(obj);
	},
	sortOnThread:function(obj)
	{
		this.loadFormForThreadName(obj);
	},
	loadFormForThreadName:function(obj)
	{
		var resultPanel = Ext.getCmp("threadResulPanel");
		var measureTime = Ext.getCmp('time').value;
		var selectedvalue = Ext.getCmp('threadname').value;
		params="time="+measureTime+"&details="+encodeURIComponent(selectedvalue);
		Ext.Ajax.request({
			async:false,
			url : '/final/monitor/jvmThreads.jsp',
			params:params,
			method:'POST',
			success : function(response) {
				var resultData = Ext.decode(response.responseText);
				//resultPanel.update(resultData);
				resultPanel.update(resultData.tableData);
			}
		});
	},
	loadform:function(obj)
	{
		var url = "";
		var selectedhref = Ext.getCmp('windowValue').selectedHref;
		if(!Ext.isEmpty(selectedhref) && selectedhref != null && selectedhref != undefined)

		{
			if(selectedhref.indexOf("?") >-1)



			{
				url = selectedhref.substring(selectedhref.indexOf("?")+1);
			}
			var selectedDate = Ext.getCmp('windowValue').selectedValue;
			if(!Ext.isEmpty(selectedDate))
			{
				url = url+"&sdate="+selectedDate;
			}
			if(!Ext.isEmpty(obj))
			{
				var elementId = obj.id;
				var meas =null;
				var sortValue = null;
				if(!Ext.isEmpty(elementId))
				{
					if(elementId=="time")
					{
						if(!Ext.isEmpty(obj.value))
						{
							url = url+"&time="+obj.value;
						}
					}
					else if(elementId=="sortByOrder")
					{
						var sortValue = obj.value;
						url = url + "&sortby="+sortValue;
						var timeTemp = Ext.getCmp("time").value;
						url = url+"&time="+timeTemp;
					}
				}
			}
			Ext.getCmp('measure').hide();
			Ext.getCmp('threadname').hide();
			Ext.getCmp('west-region-container').hide();
			var me= this;
			var details = null;
			Ext.Ajax.request({
				url : '/final/monitor/ThreadDetails.jsp?'+url,
				success : function(response) {
					var formdata = Ext.decode(response.responseText);
					var subformdata =null;
					if(!Ext.isEmpty(formdata))
					{
						for(var i = 0;i<formdata.data.length;i++)
						{
							var name=formdata.data[i].name;
							if(!Ext.isEmpty(name))
							{
								if(name=="memtime")
								{	//var selectedvalue = Ext.getCmp("time").value;
									var selectedvalue = formdata.data[i].selectedValue;
									if(selectedvalue==null)
										selectedvalue ='';
									subformdata = formdata.data[i].time;
									me.setComboOptionsInList('time', subformdata,selectedvalue);
								}
								else if(name=="memsortname")
								{
									//var selectedvalue = Ext.getCmp("sortByOrder").value;
									var selectedvalue = formdata.data[i].selectedValue;
									if(selectedvalue==null)
										selectedvalue ='';
									subformdata = formdata.data[i].sortByOrder;
									me.setComboOptionsInList('sortByOrder', subformdata,selectedvalue);
								}
							}
						}
						var resultPanel = Ext.getCmp("threadResulPanel");
						resultPanel.update(formdata.tableData);
					}
				}
			});
		}
		else
		{
			var QueryString = Ext.getCmp('measure_graph').queryString;
			var url = this.genQuery(QueryString);
			
			if(!Ext.isEmpty(obj))
			{
				var elementId = obj.id;
				var meas =null;
				var sortValue = null;
				if(!Ext.isEmpty(elementId))
				{
					if(elementId=="time")
					{
						if(!Ext.isEmpty(obj.value))
						{
							url = url+"&time="+obj.value;
							meas = Ext.getCmp("measure").value;
							url = url.replace(/(s_measure=)[^\&]+/, '$1' + meas);
						}
					}
					else if(elementId=="measure")
					{
						if(!Ext.isEmpty(obj.value))
						{
							var timeTemp = Ext.getCmp("time").value;
							url = url+"&time="+timeTemp;
							meas = obj.value;
							url = url.replace(/(s_measure=)[^\&]+/, '$1' + meas);
						}
					}
					else if(elementId=="sortByOrder")
					{
						var sortValue = obj.value;
						url = url + "&sortby="+sortValue;
						var timeTemp = Ext.getCmp("time").value;
						url = url+"&time="+timeTemp;
						var meas = Ext.getCmp("measure").value;
						url = url.replace(/(s_measure=)[^\&]+/, '$1' + meas);
					}
					else if(elementId=="threadnameSelect")
					{
						var selectedThreadName = this.getThreadName().getValue();
						var timeTemp = Ext.getCmp("time").value;
						url = url+"&time="+timeTemp;
						var meas = Ext.getCmp("measure").value;
						url = url.replace(/(s_measure=)[^\&]+/, '$1' + meas);
						url = url+"&selectedThreadName="+encodeURIComponent(selectedThreadName);
					}
					if(!Ext.isEmpty(meas) && !Ext.isEmpty(elementId) && elementId!="sortByOrder")
					{
						if(meas == 'Total_current_threads')
							sortValue ="1";
						else if(meas == 'Blocked_threads')
							sortValue ="8";
						else if(meas == 'Deadlock_threads')
							sortValue ="8";
						else if(meas == 'Waiting_threads')
							sortValue ="11";
						else if(meas == 'Timed_waiting_threads')
							sortValue ="11";
						else
							sortValue ="5";
						url = url+"&sortby="+sortValue;
					}
				}
			}
			var selectedDate = Ext.getCmp('windowValue').selectedValue;
			if(!Ext.isEmpty(selectedDate))
			{
				url = url+"&time="+selectedDate;
			}

			var me= this;
			var details = null;
			Ext.Ajax.request({
				url : '/final/monitor/ThreadDetails.jsp?'+url,
				success : function(response) {
					var formdata = Ext.decode(response.responseText);
					var subformdata =null;
					if(!Ext.isEmpty(formdata))
					{
						for(var i = 0;i<formdata.data.length;i++)
						{
							var name=formdata.data[i].name;
							if(!Ext.isEmpty(name))
							{
								if(name=="memtime")
								{	//var selectedvalue = Ext.getCmp("time").value;
									var selectedvalue = formdata.data[i].selectedvalue;
									if(selectedvalue==null)
										selectedvalue ='';
									subformdata = formdata.data[i].time;
									me.setComboOptionsInList('time', subformdata,selectedvalue);
								}
								else if(name=="Measurement")
								{
									var selectedvalue = formdata.data[i].selectedvalue;
									if(selectedvalue==null)
										selectedvalue ='';
									subformdata = formdata.data[i].measure;
									me.setComboOptionsInList('measure', subformdata,selectedvalue);
								}
								else if(name=="memsortname")
								{
									//var selectedvalue = Ext.getCmp("sortByOrder").value;
									var selectedvalue = formdata.data[i].selectedValue;
									if(selectedvalue==null)
										selectedvalue ='';
									subformdata = formdata.data[i].sortByOrder;
									me.setComboOptionsInList('sortByOrder', subformdata,selectedvalue);
								}
								else
								{								
									var	selectedvalue = formdata.data[i].selectedValue;
									subformdata = formdata.data[i].threadname;
									me.setComboOptionsInList('threadname', subformdata,selectedvalue);
									var threadCombo = Ext.getCmp("threadname");
									var tempSelectedValue = [];
									tempSelectedValue.push(selectedvalue);
									threadCombo.setValue(tempSelectedValue);
								}
							}
						}
						//this.loadData();
						var resultPanel = Ext.getCmp("threadResulPanel");
						var measureTime = Ext.getCmp('time').value;
						params="time="+measureTime+"&details="+encodeURIComponent(selectedvalue);
						Ext.Ajax.request({
							async:false,
							url : '/final/monitor/jvmThreads.jsp',
							params:params,
							method:'POST',
							success : function(response) {
								var resultData = Ext.decode(response.responseText);
								resultPanel.update(resultData.tableData);
							}
						});
					}
				}
			});
		}
	},
	genQuery:function(QueryString)
	{
		var QueryForm="";
		if(!Ext.isEmpty(QueryString))
		{
			var split = QueryString.split('&');
			if(!Ext.isEmpty(split))
			{
				for(var i=0;i<split.length;i++)
				{
					var temp = split[i];
					if((temp.indexOf('comp') == 0) || (temp.indexOf('time') == 0) || (temp.indexOf('hostlist') == 0) || (temp.indexOf('stest') ==0) || (temp.indexOf('is') ==0) || (temp.indexOf('come') ==0) || (temp.indexOf('newWindow') > -1))
					{
						continue;
					}
					else
					{
						QueryForm = QueryForm+"&"+temp;
					}

				}
				QueryForm = QueryForm.replace("measure","s_measure");
				QueryForm = QueryForm.replace("starttime","s_st_time");
				QueryForm = QueryForm.replace("endtime","s_en_time");
				QueryForm = QueryForm.replace("starthr","s_st_hr");
				QueryForm = QueryForm.replace("endhr","s_en_hr");
			}
		}
		return QueryForm;
	},
	setComboOptionsInList : function(fieldName, list, value) {
		var field = Ext.getCmp(fieldName);
		field.getStore().loadRawData(list);
		field.suspendEvents(false);
		if(value=='')
		{
				value = field.getStore().getAt(0).get('value');
		}
		field.setValue(value);
		field.resumeEvents();
	}
});