var store_col = [];
var character = [];
var flag = false;
Ext.define('AutoColumnPlugin', {
    extend: 'Ext.AbstractPlugin',
    alias: 'plugin.autocolumnplugin',
    config: {
        stringWidth: Ext.util.TextMetrics,
        sortCols: function(currentWidth) {
            var longestRow = 0, calculatedLargestRow = [];
            for (var row = 0; row < currentWidth.length; row++) {
                if (currentWidth[row].length > longestRow)
                    longestRow = currentWidth[row].length;
            }
            for (var col = 0; col < longestRow; col++) {
                var highest = Number.MIN_VALUE;
                for (var row = 0; row < currentWidth.length; row++)
                    if (col < currentWidth[row].length && currentWidth[row][col] > highest)
                        highest = currentWidth[row][col];
						calculatedLargestRow.push(highest);
            }
            // return Array
            return calculatedLargestRow;
        }
    },
	  init: function(grid) {
		var me = this;
        this.grid = grid;
		 //attached resize event
		 grid.mon(grid.view, 'resize', me.resizeview, me);
    },
    constructor: function(config) {
        this.initConfig(this.config);
    },
	resizeview:function(view, width, height, oldWidth, oldHeight, eOpts){
		var me = this;
        var grid = me.grid;
			var calculateString = new me.stringWidth,
            currentWidth = [],
			headerTotalWidth =[],
            showList,
            gridWidth = grid.width ,
            gridStore = grid.store.data.items,
			 gridHeaderCt_items = grid.view.headerCt.items.items,
            colFilter = 14,_arryObject= [],
			colstring = "col" , time_sring = "TIME" ;
        for (var o = 0; o < gridStore.length; o++) {
			 if(Ext.typeOf(grid.store.data.items[o].raw) == "object" ){
					var sub_arr = [];
					 for (var text in  grid.store.data.items[o].raw)
		{
						if(text.indexOf(colstring) !== -1 || text.indexOf(time_sring.toLowerCase( )) !== -1 ){
							 sub_arr.push(grid.store.data.items[o].raw[text].toUpperCase( ));
						}
					 }
					 _arryObject.push(sub_arr);
			 }else{
				showList = gridStore[o].raw.map(function(i, index, arry) {
					return calculateString.getSize(i).width;
				});
				 currentWidth.push(showList);
			 }
        }
	 if(Ext.typeOf(_arryObject) == "array"){
			 for (var g = 0; g < _arryObject.length;g++) {
				showList = _arryObject[g].map(function(i, index, arry) {
							return calculateString.getSize(i).width;
						});
				currentWidth.push(showList);
				}
	 }
		// passing the currentWidth Array to sortCols function 
		for (var i = 0; i < gridHeaderCt_items.length; i++) {
				headerTotalWidth.push(calculateString.getSize(gridHeaderCt_items[i].text.toUpperCase( )).width + 40)
		  }
        var gotHighestCol = new this.sortCols(currentWidth),
            gridHeaderCt_items = grid.view.headerCt.items.items,
            totalWidth = gotHighestCol.reduce(function(a, b) {
                return a + b;
            }),
			totalHeaderWidth =  headerTotalWidth.reduce(function(a, b) {
                return a + b;
            }),
			gotHighestColMaxValue = Math.max.apply(Math,gotHighestCol),
			gotHighestColMinValue = Math.min.apply(Math,gotHighestCol),
			totalHeaderWidthDivide = Math.round(totalHeaderWidth/ gridHeaderCt_items.length);
		if(Ext.isEmpty(gridWidth)){
				gridWidth =  Ext.getBody().getViewSize().width + 42 ;
		}
		var gap = gridWidth - totalHeaderWidth; 
		var getLastHeaderCt_X = gridHeaderCt_items[ gridHeaderCt_items.length -1].x + 42;
		var viewWidth = grid.view.getWidth();
        if(totalHeaderWidth  > (viewWidth + gap) || totalWidth > (viewWidth +  gap )) {
			Ext.suspendLayouts();
			 for (var i = 0; i < gridHeaderCt_items.length; i++) {
					if(!Ext.isEmpty(gotHighestCol[i] ) || !Ext.isEmpty(calculateString.getSize(gridHeaderCt_items[i].text).width)  ){
						gridHeaderCt_items[i].width = "";
						gridHeaderCt_items[i].flex = false;
						if (gotHighestCol[i] >  calculateString.getSize(gridHeaderCt_items[i].text).width) {
								if(gotHighestCol[i] > gridWidth ){
									 //Checking whether colwidth is greater than gridWidth to wrap the length text
									 //console.log("gap", gap * i);
										//gridHeaderCt_items[i].width =  gotHighestColMaxValue - totalHeaderWidth;
										gridHeaderCt_items[i].width =   45 + totalHeaderWidth + (gap - i);
					}else{
										//setting colwidth
										// Converting to percentage
										gridHeaderCt_items[i].width = (((45 + gotHighestCol[i]) /100) * 10) + "%" ;
						}
						}else{
								gridHeaderCt_items[i].width = calculateString.getSize(gridHeaderCt_items[i].text.toUpperCase( )).width + 20; //setting header Width
					}
			}
		}
			 grid.view.refresh();
			Ext.resumeLayouts(true);
		}else{
			Ext.suspendLayouts();
			for (var i = 0; i < gridHeaderCt_items.length; i++) {
				if(!Ext.isEmpty(gotHighestCol[i] ) || !Ext.isEmpty(calculateString.getSize(gridHeaderCt_items[i].text).width)  ){
						gridHeaderCt_items[i].width = "";
						gridHeaderCt_items[i].flex = false;
						if (gotHighestCol[i] >  calculateString.getSize(gridHeaderCt_items[i].text).width || gotHighestColMaxValue < gotHighestCol[i] ) {
								if(gotHighestCol[i] > gridWidth ){
									 //Checking whether colwidth is greater than gridWidth to wrap the length text
										gridHeaderCt_items[i].flex =  gridHeaderCt_items.length;
								}else{
										//setting colwidth
										gridHeaderCt_items[i].flex = 0.2+ (gotHighestCol[i] /100);	
								}
								
						}else{
								// Skip the width 
								/*The smallest positive representable number -- 
								that is, the positive number closest to zero (without actually being zero). The smallest negative representable number is -MIN_VALUE*/
								if( gotHighestCol[i] >= Number.MIN_VALUE){
									gridHeaderCt_items[i].flex = 1
								}
								gridHeaderCt_items[i].width = 0.2 + (calculateString.getSize(gridHeaderCt_items[i].text.toUpperCase( )).width /100); //setting header Width
						}
					}
			}
			Ext.resumeLayouts(true);
        }
		grid.view.refresh();
		calculateString.destroy();
		delete calculateString ,gotHighestCol;
    },
 
    disable: function() {
        this.disabled = true;
 
    },
 
    enable: function() {
        this.disabled = false;
    }
});
function createTooltip(view) {
	view.tip = Ext.create('Ext.tip.ToolTip', {
		target: view.el,
		width:'60%',
		shadow:'frame',
		//cls:'tableToolTip',
		traceMouse:true,
		shadowOffset:30,
		margin:'0',
		padding:'0',
		//autoHide:false,
		delegate: view.itemSelector,
		traceMouse: false,
		anchor: 'top',
		listeners:{
			beforeshow:function(tip){
				var htmlContent = tip.html;
				if(Ext.isEmpty(htmlContent))
					return false;
			}
		}
	});
}
Ext.define('DD.view.ddGridView', {
    extend: 'Ext.grid.Panel',
    requires: ['DD.store.ddGridStore'],
	store: 'DD.store.ddGridStore',
	 //plugins:Ext.create('AutoWidthColumnsPlugin'),
	title: '',
	id:'tableView',
	alias : 'widget.ddGridView',
	itemId:'tableView',
	border:false,
	//stateId:'tableView',
	flex:1,
	layout:{
		type:'vbox',
		align:'stretch'
	},
	//stateful: true,
	margin:'0 10 10 10',
	style:{'z-index':'1','-webkit-box-shadow':'none','box-shadow':'none'},
	screenLabels:null,
	autoDestroy:false,
	cls:'gridSkin ddGridView',
	autoScroll : true,
	scroll:true,
	border:true,
   // stateful: true,
	viewConfig: {
		//cls: 'ddgridviewconfig',
		flex:1,
		//forceFit:true,
			listeners: {
				render: createTooltip
			}
	}
});
Ext.define('DD.view.ddGridView', {
    extend: 'Ext.grid.Panel',
    requires: ['DD.store.ddGridStore'],
	store: 'DD.store.ddGridStore',
	 //plugins:Ext.create('AutoWidthColumnsPlugin'),
	title: '',
	id:'tableView',
	alias : 'widget.ddGridView',
	itemId:'tableView',
	border:false,
	//stateId:'tableView',
	flex:1,
	layout:{
		type:'vbox',
		align:'stretch'
	},
	//stateful: true,
	margin:'0 10 10 10',
	style:{'z-index':'1','-webkit-box-shadow':'none','box-shadow':'none'},
	screenLabels:null,
	autoDestroy:false,
	cls:'gridSkin ddGridView',
	autoScroll : true,
	scroll:true,
	border:true,
   // stateful: true,
	viewConfig: {
		//cls: 'ddgridviewconfig',
		flex:1,
		//forceFit:true,
			listeners: {
					
					
						
						
		
				render: createTooltip
			}
	}
    
});
