function isHyphen(str) {
	if(str != null && str != undefined && str == '-')
		return -2;
	else
	   return -1;
}
var selectedType = '';
Ext.define('DescComparsion.controller.Main',{
			extend:'Ext.app.Controller',
			views:['Main','MeasuresComparision'],
			requires:['utilities.CustomGrid'],
			tableParam:null,
			refs:[{
				selector: "utilitiestool",
				ref: "utilitiestool"
			},{
				selector: "measurescomparision",
				ref: "measurescomparision"
			}],
			init:function(){
					this.control({
						
							"main utilitiestool": {
							"afterrender": this.hideTools
							},
							"utilitiestool > #printTool > button": {
								"click": this.print
							},
							"utilitiestool > #csvTool > button": {
								"click": this.save
							},
							'main triggerfield[id=Descriptors_id]':{
								afterrender:function(triggerfieldObj){
									var me = this;
									triggerfieldObj.onTriggerClick = function(){
										me.showButtonClicked();
									};
								}
							},
							'main button[id=button_id]': {
								click: function() {
									this.showButtonClicked();
								}
							},
							'main button[id=back_button_id]': {
								click: function() {
									this.backButtonClicked();
								}
							},
							'main':{
								'render':this.loadform
							},
							'measurescomparision timeline':{
									'render':this.loadTimeLine
							},
							'measurescomparision combo[id="er_timeline"]':
							{
								'select' : function() {
									this.changeTimeline();
									this.drawGraph();
								}
							},
							'measurescomparision combo[id="er_mode"]':
							{
								'select' : this.drawGraph
							},
							'measurescomparision combo[id="priority"]':
							{
								'select' : this.drawGraph
							},
							'measurescomparision button[id="graph"]':
							{
								'click' : this.drawGraph
							},
							'measurescomparision image[id="save"]':
							{
								'click' : this.saveGraph
							},
							'measurescomparision image[id="print"]':
							{
								'click' : this.printGraph
							},
							'measurescomparision image[id="data"]':
							{
								'click' : this.displayData
							},
					}
				);
				},
				createCombo:function(jsonData,urlParameters)
				{
					var me = this;
					var comboStore = Ext.create('Ext.data.Store',{
						fields:['value','name'],
						proxy:{
							type: 'memory',
							reader: {
								type: 'json',
								root:'options'
							}
						},
						data:jsonData.msmtTimeList
					});
					
					var selected_msmt = jsonData.msmtTimeList[0].value;
					var item={
							xtype:'combo',
							editable : false,
							store:comboStore,
							cls : 'dropdown',
							displayField:'name',
							valueField:'value',
							trigerAction:'all',
							fieldLabel:'<span style="white-space:nowrap;margin-left:-10px;">Measurement Time </span>',
							value:selected_msmt,
							itemId:'allMsmtCombo',
							id:'allMsmtCombo',
							queryMode:'local',
							listeners:{
								'change':function(e){
									DescComparsion.app.getController('Main').onMsmtComboChange(urlParameters);
								}	
							}
					};	
					return item;
				},
				hideTools: function () {
					this.getUtilitiestool().loadIcon(false,true,false,false,true,false,false,false,false,false,false);
					var save=Ext.getCmp("csvTool");
					var print=Ext.getCmp("printTool");
					save.setDisabled(true);
					print.setDisabled(true);
					save.hide();
					print.hide();
					var saveSeparator = Ext.getCmp('csvToolSeparator');
					var printSeparator = Ext.getCmp('printSeparator');
					var dataSeparator = Ext.getCmp('dataSeparator');
					if (!Ext.isEmpty(saveSeparator))
					{
						saveSeparator.hide();
					}
					if (!Ext.isEmpty(printSeparator))
					{
						printSeparator.hide();
					}
					if (!Ext.isEmpty(dataSeparator))
					{
						dataSeparator.hide();
					}
				},
				 print: function () {
					var sorter = Ext.getCmp('dataGrid').getStore().sorters.getAt(0);
					var sortOrder = '';
					var sortColumn = '';
					if (!Ext.isEmpty(sorter) && sorter!=undefined && sorter!='')
					{
						sortColumn  = sorter.property;
						sortOrder = sorter.direction;
					}
					if (!Ext.isEmpty(selectedType) && selectedType=='Measure' && !Ext.isEmpty(sortColumn) && sortColumn.indexOf('value')!=-1)
					{
						sortColumn = sortColumn.substring(sortColumn.indexOf('value')+5);
						if(sortColumn>1)
							sortColumn = ((parseInt(sortColumn)*2)-1);
 					}
					window.open("../monitor/printDescComparison.jsp?sortedColumn="+sortColumn+"&sortOrder="+sortOrder+"&isDescComparison=true","width=1012,height=603,left=0,top=105,scrollbars=1,scrollbars=yes,resizable=yes,location=no");
					//Ext.widget("print").show();
					/*var a = Ext.select("#printContentDiv");
					a.set({
						src: '../monitor/printDescComparison.jsp?"'
					});*/
				},
				 save: function () {
					var sorter = Ext.getCmp('dataGrid').getStore().sorters.getAt(0);
					var sortOrder = '';
					var sortColumn = '';
					if (!Ext.isEmpty(sorter) && sorter!=undefined && sorter!='')
					{
						sortColumn  = sorter.property;
						sortOrder = sorter.direction;
					}
					if (!Ext.isEmpty(selectedType) && selectedType=='Measure' && !Ext.isEmpty(sortColumn) && sortColumn.indexOf('value')!=-1)
					{
						sortColumn = sortColumn.substring(sortColumn.indexOf('value')+5);
						if(sortColumn>1)
							sortColumn = ((parseInt(sortColumn)*2)-1);
 					}
					else if(!Ext.isEmpty(sortColumn) && sortColumn.indexOf('value')!=-1)
					{
						sortColumn = sortColumn.substring(sortColumn.indexOf('value')+5);
						sortColumn = ((parseInt(sortColumn)*2)+2);
					}
					var newWindow = Ext.create('utilities.CommonWindow',{
						height:100,
						width:100,
						
						items: [{
							xtype: "component",
							autoEl: {
								tag: "iframe",
								src: '../servlet/egurkha.reporter.SaveInCSVFormat?sortedColumn='+sortColumn+"&sortOrder="+sortOrder+"&isDescComparison=true",
							}
						}],
					}).show();
					newWindow.hide();
				},
				saveGraph:function(){
					var timstart=Ext.getCmp('er_stdate').getValue();
					var timend=Ext.getCmp('er_enddate').getValue();

					timstart = Ext.Date.format(timstart, 'm/d/Y');
					
					timend = Ext.Date.format(timend, 'm/d/Y');

					var startHr=Ext.getCmp('er_sthr').getValue();
					var endHr=Ext.getCmp('er_endhr').getValue();

					var starttime = Ext.getCmp('er_stdate').getValue();
					var endtime = Ext.getCmp('er_enddate').getValue();

					starttime = Ext.Date.format(starttime, 'm/d/Y');
					
					endtime = Ext.Date.format(endtime, 'm/d/Y');

					var startmin=startMin;
					var endmin=endMin;

					var sdate = Ext.Date.format(starttime, 'm/d/Y');
					
					var edate = Ext.Date.format(endtime, 'm/d/Y');

					params = paramsForGraph;
				
					var newWindow = Ext.create('utilities.CommonWindow',{
						height:100,
						width:100,
						
						items: [{
							xtype: "component",
							autoEl: {
								tag: "iframe",
								src: "../servlet/com.egurkha.EgMonTimelineMeasures?saveToFile=true&gformat=graph&&starttime="+timstart+"&endtime="+timend+"&starthr="+startHr+"&endhr="+endHr+"&startmin="+startmin+"&endmin="+endmin+"&"+params
								/*src: "../servlet/com.egurkha.TimelineMeasures?saveToFile=true&gformat=graph&&starttime="+timstart+"&endtime="+timend+"&starthr="+startHr+"&endhr="+endHr+"&startmin="+startmin+"&endmin="+endmin+"&"+params*/
							}
						}],
					}).show();
					newWindow.hide();
				},
				printGraph:function(){
					var priority=Ext.getCmp('priority').getValue();
					var graphMode=Ext.getCmp('er_mode').getValue();
					var timeLine = Ext.getCmp('er_timeline').getValue();
					var timstart= Ext.getCmp('er_stdate').getValue();
					var timend=Ext.getCmp('er_enddate').getValue();

					var timstartv = Ext.Date.format(timstart, 'M d, Y');
					var timendv = Ext.Date.format(timend, 'M d, Y');

					var starttime =  Ext.getCmp('er_stdate').getValue();
					var endtime = Ext.getCmp('er_enddate').getValue();
					var startHr=Ext.getCmp('er_sthr').getValue();
					var endHr=Ext.getCmp('er_endhr').getValue();
					var startmin=startMin;
					var endmin=endMin;

					var sdate = Ext.Date.format(starttime, 'M d, Y');
					var edate = Ext.Date.format(endtime, 'M d, Y');

					params = paramsForGraph;

					if (timeLine=='Any')
					{
						Ext.widget("print").show();
						var a = Ext.select("#printContentDiv");
						a.set({
							src: "../monitor/EgPrintGraph.jsp?&starttime="+timstartv+"&starthr="+startHr+"&endtime="+timendv+"&endhr="+endHr+"&startmin="+startmin+"&endmin="+endmin+"&timeline="+timeLine+"&mode="+graphMode+"&graph_type=measuregraph&gtype=yes&priority="+priority+"&info="+"&sid=&"+params
						});
					}
					else
					{	
						Ext.widget("print").show();
						var a = Ext.select("#printContentDiv");
						a.set({
							src: "../monitor/EgPrintGraph.jsp?&mode="+graphMode+"&graph_type=measuregraph&gtype=yes&gtypeval="+timeLine+"&priority="+priority+"&info="+"&sid=&"+params
						});
					}
					
				},
				displayData:function(){
					var priority=Ext.getCmp('priority').getValue();
					var graphMode=Ext.getCmp('er_mode').getValue();
					var timeLine = Ext.getCmp('er_timeline').getValue();
					var timstart= Ext.getCmp('er_stdate').getValue();
					var timend=Ext.getCmp('er_enddate').getValue();

					var timstartv = Ext.Date.format(timstart, 'M d, Y');
					var timendv = Ext.Date.format(timend, 'M d, Y');

					var starttime =  Ext.getCmp('er_stdate').getValue();
					var endtime = Ext.getCmp('er_enddate').getValue();
					var startHr=Ext.getCmp('er_sthr').getValue();
					var endHr=Ext.getCmp('er_endhr').getValue();
					var startmin=startMin;
					var endmin=endMin;

					var sdate = Ext.Date.format(starttime, 'M d, Y');
					var edate = Ext.Date.format(endtime, 'M d, Y');

					 var sDate = Ext.Date.format(starttime, 'm/d/Y');
					sDate=(Ext.isEmpty(sDate))?starttime:sDate;
					var eDate = Ext.Date.format(endtime, 'm/d/Y');
					eDate=(Ext.isEmpty(eDate))?endtime:eDate;

					Ext.widget("print").show();
						var a = Ext.select("#printContentDiv");
						var index = params.indexOf("from");
						if( index> -1)
							params = params.substring(index,params.length);
						a.set({
							src: "../servlet/com.egurkha.EgMonTimelineMeasures?&starttime="+sDate+"&starthr="+startHr+"&endtime="+eDate+"&endhr="+endHr+"&startmin="+startmin+"&endmin="+endmin+"&gtypeval="+timeLine+"&gtype=1&gformat=report&priority="+priority+"&info=+"+"&sid=&"+params
						});
				},
				drawGraph:function()
				{
					var starttime = Ext.getCmp('er_stdate').getValue();
					var endtime = Ext.getCmp('er_enddate').getValue();
					var startHr=Ext.getCmp('er_sthr').getValue();
					var endHr=Ext.getCmp('er_endhr').getValue();
					
					var stMin = startMin;
					var enMin = endMin;
					var sdate = Ext.Date.format(starttime, 'm/d/Y');
					var edate = Ext.Date.format(endtime, 'm/d/Y');

					var timeLine = Ext.getCmp('er_timeline').getValue();
					var graphMode = Ext.getCmp('er_mode').getValue();
					var priority=Ext.getCmp('priority').getValue();
					var legParam = Ext.getCmp('showLegend').getValue();
					var startHrObj=Ext.getCmp('er_sthr');
					var endHrObj=Ext.getCmp('er_endhr');
					
					params = paramsForGraph;
					if(timeLine=="Any")
					{
						if (timeLine=='Any' && !checktime(sdate, edate, startHrObj, endHrObj,timeLine))
						{
							Ext.Msg.alert('Alert', 'From date should be lesser than To date');
							return;
						}
						else
						{
							params= "&mode="+graphMode+"&starttime="+encodeURIComponent(sdate)+"&starthr="+startHr+"&endtime="+encodeURIComponent(edate)+"&endhr="+endHr+"&startmin="+stMin+"&endmin="+enMin+"&timeline="+timeLine+"&gtype=&priority="+priority+"&"+params;
						}
					}
					else
					{
						params= "&mode="+graphMode+"&gtype=yes&gtypeval="+timeLine+"&priority="+priority+"&sid="+"&"+params;
					}
					params = params+"&showLegend="+legParam;
					var modeValue = Ext.getCmp('er_mode');
					var resultPanel = Ext.getCmp('resultPanel');
					var loadMask = new Ext.LoadMask(resultPanel, {msg:'Loading....'});
					loadMask.show();
					var flag = false;
					Ext.Ajax.request({
						url : '/final/monitor/descComparisonGraph.jsp?'+params,
						success : function(response) {
							var formdata = Ext.decode(response.responseText);
							var chartName = formdata.chartOption;
							var LegendInChartStr = formdata.LegendInChart;
							//var isLegendHidden = (LegendInChartStr.toLowerCase() =='false' || LegendInChartStr.toLowerCase() == 'no')?true:false;
							startMin = formdata.smin;
							endMin = formdata.emin;
							if(!Ext.isEmpty(chartName) && (chartName.indexOf('easy')>-1 || chartName.indexOf('graph')>-1))
							{
								modeValue.show();
								Ext.getCmp('csvToolSeparator').show();
								Ext.getCmp('save').show();
								Ext.getCmp('printSeparator').show();
								Ext.getCmp('print').show();
								Ext.getCmp('dataSeparator').show();
								var GraphData = Ext.getCmp('gId');
								//GraphData.remove();
								GraphData.update('<table border="0" bordercolor="red" width="100%" height="100%"><tr><td align="center" style="text-align:center"><img src='+formdata.urlForGraph+' align="center"></td></tr></table>');
								GraphData.doLayout();
								loadMask.hide();
							}
							else
							{
								Ext.getCmp('showLegend').setRawValue(LegendInChartStr);
								modeValue.hide();
								Ext.getCmp('csvToolSeparator').hide();
								Ext.getCmp('save').hide();
								Ext.getCmp('printSeparator').hide();
								Ext.getCmp('print').hide();
								Ext.getCmp('dataSeparator').hide();
								var GraphData = Ext.getCmp('gId');
								descCompare(formdata.urlForGraph,'gId',350,$('#gId').width(),false,true,'right');
								GraphData.doLayout();
								loadMask.hide();
							}
							
						}
						
					});
					
				},
				loadTimeLine:function(obj){
					form = obj.up('form').getForm();
					var me = this;
					params = paramsForGraph;
					var resultPanel = Ext.getCmp('resultPanel');
					var loadMask = new Ext.LoadMask(resultPanel, {msg:'Loading....'});
					loadMask.show();
					Ext.Ajax.request({
						url : '/final/monitor/descComparisonGraph.jsp?'+params,
						success : function(response) {
							var formdata = Ext.decode(response.responseText);
							endMin=formdata.hiddenFields.endmin_h;
							startMin=formdata.hiddenFields.startmin_h;
							var LegendInChartStr = formdata.LegendInChart;
							//var isLegendHidden = (LegendInChartStr.toLowerCase() =='false' || LegendInChartStr.toLowerCase() == 'no')?true:false;

							form.findField('er_timeline').suspendEvents(false);
							form.findField('er_timeline').getStore().loadRawData(formdata.timeLineCombo);
							form.findField('er_timeline').resumeEvents();
							form.findField('er_timeline').setValue(formdata.selectedTimeLine);

							form.findField('er_stdate').setValue(formdata.startDate);
							
							form.findField('er_sthr').setValue(formdata.hiddenFields.starthr);

							form.findField('er_enddate').setValue(formdata.endDate);

							form.findField('er_endhr').setValue(formdata.hiddenFields.endhr);
							
							form.findField('priority').getStore().loadRawData(formdata.priority);
							form.findField('priority').setValue(formdata.priority[0].valueField);
							form.findField('priority').suspendEvents(false);
							form.findField('priority').resumeEvents();

							var GraphData = Ext.getCmp('gId');
							var chartName = formdata.chartOption;
							var modeValue = Ext.getCmp('er_mode');
							//modeValue.show();
							if(!Ext.isEmpty(chartName) && (chartName.indexOf('easy')>-1 || chartName.indexOf('graph')>-1))
							{
								modeValue.show();
								Ext.getCmp('csvToolSeparator').show();
								Ext.getCmp('save').show();
								Ext.getCmp('printSeparator').show();
								Ext.getCmp('print').show();
								Ext.getCmp('dataSeparator').show();
								GraphData = Ext.getCmp('gId');
								GraphData.update('<table border="0" bordercolor="red" width="100%" height="100%"><tr><td align="center" style="text-align:center"><img src='+formdata.urlForGraph+' align="center"></td></tr></table>');
								loadMask.hide();
							}
							else
							{
								modeValue.hide();
								var isChecked = (LegendInChartStr == 'false' || LegendInChartStr == 'no' )?0:1;
								Ext.getCmp('showLegend').setRawValue(isChecked);
								Ext.getCmp('csvToolSeparator').hide();
								Ext.getCmp('save').hide();
								Ext.getCmp('printSeparator').hide();
								Ext.getCmp('print').hide();
								Ext.getCmp('dataSeparator').hide();
								descCompare(formdata.urlForGraph,'gId',350,$('#gId').width(),false,true,'right');
								loadMask.hide();
							}
						}
					});
					//
				},
				changeTimeline : function(obj) {
					var getTimelineVal = Ext.getCmp('er_timeline').getValue();
					var stDateObj = Ext.getCmp('er_stdate');
					var endDateObj = Ext.getCmp('er_enddate');
					var stHrObj = Ext.getCmp('er_sthr');
					var endHrObj = Ext.getCmp('er_endhr');				
					
					if (getTimelineVal == 'Any') {
						stDateObj.setDisabled(false);
						endDateObj.setDisabled(false);
						stHrObj.setDisabled(false);
						endHrObj.setDisabled(false);
					} else {
						stDateObj.setDisabled(true);
						endDateObj.setDisabled(true);
						stHrObj.setDisabled(true);
						endHrObj.setDisabled(true);
					}
					if(getTimelineVal!='Any')
					{
						var strtdt = Ext.Date.dateFormat(stDateObj.getValue(), mgrDateFormat);
						var enddt = Ext.Date.dateFormat(endDateObj.getValue(), mgrDateFormat);
						if (!Ext.isEmpty(obj)) {
							
							var param = 'beanName=com.egurkha.monitor.EgMonRemoteScriptingBean&method=getTime&P0='
									+ getTimelineVal
									+ '&P1='
									+ encodeURIComponent(strtdt)
									+ '&P2='
									+ encodeURIComponent(enddt)
									+ '&P3='
									+ stHrObj.getValue()
									+ '&P4='
									+ endHrObj.getValue()
									+ '&P5=' + encodeURIComponent(currentDateFormat);
							var me = this;
							Ext.Ajax.request({
								url : '/final/servlet/com.eg.RemoteScriptingServlet',
								params : param,
								success : function(response) {
								var formdata = Ext.decode(response.responseText);
								stDateObj.setValue(formdata[0]);
								endDateObj.setValue(formdata[1]);
								stHrObj.setValue(formdata[2]);
								endHrObj.setValue(formdata[3]);
								}
							});
						}
					}
				},
				showButtonClicked : function(){
					var obj=Ext.getCmp('secondPanel');
					var obj_temp=Ext.getCmp('secondPanel_heading');
					var objGrid=Ext.getCmp('grid_id');
					var save=Ext.getCmp("csvTool");
					var print=Ext.getCmp("printTool");
					save.setDisabled(false);
					print.setDisabled(false);
					//hiding only
					save.show();
					print.show();
					//hiding only
					var backButtonId=Ext.getCmp('back_button_id');
					var saveSeparator=Ext.getCmp('csvToolSeparator');
					var printSeparator=Ext.getCmp('printSeparator');
					saveSeparator.show();
					printSeparator.show();
					var multiselect_id=Ext.getCmp('multiselect_id');
					var selectObj = multiselect_id.getValue(); //get the value one by one array format
					
					var paramSelect = '';
					if(!Ext.isEmpty(selectObj)){
						for(i=0;i<selectObj.length;i++)
							paramSelect += selectObj[i]+'|';
						paramSelect = paramSelect.slice(0,-1); //remove last | symbol
					}
					
					var urlParameters = this.tableParam;
					urlParameters['monCmd'] = 'descComparison';
					urlParameters['hiv'] = 'ok';
					urlParameters['selectedMeasures'] = paramSelect;
					urlParameters['serviceName'] = serviceName;
					var desc_search = Ext.getCmp('Descriptors_id').getValue();
					desc_search = window.opener.filterEncode(desc_search);
					urlParameters['descriptor'] = desc_search;
					var msmtHostSelect = Ext.getCmp('multiselect_msmt_id');
					var selectedHosts = msmtHostSelect.getValue();
					if(!Ext.isEmpty(selectedHosts) && selectedHosts.length > 1){
						if(!Ext.isEmpty(save) && save!='' && save!=undefined)
							save.hide();
						if(!Ext.isEmpty(saveSeparator) && saveSeparator!='' && saveSeparator!=undefined)
							saveSeparator.hide();
						if(!Ext.isEmpty(print) && print!='' && print!=undefined)
							print.hide();
						if(!Ext.isEmpty(printSeparator) && printSeparator!='' && printSeparator!=undefined)
							printSeparator.hide();
						//Ext.MessageBox.alert('Error','Choose a Measurement Host Name');
						Ext.MessageBox.alert('Error','Choose any One Measurement Host Name');
						return false;
					}
					else if(!msmtHostSelect.isHidden()){
						urlParameters['msmtHostNames'] = selectedHosts;
					}
					//&msmtHostNames=Ext_agent_11.220
					
					var param=Query;
					Ext.Ajax.request({
							url : '/final/servlet/com.eg.EgMonitorController',
							method:'POST',
							params:urlParameters,
							success : function(response) 
							{
								obj.hide();
								objGrid.show();
								backButtonId.show();
								if(response.status == 200 && !Ext.isEmpty(response.responseText))
								{
									var formdata = Ext.decode(response.responseText);
									if(formdata.resultData=='Noresult')
									{
										Ext.MessageBox.alert('No Matching Descriptors', formdata.labelObject.No_matching_descriptors);
										obj.show();
										objGrid.hide();
										backButtonId.hide();
										var save=Ext.getCmp("csvTool");
										var print=Ext.getCmp("printTool");
										var saveSeparator = Ext.getCmp('csvToolSeparator');
										var printSeparator = Ext.getCmp('printSeparator');
										var grid_id = Ext.getCmp('grid_id');
										var grid_combo_id = Ext.getCmp('grid_combo_id');
										save.hide();
										print.hide();
										saveSeparator.hide();
										printSeparator.hide();
										grid_id.hide();
										grid_combo_id.hide();

									}
									else
									{
										var gridStore = Ext.create('Ext.data.Store',
										{
											autoLoad:true,
											storeId:'store_id',
											fields:formdata.fields,
											data:formdata.descArrayData_1,
											proxy: {
												type: 'memory',
											}
										});

										if(!Ext.isEmpty(Ext.getCmp('dataGrid')))
											Ext.getCmp('dataGrid').destroy();
										var lblTime={
											xtype:'label',
											labelAlign:'left',
											id:'lbltitle',
											//labelStyle:{'text-align':'right'},
											margin:'10 10 5 10',
											html:'<div style="text-align:right">'+formdata.labelObject.MeasurementTimeLable+'</div>'
										}
										if(formdata !=null && formdata !='null' && formdata != undefined && formdata != 'undefined' && formdata.msmtTimeList.length>1)
										{
											lblTime=DescComparsion.app.getController('Main').createCombo(formdata,urlParameters);
										}
										var setForceFit=false;
										if (formdata.dummayData.length<7)
										{
											setForceFit=true;
										}
										//logic for grid sorting starting using doSort method
										for (var key in formdata.dummayData)
										{
											formdata.dummayData[key].doSort= function(state) {
													
													var ds = this.up('grid').store; 
													var field = this.getSortParam();
													ds.sort({
													property: field,
													direction: state,
													sorterFn: function(v1, v2){
														v1 = v1.raw['sort'+field];
														v2 = v2.raw['sort'+field];
														/*v1 = v1.get(field);
														v2 = v2.get(field);
														v1=v1.substring(v1.indexOf('<span>')+6);
														v2=v2.substring(v2.indexOf('<span>')+6);

														v1=v1.substring(0,v1.indexOf('</span>'));
														v2=v2.substring(0,v2.indexOf('</span>'));*/

 															if(isNaN(v1) && isNaN(v2))
															{
																// transform v1 and v2 here
																return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
															}
															else
															{
																v1= isNaN(v1) ? isHyphen(v1) : v1;
																v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
																v2= isNaN(v2) ? isHyphen(v2) : v2;
																v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);

																// transform v1 and v2 here
															return (v1 > v2) ? 1 : ((v1 < v2) ? -1 : 0);
															}
														}
													});
												}
										}
										var sorttableFlag  = true;
										if(!Ext.isEmpty(formdata.sorttableFlag) && formdata.sorttableFlag!=undefined && (formdata.sorttableFlag==false || formdata.sorttableFlag=='false'))
											sorttableFlag = false;
										if(!Ext.isEmpty(formdata.dummayData) && formdata.dummayData!=undefined && selectedType!=null)
											selectedType = formdata.dummayData[0].header;
										if(!sorttableFlag)
										{
											var cols = formdata.dummayData;
											for(var i=0;i<cols.length;i++){
												if(!Ext.isEmpty(cols[i].header) && cols[i].header!=undefined && cols[i].header!='Measure' && cols[i].header!='Descriptor')
												{
													cols[i].header = "<font data-qtip='"+sortTipText+"'>"+cols[i].header+"</font>";
												} else {
													cols[i].header = "<font>"+cols[i].header+"</font>";
												}
											}
										}
										//logic for grid sorting starting
										if(!Ext.isEmpty(formdata.labelObject.Component))
											compType += formdata.labelObject.Component;
										if(!Ext.isEmpty(formdata.labelObject.Layer))
											compType += formdata.labelObject.Layer;
										if(!Ext.isEmpty(formdata.labelObject.Test))
											compType += formdata.labelObject.Test;
										var grid = {
											//xtype:'customgrid',
											xtype:'grid',
											plugins:Ext.create('Ext.ux.AutoColumnWithLockingPlugin'),
											//cls:'gridSkin',
											cls:'gridSkin_locking',
											ui:'newGridPanel',
											columns: formdata.dummayData,
											enableLocking:true,
											margin:'0 10 10 10',
											//autoScroll:true,
											//scroll:true,
											border:true,
											needtoFixColumn:true,
											forceFit:setForceFit,
											id:'dataGrid',
											columnLines:true,
											//width:960,
											header:false,
											sortableColumns:sorttableFlag,
											menuDisabled:true,
											store:gridStore,
											//title: 'Last Measurement Time [Date And Time]',
											//title: formdata.labelObject.MeasurementTime,
											//width: '100%'
											flex:1,
											listeners:{
												'columnresize':function( ct, column, width, eOpts )
												{
													try
													{
														var tempColumnDataIndex= (Ext.decode(Ext.util.Cookies.get('tempColumnDataIndex')));
														var tempColumnObj= (Ext.decode(Ext.util.Cookies.get('tempColumnObj')));
														if(tempColumnDataIndex == undefined || tempColumnDataIndex == null)
															tempColumnDataIndex = [];
														if(tempColumnObj == undefined || tempColumnObj == null)
															tempColumnObj = [];
													}
													catch (er)
													{
														var tempColumnDataIndex=[];
														var tempColumnObj=[];
													}
													if(tempColumnDataIndex.indexOf(column.dataIndex) != -1)
													{
														var indexVal = tempColumnDataIndex.indexOf(column.dataIndex);
														try
														{
															if(tempColumnObj[indexVal].compType == compType)
															{
																tempColumnDataIndex.splice(indexVal, 1);
																tempColumnObj.splice(indexVal, 1);
															}
														}
														catch (er)
														{
															var tempColumnDataIndex=[];
															var tempColumnObj=[];
														}
														tempColumnDataIndex.push(column.dataIndex);
														tempColumnObj.push({
															"dataIndex":column.dataIndex,
															//"measureOrgName":column.measureOrgName,
															"dashboardName":"descComparison",
															"compType":compType,
															"width":width
														});
													}
													else
													{
														tempColumnDataIndex.push(column.dataIndex);
														tempColumnObj.push({
															"dataIndex":column.dataIndex,
															//"measureOrgName":column.measureOrgName,
															"dashboardName":"descComparison",
															"compType":compType,
															"width":width
														});
													}
													//Ext.util.Cookies.clear('tempColumnObj');
													//Ext.util.Cookies.clear('tempColumnDataIndex');
													Ext.util.Cookies.set('tempColumnObj',Ext.encode(tempColumnObj));
													Ext.util.Cookies.set('tempColumnDataIndex',Ext.encode(tempColumnDataIndex));
												}
											},
										};
										
										var grid_id = Ext.getCmp('grid_id');
										var grid_combo_id = Ext.getCmp('grid_combo_id');
										grid_id.removeAll();
										if(formdata !=null && formdata !='null' && formdata != undefined && formdata != 'undefined' && formdata.msmtTimeList.length>1)
										{
											if(!Ext.isEmpty(grid_combo_id))
												grid_combo_id.removeAll();

											grid_combo_id.add(lblTime);
											grid_combo_id.show();
											grid_id.add(grid);
										}
										else
										{
											//grid_combo_id.destroy();
											grid_id.add(lblTime,grid);
										}
									}
								}
							}
						});
				},
				backButtonClicked:function(){
					var obj=Ext.getCmp('secondPanel');
					var objGrid=Ext.getCmp('grid_id');
					var save=Ext.getCmp("csvTool");
					var print=Ext.getCmp("printTool");
					var backButtonId=Ext.getCmp('back_button_id');
					var dataSeparatorId=Ext.getCmp('dataSeparator');
					var saveSeparator = Ext.getCmp('csvToolSeparator');
					var printSeparator = Ext.getCmp('printSeparator');
					var dataSeparator = Ext.getCmp('dataSeparator');
					var gridComboId = Ext.getCmp('grid_combo_id');
					//save.setDisabled(true);
					//print.setDisabled(true);
					objGrid.hide();
					backButtonId.hide();
					save.hide();
					print.hide();

					if (!Ext.isEmpty(saveSeparator))
					{
						saveSeparator.hide();
					}
					if (!Ext.isEmpty(printSeparator))
					{
						printSeparator.hide();
					}
					if (!Ext.isEmpty(dataSeparator))
					{
						dataSeparator.hide();
					}
					if (!Ext.isEmpty(gridComboId))
					{
						gridComboId.hide();
					}
					obj.show();
				},
				loadform : function(){
					var param=Query;
					var me = this;
					Ext.Ajax.request({ 
							url : '/final/servlet/com.eg.EgMonitorController?'+param,
							method:'POST',
							success : function(response) 
							{
								
								if(response.status == 200 && !Ext.isEmpty(response.responseText))
								{
									var formdata = Ext.decode(response.responseText);
									me.tableParam = formdata.urlParams;

									var title_name=Ext.getCmp('title_id');
									title_name.setTitle(formdata.labelObject.desccomparisonPageTitle+"  "+formdata.labelObject.Test);

									var search_desc=Ext.getCmp('Descriptors_id');
									
									//hiding only
									var save=Ext.getCmp("csvTool");
									var print=Ext.getCmp("printTool");
									//save.show();
									//print.show();
									//hiding only
									
									//isChecked = (showLegend == 'false' || showLegend == 'no' )?0:1;
									//added by vijay 10-10-2013
									var table = new Ext.XTemplate(
										'<div class="x-table">', 
										'<table style=" table-layout: auto"  cellspacing="0" cellpadding="0" border="0" class="x-grid-table x-grid-table-resizer">', 
											'<thead>', 
												'<tr class="x-grid-row">', 
													'<th class=" x-grid-cell x-grid-cell-first">', 
														'<div class="x-grid-cell-inner">'+componentLbl+'</div>', 
													'</th>', 
													'<th class=" x-grid-cell">', 
														'<div class="x-grid-cell-inner">'+layerLbl+'</div>', 
													'</th>', 
													'<th class=" x-grid-cell" >', 
														'<div class="x-grid-cell-inner">'+testLbl+'</div>', 
													'</th>', 
												'</tr>', 
											'</thead>', 
										'<tbody>', 
											'<tr class="x-grid-row">', 
												'<td class=" x-grid-cell x-grid-cell-first">', 
													'<div class="x-grid-cell-inner" >'+formdata.labelObject.Component+'</div>', 
												'</td>', 
												'<td class=" x-grid-cell">', 
													'<div class="x-grid-cell-inner" >'+formdata.labelObject.Layer+'</div>', 
												'</td>', 
												'<td class="x-grid-cell" >', 
													'<div  class="x-grid-cell-inner" >'+formdata.labelObject.Test+'</div>', 
												'</td>', 
											'</tr>', 
										'</tbody>', 
										'</table>', 
										'</div>'
									);

									
									var multiselect_id = Ext.getCmp('multiselect_id');
									multiselect_id.getStore().loadRawData(formdata.selectedMeasuresListDetails);
									var tempList = formdata.selectedMeasuresListDetails;
									var measureList = [];
									for(var i=0;i<tempList.length;i++)
									{
										measureList.push(tempList[i].valueField);
									}
									multiselect_id.setValue(measureList);

									var multiselectExt_id = Ext.getCmp('multiselect_msmt_id');
									var host_name_id = Ext.getCmp('host_name_id');
									if(!Ext.isEmpty(formdata.SelectedMeasureHostListDetails)){
										multiselectExt_id.show();
										if(!Ext.isEmpty(host_name_id) && host_name_id!=''&&host_name_id!=undefined)
											host_name_id.show();
										multiselectExt_id.getStore().loadRawData(formdata.SelectedMeasureHostListDetails);
										var tempmsmthostList = formdata.SelectedMeasureHostListDetails;
										var msmtHostList = [];
										for (var temp=0;temp<tempmsmthostList.length;temp++ )
										{
											msmtHostList.push(tempmsmthostList[temp].measureHostList);
										}
										multiselectExt_id.setValue(msmtHostList);
										var selectedHosts = multiselectExt_id.getValue();
										if(!Ext.isEmpty(selectedHosts) && selectedHosts.length > 1){
											var descOb = Ext.getCmp('Descriptors_id');
											if(!Ext.isEmpty(descOb) && descOb!=null && descOb!=undefined)
												Ext.getCmp('Descriptors_id').hide();
										}
									}
									else{
										multiselectExt_id.hide();
									}

									Ext.getCmp('firstPanel').update(table);	
								}
							}
						});
				},
				onMsmtComboChange:function(urlParameters)
				{
					
					var msmtTime = Ext.getCmp('allMsmtCombo').getValue();
					var obj=Ext.getCmp('secondPanel');
					var obj_temp=Ext.getCmp('secondPanel_heading');
					var objGrid=Ext.getCmp('grid_id');
					var save=Ext.getCmp("csvTool");
					var print=Ext.getCmp("printTool");
					save.setDisabled(false);
					print.setDisabled(false);
					//hiding only
					save.show();
					print.show();
					//hiding only
					var backButtonId=Ext.getCmp('back_button_id');
					var saveSeparator=Ext.getCmp('csvToolSeparator');
					var printSeparator=Ext.getCmp('printSeparator');
					saveSeparator.show();
					printSeparator.show();
					var multiselect_id=Ext.getCmp('multiselect_id');
					var selectObj = multiselect_id.getValue(); //get the value one by one array format
					
					var paramSelect = '';
					if(!Ext.isEmpty(selectObj)){
						for(i=0;i<selectObj.length;i++)
							paramSelect += selectObj[i]+'|';
						paramSelect = paramSelect.slice(0,-1); //remove last | symbol
					}
					
					urlParameters['monCmd'] = 'descComparison';
					urlParameters['hiv'] = 'ok';
					urlParameters['selectedMeasures'] = paramSelect;
					urlParameters['serviceName'] = serviceName;
					urlParameters['msmtTime'] = msmtTime;

					var desc_search = Ext.getCmp('Descriptors_id').getValue();
					desc_search = window.opener.filterEncode(desc_search);
					urlParameters['descriptor'] = desc_search;
					var msmtHostSelect = Ext.getCmp('multiselect_msmt_id');
					var selectedHosts = msmtHostSelect.getValue();
					if(!Ext.isEmpty(selectedHosts) && selectedHosts.length > 1){
						if(!Ext.isEmpty(save) && save!='' && save!=undefined)
							save.hide();
						if(!Ext.isEmpty(saveSeparator) && saveSeparator!='' && saveSeparator!=undefined)
							saveSeparator.hide();
						if(!Ext.isEmpty(print) && print!='' && print!=undefined)
							print.hide();
						if(!Ext.isEmpty(printSeparator) && printSeparator!='' && printSeparator!=undefined)
							printSeparator.hide();
						Ext.MessageBox.alert('Error','Choose a Measurement Host Name');
						return false;
					}
					else if(!msmtHostSelect.isHidden()){
						urlParameters['msmtHostNames'] = selectedHosts;
					}
				
					
					var param=Query;
					Ext.Ajax.request({
						url : '/final/servlet/com.eg.EgMonitorController',
						method:'POST',
						params:urlParameters,
						success : function(response) 
						{
							obj.hide();
							objGrid.show();
							backButtonId.show();
							if(response.status == 200 && !Ext.isEmpty(response.responseText))
							{
								var formdata = Ext.decode(response.responseText);
								if(formdata.resultData=='Noresult')
								{
									Ext.MessageBox.alert('No Matching Descriptors', formdata.labelObject.No_matching_descriptors);
									obj.show();
									objGrid.hide();
									backButtonId.hide();
									var save=Ext.getCmp("csvTool");
									var print=Ext.getCmp("printTool");
									var saveSeparator = Ext.getCmp('csvToolSeparator');
									var printSeparator = Ext.getCmp('printSeparator');
									var grid_id = Ext.getCmp('grid_id');
									save.hide();
									print.hide();
									saveSeparator.hide();
									printSeparator.hide();
									grid_id.hide();

								}
								else
								{
									var gridStore = Ext.create('Ext.data.Store',
									{
										autoLoad:true,
										storeId:'store_id',
										fields:formdata.fields,
										data:formdata.descArrayData_1,
										proxy: {
											type: 'memory',
										}
									});

									if(!Ext.isEmpty(Ext.getCmp('dataGrid')))
										Ext.getCmp('dataGrid').destroy();
									
									var lblTime=DescComparsion.app.getController('Main').createCombo(formdata,urlParameters);

									var setForceFit=false;
									if (formdata.dummayData.length<7)
									{
										setForceFit=true;
									}
									//logic for grid sorting starting using doSort method
									for (var key in formdata.dummayData)
									{
										formdata.dummayData[key].doSort= function(state) {
												
												var ds = this.up('grid').store; 
												var field = this.getSortParam();
												ds.sort({
												property: field,
												direction: state,
												sorterFn: function(v1, v2){
													v1 = v1.raw['sort'+field];
													v2 = v2.raw['sort'+field];
													/*v1 = v1.get(field);
													v2 = v2.get(field);
													v1=v1.substring(v1.indexOf('<span>')+6);
													v2=v2.substring(v2.indexOf('<span>')+6);

													v1=v1.substring(0,v1.indexOf('</span>'));
													v2=v2.substring(0,v2.indexOf('</span>'));*/

														if(isNaN(v1) && isNaN(v2))
														{
															// transform v1 and v2 here
															return v1 > v2 ? 1 : (v1 < v2 ? -1 : 0);
														}
														else
														{
															v1= isNaN(v1) ? isHyphen(v1) : v1;
															v1 = Ext.isNumber(v1) ? v1 : parseFloat(String(v1), 10);
															v2= isNaN(v2) ? isHyphen(v2) : v2;
															v2 = Ext.isNumber(v2) ? v2 : parseFloat(String(v2), 10);

															// transform v1 and v2 here
														return (v1 > v2) ? 1 : ((v1 < v2) ? -1 : 0);
														}
													}
												});
											}
									}
									//logic for grid sorting starting
									if(!Ext.isEmpty(formdata.labelObject.Component))
										compType += formdata.labelObject.Component;
									if(!Ext.isEmpty(formdata.labelObject.Layer))
										compType += formdata.labelObject.Layer;
									if(!Ext.isEmpty(formdata.labelObject.Test))
										compType += formdata.labelObject.Test;
								
									var grid = {
										
										xtype:'grid',
										plugins:Ext.create('Ext.ux.AutoColumnWithLockingPlugin'),
										
										cls:'gridSkin_locking',
										ui:'newGridPanel',
										columns: formdata.dummayData,
										enableLocking:true,
										margin:'0 10 10 10',
										
										
										border:true,
										needtoFixColumn:true,
										forceFit:setForceFit,
										id:'dataGrid',
										columnLines:true,
										
										header:false,
										sortableColumns:true,
										menuDisabled:true,
										store:gridStore,
					
										flex:1,
										listeners:{
											'columnresize':function( ct, column, width, eOpts )
											{
												try
												{
													var tempColumnDataIndex= (Ext.decode(Ext.util.Cookies.get('tempColumnDataIndex')));
													var tempColumnObj= (Ext.decode(Ext.util.Cookies.get('tempColumnObj')));
													if(tempColumnDataIndex == undefined || tempColumnDataIndex == null)
														tempColumnDataIndex = [];
													if(tempColumnObj == undefined || tempColumnObj == null)
														tempColumnObj = [];
												}
												catch (er)
												{
													var tempColumnDataIndex=[];
													var tempColumnObj=[];
												}
												if(tempColumnDataIndex.indexOf(column.dataIndex) != -1)
												{
													var indexVal = tempColumnDataIndex.indexOf(column.dataIndex);
													if(tempColumnObj[indexVal].compType == compType)
													{
														tempColumnDataIndex.splice(indexVal, 1);
														tempColumnObj.splice(indexVal, 1);
													}
													tempColumnDataIndex.push(column.dataIndex);
													tempColumnObj.push({
														"dataIndex":column.dataIndex,
														//"measureOrgName":column.measureOrgName,
														"dashboardName":"descComparison",
														"compType":compType,
														"width":width
													});
												}
												else
												{
													tempColumnDataIndex.push(column.dataIndex);
													tempColumnObj.push({
														"dataIndex":column.dataIndex,
														//"measureOrgName":column.measureOrgName,
														"dashboardName":"descComparison",
														"compType":compType,
														"width":width
													});
												}
												//Ext.util.Cookies.clear('tempColumnObj');
												//Ext.util.Cookies.clear('tempColumnDataIndex');
												Ext.util.Cookies.set('tempColumnObj',Ext.encode(tempColumnObj));
												Ext.util.Cookies.set('tempColumnDataIndex',Ext.encode(tempColumnDataIndex));
											}
										},
									};
									var grid_id = Ext.getCmp('grid_id');
		
									if(!Ext.isEmpty(Ext.getCmp('dataGrid')))
										Ext.getCmp('dataGrid').destroy();

									grid_id.add(grid);
								}
							}
						}
					});
				}
		}
	);