Ext.define('DispSiteSeg.controller.Main',{
	extend: 'Ext.app.Controller',
	views:['Main','SystemComponentList'],
	requires:['DispSiteSeg.view.SystemComponentList'],
	refs:[{
		selector:'main',
		ref:'main'
	},
	{selector:'systemcomponent',ref:'systemComponent'}],
	init:function(){
		setInterval("execute()",refreshFrequency);
		this.control({
			'main':{
				render:this.renderMainFun
			},
			'main button[action=back]':{
       			click:this.backButtonHandler
       		},
			'main trigger' : {
       			specialkey: this.servicesSearchKeyPress,
				click:this.servicesSearch
       		},
		});
	},
	servicesSearchKeyPress:function(field, e){
		if (e.getKey() == e.ENTER) {
			var searchUrl= "/final/monitor/EgDispSiteSegStatesData.jsp?search="+field.getValue()+"&site="+requestParams.site+"&segment="+requestParams.segment;
			this.renderMain(searchUrl);
		}
	},
	servicesSearch:function(field){
		var searchUrl= "/final/monitor/EgDispSiteSegStatesData.jsp?search="+field.getValue()+"&site="+requestParams.site+"&segment="+requestParams.segment;
		this.renderMain(searchUrl);
	},
	renderMainFun:function(){
		var searchUrl='/final/monitor/EgDispSiteSegStatesData.jsp?'+querystring;
		this.renderMain(searchUrl);
	},
	renderMain:function(input_url){
		var urlValue='/final/monitor/EgDispSiteSegStatesData.jsp?'+querystring;
		if(input_url!=null && input_url!=undefined && input_url!="")
		{
			urlValue=input_url;
		}
		refreshURL = urlValue;
		var me= this;
		Ext.Ajax.request({
			url:urlValue,
			method : 'POST',
			scope:this,
			success : function(response, opts)
			{
				var jsonText = response.responseText;
				var jsonData = Ext.decode(jsonText);
				//console.log("jsonData",jsonData);

				//me.getMain().removeAll(true);

				var systemcomponent = Ext.getCmp('systemcomponent');
				if(!Ext.isEmpty(systemcomponent) && !Ext.isEmpty(systemcomponent.items))
				{
					var resultItems=systemcomponent.items.items;
					for(var item=resultItems.length-1; item>-1 ; item--)
					{
						resultItems[item].destroy();
					}
				}

				if(!Ext.isEmpty(jsonData.screenLabels))
				{
					if(!Ext.isEmpty(jsonData.screenLabels.Title))
					{
						me.getMain().setTitle(jsonData.screenLabels.Title);
					}

					me.getSystemComponent().setTitle(jsonData.screenLabels.groupNameTitle);

					var leftHeaderNameIdObj = Ext.getCmp('leftHeaderNameId');
					if(!Ext.isEmpty(jsonData.screenLabels.leftHeaderLabel) && !Ext.isEmpty(leftHeaderNameIdObj))
					{
						leftHeaderNameIdObj.setText(jsonData.screenLabels.leftHeaderLabel);
					}
					
					var rightHeaderNameIdObj = Ext.getCmp('rightHeaderNameId');
					if(!Ext.isEmpty(jsonData.screenLabels.rightHeaderLabel) && !Ext.isEmpty(rightHeaderNameIdObj))
					{
						rightHeaderNameIdObj.setText(jsonData.screenLabels.rightHeaderLabel);
					}
				}

				if((!Ext.isEmpty(jsonData.componentNameObject)) && jsonData.componentNameObject.length>0)
				{
					var panelArray = [];
					var toolsArray = [];

					Ext.suspendLayouts();
					for(var t=0;t<jsonData.componentNameObject.length;t++){
						var contentSystemlist = Ext.create('DispSiteSeg.view.SystemComponentList',{
							jsonData:jsonData.componentNameObject[t],
						});
						//panelArray.push(contentSystemlist);
						systemcomponent.add(contentSystemlist);
					}
					Ext.resumeLayouts(true);

					//me.getMain().add(panelArray);
					var searchIdObj = Ext.getCmp('searchId');
					if((!Ext.isEmpty(searchIdObj)) && !Ext.isEmpty(jsonData.EnableSearch) && jsonData.EnableSearch=='true')
					{
						if(searchIdObj!=null && searchIdObj!=undefined)
						{
							searchIdObj.show();
							searchIdObj.emptyText=jsonData.SearchEmptyText;
							searchIdObj.fieldLabel=jsonData.SearchFieldLabel;
						}
					}
					else if((!Ext.isEmpty(searchIdObj)) && !Ext.isEmpty(jsonData.EnableSearch) && jsonData.EnableSearch=='false')
					{
						if(searchIdObj!=null && searchIdObj!=undefined)
						{
							searchIdObj.emptyText="";
							searchIdObj.fieldLabel="Search for a segment";
							searchIdObj.hide();
						}
					}
				}
				else if((!Ext.isEmpty(jsonData.noMatch)))
				{
					//me.getMain().removeAll(true);
					var systemcomponent = Ext.getCmp('systemcomponent');
					if(!Ext.isEmpty(systemcomponent) && !Ext.isEmpty(systemcomponent.items))
					{
						var resultItems=systemcomponent.items.items;
						for(var item=resultItems.length-1; item>-1 ; item--)
						{
							resultItems[item].destroy();
						}
					}

					var emptyPanel = Ext.create('utilities.EmptyPanel', {
						bodyStyle:{'background':'none'},
						cls:'egDummyClass',
						items: [{
							xtype: 'container',
							padding: 50,
							style: {
								'text-align': 'center'
							},
							html: '<div class = "iconInformation" style="margin:10% auto 0px auto"></div><div>'+jsonData.noMatch.NoMatchIndependent+'</div>'
						}]
					});
					systemcomponent.add(emptyPanel);
					//me.getMain().add(emptyPanel);
				}
				else
				{
					//me.getMain().removeAll(true);
					var systemcomponent = Ext.getCmp('systemcomponent');
					if(!Ext.isEmpty(systemcomponent) && !Ext.isEmpty(systemcomponent.items))
					{
						var resultItems=systemcomponent.items.items;
						for(var item=resultItems.length-1; item>-1 ; item--)
						{
							resultItems[item].destroy();
						}
					}

					var emptyPanel = Ext.create('utilities.EmptyPanel', {
						bodyStyle:{'background':'none'},
						cls:'egDummyClass',
						items: [{
							xtype: 'container',
							padding: 50,
							style: {
								'text-align': 'center'
							},
							html: '<div class = "iconInformation" style="margin:10% auto 0px auto"></div><div>'+noGroup+'</div>'
						}]
					});
					systemcomponent.add(emptyPanel);
					//me.getMain().add(emptyPanel);
				}
			},
			failure : function(){
				//alert("failure");
				console.log("Ajax request failure");
				console.log("Ajax request url--->",urlValue);
			}
		});
	},
	backButtonHandler:function()
	{
		if (requestParams.action=='service')
		{
			document.location='/final/servlet/com.eg.EgMonitorController?monCmd=serviceList&from=MainDashboard&action=service&isFromMenu=true';
		}
		else
		{
			document.location='/final/servlet/com.eg.EgMonitorController?monCmd=dashboard';
		}
	}
});