Ext.define('EMDashboard.controller.BaseController',{
	extend:'Ext.app.Controller',
	treePaths:[],
	requires:['Ext.tip.*','Ext.Button','Ext.window.MessageBox'],
	stores:['Tree','ProblemMonitors','SubOptimals','HealthTree','MonTree'],
	views:['Main','Base','LocationsTree','LocationsMapContainer','LocationsMap','MonitorTree','HealthChart','ProblemMonitors','SubOptimals','HealthTree','PortalColumn','ComponentOverview','MonitorOverview','LocationFusionMap','LocationOverview'],
	refVar:null,
	
	refs:[{
		selector:'main',
		ref:'main'
	},{
		selector:'componentoverview',
		ref:'componentOverview'
	},{
		selector:'monitoroverview',
		ref:'monitorOverview'
	},{
		selector:'locationoverview',
		ref:'locationOverview'
	},{
		selector:'transactionoverview',
		ref:'transactionOverview'
	},{
		selector:'base',
		ref:'base'
	},{
		selector:'base combo[itemId=monitors]',
		ref:'monitors'
	},{
		selector:'base combo[itemId=filters]',
		ref:'filters'
	},{
		selector:'base combo[itemId=subFilters]',
		ref:'subFilters'
	},{
		selector:'locationstree',
		ref:'locationsTree'
	},{
		selector:'suboptimals button#maximize',
		ref:'maximize'
	},{
		selector:'monitortree',
		ref:'monitorTree'
	},{
		selector:'base locationstree combo[itemId=severity]',
		ref:'severity'
	},{
		selector:'base monitortree combo[itemId=monitorSeverity]',
		ref:'monitorSeverity'
	},{
		selector:'locationsmap',
		ref:'locationsMap'
	},{
		selector:'healthchart',
		ref:'healthChart'
	},{
		selector:'problemmonitors',
		ref:'problemMonitors'
	},{
		selector:'suboptimals',
		ref:'suboptimals'
	},{
		selector:'healthtree',
		ref:'healthTree'
	},{
		selector:'base combo#monitors',
		ref:'monitors'
	},{
		selector:'base combo#filters',
		ref:'filters'
	},{
		selector:'base combo#subFilters',
		ref:'subFilters'
	}],
	
	init:function(){
		baseRefreshVal = setInterval('refresh("BaseController")',refreshRate);
		this.control({
			'main':{
				deactivate:function(){
					//console.log('Main deactivated!');
				}
			},
			'base':{
				render:function(base,eOpts){
					this.setDashboardData(base,eOpts);
					var test = this.getJSON();
					sessionUrl = '';
					if(test){
						//this.loadPreviousPage();
					}
				}
			},
			'base combo#monitors':{
				select:this.getJSON
			},
			'base combo#filters':{
				change:function(combo,newValue,oldValue,eOpts){
					this.filtersChanged(combo,newValue,oldValue,eOpts);
				}
			},
			'base combo#subFilters':{
				select:this.getJSON
			},
			'base monitortree':{
				itemclick:this.locationDrillDown,
				itemexpand:this.getMonTreeExpandedNode,
				itemcollapse:this.getMonTreeExpandedNode
			},
			'base locationstree':{
				
				itemclick:this.specificLocationFromHealthTree,
				itemexpand:this.getExpandedNode,
				itemcollapse:this.getExpandedNode
			},
			'base healthtree':{
				//itemclick:this.specificLocationFromHealthTree,
				itemclick:this.allLocationFromHealthTree,
				itemexpand:this.getHealthTreeNode,
				itemcollapse:this.getHealthTreeNode
			},
			'base locationstree combo#severity':{
				select:this.getJSON
			},
			'base monitortree combo#monitorSeverity':{
				select:this.getJSON
			},
			'base button[cls=treeButton]':{
				click:this.locationTreeOpen
			},
			'base locationsmap':{
				mark:function(map){
					map.markers = [];
					for(i=0;i<map.mapData.length;i++){
						map.markers[i]=map.addMarker(map.mapData[i]);
					}
				},
				clearmark:function(map){
					if(map.markers!=null){
						for(i=0;i<map.markers.length;i++){
							map.markers[i].setMap(null);
						}
					}
				}
			}
		});
	},
	savePositions:function(ob){
		var me = this;
		var panelPositions = {};
		var baseItems = this.getBase().items.items;
		for(i=0;i<baseItems.length;i++){
			if(baseItems[i].getXType() == 'portalcolumn'){
				var innerXTypes = [];
				var innerItems = baseItems[i].items.items;
				for(j=0;j<innerItems.length;j++){
					innerXTypes.push(innerItems[j].getXType());
				}
				panelPositions[baseItems[i].getId()] = innerXTypes;
			}
		}

		Ext.Ajax.request({
			url:'/final/monitor/externalMonitorsSessionState.jsp',
			params:{
				position:Ext.encode(panelPositions),
				sessionParams:Ext.encode(me.setRequestParameters())
			},
			disableCaching:false
		});
	},
		
	setRequestParameters:function(){
		var param = {
			
			monitors:Ext.isEmpty(this.getMonitors().getValue())?'ALL':this.getMonitors().getValue(),
			filterBy:Ext.isEmpty(this.getFilters().getValue())?'ALL':this.getFilters().getValue(),
			//severity:Ext.isEmpty(this.getFilters().getValue())?'ALL':this.getFilters().getValue(),
			subFilter:(this.getFilters().getValue() == 'Component' || Ext.isEmpty(this.getSubFilters().getValue()))?'':this.getSubFilters().getValue(),
			location: 'ALL',
			panels: [{
				locationTree: {
					//severity:'ALL',
					severity:Ext.isEmpty(this.getSeverity().getValue())?'ALL':this.getSeverity().getValue(),
					monitorSeverity:Ext.isEmpty(this.getMonitorSeverity().getValue())?'ALL':this.getMonitorSeverity().getValue(),
					agentNick: ''
				}},
			{healthChart:{}},
			{problemMonitors:{}},
			{subOptimal:{}},
			{locationMap:{}}
			]
		};
		return param;
	},

	getJSON:function(parameters){
		var param = Ext.encode(this.setRequestParameters());
		var monName = Ext.isEmpty(this.getMonitors().getValue())?'ALL':this.getMonitors().getValue();
		if(!Ext.isEmpty(sessionUrl))
			param = sessionUrl;
		var mask = new Ext.LoadMask(this.getMain(), {msg:"Loading...",cls:'maskDashUpperGrid'});
		mask.show();
		var me = this;
		me.getBase().hide();
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgExtMonDashController',
			method:'GET',
			params:{reqObject:param},
			disableCaching:false,
			success:function(response){
				var json = Ext.decode(response.responseText);
				mapInfoWindowData = json.mapInfoData;
				me.getBase().setData(json.dropDowns);
			
				me.getLocationsTree().setData(json);
				me.treeStateManager();
				me.getLocationsTree()["collapseAll"]();
				if(!Ext.isEmpty(json.monitorGroupBy))
				{
					me.getMonitorTree().setData(json);
				}
				else
				{
					me.getMonitorTree().setData(json);
					me.getMonitorTree().setEmptyPanel();
				}
				if(!Ext.isEmpty(json.healthChartPanel) && !Ext.isEmpty(json.healthChartPanel.chartJson)){
					me.renderHealthChart(json.healthChartPanel.chartJson,json);

					

					me.getHealthTree().show();
					me.getHealthTree().setRootNode(json.healthChartPanel.healthTree);
					me.healthTreeStateManager();
				}
				else{
					me.getHealthChart().setEmptyPanel();
					me.getHealthTree().hide();
				}
				if(!Ext.isEmpty(json.monitorProblemsPanel))
					me.getProblemMonitorsStore().loadData(json.monitorProblemsPanel);
				else
				{
					me.getProblemMonitorsStore().removeAll();
					//me.getProblemMonitors().setEmptyPanel();
				}
				if(!Ext.isEmpty(json.subOptimalsPanel))
					me.getSubOptimalsStore().loadData(json.subOptimalsPanel);
				else
				{
					me.getSubOptimalsStore().removeAll();
				}
				var errorPanel = Ext.getCmp('locationsMapErrorPanel');
				if(!Ext.isEmpty(json.mapMarkers)){
					
					if(errorPanel!=null)
						errorPanel.hide();
					me.getLocationsMap().show();
					var fl=me.getLocationsMap().clearMapMarkers();
					if(fl)
						me.getLocationsMap().setMapMarkers(json.mapMarkers);
				}
				else{
					me.getLocationsMap().hide();
					errorPanel.show();
				}
				me.getBase().show();
				if(!Ext.isEmpty(mask)){
        			mask.hide();
        		}

				var	mapObj = null;
				try
				{
					if(Ext.getCmp('mapIds')!=null && Ext.getCmp('mapIds')!=undefined)
					{
						mapObj = Ext.getCmp('mapIds').gmap;

						var customMapType = new google.maps.StyledMapType(featureOpts, styledMapOptions);
						mapObj.mapTypes.set(MY_MAPTYPE_ID, customMapType);
					}
				}
				catch (e)
				{
				}

			},
			failure:function(){
				me.getHealthChart().setEmptyPanel();
				//me.getProblemMonitors().setEmptyPanel();
			}
		});
		return true;
	},
	setDashboardData:function(base,eOpts){
		base.body.ddScrollConfig = {
			vthresh:100,
			hthresh:1,
			frequency:100,
			increment:300
		},
		Ext.dd.ScrollManager.register(base.body);
	},
	renderHealthChart:function(chartJson,json){

	
		
		var isFusion = (!Ext.isEmpty(json.healthChartPanel))?json.healthChartPanel.isIniChartType:false;
		if( !isFusion )
		{
			var formdata =chartJson;
			var pieChart = {};
			pieChart = jQuery.extend(true, {}, createBar('chartContainer',200,500), pieChart);
			pieChart.setData(chartJson,'','','pie');
			pieChart.drawChart();
		}
		else
		{
			if(FusionCharts('monitorHealth'))
			{
				var healthObj = document.getElementById('monitorHealthPie');
				if(Ext.isEmpty(healthObj))
				{
					FusionCharts('monitorHealth').dispose();
					this.getHealthChart().down('container[itemId=chartContainer]').update('<div id="monitorHealthPie" style="width:100%;height:170px;margin-top:-18px"></div>');
					var healthChart = new FusionCharts('/final/FusionCharts/swf/Pie2D.swf','monitorHealth', '100%', '80%', '0', '1');
					healthChart.setJSONData(chartJson);
					healthChart.setTransparent(true);
					healthChart.render('monitorHealthPie');
				}
				else
					FusionCharts('monitorHealth').setJSONData(chartJson);
			}
			else
			{

				var healthObj = document.getElementById('monitorHealthPie');
				if(Ext.isEmpty(healthObj))
					this.getHealthChart().down('container[itemId=chartContainer]').update('<div id="monitorHealthPie" style="width:100%;height:170px;border:0px solid blue;margin-top:-18px"></div>');
				var healthChart = new FusionCharts('/final/FusionCharts/swf/Pie2D.swf','monitorHealth', '100%', '170', '0', '1');
				healthChart.setJSONData(chartJson);
				healthChart.setTransparent(true);
				healthChart.render('monitorHealthPie');
			}
		}
	},
	filtersChanged:function(combo,newValue,oldValue,eOpts){
		if(newValue != 'Component'){
			var me = this;
			Ext.Ajax.request({
				url:'/final/servlet/com.eg.EgExtMonDashController',
				method:'GET',
				params:{filterBy:me.getFilters().getValue()},
				disableCaching:false,
				success:function(response){
					var subFilterData = Ext.decode(response.responseText);
					if(!Ext.isEmpty(subFilterData.options))
					{
						me.getSubFilters().getStore().loadRawData(subFilterData.options);
						me.getSubFilters().setValue(subFilterData.selected);
						me.getSubFilters().show();
						me.getJSON();
					}
					else
					{
						if( !Ext.isEmpty(me.getSubFilters()) )
						{
							me.getSubFilters().getStore().removeAll();
							me.getSubFilters().getStore(new Ext.GridPanel({viewConfig: {emptyText: 'No records'}}));
							me.getSubFilters().hide();
						}
					}
				},
				failure:function(){
				}
			});			
		}
		else if(newValue == 'Component'){
			if( !Ext.isEmpty(this.getSubFilters()) )
			{
				this.getSubFilters().getStore().removeAll();
				this.getSubFilters().hide();
			}
			this.getJSON();
		}
		else{
			this.getSubFilters().getStore().removeAll();
			this.getSubFilters().hide();
		}
	},
	locationTreeOpen:function(button,eOpts){
		var buttonId = button.getItemId();
		if( buttonId == 'monitorExpandAll' || buttonId == 'monitorCollapseAll' )
		{
			isMonTreeExpand
			var methodName = (isMonTreeExpand)?"collapseAll":"expandAll";
			isMonTreeExpand = !isMonTreeExpand;
			this.getMonitorTree()[methodName]();
		}
		else
		{
			var methodName = (isLocTreeExpand)?"collapseAll":"expandAll";
			isLocTreeExpand = !isLocTreeExpand;
			this.getLocationsTree()[methodName]();
		}
	},
	getExpandTreeData:function(record){
		var agent = '';
		var iconCls = '';
		var location = '';
		var test = '';
		var text = '';
		var type = '';
		
		var compIconCls='';
		var compLeaf='';
		var compRealName='';
		var compTest='';
		var compText='';
		var root2leafStr = '';
		var info = '';
		if( !Ext.isEmpty(record.parentNode) )
		{
			var parentOneData = record.parentNode;
			if( !Ext.isEmpty(parentOneData.raw) )
			{
				// if location has only one child goes here otherwise goto else . By Checking agent on first paren raw data 
				if( !Ext.isEmpty(parentOneData.raw.agent) )
				{
					agent = parentOneData.raw.agent;
					iconCls = parentOneData.raw.iconCls;
					location = parentOneData.raw.location;
					test = parentOneData.raw.test;
					text = parentOneData.raw.text;
					type = parentOneData.raw.type;
				}
				else
				{
					var parentTwo = parentOneData.parentNode
					if( !Ext.isEmpty( parentTwo ) )
					{
						agent = parentTwo.raw.agent;
						iconCls = parentTwo.raw.iconCls;
						location = parentTwo.raw.location;
						test = parentTwo.raw.test;
						text = parentTwo.raw.text;
						type = parentTwo.raw.type;
					}
				}
			}
		}
		if( !Ext.isEmpty(record.raw) )
		{
			if(!Ext.isEmpty(!Ext.isEmpty(record.raw.iconCls)))
				compIconCls = record.raw.iconCls;
			if(!Ext.isEmpty(!Ext.isEmpty(record.raw.leaf)))
				compLeaf = record.raw.leaf;
			if(!Ext.isEmpty(!Ext.isEmpty(record.raw.realName)))
				compRealName = record.raw.realName;
			if(!Ext.isEmpty(!Ext.isEmpty(record.raw.test)))
				compTest = record.raw.test;
			if(!Ext.isEmpty(!Ext.isEmpty(record.raw.text)))
				compText = record.raw.text;
		}
		location = ( Ext.isEmpty( location ) || location == 'default' )? agent:location;
		info = ( compRealName.lastIndexOf(":")+1);
		root2leafStr = location+'^eg^'+agent+'^eg^'+test+'^eg^'+compRealName+'^eg^'+compText+'^eg^'+compLeaf;
		return root2leafStr;
	},
	locationDrillDown:function(tree,record,item,index,e,eOpts){
		clearInterval(baseRefreshVal);
		var root2leafStr = (!Ext.isEmpty(record.raw.id))?record.raw.id:'';
		var real_comp_name = ''
		if(!Ext.isEmpty(record.raw) && !Ext.isEmpty(record.raw.realName) )
		{

			real_comp_name = record.raw.realName;
			var compArray = real_comp_name.split(":");
			if( compArray.length > 2 )
				real_comp_name = compArray[2];
			real_comp_name = real_comp_name.substring(1);
		}
		var me = this;
		if( (!Ext.isEmpty(record.data['leaf']) && (record.data['leaf'] == 'true' || record.data['leaf'] == true)) || (!Ext.isEmpty(record.raw.realName) && real_comp_name == 'summary')){
			var component = record.raw.realName;
			var test = record.raw.test;
			var monTreeKey = monTreeRefNode;
			if(test.indexOf(',') > 0)
				test = test.substring(0,test.indexOf(','));
			var site = 'NULL';
			Ext.Ajax.request({
				url:'/final/servlet/com.eg.EgExtMonDashController',
				method:'GET',
				params:{
					drillDown:'allLocations',
					component:component,
					test:test,
					site:site,
					eventTimeline:'1 hour',
					allLocAlarmPage:'yes'
				},
				disableCaching:false,
				success:function(response){
					var json = Ext.decode(response.responseText);
					if(Ext.isEmpty(json.summary))
					{
						Ext.Msg.alert('',' No data found');
					}
					else
					{
						var iconClsText = 'info_'+json.summary.state;
						me.getMain().removeAll(false);
						if(Ext.isEmpty(me.getComponentOverview())){
							me.getMain().add({
								xtype:'componentoverview',
								iconCls:iconClsText,
								component:component,
								test:test,
								site:site,
								comComponent:component,
								comTest:test,
								comSite:site,
								jsonData:json,
								parent:'base',
								selectedData:root2leafStr,
								selectedMonTree:monTreeKey
							});
						}
						else{
							me.getComponentOverview().setIconCls(iconClsText);
							me.getComponentOverview().component = component;
							me.getComponentOverview().test = test;
							me.getComponentOverview().site = site;
							me.getComponentOverview().comComponent = component;
							me.getComponentOverview().compTest = test;
							me.getComponentOverview().comSite = site;
							me.getComponentOverview().jsonData = json;
							me.getMain().add(me.getComponentOverview());
						}
					}
				}
			});
		}
		else if(!Ext.isEmpty(record.raw.type) && record.raw.type == 'monitors'){
			var test = record.raw.test;
			Ext.Ajax.request({
				url:'/final/servlet/com.eg.EgExtMonDashController',
				method:'GET',
				params:{
					drillDown:'monitors',
					test:test,
					agent:record.raw.agent,
					location:record.raw.location
				},
				disableCaching:false,
				success:function(response){
					var json = Ext.decode(response.responseText);

					var iconClsText = record.data['iconCls'];
					var titleText = record.data['text'];
					me.getMain().removeAll(false);
					if(Ext.isEmpty(me.getMonitorOverview())){
						me.getMain().add({
							xtype:'monitoroverview',
							title:titleText,
							iconCls:iconClsText,
							test:test,
							agent:record.raw.agent,
							location:record.raw.location,
							jsonData:json,
							parent:'base'
						});
					}
					else{
						me.getMonitorOverview().setIconCls(iconClsText);
						me.getMonitorOverview().setTitle(titleText);
						me.getMonitorOverview().jsonData = json;
						me.getMain().add(me.getMonitorOverview());
					}
				}
			});
		}
		/*else if(!Ext.isEmpty(record.raw.realName) && real_comp_name == 'summary')
		{
			var component = record.raw.realName;
			var test = record.raw.test;
			if(test.indexOf(',') > 0)
				test = test.substring(0,test.indexOf(','));
			var locations = record.raw.location;
			var site = record.raw.site;
			var agent = record.raw.location;
			agent = ( Ext.isEmpty(agent) || agent == 'default' )?record.raw.agent:agent;
			this.getMain().removeAll(false);
			Ext.Ajax.request({
				url:'/final/servlet/com.eg.EgExtMonDashController',
				method:'GET',
				params:{
					specificLocation:agent,
					component:component,
					test:test,
					site:site
				},
				disableCaching:false,
				success:function(response){
					var json = Ext.decode(response.responseText);
					if(!Ext.isEmpty(json.summary))
					{
						var iconClsText = json.summary.state;
						if( !Ext.isEmpty(test) && test == 'SyntheticTransTest' )
						{
							if(Ext.isEmpty(me.getTransactionOverview())){
								me.getMain().add({
									xtype:'transactionoverview',
									iconCls:iconClsText,
									component:component,
									test:test,
									site:site,
									summaryLocation:agent,
									summaryComponent:component,
									summaryTest:test,
									summarySite:site,
									jsonData:json,
									parent:'base',
									//selectedData:root2leafStr,
									//healthKey:healthSelectedKey,
									//selectedMonTree:monTreeKey
								});
							}
							else{
								me.getTransactionOverview().setIconCls(iconClsText);
								me.getTransactionOverview().component = component;
								me.getTransactionOverview().test = test;
								me.getTransactionOverview().site = site;
								me.getTransactionOverview().summaryLocation = agent;
								me.getTransactionOverview().summaryComponent = component;
								me.getTransactionOverview().summaryTest = test;
								me.getTransactionOverview().summarySite = site;
								me.getTransactionOverview().parent = 'componentoverview';
								//me.getLocationOverview().specificLocation = object.innerHTML;
								me.getTransactionOverview().jsonData = json;
								me.getMain().add(me.getTransactionOverview());
							}
						}
						else
						{
							if(Ext.isEmpty(me.getLocationOverview())){
								me.getMain().add({
									xtype:'locationoverview',
									iconCls:iconClsText,
									component:component,
									test:test,
									site:site,
									jsonData:json,
									parent:'base',
									selectedData:root2leafStr,
									treeKey:locationSelectedKey,
									selectedMonTree:monTreeKey
									//specificLocation:locations
								});
							}
							else{
								me.getLocationOverview().setIconCls(iconClsText);
								me.getLocationOverview().component = component;
								me.getLocationOverview().test = test;
								me.getLocationOverview().site = site;
								me.getLocationOverview().parent = 'base';
								//me.getLocationOverview().specificLocation = locations;
								me.getLocationOverview().jsonData = json;
								me.getMain().add(me.getLocationOverview());
							}
						}
					}
					else
					{
						me.getMain().add({
								xtype:'locationoverview',
								text:'<div style="font-weight:bold;text-align:center;padding:100px 0px"><img class="x-grid-empty-image" src="eg_images/gray/exclamation-icon.gif"/><br/>No data found</div>'
						});
					}
				}
			});
		}*/
	},

	getExpandedNode:function(node,eOpts){
		var me = this;
		if(!isAutoRefresh)
		{
			var path = node.getPath('text');
			if( !Ext.isEmpty(node.raw.id) )
			{
				treeRefNode = node.raw.id;
			}
			Ext.Ajax.request({
				url:'/final/monitor/externalMonitorsSessionState.jsp',
				params:{
					locationTreeState:Ext.encode(path),
					sessionParams:Ext.encode(me.setRequestParameters())
				},
				disableCaching:false
			});
		}
	},
	getMonTreeExpandedNode:function(node,eOpts){
		var me = this;
		if(!isAutoRefresh)
		{
			var path = node.getPath('text');
			if( !Ext.isEmpty(node.raw.id) )
			{
				monTreeRefNode = node.raw.id;
			}
			Ext.Ajax.request({
				url:'/final/monitor/externalMonitorsSessionState.jsp',
				params:{
					locationTreeState:Ext.encode(path),
					sessionParams:Ext.encode(me.setRequestParameters())
				},
				disableCaching:false
			});
		}
	},
	getHealthTreeNode:function(node,eOpts){
		if(!isAutoRefresh)
		{
			var me = this;
			var path = node.getPath('text');
			if( !Ext.isEmpty(node.raw.id) )
			{
				healthRefNode = node.raw.id;
			}
			Ext.Ajax.request({
				url:'/final/monitor/externalMonitorsSessionState.jsp',
				params:{
					healthTreeState:Ext.encode(path),
					sessionParams:Ext.encode(me.setRequestParameters())
				},
				disableCaching:false
			});
		}
	},

	treeStateManager:function(){
		if(Ext.isEmpty(locationTreeState))
			return false;
		var treePathArray = Ext.decode(locationTreeState);
		for(i=0;i<treePathArray.length;i++){
			this.getLocationsTree().expandPath(treePathArray[i],'text');
		}
	},

	healthTreeStateManager:function(){
		if(Ext.isEmpty(healthTreeState))
			return false;
		var treePathArray = Ext.decode(healthTreeState);
		for(i=0;i<treePathArray.length;i++){
			this.getHealthTree().expandPath(treePathArray[i],'text');
		}
	},
	allLocationFromHealthTree:function(tree,record,item,index,e,eOpts){
		clearInterval(baseRefreshVal);
		var me = this;
		if(!Ext.isEmpty(record.data['leaf']) && (record.data['leaf'] == 'true' || record.data['leaf'] == true))
		{
			var healthSelectedKey = healthRefNode;
			var locationSelectedKey = treeRefNode;
			var locations = "ALL";
			var component = record.raw.realName;
			var test = record.raw.test;
			var site = record.raw.site;
			var agent = "ALL";
			this.getMain().removeAll(false);
			Ext.Ajax.request({
				url:'/final/servlet/com.eg.EgExtMonDashController',
				method:'GET',
				params:{
					drillDown:'allLocations',
					allLocAlarmPage:'yes',
					//specificLocation:agent,
					component:component,
					test:test,
					site:site
				},
				disableCaching:false,
				success:function(response){
					var json = Ext.decode(response.responseText);
					if(!Ext.isEmpty(json.summary))
					{
						var iconClsText = json.summary.state;
						/*if( !Ext.isEmpty(test) && test == 'SyntheticTransTest' )
						{
							if(Ext.isEmpty(me.getTransactionOverview())){
								me.getMain().add({
									xtype:'transactionoverview',
									iconCls:iconClsText,
									component:component,
									test:test,
									site:site,
									summaryLocation:agent,
									summaryComponent:component,
									summaryTest:test,
									summarySite:site,
									jsonData:json,
									parent:'base',
									//selectedData:root2leafStr,
									//healthKey:healthSelectedKey
								});
							}
							else{
								me.getTransactionOverview().setIconCls(iconClsText);
								me.getTransactionOverview().component = component;
								me.getTransactionOverview().test = test;
								me.getTransactionOverview().site = site;
								me.getTransactionOverview().summaryLocation = agent;
								me.getTransactionOverview().summaryComponent = component;
								me.getTransactionOverview().summaryTest = test;
								me.getTransactionOverview().summarySite = site;
								me.getTransactionOverview().parent = 'componentoverview';
								//me.getLocationOverview().specificLocation = object.innerHTML;
								me.getTransactionOverview().jsonData = json;
								me.getMain().add(me.getTransactionOverview());
							}
						}
						else
						{*/
							if(Ext.isEmpty(me.getComponentOverview())){
								me.getMain().add({
									xtype:'componentoverview',
									iconCls:iconClsText,
									component:component,
									test:test,
									site:site,
									jsonData:json,
									parent:'base',
									//selectedData:root2leafStr,
									//treeKey:locationSelectedKey
									//specificLocation:locations
								});
							}
							else{
								me.getComponentOverview().setIconCls(iconClsText);
								me.getComponentOverview().component = component;
								me.getComponentOverview().test = test;
								me.getComponentOverview().site = site;
								me.getComponentOverview().parent = 'base';
								//me.getComponentOverview().specificLocation = locations;
								me.getComponentOverview().jsonData = json;
								me.getMain().add(me.getComponentOverview());
							}
						//}
					}
					else
					{
						me.getMain().add({
								xtype:'componentoverview',
								text:'<div style="font-weight:bold;text-align:center;padding:100px 0px"><img class="x-grid-empty-image" src="eg_images/gray/exclamation-icon.gif"/><br/>No data found</div>'
						});
					}
				}
			});
		}
	},
	specificLocationFromHealthTree:function(tree,record,item,index,e,eOpts){
		clearInterval(baseRefreshVal);
		var real_comp_name = ''
		if(!Ext.isEmpty(record.raw) && !Ext.isEmpty(record.raw.realName) )
		{

			real_comp_name = record.raw.realName;
			var compArray = real_comp_name.split(":");
			if( compArray.length > 2 )
				real_comp_name = compArray[2];
			real_comp_name = real_comp_name.substring(1);
		}
		var me = this;
		var root2leafStr = (!Ext.isEmpty(record.raw.id))?record.raw.id:'';
		if(!Ext.isEmpty(record.data['leaf']) && ((record.data['leaf'] == 'true' || record.data['leaf'] == true) || (!Ext.isEmpty(record.raw.realName) && real_comp_name == 'summary'))){
			var healthSelectedKey = healthRefNode;
			var locationSelectedKey = treeRefNode;
			var monTreeKey = monTreeRefNode;
			var locations = record.raw.location;
			var component = record.raw.realName;
			var test = record.raw.test;
			var site = record.raw.site;
			var agent = record.raw.location;
			locations = (Ext.isEmpty(locations) || locations == 'default')?record.raw.agent:locations;
			locations = ( locations.indexOf("default -") > -1 )?locations.substring(locations.indexOf("default -")+10):locations;
			locations = locations.trim();
			this.getMain().removeAll(false);
			Ext.Ajax.request({
				url:'/final/servlet/com.eg.EgExtMonDashController',
				method:'GET',
				params:{
					specificLocation:locations,
					component:component,
					test:test,
					site:site
				},
				disableCaching:false,
				success:function(response){
					var json = Ext.decode(response.responseText);
					if(!Ext.isEmpty(json.summary))
					{
						var iconClsText = json.summary.state;
						if( !Ext.isEmpty(test) && test == 'SyntheticTransTest' )
						{
							if(Ext.isEmpty(me.getTransactionOverview())){
								me.getMain().add({
									xtype:'transactionoverview',
									iconCls:iconClsText,
									component:component,
									test:test,
									site:site,
									summaryLocation:locations,
									summaryComponent:component,
									summaryTest:test,
									summarySite:site,
									jsonData:json,
									parent:'base',
									selectedData:root2leafStr,
									healthKey:healthSelectedKey,
									selectedMonTree:monTreeKey
								});
							}
							else{
								me.getTransactionOverview().setIconCls(iconClsText);
								me.getTransactionOverview().component = component;
								me.getTransactionOverview().test = test;
								me.getTransactionOverview().site = site;
								me.getTransactionOverview().parent = 'base';
								me.getTransactionOverview().summaryLocation = locations;
								me.getTransactionOverview().summaryComponent = component;
								me.getTransactionOverview().summaryTest = test;
								me.getTransactionOverview().summarySite = site;
								//me.getLocationOverview().specificLocation = object.innerHTML;
								me.getTransactionOverview().jsonData = json;
								me.getMain().add(me.getTransactionOverview());
							}
						}
						else
						{
							if(Ext.isEmpty(me.getLocationOverview())){
								me.getMain().add({
									xtype:'locationoverview',
									iconCls:iconClsText,
									component:component,
									test:test,
									site:site,
									jsonData:json,
									parent:'base',
									selectedData:root2leafStr,
									treeKey:locationSelectedKey,
									selectedMonTree:monTreeKey
									//specificLocation:locations
								});
							}
							else{
								me.getLocationOverview().setIconCls(iconClsText);
								me.getLocationOverview().component = component;
								me.getLocationOverview().test = test;
								me.getLocationOverview().site = site;
								me.getLocationOverview().parent = 'base';
								//me.getLocationOverview().specificLocation = locations;
								me.getLocationOverview().jsonData = json;
								me.getMain().add(me.getLocationOverview());
							}
						}
					}
					else
					{
						me.getMain().add({
								xtype:'locationoverview',
								text:'<div style="font-weight:bold;text-align:center;padding:100px 0px"><img class="x-grid-empty-image" src="eg_images/gray/exclamation-icon.gif"/><br/>No data found</div>'
						});
					}
				}
			});
		}
		else if(!Ext.isEmpty(record.raw.type) && record.raw.type == 'monitors'){
			var test = record.raw.test;
			Ext.Ajax.request({
				url:'/final/servlet/com.eg.EgExtMonDashController',
				method:'GET',
				params:{
					drillDown:'monitors',
					test:test,
					agent:record.raw.agent,
					location:record.raw.location
				},
				disableCaching:false,
				success:function(response){
					var json = Ext.decode(response.responseText);
					var iconClsText = record.data['iconCls'];
					var titleText = record.data['text'];
					me.getMain().removeAll(false);
					if(Ext.isEmpty(me.getMonitorOverview())){
						me.getMain().add({
							xtype:'monitoroverview',
							title:titleText,
							iconCls:iconClsText,
							test:test,
							agent:record.raw.agent,
							location:record.raw.location,
							jsonData:json,
							parent:'base'
						});
					}
					else{
						me.getMonitorOverview().setIconCls(iconClsText);
						me.getMonitorOverview().setTitle(titleText);
						me.getMonitorOverview().jsonData = json;
						me.getMain().add(me.getMonitorOverview());
					}
				}
			});
		}
	},
	getTreeExpand:function(locationTreeParam,dataId,from){
		if(locationTreeParam !==null && locationTreeParam !=='null')
		{
			// Store selected node for further refresh
			var myNode;
			var treePanel='';
			if(from == 'locationTree' )
			{
				treePanel = this.getLocationsTree();
				treeRefNode = locationTreeParam;
			}
			else
			{
				treePanel = this.getMonitorTree();
				monTreeRefNode = locationTreeParam;
			}
			var myRoot = treePanel.getRootNode();
			var rootRawId = (dataId == 'id' )?myRoot.raw.id:myRoot.raw.locid;
			if(rootRawId === locationTreeParam)
			{
				myNode=myRoot;
				treePanel.getSelectionModel().select(myNode);
			}
			else
			{
				myNode=myRoot.findChild(dataId,locationTreeParam);
				if(myNode===null){
					var breakIteration = false;
					myRoot.eachChild(function(child){
						var getChild=function(child){
							if(!breakIteration){
								myNode=child.findChild(dataId,locationTreeParam);
								if(myNode===null){
									child.eachChild(function(innerChild){
										getChild(innerChild);
									});
								}
								else{
									treePanel.getSelectionModel().select(myNode);
									breakIteration = true;
								}
							}
						}
						getChild(child);
					});
				} else {
					treePanel.getSelectionModel().select(myNode);
				}
			}
			var selectedNodeDepth="";
			if(!Ext.isEmpty(myNode))
				selectedNodeDepth=myNode.getDepth();
			var selected=myNode;
			for(var i=0; i < selectedNodeDepth; i++){
				if(selected.isLeaf()){
					selected.parentNode.expand();
				}
				else{
					selected.expand();
				}
				selected=selected.parentNode;
			}
		}
	},
	getHealthTreeExpand:function(parameters,dataId){
		if(parameters !==null && parameters !=='null')
		{
			// Store selected node for further refresh
			healthRefNode = parameters;
			var myNode;
			var treePanel='';
			treePanel = this.getHealthTree();
			var myRoot = treePanel.getRootNode();
			var rootRawId = myRoot.raw.id;
			if(rootRawId === parameters)
			{
				myNode=myRoot;
				treePanel.getSelectionModel().select(myNode);
			}
			else
			{
				myNode=myRoot.findChild(dataId,parameters);
				if(myNode===null){
					var breakIteration = false;
					myRoot.eachChild(function(child){
						var getChild=function(child){
							if(!breakIteration){
								myNode=child.findChild(dataId,parameters);
								if(myNode===null){
									child.eachChild(function(innerChild){
										getChild(innerChild);
									});
								}
								else{
									treePanel.getSelectionModel().select(myNode);	
									breakIteration = true;
								}
							}
						}
						getChild(child);
					});
				} else {
					treePanel.getSelectionModel().select(myNode);
				}
			}
			var selectedNodeDepth="";
			if(!Ext.isEmpty(myNode))
				selectedNodeDepth=myNode.getDepth();
			var selected=myNode;
			for(var i=0; i < selectedNodeDepth; i++){
				if(selected.isLeaf()){
					selected.parentNode.expand();
				}
				else{
					selected.expand();
				}
				selected=selected.parentNode;
			}
		}
		isAutoRefresh = false;
	},
	getBaseRefresh:function( locationTreeParam, healthTreeParam, monitorTreeParam ){
		isAutoRefresh = true;
		locationTreeParam = (Ext.isEmpty(treeRefNode) || treeRefNode == 'root')?locationTreeParam:treeRefNode;
		healthTreeParam = (Ext.isEmpty(healthRefNode) )?healthTreeParam:healthRefNode;
		monitorTreeParam = (Ext.isEmpty(monTreeRefNode) )?monitorTreeParam:monTreeRefNode;
		var param = Ext.encode(this.setRequestParameters());
		var monName = Ext.isEmpty(this.getMonitors().getValue())?'ALL':this.getMonitors().getValue();
		if(!Ext.isEmpty(sessionUrl))
			param = sessionUrl;
		var me = this;
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgExtMonDashController',
			method:'GET',
			params:{reqObject:param},
			disableCaching:false,
			success:function(response){
				var json = Ext.decode(response.responseText);
				me.getBase().setData(json.dropDowns);
				me.getLocationsTree().setData(json);
				me.treeStateManager();
				me.getTreeExpand(locationTreeParam,'id','locationTree');
				if(!Ext.isEmpty(json.monitorGroupBy))
				{
					me.getMonitorTree().setData(json);
					me.getTreeExpand(monitorTreeParam,'id','monitorTree');
				}
				else
				{
					me.getMonitorTree().setEmptyPanel();
					me.getMonitorTree().hide();
				}
				if(!Ext.isEmpty(json.healthChartPanel) && !Ext.isEmpty(json.healthChartPanel.chartJson)){
					me.renderHealthChart(json.healthChartPanel.chartJson,json);
					me.getHealthTree().show();
					me.getHealthTree().setRootNode(json.healthChartPanel.healthTree);
					me.healthTreeStateManager();
					me.getHealthTreeExpand(healthTreeParam,'id');
					
				}
				else{
					me.getHealthChart().setEmptyPanel();
					me.getHealthTree().hide();
				}
				if(!Ext.isEmpty(json.monitorProblemsPanel))
					me.getProblemMonitorsStore().loadData(json.monitorProblemsPanel);
				else
				{
					me.getProblemMonitorsStore().removeAll();
					me.getProblemMonitors().setEmptyPanel();
				}
				if(!Ext.isEmpty(json.subOptimalsPanel))
					me.getSubOptimalsStore().loadData(json.subOptimalsPanel);
				else
				{
					me.getSubOptimalsStore().removeAll();
				}

				if(!Ext.isEmpty(json.mapMarkers)){
					me.getLocationsMap().show();
					me.getLocationsMap().clearMapMarkers();
					me.getLocationsMap().setMapMarkers(json.mapMarkers);
				}
				else{
					me.getLocationsMap().hide();
				}
			},
			failure:function(){
				me.getHealthChart().setEmptyPanel();
				me.getProblemMonitors().setEmptyPanel();
			}
		});
	},
		openMarkerInfoWindow:function(infoWindow, map, marker){
			var divId = marker.title+"_ID";
			if(infoWin.length == 0)
				infoWin.push(infoWindow);
			else{
				for(var l=0;l<infoWin.length;l++){
					var old_infoWindow = infoWin[l];
					old_infoWindow.close();
				}
				infoWin = new Array();
				infoWin.push(infoWindow);
			}
			var content = "<div class ='popup-style-gmap' style='overflow:hidden;border:none;' id='"+divId+"'><table style='width:auto;height:auto;overflow:hidden;font-size:11px;' border=0>";	
			var criticalExists = false;
			var locationsArray = mapInfoWindowData;
			if(locationsArray!=null && locationsArray.length>0){
				for(i=0;i<locationsArray.length;i++){
					if(locationsArray[i].location==marker.title){
						var monitorsArray = locationsArray[i].monitors;
						if(monitorsArray!=null && monitorsArray.length>0){
							for(j=0;j<monitorsArray.length;j++){
								var monitor = monitorsArray[j];
								if(monitor.iconCls !="GOOD" && monitor.iconCls !="UNKNOWN"){
									criticalExists = true;
									content+="<tr>";
									content+="<td align=\"left\" style=\"padding:3px;width:20px\"><img  src='/final/images/clear.png' class=\"state_"+monitor.iconCls+"\"></td>";
									content+="<td align=\"left\" style=\"white-space: nowrap\"><a style=\"color:black;\" href='javascript:void(0);' onClick='javascript:redirectToMonitorOverview(\""+locationsArray[i].location+"\",\""+monitor.name+"\",\"state_footer_"+monitor.iconCls+"\",\""+monitor.test+"\",\""+monitor.agent+"\");'>"+monitor.name+"</a></td>";
									content+="</tr>";
								}
							}
						}
					}
				}
			}
			content+="</table></div>";
			if(criticalExists){
				infoWindow.setContent(content);
				infoWindow.open(map,marker);
			}
		},
		redirectToMonitorOverview:function(location,name,state,test,agent){
			clearInterval(baseRefreshVal);
			var me = this;
			Ext.Ajax.request({
				url:'/final/servlet/com.eg.EgExtMonDashController',
				method:'GET',
				params:{
					drillDown:'monitors',
					test:test,
					agent:agent,
					location:location
				},
				disableCaching:false,
				success:function(response){
					var json = Ext.decode(response.responseText);
					me.getMain().removeAll(false);
					me.getMain().add({
						xtype:'monitoroverview',
						title:name,
						iconCls:state,
						test:test,
						agent:agent,
						location:location,
						jsonData:json,
						parent:'base'
					});
				}
			});
		},
		redirectToSummaryTransactionOverview:function(location,component,test,site,parent,monTest,monLocation,monAgent,monTitle,monState){
			clearInterval(baseRefreshVal);
			parent = (Ext.isEmpty(parent))?"base":parent;
			var me = this;
			Ext.Ajax.request({
				url:'/final/servlet/com.eg.EgExtMonDashController',
				method:'GET',
				params:{
					specificLocation:location,
					component:component,
					test:test,
					site:site
				},
				disableCaching:false,
				success:function(response){
					var json = Ext.decode(response.responseText);
					locStr = json;
					var iconClsText = '';
					if(!Ext.isEmpty(json.summary))
						 iconClsText = 'state_'+json.summary.state;
					else
						iconClsText = 'state_GOOD';
					if( !Ext.isEmpty(test) && test == 'SyntheticTransTest' )
					{
						me.getMain().add({
							xtype:'transactionoverview',
							iconCls:iconClsText,
							component:component,
							test:test,
							site:site,
							monTest:monTest,
							monLocation:monLocation,
							monAgent:monAgent,
							monTitle:monTitle,
							monState:monState,
							summaryLocation:location,
							summaryComponent:component,
							summaryTest:test,
							summarySite:site,	 
							jsonData:json,
							parent:parent
						});
					}
				}
				
			});
		},
		redirectToComponentOverview:function(component,test,site){
			clearInterval(baseRefreshVal);
			var me = this;
			Ext.Ajax.request({
				url:'/final/servlet/com.eg.EgExtMonDashController',
				method:'GET',
				params:{
					drillDown:'allLocations',
					component:component,
					test:test,
					site:site
				},
				disableCaching:false,
				success:function(response){
					var json = Ext.decode(response.responseText);
					var iconClsText = 'info_'+json.summary.state;
					me.getMain().removeAll(false);
					if(Ext.isEmpty(me.getComponentOverview())){
						me.getMain().add({
							xtype:'componentoverview',
							iconCls:iconClsText,
							component:component,
							test:test,
							site:site,
							comComponent:component,
							comTest:test,
							comSite:site,	 
							jsonData:json,
							parent:'base'
						});
					}
				}
			});
		},
		redirectToLocationOverview:function(){
			clearInterval(baseRefreshVal);
			var me = this;
			var component = "";
			var iconClsText = "";
			var test = "";
			var site = "";
			var location = "";
			Ext.Ajax.request({
				url:'/final/servlet/com.eg.EgExtMonDashController',
				method:'GET',
				params:{
					drillDown:'monitors',
					test:test,
					agent:agent,
					location:location
				},
				disableCaching:false,
				success:function(response){
					var json = Ext.decode(response.responseText);
					me.getMain().removeAll(false);
					me.getMain().add({
						xtype:'locationoverview',
						iconCls:iconClsText,
						component:component,
						test:test,
						site:site,
						jsonData:json,
						parent:'base'//,
						//selectedData:root2leafStr,
						//treeKey:locationSelectedKey,
						//selectedMonTree:monTreeKey
						//specificLocation:locations
					});
				}
			});
		}
			
});