Ext.define('EMDashboard.controller.ComponentOverview',{
	extend:'Ext.app.Controller',
	stores:['Overview','Alarms'],
	views:['Main','Base','ComponentOverview','Graph','OverviewGrid','LocationOverviewGrid','ComponentOverviewStatusSummary','LocationOverview','GraphContainer','TransactionOverview','MonitorOverview','Alarms'],
	compRefVar:null,
	treeHiddenData:null,
	healthHiddenData: null,
	monTreeHiddenData: null,
	refs:[{
		selector:'main',
		ref:'main'
	},{
		selector:'base',
		ref:'base'
	},{
		selector:'componentoverview',
		ref:'componentOverview'
	},{
		selector:'componentoverview graphcontainer',
		ref:'graphContainer'
	},{
		selector:'componentoverview container[itemId=errContId]',
		ref:'errorContainer'
	},{
		selector:'locationoverview',
		ref:'locationOverview'
	},{
		selector:'transactionoverview',
		ref:'transactionOverview'
	},{
		selector:'monitoroverview',
		ref:'monitorOverview'
	},{
		selector:'overviewgrid',
		ref:'overviewGrid'
	},{
		selector:'locationoverviewgrid',
		ref:'locationOverviewGrid'
	},{
		selector:'componentoverview componentoverviewstatussummary',
		ref:'statusSummary'
	},{
		selector:'graphcontainer',
		ref:'graphcontainer'
	},{
		selector:'componentoverview graphcontainer combo[itemId=timelineFilter]',
		ref:'timelineContainer'
	},{
		selector:'componentoverview combo[itemId=locationFilter]',
		ref:'locationContainer'
	},{
		selector:'locationoverview combo[itemId=locationFilter]',
		ref:'locationContainer2'
	},{
		selector:'base combo#monitors',
		ref:'monitors'
	},{
		selector:'base combo#filters',
		ref:'filters'
	},{
		selector:'base combo#subFilters',
		ref:'subFilters'
	},{
		selector:'base locationstree combo[itemId=severity]',
		ref:'severity'
	},{
		selector:'componentoverview combo[itemId=alarmFilter]',
		ref:'alarmContainer'
	}],

	init:function(){
		this.control({
			'main componentoverview':{
				added:this.loadPage,
				afterrender:this.loadLoc,
				boxready:this.setRefresh
			},
			'main componentoverview button[action=back]':{
				click:this.backHandler
			},
			'componentoverview combo[itemId=locationFilter]':{
				boxready:this.graphFilterChange
			},
			'main combo[itemId=timelineFilter]':{
				select:this.graphChange
			},
			'main graph':{
				boxready:this.loadGraph
			},
			'componentoverview combo[itemId=locationFilter]':{
				select:this.reloadPage
			},
			'main componentoverview combo[itemId=alarmFilter]':{
				select:this.alarmChanged
			}
		});
	},
	setRefresh:function(){
		compRefreshVal = setInterval('refresh("ComponentOverview")',refreshRate);
	},
	loadLoc:function(componentoverview,eOpts){
		var json = this.getComponentOverview().jsonData;
		if(!Ext.isEmpty(json))
		{
			var dynamicStore = Ext.create('Ext.data.Store',{
				autoLoad:true,
				fields:json.locations
			});
			this.getLocationContainer().hide();
			this.getLocationContainer().getStore().loadRawData(json.locations.options);
			this.getLocationContainer().setValue(json.locations.selected);
		}
		else
			this.getLocationContainer().hide();
	},
	loadPage:function(componentoverview,eOpts){
		if(!Ext.isEmpty(baseRefreshVal))
			clearInterval(baseRefreshVal);
		if(!Ext.isEmpty(locRefreshVal))
			clearInterval(locRefreshVal);

		if(!Ext.isEmpty(this.getComponentOverview()))
		{
			var json = this.getComponentOverview().jsonData;
			if( !Ext.isEmpty(json))
			{
				if(!Ext.isEmpty(this.getAlarmsStore()))
					this.getAlarmsStore().removeAll(false);

				hiddenData = '';//this.getComponentOverview().selectedData;
				healthHiddenData = '';//this.getComponentOverview().healthKey;
				healthHiddenData = this.getComponentOverview().selectedData;
				treeHiddenData = this.getComponentOverview().treeKey;
				monTreeHiddenData = this.getComponentOverview().selectedMonTree;
				var allItems = this.getGraphContainer().items.items;
				for(k=allItems.length-1;k>-1;k--){
					allItems[k].destroy();
				}
				if( !Ext.isEmpty( json ) && !Ext.isEmpty(json.graphs) ){
					var graphs = json.graphs;
					var flg=false;
					for(i=0;i<graphs.length;i++){
						var panelId = 'graphPanel_'+i;
						var timeLineId = 'timelineFilter_'+i;
						var graphTitleContainerId = 'graphPanelTitleContainer_'+i;
						var mgsty="12 12 12 0";
						if(flg)
						{
							mgsty="12 0 12 0";
							flg=false;
						}
						else 
							flg=true;
						var graphPanelTitle = (Ext.isEmpty(graphs[i].panelTitle))?'':graphs[i].panelTitle;
						graphPanelTitle = ( Ext.isEmpty(graphPanelTitle) )?graphs[i].tempTitle:graphPanelTitle;
						this.getGraphContainer().show();
						this.getGraphContainer().add({
							xtype:'panel',
							cls:'emdDatapanel',
							frame:true,
							height: 300,
							padding:0,
							layout:{type:'vbox',align:'stretch'},
							id:panelId,
							margin:mgsty,
							style:{'border':'0px solid yellow'},
							dockedItems:[
								{
									xtype:'toolbar',
									dock:'top',
									cls:'emdDocked',
									padding:'10 10 0 10',
									items:[
										{
											xtype:'container',
											cls:'emdDatapanelHeader',
											html:graphPanelTitle,
											id:graphTitleContainerId
										},
										'->',
										{
											xtype:'combo',	
											cls:'dropdown',
											id:timeLineId,
											index: i,
											measureName: graphs[i].realMeasuareName,
											location: json.locations.selected,
											component:componentoverview.component,
											fieldLabel:'Show',
											margin:'0 0 0 5',
											labelWidth:35,
											queryMode:'local',
											labelSeparator:'',
											width:120,
											displayField:'display',
											valueField:'value',
											value:'1 hour',
											editable:false,
											store:Ext.create('Ext.data.Store',{
												fields:['display','value'],
												data:[
													{display:'1 hour',value:'1 hour'},
													{display:'3 hours',value:'3 hours'},
													{display:'6 hours',value:'6 hours'},
													{display:'12 hours',value:'12 hours'},
													{display:'18 hours',value:'18 hours'},
													{display:'24 hours',value:'24 hours'},
													{display:'2 days',value:'2 days'},
													{display:'3 days',value:'3 days'},
													{display:'4 days',value:'4 days'},
													{display:'5 days',value:'5 days'},
													{display:'6 days',value:'6 days'},
													{display:'1 week',value:'1 week'},
													{display:'2 weeks',value:'2 weeks'},
													{display:'3 weeks',value:'3 weeks'},
													{display:'4 weeks',value:'4 weeks'},
													{display:'1 month',value:'1 month'}
												]							
											}),
											listeners: {
											"select": function (obj) {
												updateGraph(obj.index, obj.measureName, obj.location, "fromComponent",obj.component,'');
												}
											}
										}
									]
								}
							],
							items:[
								{
								xtype:'graph',
								height:250,
								style:{'position':'absolute'},
								data:graphs[i],
								parent:'componentoverview',
								realMeasure:graphs[i].realMeasuareName
							}],
						});
					}
				}
				else{
					this.getGraphContainer().add({
						xtype:'container',
						columnWidth:1,
						html:'<center><div style="margin:5% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div class="commonErrorMsgText">No data found</div></div></center>'
					});
				}
				if(!Ext.isEmpty(json) && !Ext.isEmpty(json.grid)){
					this.getLocationOverviewGrid().show();
					var dynamicStore = Ext.create('Ext.data.Store',{
						autoLoad:true,
						fields:json.grid.fields,
						data:json.grid.data
					});
					if( json.grid.data.length > 3 )
					{
						Ext.getCmp('pagenationId').show();
					}
					this.getLocationOverviewGrid().reconfigure(dynamicStore,json.grid.columns);
				}
				if( !Ext.isEmpty(json) && !Ext.isEmpty(json.summary)){
					this.getStatusSummary().show();
					this.getStatusSummary().setData(json.summary);
					this.getComponentOverview().setTitle(json.summary.title);
					this.getComponentOverview().setIconCls(json.summary.state);
				}
				if( !Ext.isEmpty(json) && !Ext.isEmpty(json.alarms)){
					this.getAlarmsStore().loadRawData(json.alarms);
				}
				if(!Ext.isEmpty(this.getTimelineContainer()))
					this.getTimelineContainer().setValue("1 hour");
			}
			else
			{
				this.getErrorContainer().show()
				this.getGraphContainer().hide();
				this.getStatusSummary().hide();
				this.getLocationOverviewGrid().hide();
			}
		}
		
	},
	backHandler:function(button){
		clearInterval(compRefreshVal);		
		var componentParent = this.getComponentOverview().parent;
		var items = this.getMain().items.items;
		for(i=items.length-1;i>-1;i--){
			items[i].destroy();
		}
		if( !Ext.isEmpty(this.getComponentOverview()) )
		{
			this.getComponentOverview().destroy();
		}
		if(componentParent == 'locationoverview')
		{
			this.getMain().add(this.getLocationOverview());
		}
		else
		{
			baseRefreshVal = setInterval('refresh("BaseController")',refreshRate);
			this.getMain().add(this.getBase());
			EMDashboard.app.getController('BaseController').getBaseRefresh(hiddenData, treeHiddenData, monTreeHiddenData);
		}
	},
	
	loadGraph:function(graph,width,height,eOpts){
		var me = this;
		if(!Ext.isEmpty(graph.data.DataSet)){
			var gWidth = ( graph.getWidth() > 1000 )?graph.getWidth() / 2:graph.getWidth();
			graph.data['fromPage'] = 'seum';
			var lineChart = {};
			lineChart = jQuery.extend(true, {}, getHighCharts(graph.getId(),graph.getHeight(),gWidth-40,''), lineChart);
			lineChart.setData(graph.data,currentDateFormat,'','','right');
			lineChart.drawChart();
		}
		else{
			var myhtml = '<center><div style="margin:20% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div class="commonErrorMsgText">No data found</div></div></center>';
			var chartContObj=document.getElementById(graph.getId());
			if(chartContObj == null || chartContObj == undefined)
				chartContObj = Ext.getCmp(graph.getId());
			if(chartContObj!=null)
			{
				chartContObj.innerHTML=myhtml;
			}
		}
	},

	specificLocation:function(object){
		clearInterval(compRefreshVal);
		var me = this;
		var mask = new Ext.LoadMask(me.getComponentOverview(), {msg:"Loading...",cls:'maskDashUpperGrid'});
		mask.show();
		var loc = object.innerHTML;
		var component = me.getComponentOverview().component;
		var test = me.getComponentOverview().test;
		var site = me.getComponentOverview().site;
		var comComponent = me.getComponentOverview().comComponent;
		var comTest = me.getComponentOverview().comTest;
		var comSite = me.getComponentOverview().comSite;
		this.getMain().removeAll(false);		
		var locStr;
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgExtMonDashController',
			method:'GET',
			params:{
				specificLocation:loc,
				component:component,
				test:test,
				site:site
			},
			disableCaching:false,
			success:function(response){
				var json = Ext.decode(response.responseText);
				locStr = json;
				var iconClsText = '';
				if(!Ext.isEmpty(json.summary))
					 iconClsText = 'state_'+json.summary.state;
				else
					iconClsText = 'state_GOOD';
				if( !Ext.isEmpty(test) && test == 'SyntheticTransTest' )
				{	me.getComponentOverview().destroy();
					if(Ext.isEmpty(me.getTransactionOverview())){
						me.getMain().add({
							xtype:'transactionoverview',
							iconCls:iconClsText,
							component:component,
							test:test,
							site:site,
							comComponent:comComponent,
							comTest:comTest,
							comSite:comSite,
							jsonData:json,
							parent:'componentoverview'
						});
					}
					else{
						me.getTransactionOverview().setIconCls(iconClsText);
						me.getTransactionOverview().component = component;
						me.getTransactionOverview().test = test;
						me.getTransactionOverview().site = site;
						me.getComponentOverview().comComponent = comComponent;
						me.getComponentOverview().compTest = comTest;
						me.getComponentOverview().comSite = comSite;
						me.getTransactionOverview().parent = 'componentoverview';
						me.getTransactionOverview().jsonData = json;
						me.getMain().add(me.getTransactionOverview());
					}
				}
				else
				{
					if(Ext.isEmpty(me.getLocationOverview())){
						me.getMain().add({
							xtype:'locationoverview',
							iconCls:iconClsText,
							component:component,
							test:test,
							site:site,
							jsonData:json,
							parent:'componentoverview'
						});
					}
					else{
						me.getLocationOverview().setIconCls(iconClsText);
						me.getLocationOverview().component = component;
						me.getLocationOverview().test = test;
						me.getLocationOverview().site = site;
						me.getLocationOverview().parent = 'componentoverview';
						me.getLocationOverview().jsonData = json;
						me.getMain().add(me.getLocationOverview());
					}
				}
			}
		});
		if(!Ext.isEmpty(mask)){
        			mask.hide();
        		}
	},
	graphFilterChange:function(combo,record,eOpts,componentoverview){
		var me = this;
		var locationCombo = this.getLocationContainer();
		if(!Ext.isEmpty(this.getComponentOverview()))
		{
			var json = this.getComponentOverview().jsonData;
			locationCombo.getStore().loadRawData(json.locations.options);
			locationCombo.setValue(json.locations.selected);
		}
	},
	graphChange:function(combo,record,eOpts){
		var me = this;
		var graph = combo.up('graphcontainer');
		var timelineCombo = this.getTimelineContainer();
		var locationCombo = this.getLocationContainer();
		var dataBank = me.getComponentOverview();
		if(Ext.isEmpty(dataBank))
			dataBank = me.getLocationOverview();
		var graphs = graph.items.items;
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgExtMonDashController',
			method:'GET',
			params:{
				realMeasure:'NONE',
				test:dataBank.test,
				component:dataBank.component,
				graphTimelineChange:timelineCombo.getValue(),
				graphLocationChange:locationCombo.getValue()
			},
			disableCaching:false,
			success:function(response){
				var json = Ext.decode(response.responseText);
				locationCombo.getStore().loadRawData(json.locations.options);
				locationCombo.setValue(json.locations.selected);
				for(i=0;i<graphs.length;i++){
					graphs[i].data = json.graph[i];
					graphs[i].fireEvent('boxready',graphs[i]);
				}
			}
		});
	},
	updateGraphTimeLine:function(index, measure, location, fromPage, component,fromReq ){
		var me = this;
		var graphPanel = Ext.getCmp('graphPanel_'+index);
		var timelineCombo = Ext.getCmp('timelineFilter_'+index);
		var graphTitleContainerId = Ext.getCmp('graphPanelTitleContainer_'+index);
		var locationValue = location;
		var agent = locationValue.substring(locationValue.lastIndexOf("^")+1);
		locationValue = locationValue.substring(0,locationValue.indexOf("^"));
		var isFromMonitor = "no";
		var dataBank = me.getComponentOverview();
		if(fromPage=='fromLocation')
			dataBank = me.getLocationOverview();
		else if(fromPage=='fromComponent')
			dataBank = me.getComponentOverview();
		else if(fromPage=='fromTransaction')
			dataBank = me.getTransactionOverview();
		else
		{
			dataBank = me.getMonitorOverview();
			isFromMonitor = "yes";
		}
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgExtMonDashController',
			method:'GET',
			params:{
				drillDown: 'monitorsGraph',
				graphMeasure: measure,
				test:dataBank.test,
				agent:agent,
				graphTimeline:timelineCombo.getValue(),
				location:locationValue,
				component:component,
				fromReq:fromReq,
				isFromMonitor:isFromMonitor
			},
			disableCaching:false,
			success:function(response){
				var json = Ext.decode(response.responseText);
				var graphs = graphPanel.items.items;
				var graphTitle = (Ext.isEmpty(json.measGraph[0].panelTitle))?'':json.measGraph[0].panelTitle;
				graphTitle = ( Ext.isEmpty(graphTitle) )?json.measGraph[0].tempTitle:graphTitle;
				if(!Ext.isEmpty(graphTitleContainerId)){
					graphTitleContainerId.update(graphTitle);
				}else{
					graphPanel.setTitle(graphTitle);
				}
				for(k=0;k<graphs.length;k++){
					if(graphs[k].getXType()=='graph'){
						graphs[k].data = json.measGraph[0];
						graphs[k].fireEvent('boxready',graphs[k]);
					}
				}
			},
			failure:function(){
				alert("failure");
			}
		});
	},

	loadCompRefreshPage:function(combo){
		var me = this;
		var graph = this.getGraphContainer();
		var locationCombo = this.getLocationContainer();
		var dataBank = me.getComponentOverview();
		if(Ext.isEmpty(dataBank))
			dataBank = me.getLocationOverview();
		var graphs = graph.items.items;
		var locaStr = locationCombo.getValue().toLowerCase();
		locaStr = locaStr.trim();
		if(!Ext.isEmpty(locaStr) && locaStr == 'all')
		{
			Ext.Ajax.request({
				url:'/final/servlet/com.eg.EgExtMonDashController',
				method:'GET',
				params:{
					drillDown:"allLocations",
					component:dataBank.component,
					test:dataBank.test,
				},
				disableCaching:false,
				success:function(response){
						var json = Ext.decode(response.responseText);
						me.updateRefreshPage(json,'alllocation');
					}
			});
		}
		else
		{
			Ext.Ajax.request({
				url:'/final/servlet/com.eg.EgExtMonDashController',
				method:'GET',
				params:{
					realMeasure:'NONE',
					drillDown:'refresh',
					test:dataBank.test,
					component:dataBank.component,
					//graphTimelineChange:timelineCombo.getValue(),
					graphLocationChange:locationCombo.getValue()

				},
				disableCaching:false,
				success:function(response){
					var json = Ext.decode(response.responseText);
					me.updateRefreshPage(json,'specific');
				}
			});
		}
		
	},
	updateRefreshPage:function(json,fromReq){
		var me = this;
		var locationCombo = this.getLocationContainer();
		var graph = this.getGraphContainer();
		var graphs = graph.items.items;
		var dataBank = me.getComponentOverview();
		if(Ext.isEmpty(dataBank))
			dataBank = me.getLocationOverview();

		if(!Ext.isEmpty(json)){

			if(!Ext.isEmpty(json.grid)){
				var dynamicStore = Ext.create('Ext.data.Store',{
					autoLoad:true,
					fields:json.grid.fields,
					data:json.grid.data
				});
				me.getLocationOverviewGrid().reconfigure(dynamicStore,json.grid.columns);
			}
			if(!Ext.isEmpty(json.summary)){
				me.getStatusSummary().setData(json.summary);
				me.getComponentOverview().setTitle(json.summary.title);
				me.getComponentOverview().setIconCls(json.summary.state);
			}
			locationCombo.getStore().loadRawData(json.locations.options);
			locationCombo.setValue(json.locations.selected);
			var items = graph.items.items;
			var length = items.length;
			var timeLineArray = new Array();
			for(x=0;x<length;x++){
				timeLineArray.push(Ext.getCmp('timelineFilter_'+x).getValue());
			}
			for(i=0;i<graphs.length;i++){
				var panelId = 'graphPanel_'+i;
				var timeLineId = 'timelineFilter_'+i;
				var graphPanel = Ext.getCmp(panelId);
				var graphInstance = graphPanel.items.items;
				for(k=0;k<graphInstance.length;k++){
					if(graphInstance[k].getXType()=='graph'){
						graphInstance[k].data = graphs[i];
						graphInstance[k].fireEvent('boxready',graphInstance[k]);
					}
				}
				var timeLineCombo = Ext.getCmp(timeLineId);
				timeLineCombo.setValue(timeLineArray[i]);
				updateGraph(timeLineCombo.index, timeLineCombo.measureName, locationCombo.getValue(), "fromComponent",dataBank.component,fromReq);
			}
		}
	},
	reloadPage:function(componentoverview,eOpts,combo){		
		if(!Ext.isEmpty(this.getComponentOverview())){
			var me = this;
			var thisObj = this.getComponentOverview();
			var component = thisObj.component;
			var test = thisObj.test;
			var specLoc = componentoverview.rawValue;
			var site = thisObj.site;


			var locaStr = specLoc.toLowerCase();
			locaStr = locaStr.trim();
			if(!Ext.isEmpty(locaStr) && locaStr == 'all')
			{
				Ext.Ajax.request({
					url:'/final/servlet/com.eg.EgExtMonDashController',
					method:'GET',
					params:{
						drillDown:"allLocations",
						component:component,
						test:test,
						site:site,
					},
					disableCaching:false,
					success:function(response){
							var json = Ext.decode(response.responseText);
							me.updateReloadPage(json,componentoverview);
						}
				});
			}
			else
			{
				Ext.Ajax.request({
					url:'/final/servlet/com.eg.EgExtMonDashController',
					method:'GET',
					params:{
						specificLocation:specLoc,
						component:component,
						test:test,
						site:site
					},
					disableCaching:false,
					success:function(response){
						var json = Ext.decode(response.responseText);
							me.updateReloadPage(json,componentoverview);
						}
				});
			}
			
		}
	},
	updateReloadPage:function(json,componentoverview)
	{
		var me = this;
		if(!Ext.isEmpty(json.summary))
		{
			
			if(!Ext.isEmpty(me.getOverviewStore()))
			{
				me.getOverviewStore().removeAll(false);
			}
			if(!Ext.isEmpty(json.alarms)){
				me.getOverviewStore().loadRawData(json.grid.data);
			}
			if(!Ext.isEmpty(json.summary)){
				me.getStatusSummary().setData(json.summary);
				me.getComponentOverview().setTitle(json.summary.title);
				me.getComponentOverview().setIconCls(json.summary.state);
			}

			var allItems = me.getGraphContainer().items.items;
			for(k=allItems.length-1;k>-1;k--){
				if(allItems[k].getId().indexOf("graphPanel_")>-1){
					allItems[k].destroy();
				}
			}
			if(!Ext.isEmpty(json) && !Ext.isEmpty(json.graphs)){
				var graphs = json.graphs;
				for(i=0;i<graphs.length;i++){
					var panelId = 'graphPanel_'+i;
					var timeLineId = 'timelineFilter_'+i;
					var graphTitleContainerId = 'graphPanelTitleContainer_'+i;
					var flg=false;
					var mgsty="8 8 8 0";
						if(flg)
						{
							mgsty="8 0 8 0";
							flg=false;
						}
						else 
							flg=true;

					var graphItem =  {
						xtype:'container',
						//style:{'background':'#fff'},
						frame:true,
						padding:0,
						layout:{type:'vbox',align:'stretch'},
						id:panelId,
						margin:mgsty,
						header:false,
						dockedItems:[
							{
								xtype:'toolbar',
								dock:'top',
								items:[{
											xtype:'container',
											cls:'emdDatapanelHeader',
											html:graphs[i].panelTitle,
											id:graphTitleContainerId
										},
										{
											xtype: 'tbfill'
										},
										{
										xtype:'combo',	
										cls:'dropdown',
										id:timeLineId,
										index: i,
										measureName: graphs[i].realMeasuareName,
										location: json.locations.selected,
										component:componentoverview.component,
										fieldLabel:'Show',
										margin:'0 0 0 5',
										labelWidth:35,
										queryMode:'local',
										width:120,
										displayField:'display',
										valueField:'value',
										value:'1 hour',
										editable:false,
										store:Ext.create('Ext.data.Store',{
											fields:['display','value'],
											data:[
												{display:'1 hour',value:'1 hour'},
												{display:'3 hours',value:'3 hours'},
												{display:'6 hours',value:'6 hours'},
												{display:'12 hours',value:'12 hours'},
												{display:'18 hours',value:'18 hours'},
												{display:'24 hours',value:'24 hours'},
												{display:'2 days',value:'2 days'},
												{display:'3 days',value:'3 days'},
												{display:'4 days',value:'4 days'},
												{display:'5 days',value:'5 days'},
												{display:'6 days',value:'6 days'},
												{display:'1 week',value:'1 week'},
												{display:'2 weeks',value:'2 weeks'},
												{display:'3 weeks',value:'3 weeks'},
												{display:'4 weeks',value:'4 weeks'},
												{display:'1 month',value:'1 month'}
											]							
										}),
										listeners: {
											"select": function (obj) {
												updateGraph(obj.index, obj.measureName, obj.location, "fromComponent",obj.component);
											}
										}
												
									}]
							}
						
						],

						items:[
							{
								xtype:'container',
								items:[
								{
									xtype:'graph',
									style:{'border':'0px solid yellow'},
									layout:'anchor',
									header:false,
									anchor:'100%',
									margin:0,
									padding:0,
									data:graphs[i],
									parent:'componentoverview',
									realMeasure:graphs[i].realMeasuareName
								}
								]
							}],
					};
					me.getGraphContainer().insert(i+1,graphItem);
				}
			}
			else{
				me.getGraphContainer().insert(0,{
					xtype:'container',
					itemId:'errorPanel',
					columnWidth:1,
					html:'<center><div style="margin:10% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div class="commonErrorMsgText">No data found</div></div></center>'
				});
			}
		}
		else
		{
			me.getMain().add({
					xtype:'componentoverview',
					text:'<center><div style="margin:10% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div class="commonErrorMsgText"> No data found</div></div></center>'
			});
		}
	},
	alarmChanged:function(combo,record,eOpts){
		var me = this;
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgExtMonDashController',
			method:'GET',
			params:{
				alarmsTimeline:combo.getValue(),
				component:me.getComponentOverview().component,
				test:me.getComponentOverview().test,
				site:me.getComponentOverview().site,
				specificLocation:me.getComponentOverview().specificLocation,
				allLocAlarmPage:'yes'
			},
			disableCaching:false,
			success:function(response){
				var alarms = Ext.decode(response.responseText);
				me.getAlarmsStore().loadRawData(alarms);
			}
		});
	}
});