Ext.define('EMDashboard.controller.LocationOverview',{
	extend:'Ext.app.Controller',
	stores:['Alarms'],
	views:['Main','Base','ComponentOverview','LocationOverview','StatusSummary','Alarms','GraphContainer','ComponentOverviewStatusSummary'],
	requires:['EMDashboard.view.StatusSummary'],
	intVar:null,
	hiddenData:null,
	treeHiddenData:null,
	monTreeHiddenData:null,
	refs:[{
		selector:'main',
		ref:'main'
	},{
		selector:'base',
		ref:'base'
	},{
		selector:'componentoverview',
		ref:'componentOverview'
	},{
		selector:'locationoverview',
		ref:'locationOverview'
	},{
		selector:'locationoverview graphcontainer',
		ref:'itemContainer'
	},{
		selector:'locationoverview combo[itemId=alarmFilter]',
		ref:'alarmContainer'
	},{
		selector:'locationoverview statussummary',
		ref:'statussummary'
	},{
		selector:'locationoverview componentoverviewstatussummary',
		ref:'allSummary'
	},{
		selector:'locationoverview overviewgrid[itemId=syntheticGrid]',
		ref:'syntheticGrid'
	},{
		selector:'alarms',
		ref:'alarms'
	},{
		selector:'locationoverview panel[itemId=succScreen]',
		ref:'successImage'
	},{
		selector:'locationoverview graphcontainer combo[itemId=timelineFilter]',
		ref:'timelineContainer'
	},{
		selector:'graphcontainer',
		ref:'graphcontainer'
	},{
		selector:'locationoverview combo[itemId="locationFilter"]',
		ref:'locationFilterOBJ'
	},{
		selector:'locationoverview combo[itemId=locationFilter]',
		ref:'locationContainer2'
	},{
		selector:'componentoverview graphcontainer ',
		ref:'compFilterOBJ'
	},{
		selector:'locationoverview container',
		ref:'allItemContainer'
	},{
		selector:'locationoverview container[itemId=locErrContId]',
		ref:'locErrorContainer'
	}],

	init:function(){
		this.control({
			'main locationoverview':{
				'afterrender':this.loadLocations,
				added:this.loadPage,
				boxready:this.setLocRefresh
			},
			'main locationoverview button[action=back]':{
				click:this.backHandler
			},
			'main locationoverview combo[itemId=alarmFilter]':{
				select:this.alarmChanged
			},
			'main locationoverview graph combo[itemId=locationFilter]':{
				render:this.hideLocations
			},
			'locationoverview combo[itemId=locationFilter]':{
				select:this.reloadPage
			},
			'locationoverview graph': {
				//beforerender:this.loadLocations
			}
		});
	},
	setLocRefresh:function(){
		locRefreshVal = setInterval('refresh("LocationOverview")',refreshRate);
	},
	loadLocations:function(combo,record,eOpts,locationOverview){
		var me = this;
		var locationCombo = this.getLocationContainer2();
		//if(!Ext.isEmpty(this.getLocationOverview()))
		{
			var json = this.getLocationOverview().jsonData;
			if(!Ext.isEmpty(json))
			{
				this.getLocationContainer2().show();
				locationCombo.getStore().loadRawData(json.locations.options);
				locationCombo.setValue(json.locations.selected);
			}
			else
				this.getLocationContainer2().hide();
		}
	},
	reloadPage:function(locationoverview,eOpts,combo){
		if(!Ext.isEmpty(this.getLocationOverview())){
			var me = this;
			var thisObj = this.getLocationOverview();
			var component = thisObj.component;
			var test = thisObj.test;
			var specLoc = locationoverview.rawValue;
			var site = thisObj.site;
			if(!Ext.isEmpty(specLoc) && specLoc == 'All')
			{
				Ext.Ajax.request({
					url:'/final/servlet/com.eg.EgExtMonDashController',
					method:'GET',
					params:{
						drillDown:"allLocations",
						component:component,
						test:test,
						site:site
					},
					disableCaching:false,
					success:function(response){
						var json = Ext.decode(response.responseText);
						me.updateReloadPage(locationoverview,json,'alllocation');
					}
				});
			}
			else
			{
				Ext.Ajax.request({
					url:'/final/servlet/com.eg.EgExtMonDashController',
					method:'GET',
					params:{
						specificLocation:specLoc,
						component:component,
						test:test,
						site:site
					},
					disableCaching:false,
					success:function(response){
						var json = Ext.decode(response.responseText);
						me.updateReloadPage(locationoverview,json,'specific');
					}
				});
			}
		}
	},
	updateReloadPage:function(locationoverview,json,fromReq){
		var me = this;
		var currentPageObj = this.getLocationOverview();
		if(!Ext.isEmpty(json))
		{			
			if(!Ext.isEmpty(json) && !Ext.isEmpty(json.summary)){
				var iconClsText = json.summary.state;
				if(fromReq == 'alllocation')
				{
					if(!Ext.isEmpty( currentPageObj.down('panel[itemId=overviewSummary]') ))
						currentPageObj.down('panel[itemId=overviewSummary]').setData(json.summary);
					me.getLocationOverview().setTitle(json.summary.title);
					me.getLocationOverview().setIconCls(json.summary.state);
				}
				else
				{
					if(!Ext.isEmpty( currentPageObj.down('panel[itemId=overviewSummary]') ))
						currentPageObj.down('panel[itemId=overviewSummary]').setData(json.summary);
					me.getLocationOverview().setTitle(json.summary.title);
					me.getLocationOverview().setIconCls(json.summary.state);
				}
			}else{				
				me.getLocationOverview().setTitle("");
				me.getLocationOverview().setIconCls("");
				currentPageObj.down('panel[itemId=overviewSummary]').setData(json.summary);
			}
			if(!Ext.isEmpty(me.getAlarmsStore()))
			{
				me.getAlarmsStore().removeAll(false);
			}
			if(!Ext.isEmpty(json.alarms)){
				me.getAlarmsStore().loadRawData(json.alarms);
			}
			var items = me.getLocationOverview().items.items;
			var graphItems = new Array();
			for(z=0;z<items.length;z++){
				if(items[z].getId().indexOf("graphPanel_")>-1){
					graphItems.push(items[z]);
				}
			}
			var length = graphItems.length;
			var timeLineArray = new Array();
			for(x=0;x<length;x++){
				timeLineArray.push(Ext.getCmp('timelineFilter_'+x).getValue());
			}
			var graphs = json.graphs;
			for(i=0;i<graphs.length;i++){
				var panelId = 'graphPanel_'+i;
				var timeLineId = 'timelineFilter_'+i;
				var graphPanel = Ext.getCmp(panelId);				
				var graphInstance = graphPanel.items.items[0];
				graphInstance.data = graphs[i];
				graphInstance.fireEvent('boxready',graphInstance);
				var timeLineCombo = Ext.getCmp(timeLineId);
				timeLineCombo.setValue('1 hour');
				//updateGraph(timeLineCombo.index, timeLineCombo.measureName, timeLineCombo.location, "fromLocation");
			}
		}
		else
		{			
			me.getMain().add({
					xtype:'locationoverview',
					text:'<div style="font-weight:bold;text-align:center;padding:100px 0px"><img class="x-grid-empty-image" src="eg_images/gray/exclamation-icon.gif"/><br/>No data found</div>'
			});
		}
	},
	loadSingleHCGraph:function(json,locationoverview,fromReq,i){
		var me = this;
		if(!Ext.isEmpty(json) && !Ext.isEmpty(json.graphs)){
			var graphs = json.graphs;
			//for(i=0;i<graphs.length;i++){
			var panelId = 'graphPanel_'+i;
			var timeLineId = 'timelineFilter_'+i;
			var graphTitleContainerId = 'graphPanelTitleContainer_'+i; 
			var flg=false;
			var mgsty="0 12 12 0";
				if(flg)
				{
					mgsty="0 0 12 0";
					flg=false;
				}
				else 
					flg=true;
			var graphPanelTitle = (Ext.isEmpty(graphs[i].panelTitle))?'':graphs[i].panelTitle;
			graphPanelTitle = ( Ext.isEmpty(graphPanelTitle) )?graphs[i].tempTitle:graphPanelTitle;
			var graphItem =  {
				xtype:'panel',
				cls:'emdDatapanel',
				style:{'border':'0px solid green'},
				frame:true,
				padding:0,
				title:graphPanelTitle,
				height:'auto',
				id:panelId,
				draggable: {moveOnDrag: false},
				margin:mgsty,
				columnWidth:.5,
				tools:[
						{
						xtype:'combo',	
						margin:'14 7 0 0',
						cls:'dropdown',
						id:timeLineId,
						index: i,
						measureName: graphs[i].realMeasuareName,
						location: json.locations.selected,
						component:locationoverview.component,
						fieldLabel:'Show',
						labelWidth:35,
						queryMode:'local',
						width:120,
						displayField:'display',
						valueField:'value',
						value:'1 hour',
						editable:false,
						store:Ext.create('Ext.data.Store',{
							fields:['display','value'],
							data:[
								{display:'1 hour',value:'1 hour'},
								{display:'3 hours',value:'3 hours'},
								{display:'6 hours',value:'6 hours'},
								{display:'12 hours',value:'12 hours'},
								{display:'18 hours',value:'18 hours'},
								{display:'24 hours',value:'24 hours'},
								{display:'2 days',value:'2 days'},
								{display:'3 days',value:'3 days'},
								{display:'4 days',value:'4 days'},
								{display:'5 days',value:'5 days'},
								{display:'6 days',value:'6 days'},
								{display:'1 week',value:'1 week'},
								{display:'2 weeks',value:'2 weeks'},
								{display:'3 weeks',value:'3 weeks'},
								{display:'4 weeks',value:'4 weeks'},
								{display:'1 month',value:'1 month'}
							]							
						}),
						listeners: {
							"select": function (obj) {
								updateGraph(obj.index, obj.measureName, obj.location, "fromLocation",obj.component,fromReq);
							}
						}
					}
				],
				items:[{
					xtype:'graph',
					height:250,
					data:graphs[i],
					parent:'locationoverview',
					realMeasure:graphs[i].realMeasuareName
				}],
			};
			return graphItem;
		}
		else{
			var graphItem =  {
				xtype:'container',
				itemId:'errorPanel',
				draggable: {moveOnDrag: false},
				columnWidth:1,
				html:'<div style="font-weight:bold;text-align:center;padding:100px 0px"><img class="x-grid-empty-image" src="eg_images/gray/exclamation-icon.gif"/><br/>No data found</div>'
			};
			return graphItem;
		}
	},
	loadHCGraph:function(json,locationoverview,fromReq){
		var me = this;
		var allItems = this.getAllItemContainer().items.items;
		for(k=allItems.length-1;k>-1;k--){
			if(allItems[k].getId().indexOf("graphPanel_")>-1){
				allItems[k].destroy();
			}
		}
		if(!Ext.isEmpty(json) && !Ext.isEmpty(json.graphs)){
			var graphs = json.graphs;
			for(i=0;i<graphs.length;i++){
				var panelId = 'graphPanel_'+i;
				var timeLineId = 'timelineFilter_'+i;
				var graphTitleContainerId = 'graphPanelTitleContainer_'+i; 
				var flg=false;
				var mgsty="0 12 12 0";
					if(flg)
					{
						mgsty="0 0 12 0";
						flg=false;
					}
					else 
						flg=true;
				var graphPanelTitle = (Ext.isEmpty(graphs[i].panelTitle))?'':graphs[i].panelTitle;
				var graphItem =  {
					xtype:'panel',
					cls:'emdDatapanel',
					style:{'border':'0px solid yellow'},
					frame:true,
					padding:0,
					height:'auto',
					id:panelId,
					draggable: {moveOnDrag: false},
					margin:mgsty,
					columnWidth:.5,
					dockedItems:[
						{
							xtype:'toolbar',
							padding:'5 10 5 10',
							cls:'emdDocked',
							dock:'top',
							items:[
									{
										xtype:'container',
										cls:'emdDatapanelHeader',
										html:graphPanelTitle,
										id:graphTitleContainerId
									},
									'->',
									{
									xtype:'combo',	
									cls:'dropdown',
									id:timeLineId,
									index: i,
									measureName: graphs[i].realMeasuareName,
									location: json.locations.selected,
									component:locationoverview.component,
									fieldLabel:'Show',
									margin:'0 0 0 5',
									labelWidth:35,
									queryMode:'local',
									width:120,
									displayField:'display',
									valueField:'value',
									value:'1 hour',
									editable:false,
									store:Ext.create('Ext.data.Store',{
										fields:['display','value'],
										data:[
											{display:'1 hour',value:'1 hour'},
											{display:'3 hours',value:'3 hours'},
											{display:'6 hours',value:'6 hours'},
											{display:'12 hours',value:'12 hours'},
											{display:'18 hours',value:'18 hours'},
											{display:'24 hours',value:'24 hours'},
											{display:'2 days',value:'2 days'},
											{display:'3 days',value:'3 days'},
											{display:'4 days',value:'4 days'},
											{display:'5 days',value:'5 days'},
											{display:'6 days',value:'6 days'},
											{display:'1 week',value:'1 week'},
											{display:'2 weeks',value:'2 weeks'},
											{display:'3 weeks',value:'3 weeks'},
											{display:'4 weeks',value:'4 weeks'},
											{display:'1 month',value:'1 month'}
										]							
									}),
									listeners: {
										"select": function (obj) {
											updateGraph(obj.index, obj.measureName, obj.location, "fromLocation",obj.component,fromReq);
										}
									}
											
								}	
							]
						}	
					],
					items:[{
						xtype:'graph',
						height:300,
						data:graphs[i],
						parent:'locationoverview',
						realMeasure:graphs[i].realMeasuareName
					}],
				};
				me.getAllItemContainer().add(graphItem);
			}
		}
		else{
			me.getAllItemContainer().add({
				xtype:'container',
				itemId:'errorPanel',
				margin:'0 0 10 0',
				draggable: {moveOnDrag: false},
				columnWidth:1,
				html:'<div style="font-weight:bold;text-align:center;padding:100px 0px"><img class="x-grid-empty-image" src="eg_images/gray/exclamation-icon.gif"/><br/>No data found</div>'
			});
		}
	},
	getColumnValues:function(json,locationoverview){
		var me = this;
		var allPositions = {};
		var ajaxRes = '';
		Ext.Ajax.request({
			url:'/final/monitor/externalMonitorsSessionState.jsp',
			params:{getPosition:true,viewName:'locationoverview'},
			disableCaching:false,
			success:function(response){
				var jsonRes = Ext.decode(response.responseText);
				ajaxRes = (!Ext.isEmpty(jsonRes.position))?jsonRes.position:'';
				if( Ext.isEmpty(ajaxRes) )
				{
					var columnPanels = "statussummary,alarms";
					var panelNames = "statussummary,alarms";
					var graphs = json.graphs;
					var graphPanels = ",";
					var graphPanelNames = ",";
					for(i=0;i<graphs.length;i++)
					{
						graphPanels = graphPanels+"panel,";
						graphPanelNames = graphPanelNames+"highchart,";
					}
					if(!Ext.isEmpty(json.alarms)){
					}
					columnPanels = columnPanels+graphPanels;
					panelNames = panelNames+graphPanelNames;
					columnPanels = columnPanels.substring(0,columnPanels.length-1);
					panelNames = panelNames.substring(0,panelNames.length-1);
					var splitedColumn = columnPanels.split(",");
					var splitedPanelNames = panelNames.split(",");
					var spLen = splitedColumn.length;
					var colLen = 0;
					var isOdd = false;
					var colPositionsObj = {};
					var panelPositionsObj = {};
					if( spLen % 2 == 0)
					{
						 colLen = spLen/2;
						 // column panels
						var colOne = [];
						var colTwo = [];
						// name of the panel to render
						var colPanelOne = [];
						var colPanelTwo = [];
						for(var a=0;a<colLen;a++)
						{
							colOne[a]=splitedColumn[a];
							colPanelOne[a]=splitedPanelNames[a];
						}
						var inc = 0;
						for(var a=colLen;a<splitedColumn.length;a++)
						{
							colTwo[inc]=splitedColumn[a];
							colPanelTwo[inc]=splitedPanelNames[a];
							inc = inc+1;
						}
						colPositionsObj ={ 'col-1':colOne,'col-2':colTwo}
						panelPositionsObj ={ 'col-1':colPanelOne,'col-2':colPanelTwo}
					}
					else
					{
						isOdd = true;
						colLen = spLen/2;
						colLen = Math.round(colLen);
						var colOne = [];
						var colTwo = [];
						// name of the panel to render
						var colPanelOne = [];
						var colPanelTwo = [];
						for(var a=0;a<colLen;a++)
						{
							colOne[a]=splitedColumn[a];
							colPanelOne[a]=splitedPanelNames[a];
						}
						var inc = 0;
						for(var a=colLen; a < splitedColumn.length;a++)
						{
							colTwo[inc]=splitedColumn[a];
							colPanelTwo[inc]=splitedPanelNames[a];
							inc = inc+1;
						}
						colPositionsObj ={ 'col-1':colOne,'col-2':colTwo}
						panelPositionsObj ={ 'col-1':colPanelOne,'col-2':colPanelTwo}
					}
					allPositions = {'columns':colPositionsObj,'panels':panelPositionsObj};
					me.getPageUpdateByIni(json,allPositions,locationoverview);
				}
				else
				{
					allPositions = {'columns':ajaxRes,'panels':ajaxRes};
					me.getPageUpdateByIni(json,allPositions,locationoverview);
				}
			}
		});
	},
	loadPage:function(locationoverview,eOpts,combo){
		if( !Ext.isEmpty(this.getLocationOverview()) )
		{
			hiddenData = this.getLocationOverview().selectedData;
			treeHiddenData = this.getLocationOverview().treeKey;
			monTreeHiddenData = this.getLocationOverview().selectedMonTree;
			var json = this.getLocationOverview().jsonData;
			this.getColumnValues(json,locationoverview);
		}
	},
	getPageUpdateByIni:function(json,allPositions,locationoverview){
		if( !Ext.isEmpty(this.getLocationOverview()) && !Ext.isEmpty(json))
		{
			var me = this;
			hiddenData = this.getLocationOverview().selectedData;
			treeHiddenData = this.getLocationOverview().treeKey;
			monTreeHiddenData = this.getLocationOverview().selectedMonTree;
			var overAllPositions = allPositions;
			var columnPositions = overAllPositions['columns'];
			var panelPositions = overAllPositions['panels'];
			if(!Ext.isEmpty(this.getItemContainer()))
				this.getItemContainer().removeAll();
			if(!Ext.isEmpty(this.getCompFilterOBJ()))
				this.getCompFilterOBJ().removeAll();
			if(!Ext.isEmpty(this.getAlarmsStore()))
				this.getAlarmsStore().removeAll(false);
			this.getLocationOverview().setLoading('Loading image...');
			if(!Ext.isEmpty(Ext.getCmp("firstCon")))
				Ext.getCmp("firstCon").removeAll(false);
			if(!Ext.isEmpty(Ext.getCmp("secCon")))
				Ext.getCmp("secCon").removeAll(false);

			this.items = [];
			var chartCount = 0;
			for(var key in columnPositions){
				var columnItems = columnPositions[key];
				var columnPanelItems = panelPositions[key];
				var column = {
					xtype:'container',
					columnWidth:.50,
					layout:'anchor',
					padding:'0 0 0 0',
					style:{'border':'0px solid yellow'},
					id:key
				};
				var insertItems = [];
				for(j=0;j<columnItems.length;j++){
					var panelNameStr = columnPanelItems[j];
					if( panelNameStr == 'highchart' || panelNameStr.indexOf('graphPanel_') > -1 )
					{
						chartCount = ( panelNameStr.indexOf('graphPanel_') > -1 )?panelNameStr.substring(11):chartCount;
						var chartObj = this.loadSingleHCGraph(json,locationoverview,'spec',chartCount);
						insertItems.push(chartObj);
						chartCount = chartCount+1;
					}
					else if(panelNameStr == 'statussummary')
					{
						insertItems.push({
							xtype:'statussummary',
							frame:true,
							padding:0,
							cls:'emdDatapanel',
							columnWidth:.5,
							itemId:'overviewSummary',
							margin:'0 12 12 0',
							bodyPadding:'0 10 10 10',
							height:'auto',
							dockedItems:[
								{
									xtype:'toolbar',
									cls:'emdDocked'
								}
							],
							draggable: {moveOnDrag: false},
							listeners: {
									"afterrender": function (currObj) {
										if(!Ext.isEmpty(json) && !Ext.isEmpty(json.summary)){
											currObj.setData(json.summary);
										}
										else
										{
											me.getStatussummary().update('<center><div style="margin:4% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div class="commonErrorMsgText">No data found</div></div></center>');
										}
									}
							}
						});
					}
					else if(panelNameStr == 'alarms')
					{
						insertItems.push({
							xtype:'alarms',
							frame:true,
							padding:0,
							cls:'emdGrid',
							style:{'border':'0px solid yellow'},
							bodyPadding:'0 10 10 10',
							height:'auto',
							columnWidth:.5,
							margin:'0 12 12 0',
							draggable: {moveOnDrag: false},
						});
					}
				}
				column.items = insertItems;
				if(key=='col-1' || key == 'firstCon' )
				{
					Ext.getCmp("firstCon").add(insertItems);
				}
				if(key=='col-2' || key == 'secCon' )
				{
					Ext.getCmp("secCon").add(insertItems);
				}
			}
			if(!Ext.isEmpty(json))
			{
				/*me.getAllItemContainer().add({
					xtype:'container',
					itemId:'errorPanel',
					draggable: {moveOnDrag: false},
					margin:'0 0 10 0',
					columnWidth:1,
					html:'<div style="font-weight:bold;text-align:center;margin:10% 0 aut 0"> No data found</div>'
				});
				var errMsgs = '<div style="font-weight:bold;text-align:center;margin:10% 0 aut 0"><img class="x-grid-empty-image" src="eg_images/gray/exclamation-icon.gif"/><br/>No data found</div>';
			}
			else
			{*/
				if(!Ext.isEmpty(json.alarms)){
					this.getAlarmsStore().loadRawData(json.alarms);
				}
			}
			if(!Ext.isEmpty(json) && !Ext.isEmpty(json.summary)){
				this.getLocationOverview().setTitle(json.summary.title);
				this.getLocationOverview().setIconCls(json.summary.state);
			}
			this.getLocationOverview().setLoading(false);
			if(!Ext.isEmpty(json) && !Ext.isEmpty(json.locations)){
				var dynamicStore = Ext.create('Ext.data.Store',{
						autoLoad:true,
						fields:json.locations
				});
			}
			if(!Ext.isEmpty(this.getLocationContainer2()))
			{
				var as = this.getLocationContainer2().getStore();
				//as.loadRawData(json.locations.options);
			}			
		}
		else
		{
			this.getLocErrorContainer().show()
		}
	},
	backHandler:function(button){
		clearInterval(locRefreshVal);		
		var locationParent = this.getLocationOverview().parent;
		var items = this.getMain().items.items;
		for(i=items.length-1;i>-1;i--){
			items[i].destroy();
		}
		if(!Ext.isEmpty(this.getLocationOverview()))
			this.getLocationOverview().destroy();

		if(locationParent == 'componentoverview')
		{
			this.getMain().add(this.getComponentOverview());
		}
		else if(locationParent == 'base')
		{
			baseRefreshVal = setInterval('refresh("BaseController")',refreshRate);
			this.getMain().add(this.getBase());
			EMDashboard.app.getController('BaseController').getBaseRefresh(hiddenData, treeHiddenData, monTreeHiddenData);
		}
		else
		{
			baseRefreshVal = setInterval('refresh("BaseController")',refreshRate);
			this.getMain().add(this.getBase());
			EMDashboard.app.getController('BaseController').getBaseRefresh(hiddenData, treeHiddenData, monTreeHiddenData);
		}
	},

	alarmChanged:function(combo,record,eOpts){
		var me = this;
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgExtMonDashController',
			method:'GET',
			params:{
				alarmsTimeline:combo.getValue(),
				component:me.getLocationOverview().component,
				test:me.getLocationOverview().test,
				site:me.getLocationOverview().site,
				specificLocation:me.getLocationOverview().specificLocation,
				
			},
			disableCaching:false,
			success:function(response){
				var alarms = Ext.decode(response.responseText);
				me.getAlarmsStore().loadRawData(alarms);
			}
		});
	},

	hideLocations:function(combo,eOpts){
		var parentName = combo.up('graph').parent;
		var locationName = combo.up('locationoverview').specificLocation;
		if(parentName == 'locationoverview'){
			combo.setValue(locationName);
			combo.hide();
		}
	},
	loadLocationRefreshPage:function(){
		var me = this;
		var locaStr = me.getLocationContainer2().getRawValue().toLowerCase();
		locaStr = locaStr.trim();
		if(!Ext.isEmpty(locaStr) && locaStr == 'all')
		{
			Ext.Ajax.request({
				url:'/final/servlet/com.eg.EgExtMonDashController',
				method:'GET',
				params:{
					drillDown:"allLocations",
					component:me.getLocationOverview().component,
					test:me.getLocationOverview().test,
					site:me.getLocationOverview().site,
					isFromRefresh:'yes'
				},
				disableCaching:false,
				success:function(response){
					var json = Ext.decode(response.responseText);
					me.updateRefreshData(json,'alllocation');
				}
			});
		}
		else
		{
			Ext.Ajax.request({
				url:'/final/servlet/com.eg.EgExtMonDashController',
				method:'GET',
				params:{
					eventTimeline:this.getAlarmContainer().getValue(),
					component:me.getLocationOverview().component,
					test:me.getLocationOverview().test,
					site:me.getLocationOverview().site,
					specificLocation:me.getLocationContainer2().getRawValue(),
					graphLocationChange:me.getLocationContainer2().getValue(),
					isFromRefresh:'yes'
				},
				disableCaching:false,
				success:function(response){
					var json = Ext.decode(response.responseText);
					me.updateRefreshData(json,'specific');
				}
			});
		}
	},
	updateRefreshData:function(json,fromReq){
		var me = this;
		var currentPageObj = this.getLocationOverview();
		if(!Ext.isEmpty(json)){
			if(fromReq == 'alllocation')
			{
				if(!Ext.isEmpty(currentPageObj.down('panel[itemId=overviewSummary]')))
					currentPageObj.down('panel[itemId=overviewSummary]').setData(json.summary);
				me.getLocationOverview().setTitle(json.summary.title);
				me.getLocationOverview().setIconCls(json.summary.state);
			}
			else
			{
				if(!Ext.isEmpty(currentPageObj.down('panel[itemId=overviewSummary]')))
					currentPageObj.down('panel[itemId=overviewSummary]').setData(json.summary);
				me.getLocationOverview().setTitle(json.summary.title);
				me.getLocationOverview().setIconCls(json.summary.state);
			}
			var graphs = json.graphs;
			var items = me.getAllItemContainer().items.items;
			var graphItems = new Array();
			for(z=0;z<items.length;z++){
				if(items[z].getId().indexOf("graphPanel_")>-1){
					graphItems.push(items[z]);
				}
			}
			var length = graphItems.length;
			var timeLineArray = new Array();
			for(x=0;x<length;x++){
				timeLineArray.push(Ext.getCmp('timelineFilter_'+x).getValue());
			}
			for(i=0;i<graphs.length;i++){
				var panelId = 'graphPanel_'+i;
				var timeLineId = 'timelineFilter_'+i;
				var graphPanel = Ext.getCmp(panelId);
				var graphInstance = graphPanel.items.items[0];
				graphInstance.data = graphs[i];
				graphInstance.fireEvent('boxready',graphInstance);
				var timeLineCombo = Ext.getCmp(timeLineId);
				timeLineCombo.setValue(timeLineArray[i]);
				updateGraph(timeLineCombo.index, timeLineCombo.measureName, timeLineCombo.location, "fromLocation",me.getLocationOverview().component,fromReq);
			}
			me.getAlarmsStore().loadRawData(json.alarms);
		}
	},
	savePositions:function(ob){
		var me = this;
		var panelPositions = {};
		var panelItems = this.getLocationOverview().items.items;
		for(i=0;i<panelItems.length;i++){
			if(panelItems[i].getXType() == 'container'){
				var innerXTypes = [];
				var innerItems = panelItems[i].items.items;
				for(j=0;j<innerItems.length;j++){
					var itemXtype = innerItems[j].getXType();
					if(itemXtype == 'panel')
					{
						innerXTypes.push(innerItems[j].id);
					}
					else
						innerXTypes.push(innerItems[j].getXType());
				}
				panelPositions[panelItems[i].getId()] = innerXTypes;
			}
		}
		Ext.Ajax.request({
			url:'/final/monitor/externalMonitorsSessionState.jsp',
			params:{
				position:Ext.encode(panelPositions),
				viewName:'locationoverview'
			},
			disableCaching:false
		});
	}
		
});