Ext.define('EMDashboard.controller.MonitorOverview',{
	extend:'Ext.app.Controller',
	views:['Main','Base','MonitorOverview','OverviewGrid','GraphContainer','TransactionOverview','LocationOverview'],
	monTest:null,
	monAgent:null,
	monLocation:null,
	refs:[{
		selector:'main',
		ref:'main'
	},{
		selector:'base',
		ref:'base'
	},{
		selector:'monitoroverview',
		ref:'monitorOverview'
	},{
		selector:'locationoverview',
		ref:'locationOverview'
	},{
		selector:'transactionoverview',
		ref:'transactionOverview'
	},{
		selector:'main combo[itemId=monitorGraphsTimelineFilter1]',
		ref:'timelineCombo'
	},{
		selector:'main combo[itemId=monitorGraphsTimelineFilter2]',
		ref:'timeCombo'
	},{
		selector:'main combo[itemId=monitorGraphsLocationFilter]',
		ref:'locationCombo'
	},{
		selector:'monitoroverview graphcontainer',
		ref:'itemContainer'
	},{
		selector:'monitoroverview container',
		ref:'allItemContainer'
	}],

	init:function(){
		this.control({
			'main monitoroverview':{
				afterrender:this.loadLocations,
				added:this.loadPage,
				boxready:this.setMonitorRefresh
			},
			'main monitoroverview button[action=back]':{
				click:this.backHandler
			},
			'main monitoroverview combo[itemId=monitorGraphsTimelineFilter1]':{
				select:this.timeFilterChange
			},
			'main monitoroverview combo[itemId=monitorGraphsTimelineFilter2]':{
				select:this.timeFilterChange
			},
			'main monitoroverview combo[itemId=monitorGraphsLocationFilter]':{
				select:this.fiteringOverview
			}
		});
	},
	setMonitorRefresh:function()
	{
		monitorRefreshVal = setInterval('refresh("MonitorOverview")',refreshRate);
	},
	loadLocations:function(monitoroverview){
		if(!Ext.isEmpty(this.getLocationCombo()) && !Ext.isEmpty(monitoroverview.jsonData.locations)){
			this.getLocationCombo().getStore().loadRawData(monitoroverview.jsonData.locations.options);
			this.getLocationCombo().setValue(monitoroverview.jsonData.locations.selected);
		}
	},
	getColumnValues:function(json,monitoroverview){
		var me = this;
		var allPositions = {};
		var ajaxRes = '';
		Ext.Ajax.request({
			url:'/final/monitor/externalMonitorsSessionState.jsp',
			params:{getPosition:true,viewName:'monitoroverview'},
			disableCaching:false,
			success:function(response){
				var jsonRes = Ext.decode(response.responseText);
				ajaxRes = (!Ext.isEmpty(jsonRes.position))?jsonRes.position:'';
				if( Ext.isEmpty(ajaxRes) )
				{
					var columnPanels = "overviewgrid";
					var panelNames = "overviewgrid";
					var graphs = json.graphs;
					var graphPanels = ",";
					var graphPanelNames = ",";
					for(i=0;i<graphs.length;i++)
					{
						graphPanels = graphPanels+"panel,";
						graphPanelNames = graphPanelNames+"highchart,";
					}
					columnPanels = columnPanels+graphPanels;
					panelNames = panelNames+graphPanelNames;
					columnPanels = columnPanels.substring(0,columnPanels.length-1);
					panelNames = panelNames.substring(0,panelNames.length-1);
					var splitedColumn = columnPanels.split(",");
					var splitedPanelNames = panelNames.split(",");
					var spLen = splitedColumn.length;
					var colLen = 0;
					var isOdd = false;
					var colPositionsObj = {};
					var panelPositionsObj = {};
					if( spLen % 2 == 0)
					{
						 colLen = spLen/2;
						 // column panels
						var colOne = [];
						var colTwo = [];
						// name of the panel to render
						var colPanelOne = [];
						var colPanelTwo = [];
						for(var a=0;a<colLen;a++)
						{
							colOne[a]=splitedColumn[a];
							colPanelOne[a]=splitedPanelNames[a];
						}
						var inc = 0;
						for(var a=colLen;a<splitedColumn.length;a++)
						{
							colTwo[inc]=splitedColumn[a];
							colPanelTwo[inc]=splitedPanelNames[a];
							inc = inc+1;
						}
						colPositionsObj ={ 'col-1':colOne,'col-2':colTwo}
						panelPositionsObj ={ 'col-1':colPanelOne,'col-2':colPanelTwo}
					}
					else
					{
						isOdd = true;
						colLen = spLen/2;
						colLen = Math.round(colLen);
						var colOne = [];
						var colTwo = [];
						// name of the panel to render
						var colPanelOne = [];
						var colPanelTwo = [];
						for(var a=0;a<colLen;a++)
						{
							colOne[a]=splitedColumn[a];
							colPanelOne[a]=splitedPanelNames[a];
						}
						var inc = 0;
						for(var a=colLen; a < splitedColumn.length;a++)
						{
							colTwo[inc]=splitedColumn[a];
							colPanelTwo[inc]=splitedPanelNames[a];
							inc = inc+1;
						}
						colPositionsObj ={ 'col-1':colOne,'col-2':colTwo}
						panelPositionsObj ={ 'col-1':colPanelOne,'col-2':colPanelTwo}
					}
					allPositions = {'columns':colPositionsObj,'panels':panelPositionsObj};
					me.loadMonitorPanels(allPositions,json,monitoroverview);
				}
				else
				{
					allPositions = {'columns':ajaxRes,'panels':ajaxRes};
					me.loadMonitorPanels(allPositions,json,monitoroverview);
				}
			}
		});
	},
	loadPage:function(monitoroverview,eOpts){
		if( !Ext.isEmpty(monitoroverview) )
		{
			monTest = monitoroverview.test;
			monAgent = monitoroverview.agent;
			monLocation = monitoroverview.location;
			var data = monitoroverview.jsonData;
			if(!Ext.isEmpty(Ext.getCmp("monFirstCon")))
			{
				var firstColItems = Ext.getCmp("monFirstCon").items.items;
				for(i=firstColItems.length-1;i>-1;i--){
					//firstColItems[i].destroy();
				}
			}
			if(!Ext.isEmpty(Ext.getCmp("monSecCon")))
			{
				var secondColItems = Ext.getCmp("monSecCon").items.items;
				for(i=secondColItems.length-1;i>-1;i--){
					//secondColItems[i].destroy();
				}
			}
			this.getColumnValues(data,monitoroverview);
		}		
	},
	loadMonitorPanels:function(overAllPositions,data,monitoroverview){
		var columnPositions = overAllPositions['columns'];
		var panelPositions = overAllPositions['panels'];
		if(!Ext.isEmpty(this.getLocationCombo()) && !Ext.isEmpty(data.locations)){
			this.getLocationCombo().getStore().loadRawData(data.locations.options);
			this.getLocationCombo().setValue(data.locations.selected);
		}
		if(!Ext.isEmpty(data.grid.titleIconCls)){
			this.getMonitorOverview().setIconCls(data.grid.titleIconCls);
		}
		this.items = [];
		var chartCount = 0;
		for(var key in columnPositions){
			var columnItems = columnPositions[key];
			var columnPanelItems = panelPositions[key];
			var insertItems = [];
			for(j=0;j<columnItems.length;j++){
				var panelNameStr = columnPanelItems[j];
				if( panelNameStr == 'highchart' || panelNameStr.indexOf('graphPanel_') > -1 )
				{
					chartCount = ( panelNameStr.indexOf('graphPanel_') > -1 )?panelNameStr.substring(11):chartCount;
					var chartObj = this.loadGraph(data,chartCount);
					insertItems.push(chartObj);
					chartCount = chartCount+1;
				}
				else if (panelNameStr == 'overviewgrid')
				{
					insertItems.push({
						xtype:'overviewgrid',
						itemId:'comparisionGrid',
						height:'auto',
						columnWidth:.50,
						layout: 'fit',
						//forceFit:true,
						frame:true,
						resizable:false,
						draggable: {moveOnDrag: false},
						listeners: {
							'afterrender': function () {
									if(!Ext.isEmpty(data.grid) && !Ext.isEmpty(data.grid.fields) && !Ext.isEmpty(data.grid.data) && !Ext.isEmpty(data.grid.columns)){
										var store = Ext.create('Ext.data.Store',{
											fields:data.grid.fields,
											data:data.grid.data
										});
											var titleStr = monitoroverview.title+" DETAILS";
											titleStr = titleStr.toLowerCase();
										monitoroverview.down('overviewgrid[itemId=comparisionGrid]').setTitle("<span style='text-transform:capitalize !important'>"+titleStr+"</span>");
										monitoroverview.down('overviewgrid[itemId=comparisionGrid]').reconfigure(store,data.grid.columns);
									}
							}
						}
					});
				}
			}
			if(key=='col-1' || key=='monFirstCon')
			{
				if(!Ext.isEmpty(Ext.getCmp("monFirstCon")))
				{
					var firstColItems = Ext.getCmp("monFirstCon").items.items;
					for(i=firstColItems.length-1;i>-1;i--){
						//firstColItems[i].destroy();
					}
				}
				Ext.getCmp("monFirstCon").add(insertItems);
			}
			if(key=='col-2' || key=='monSecCon' )
			{
				if(!Ext.isEmpty(Ext.getCmp("monSecCon")))
				{
					var secondColItems = Ext.getCmp("monSecCon").items.items;
					for(i=secondColItems.length-1;i>-1;i--){
						//secondColItems[i].destroy();
					}
				}
				Ext.getCmp("monSecCon").add(insertItems);
			}			
		}
	},
	loadGraph:function(jsonData,i){
		var me = this;
		var data = jsonData.graphs;
		var panelId = 'graphPanel_'+i;
		var timeLineId = 'timelineFilter_'+i;
		var graphTitleContainerId = 'graphPanelTitleContainer_'+i; 
		var flg=false;
		var mgsty="0 12 12 0";
			if(flg)
			{
				mgsty="0 0 12 0";
				flg=false;
			}
			else 
				flg=true;
		var graphPanelTitle = (Ext.isEmpty(data[i].panelTitle))?'':data[i].panelTitle;
		graphPanelTitle = ( Ext.isEmpty(graphPanelTitle) )?data[i].tempTitle:graphPanelTitle;
		var graphItem =  {
			xtype:'panel',
			cls:'emdDatapanel',
			frame:true,
			height: 300,
			padding:0,
			title:graphPanelTitle,
			columnWidth:.50,
			margin:mgsty,
			draggable: {moveOnDrag: false},
			style:{'border':'0px solid blue'},
			id:panelId,
			tools:[
				{
					xtype:'combo',	
					cls:'dropdown',
					id:timeLineId,
					index: i,
					measureName: data[i].realMeasuareName,
					location: jsonData.locations.selected,
					fieldLabel:'Show',
					margin:'13 7 0 0',
					labelWidth:35,
					queryMode:'local',
					width:120,
					displayField:'display',
					valueField:'value',
					value:'1 hour',
					editable:false,
					store:Ext.create('Ext.data.Store',{
						fields:['display','value'],
						data:[
							{display:'1 hour',value:'1 hour'},
							{display:'3 hours',value:'3 hours'},
							{display:'6 hours',value:'6 hours'},
							{display:'12 hours',value:'12 hours'},
							{display:'18 hours',value:'18 hours'},
							{display:'24 hours',value:'24 hours'},
							{display:'2 days',value:'2 days'},
							{display:'3 days',value:'3 days'},
							{display:'4 days',value:'4 days'},
							{display:'5 days',value:'5 days'},
							{display:'6 days',value:'6 days'},
							{display:'1 week',value:'1 week'},
							{display:'2 weeks',value:'2 weeks'},
							{display:'3 weeks',value:'3 weeks'},
							{display:'4 weeks',value:'4 weeks'},
							{display:'1 month',value:'1 month'}
						]							
					}),
					listeners: {
						"select": function (obj) {
							updateGraph(obj.index, obj.measureName, me.getLocationCombo().getValue(), "fromMonitor");
						}
					}
								
				}
				
			],
			items:[{
				xtype:'graph',
				height:250,
				data:data[i],
				parent:'locationoverview',
				realMeasure:data[i].realMeasuareName
			}],
		};
		return graphItem;
	},
	specificLocation:function(object){
		clearInterval(monitorRefreshVal);
		var me = this;
		var mask = new Ext.LoadMask(me.getMonitorOverview(), {msg:"Loading...",cls:'maskDashUpperGrid'});
		mask.show();
		var compName = object.getAttribute("component");
		var compInfoName = object.getAttribute("info");
		var loc = me.getMonitorOverview().location;
		var component = compName+":"+compInfoName;
		var test = me.getMonitorOverview().test;
		var site = me.getMonitorOverview().site;
		var agent = me.getMonitorOverview().agent;
		var monTitle = me.getMonitorOverview().title;
		var monState = me.getMonitorOverview().iconCls;
		site = "NULL";
		this.getMain().removeAll(false);
		this.getMonitorOverview().destroy();
		var locStr;
		loc = ( Ext.isEmpty(loc) || loc == 'default' )?agent:loc;
		loc = ( Ext.isEmpty(loc) && !Ext.isEmpty(agent) )?agent:loc;
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgExtMonDashController',
			method:'GET',
			params:{
				specificLocation:loc,
				component:component,
				test:test,
				site:site
			},
			disableCaching:false,
			success:function(response){
				var json = Ext.decode(response.responseText);
				locStr = json;
				var iconClsText = '';
				if(!Ext.isEmpty(json.summary))
					 iconClsText = 'state_'+json.summary.state;
				else
					iconClsText = 'state_GOOD';
				if( !Ext.isEmpty(test) && test == 'SyntheticTransTest' )
				{
					if(Ext.isEmpty(me.getTransactionOverview())){
						me.getMain().add({
							xtype:'transactionoverview',
							iconCls:iconClsText,
							component:component,
							test:test,
							site:site,
							monTest:test,
							monLocation:monLocation,
							monAgent:monAgent,	
							monTitle:monTitle,
							monState:monState,
							summaryLocation:loc,
							summaryComponent:component,
							summaryTest:test,
							summarySite:site,
							fromParent:'monitoroverview',
							jsonData:json,
							parent:'monitoroverview'
						});
					}
					else{
						me.getTransactionOverview().setIconCls(iconClsText);
						me.getTransactionOverview().component = component;
						me.getTransactionOverview().test = test;
						me.getTransactionOverview().site = site;
						me.getTransactionOverview().monLocation = loc;
						me.getTransactionOverview().monTest = test;
						me.getTransactionOverview().monAgent = agent;
						me.getTransactionOverview().monTitle = monTitle;
						me.getTransactionOverview().monState = monState;
						me.getTransactionOverview().summaryLocation = loc;
						me.getTransactionOverview().summaryComponent = component;
						me.getTransactionOverview().summaryTest = test;
						me.getTransactionOverview().summarySite = site;
						me.getTransactionOverview().fromParent = 'monitoroverview';
						me.getTransactionOverview().parent = 'monitoroverview';
						me.getTransactionOverview().jsonData = json;
						me.getMain().add(me.getTransactionOverview());
					}
				}
				else
				{
					if(Ext.isEmpty(me.getLocationOverview())){
						me.getMain().add({
							xtype:'locationoverview',
							iconCls:iconClsText,
							component:component,
							test:test,
							site:site,
							jsonData:json,
							parent:'monitoroverview'
						});
					}
					else{
						me.getLocationOverview().setIconCls(iconClsText);
						me.getLocationOverview().component = component;
						me.getLocationOverview().test = test;
						me.getLocationOverview().site = site;
						me.getLocationOverview().parent = 'componentoverview';
						me.getLocationOverview().jsonData = json;
						me.getMain().add(me.getLocationOverview());
					}
				}
			}
			
		});
		if(!Ext.isEmpty(mask)){
        			mask.hide();
        		}
	},
	backHandler:function(button){
		clearInterval(monitorRefreshVal);
		this.getMain().removeAll(false);
		baseRefreshVal = setInterval('refresh("BaseController")',refreshRate);
		this.getMonitorOverview().destroy();
		this.getMain().add(this.getBase());
	},
	timeFilterChange:function(combo,record,eOpts){
		var graphOuterItemId = '';
		var graphItemId = '';
		var comboPanelRef = combo.up('panel');
		var graphPanelRef = comboPanelRef.down('graph');
		if(!Ext.isEmpty(comboPanelRef))
		{
			graphOuterItemId = comboPanelRef.getItemId();
			graphItemId = graphPanelRef.getItemId();
		}
		// Get Graph RealName Measure
		var RMeasure = '';
		if(!Ext.isEmpty(graphPanelRef.data))
			RMeasure = graphPanelRef.data.realMeasuareName;

		var me = this;
		var test = this.getMonitorOverview().test;
		var agent = this.getMonitorOverview().agent;
		var locations = this.getMonitorOverview().location;
		var selectedTime = ( graphItemId == 'bottomGraphId' )?me.getTimelineCombo().getValue():me.getTimeCombo().getValue();
		var drillDownType = 'monitors';
		var parameters;
		if( !Ext.isEmpty(graphItemId) ){
			drillDownType += 'Graph';
			parameters = {
				drillDown:drillDownType,
				graphTimeline:selectedTime,
				test:test,
				agent:agent,
				location:locations,
				fromPage:'monitor',
				graphMeasure:RMeasure
			};
		}
		
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgExtMonDashController',
			method:'GET',
			scope:this,
			params:parameters,
			disableCaching:false,
			success:function(response){
				var json = Ext.decode(response.responseText);
				if(drillDownType == 'monitorsGraph'){
					me.getMonitorOverview().jsonData.graphs = json;
					me.updateHighChart(json,graphOuterItemId,graphItemId);
				}
			}
		});
	},
	updateHighChart:function(data,graphOuterItemId,graphItemId){
		var monitoroverview = this.getMonitorOverview();
		var data = data.measGraph;
		monitoroverview.down('panel[itemId='+graphOuterItemId+']').down('graph[itemId='+graphItemId+']').destroy();
		if(!Ext.isEmpty(data))
		{
			monitoroverview.down('panel[itemId='+graphOuterItemId+']').add({
			xtype:'graph',
			height:250,
			data:data[0],
			itemId:graphItemId
			});
		}
	},
	fiteringOverview:function(combo,record,eOpts){
		var me =this;
		var test = this.getMonitorOverview().test;
		var agent = combo.value;
		var location = this.getLocationCombo().getValue();
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgExtMonDashController',
			method:'GET',
			scope:this,
			params:{
				drillDown:'monitors',
				test:test,
				agent:agent,
				location:location
			},
			success:function(response){
				var data = Ext.decode(response.responseText);	
				this.updateMonitorOverviewData(data);
			}
		});

	},
	updateMonitorOverviewData:function(data){
		if(!Ext.isEmpty(data))
		{
			var me =this;
			if(!Ext.isEmpty(data.grid) && !Ext.isEmpty(data.grid.fields) && !Ext.isEmpty(data.grid.data) && !Ext.isEmpty(data.grid.columns)){
				var store = Ext.create('Ext.data.Store',{
					fields:data.grid.fields,
					data:data.grid.data
				});
					
				me.getMonitorOverview().down('overviewgrid[itemId=comparisionGrid]').reconfigure(store,data.grid.columns);
			}
			if(!Ext.isEmpty(this.getLocationCombo()) && !Ext.isEmpty(data.locations)){
				this.getLocationCombo().getStore().loadRawData(data.locations.options);
				this.getLocationCombo().setValue(this.getLocationCombo().getValue());
			}
			var panelItems = me.getMonitorOverview().items.items;
			var graphItems = new Array();
			for(z=0;z<panelItems.length;z++){
				var innerItems = panelItems[z].items.items;
				for(j=0;j<innerItems.length;j++){
					if(innerItems[j].getId().indexOf("graphPanel_")>-1){
						graphItems.push(innerItems[j]);
					}
				}
			}
			var length = graphItems.length;
			var timeLineArray = new Array();
			for(x=0;x<length;x++){
				timeLineArray.push(Ext.getCmp('timelineFilter_'+x).getValue());
			}
			var graphs = data.graphs;
			for(i=0;i<graphs.length;i++){
				var panelId = 'graphPanel_'+i;
				var timeLineId = 'timelineFilter_'+i;
				var graphPanel = Ext.getCmp(panelId);
				var graphInstance = graphPanel.items.items[0];
				graphInstance.data = graphs[i];
				graphInstance.fireEvent('boxready',graphInstance);
				var timeLineCombo = Ext.getCmp(timeLineId);
				timeLineCombo.setValue('1 hour');
				//updateGraph(timeLineCombo.index, timeLineCombo.measureName, timeLineCombo.location, "fromMonitor");
			}
		}
	},
	savePositions:function(ob){
		var me = this;
		var panelPositions = {};
		var panelItems = this.getMonitorOverview().items.items;
		for(i=0;i<panelItems.length;i++){
			if(panelItems[i].getXType() == 'container'){
				var innerXTypes = [];
				var innerItems = panelItems[i].items.items;
				for(j=0;j<innerItems.length;j++){
					var itemXtype = innerItems[j].getXType();
					if(itemXtype == 'panel')
					{
						innerXTypes.push(innerItems[j].id);
					}
					else
						innerXTypes.push(innerItems[j].getXType());
				}
				panelPositions[panelItems[i].getId()] = innerXTypes;
			}
		}
		Ext.Ajax.request({
			url:'/final/monitor/externalMonitorsSessionState.jsp',
			params:{
				position:Ext.encode(panelPositions),
				viewName:'monitoroverview'
			},
			disableCaching:false
		});
	},
	loadRefreshPage:function(){
		var me = this;
		var monPageObj = this.getMonitorOverview();
		 monTest = monPageObj.test;
		 monAgent = this.getLocationCombo().getValue();
		 monLocation = monPageObj.location;
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgExtMonDashController',
			method:'GET',
			params:{
				drillDown:'monitors',
				//graphTimeline:me.getTimelineCombo().getValue(),
				test:monTest,
				agent:monAgent,
				location:monLocation
			},
			disableCaching:false,
			scope:this,
			success:function(response){
					var json = Ext.decode(response.responseText);
					var data = json;
					if(!Ext.isEmpty(data.grid) && !Ext.isEmpty(data.grid.fields) && !Ext.isEmpty(data.grid.data) && !Ext.isEmpty(data.grid.columns)){
						var store = Ext.create('Ext.data.Store',{
							fields:data.grid.fields,
							data:data.grid.data
						});
						me.getMonitorOverview().down('overviewgrid[itemId=comparisionGrid]').reconfigure(store,data.grid.columns);
					}
					if(!Ext.isEmpty(this.getLocationCombo()) && !Ext.isEmpty(data.locations)){
						this.getLocationCombo().getStore().loadRawData(data.locations.options);
						this.getLocationCombo().setValue(data.locations.selected);
					}
					var panelItems = me.getMonitorOverview().items.items;
					var graphItems = new Array();
					for(z=0;z<panelItems.length;z++){
						var innerItems = panelItems[z].items.items;
						for(j=0;j<innerItems.length;j++){
							if(innerItems[j].getId().indexOf("graphPanel_")>-1){
								graphItems.push(innerItems[j]);
							}
						}
					}
					var length = graphItems.length;
					var timeLineArray = new Array();
					for(x=0;x<length;x++){
						
						timeLineArray.push(Ext.getCmp('timelineFilter_'+x).getValue());
					}
					var graphs = data.graphs;
					for(i=0;i<graphs.length;i++){
						var panelId = 'graphPanel_'+i;
						var timeLineId = 'timelineFilter_'+i;
						var graphPanel = Ext.getCmp(panelId);
						var graphInstance = graphPanel.items.items[0];
						graphInstance.data = graphs[i];
						graphInstance.fireEvent('boxready',graphInstance);
						var timeLineCombo = Ext.getCmp(timeLineId);
						timeLineCombo.setValue(timeLineArray[i]);
						updateGraph(timeLineCombo.index, timeLineCombo.measureName, me.getLocationCombo().getValue(), "fromMonitor");
					}
				}
			});
	}
});