function popupWindow()
{
	Ext.create('Ext.window.Window', {
	title: screenShotTitle,
	height: 500,
	width: 900,
	modal:true,
	border:false,
	shadow:'drop',
    shadowOffset: 10,
	layout: 'fit',
	items: {  // Let's put an empty grid in just to illustrate fit layout
		xtype: 'container',
		html:'<iframe src="'+errorImgUrl+'" width="100%" height="100%" frameborder="0"></iframe>'
	}
	}).show();
}


Ext.define('EMDashboard.controller.TransactionOverview',{
	extend:'Ext.app.Controller',
	stores:['Alarms'],
	views:['Main','Base','ComponentOverview','LocationOverview','StatusSummary','Alarms','GraphContainer','TransactionOverview','PortalColumn'],
	hiddenData:null,
	transHiddenData: null,
	refs:[{
		selector:'main',
		ref:'main'
	},{
		selector:'base',
		ref:'base'
	},{
		selector:'componentoverview',
		ref:'componentOverview'
	},{
		selector:'transactionoverview',
		ref:'transactionOverview'
	},{
		selector:'transactionoverview graphcontainer',
		ref:'itemContainer'
	},{
		selector:'transactionoverview statussummary',
		ref:'statusSummary'
	},{
		selector:'transactionoverview overviewgrid[itemId=syntheticGrid]',
		ref:'syntheticGrid'
	},{
		selector:'monitoroverview',
		ref:'monitorOverview'
	},{
		selector:'alarms',
		ref:'alarms'
	},{
		selector:'transactionoverview panel[itemId=waterFallChart]',
		ref:'waterFallChart'
	},{
		selector:'transactionoverview panel[itemId=summaryTypeId]',
		ref:'summaryType'
	},{
		selector:'transactionoverview panel[itemId=reqTimeId]',
		ref:'reqTime'
	},{
		selector:'transactionoverview panel[itemId=summaryHeaderId]',
		ref:'summaryHeader'
	},{
		selector:'transactionoverview panel[id=gaugeId]',
		ref:'gaugeChartTwo'
	},{
		selector:'transactionoverview panel[itemId=succScreen]',
		ref:'successImage'
	},{
		selector:'transactionoverview combo[itemId=timelineFilter]',
		ref:'timelineContainer'
	},{
		selector:'graphcontainer',
		ref:'graphcontainer'
	},{
		selector:'transactionoverview combo[itemId="locationFilter"]',
		ref:'locationFilterOBJ'
	},{
		selector:'transactionoverview combo[itemId=locationFilter]',
		ref:'locationContainer2'
	},{
		selector:'componentoverview graphcontainer ',
		ref:'compFilterOBJ'
	},{
		selector:'transactionoverview combo[itemId=alarmFilter]',
		ref:'alarmContainer'
	},{
		selector:'transactionoverview docked[itemId=waterfallTitle]',
		ref:'waterfalltitletxt'
	},{
		selector:'transactionoverview container',
		ref:'allItemContainer'
	}],

	init:function(){
		this.control({
			'main transactionoverview':{
				'afterrender':this.loadLocations,
				added:this.loadPage,
				boxready:this.setTransactionRefresh
			},
			'main transactionoverview button[action=back]':{
				click:this.backHandler
			},
			'main transactionoverview combo[itemId=alarmFilter]':{
				select:this.alarmChanged
			},
			'main transactionoverview graph combo[itemId=locationFilter]':{
				render:this.hideLocations
			},
			'main transactionoverview panel[itemId=waterFallChart]':{
				loadwaterfall:this.loadWaterFallChart
			},
			'main transactionoverview panel[itemId=waterFallChart2]':{
				loadwaterfall2:this.loadPieChart
			},
			'transactionoverview combo[itemId=locationFilter]':{
				//boxready:this.loadLocations
			},
			'transactionoverview graph': {
				beforerender:this.loadLocations
			}
		});
	},
	setTransactionRefresh:function(){
		transRefreshVal = setInterval('refresh("TransactionOverview")',refreshRate);
	},
	loadLocations:function(combo,record,eOpts,transactionOverview){
		var me = this;
		var locationCombo = this.getLocationContainer2();
		{
			var json = this.getTransactionOverview().jsonData;
			locationCombo.getStore().loadRawData(json.locations.options);
			locationCombo.setValue(json.locations.selected);
		}
	},
	loadLoc:function(transactionoverview,eOpts,combo){
		if(!Ext.isEmpty(this.getLocationFilterOBJ()))
		{
			var combo = this.getLocationFilterOBJ();
			var graph = combo.up('graphcontainer');
			var locationCombo = graph.down('combo[itemId=locationFilter]');
			var combo = this.getLocationContainer2();
			var graph = combo.up('graphcontainer');
			var locationCombo = graph.down('combo[itemId=locationFilter]');
			var strVal = locationCombo.getStore();
			var cnts = locationCombo.getStore().getTotalCount();
			for(var i=0;i<cnts;i++)
			{
				strVal.removeAt(i);
			}
			if(!Ext.isEmpty(locationCombo.getStore()))
				locationCombo.getStore().removeAll();
		}
	},
	loadGaugeChart:function()
	{
		gaugeTitle = (Ext.isEmpty(gaugeTitle))?"TotalResponseTime":gaugeTitle;
		var content = document.getElementById("monitorGauge");
		var footerTxtId = document.getElementById("graphTxt");
		footerTxtId.innerHTML=gaugeTitle;
		var logData = fusionData;
		if(FusionCharts('transGauge'))
		{
			FusionCharts('transGauge').dispose();
			var transHealthChart = new FusionCharts('/final/FusionCharts/swf/AngularGauge.swf','transGauge', '100%', '80%', '0', '1');
			transHealthChart.setXMLData(logData);
			transHealthChart.setTransparent(true);
			transHealthChart.render('monitorGauge');
		}
		else
		{
			var transHealthChart = new FusionCharts('/final/FusionCharts/swf/AngularGauge.swf','transGauge', '100%', '80%', '0', '1');
			transHealthChart.setXMLData(logData);
			transHealthChart.setTransparent(true);
			transHealthChart.render('monitorGauge');
		}
	},
	loadPieChart:function(contentEle,curObj){
		var pie1Obj = '';
		var pie2Obj = '';
		var pie3Obj = '';
		var me = this;
		if(!Ext.isEmpty(me.getTransactionOverview().down('panel[id=summaryHeader]')))
		{
			pie3Obj = me.getTransactionOverview().down('panel[id=summaryHeader]')
		}
		if(!Ext.isEmpty(me.getTransactionOverview().down('panel[id=reqTime]')))
		{
			pie2Obj = me.getTransactionOverview().down('panel[id=reqTime]')
		}
		if(!Ext.isEmpty(me.getTransactionOverview().down('panel[id=summaryType]')))
		{
			pie1Obj = me.getTransactionOverview().down('panel[id=summaryType]')
		}

		var content = document.getElementById(contentEle);
		var timingPie;
		var data = new Array();
		var contentPieData = new Array();
		var jsTypes = {
			"text/javascript": 1,
			"text/jscript": 1,
			"application/javascript": 1,
			"application/x-javascript": 1,
			"text/js": 1
		}
		var htmlTypes = {
			"text/plain": 1,
			"text/html": 1
		}

		var cssTypes = {
			"text/css": 1
		}
		var imageTypes = {
			"image/png": 1,
			"image/jpeg": 1,
			"image/gif": 1
		}

		var flashTypes = {
			"application/x-shockwave-flash": 1
		}
		if(!Ext.isEmpty(panel.harlog))
		{
			if(!Ext.isEmpty(panel.harlog.log.pages))
			{
				if(!Ext.isEmpty(curObj))
					curObj.show();
				else
					this.showHidePieWaterFallCharts(true,false,false,false);
				
				/*curObj.getSummaryHeader().show();
				curObj.getReqTime().show();*/
				var pages = panel.harlog.log.pages;
				var blo = 0;
				var dnsVal = 0;
				var sslVal = 0;
				var con = 0;
				var sen = 0;
				var wait = 0;
				var rece = 0;
				var cssPieData = 0;
				var cssCount = 0;
				var jsCount = 0;
				var jsPieData = 0;
				var imageCount = 0;
				var imagePieData = 0;
				var flashCount = 0;
				var flashPieData = 0;
				var htmlCount = 0;
				var htmlPieData = 0;
				var otherCount = 0;
				var otherPieData = 0;
				// Get traffic info variables
				var reqHeaderSize = 0;
				var resHeaderSize = 0;
				var reqBodySize = 0;
				var headerResBodySize = 0;
				var entries = panel.harlog.log.entries;
				for (var i=0; i<entries.length; i++)
				{
					 var entry = entries[i];
					 if (!entry.timings)
						continue;

					// Get timing info (SSL is new in HAR 1.2)
					blo += entry.timings.blocked;
					dnsVal += entry.timings.dns;
					sslVal += entry.timings.ssl > 0 ? entry.timings.ssl : 0;
					con += entry.timings.connect;
					sen += entry.timings.send;
					wait += entry.timings.wait;
					rece += entry.timings.receive;
					// The ssl time is also included in the connect field, see HAR 1.2 spec
					// (to ensure backward compatibility with HAR 1.1).
					if (entry.timings.ssl > 0)
						sslVal -= entry.timings.ssl;

					var response = entry.response;
					var resBodySize = response.bodySize > 0 ? response.bodySize : 0;

					// Get Content type info. Make sure we read the right content type
					// even if there is also a charset specified.
					var mimeType = response.content.mimeType;
					var contentType = mimeType ? mimeType.match(/^([^;]+)/)[1] : null;
					var mimeType = contentType ? contentType : response.content.mimeType;

					// Collect response sizes according to the mimeType.
					if (htmlTypes[mimeType]) {
						htmlPieData += resBodySize;
						htmlCount++;
					}
					else if (jsTypes[mimeType]) {
						jsPieData += resBodySize;
						jsCount++;
					}
					else if (cssTypes[mimeType]) {
						cssPieData += resBodySize;
						cssCount++;
					}
					else if (imageTypes[mimeType]) {
						imagePieData += resBodySize;
						imageCount++;
					}
					else if (flashTypes[mimeType]) {
						flashPieData += resBodySize;
						flashCount++;
					}
					else {
						otherPieData += resBodySize;
						otherCount++;
					}
					// Get traffic info
					reqHeaderSize += entry.request.headersSize > 0 ? entry.request.headersSize : 0;
					reqBodySize += entry.request.bodySize > 0 ? entry.request.bodySize : 0;
					resHeaderSize += entry.response.headersSize > 0 ? entry.response.headersSize : 0;
					headerResBodySize += resBodySize;

				}
				//contentPieData = [htmlArr,javasArr,cssArr,imgArr,flashArr,othArr];
				var summaryContentData = '';
					var jsonData =[];
				var summaryContentTitle = '';
				if( contentEle == 'summaryType')
				{
					var contentData = [
							{value: htmlPieData, name: "HTML/Text",y:htmlPieData,count: htmlCount,color : "#3e6abb", legendLabel:"HTML "+ htmlCount +" requests, "+bytesToSize(htmlPieData)},
							{value: jsPieData, name: "JavaScript", y:jsPieData,count: jsCount,color : "#f25454", legendLabel:"JavaScript "+ jsCount +" requests, "+bytesToSize(jsPieData)},
							{value: cssPieData, name: "CSS",y:cssPieData,count: cssCount,color : "#60bd68",legendLabel:"CSS "+ cssCount +" requests, "+bytesToSize(cssPieData)},
							{value: imagePieData, name: "Image",y:imagePieData,count: imageCount,color : "#b276b2",legendLabel:"Images "+ imageCount +" requests, "+bytesToSize(imagePieData)},
							{value: flashPieData, name: "Flash",y:flashPieData,count: flashCount,color : "#81bef7",legendLabel:"Flash "+ flashCount +" requests, "+bytesToSize(flashPieData)},
							{value: otherPieData, name: "Others", y:otherPieData,count: otherCount,color : "#a61120",legendLabel:"Others "+ otherCount +" requests, "+bytesToSize(otherPieData)}
					];
					summaryContentData = contentData;
					summaryContentTitle = "<div id='content' class='emdDatapanelHeader'>Summary of content types</div>";
				}
				else if( contentEle == 'reqTime' )
				{
					var requestData = [
							{value: blo, name: "Blocked",y:blo,legendLabel:"Blocked: "+millisecondsToStr(blo)},
							{value: dnsVal, name: "DNS", y:dnsVal,legendLabel:"DNS: "+millisecondsToStr(dnsVal)},
							{value: sslVal, name: "SSL/TLS",y:sslVal,legendLabel:"SSL/TLS: "+millisecondsToStr(sslVal)},
							{value: con, name: "Connect",y:con,legendLabel:"Connect "+millisecondsToStr(con)},
							{value: sen, name: "Send", y:sen,legendLabel:"Send: "+millisecondsToStr(sen)},
							{value: wait, name: "Wait", y:wait,legendLabel:"Wait: "+millisecondsToStr(wait)},
							{value: rece, name: "Receive",y:rece,legendLabel:"Receive: "+millisecondsToStr(rece)}
					];
					summaryContentData = requestData;
					summaryContentTitle = "<div id='content' class='emdDatapanelHeader'>Summary of request times</div>";
				}
				else
				{
					var bodyHeaderData = [
							{value: reqHeaderSize, name: "Headers Sent", y: reqHeaderSize, legendLabel:"Headers Sent :"+bytesToSize(reqHeaderSize)},
							{value: reqBodySize, name: "Bodies Sent",y: reqBodySize, legendLabel:"Bodies Sent :"+bytesToSize(reqBodySize)},
							{value: resHeaderSize, name: "Headers Received",y: resHeaderSize, legendLabel:"Headers Received :"+bytesToSize(resHeaderSize)},
							{value: headerResBodySize, name: "Bodies Received", y: headerResBodySize, legendLabel:"Bodies Received :"+bytesToSize(headerResBodySize)}
					];
					summaryContentData = bodyHeaderData;
					summaryContentTitle =  "<div id='content' class='emdDatapanelHeader'>Summary of send and received bodies & headers</div> ";
				}
				var dataJSONObject = {"data": summaryContentData};
				var dataArray = [dataJSONObject];
				var dataSetObject = {"DataSet": dataArray};
				var pieChart = {};
				pieChart = jQuery.extend(true, {}, createBar(contentEle,250,$('#'+contentEle).width()), pieChart);
				pieChart.setData(dataSetObject,'','','pie');
				pieChart.drawChart();
			}
			else
			{
				try
				{
					content.hide();
				}
				catch (e)
				{
					if( contentEle == 'summaryType' && !Ext.isEmpty(me.getTransactionOverview().down('panel[itemId=summaryTypeId]')) )
					{
						//me.getSummaryType().hide();
					}
					else if( contentEle == 'summaryHeader' && !Ext.isEmpty(me.getTransactionOverview().down('panel[itemId=summaryHeaderId]')) )
					{
						//me.getTransactionOverview().down('panel[itemId=summaryHeaderId]').hide()
					}
					else if( contentEle == 'reqTimeId' && !Ext.isEmpty(me.getTransactionOverview().down('panel[itemId=reqTimeId]')) )
					{
						//me.getTransactionOverview().down('panel[itemId=reqTimeId]').hide()
					}
					
				}
				
			}
		}
		else
		{
			if(!Ext.isEmpty(panel.jsonData)){
				if(!Ext.isEmpty(panel.jsonData.errscreen)){
					this.showHidePieWaterFallCharts(false,false,true,false);
					var imgUrl = "<img src='"+panel.jsonData.errscreen+"'/>";
					$("#"+contentEle).html(imgUrl);
				}
				else
				{
					this.showHidePieWaterFallCharts(false,true,false,false);
					/*curObj.getSummaryHeader().hide();
					curObj.getReqTime().hide();*/
				}
			}
			else
			{
				this.showHidePieWaterFallCharts(false,true,false,false);
				/*curObj.getSummaryHeader().hide();
				curObj.getReqTime().hide();*/
			}
			/*else
			{
				this.getSummaryType().hide();
			}*/
		}
	},
	loadWaterFallChart:function(panel){
		//setPanel(panel);
		var content = document.getElementById("content");
		if(!Ext.isEmpty(panel.jsonData))
		{
			var logData = panel.jsonData.harlog;
			if(!Ext.isEmpty(panel.jsonData.harlog)){
				this.getWaterFallChart().show();
				this.getWaterFallChart().setTitle(panel.jsonData.logPanelTitle);
				this.showHidePieWaterFallCharts(true,false,false,false);
				var reqId = document.getElementById("scriptId");
				if(Ext.isEmpty(reqId))
				{
					this.LoadJs("/final/monitor/jharviewer/scripts/require.js");
				}
				else
				{
						var alljs = document.getElementsByTagName("script");
						for (var i = alljs.length; i >= 0; i--) {
							if (alljs[i] && alljs[i].getAttribute('src')!= null)
							{
								var mainDataStr = alljs[i].getAttribute("data-main");
								var as = alljs[i].getAttribute("src");
								if(as == "/final/monitor/jharviewer/scripts/require.js")
								{
									alljs[i].parentNode.removeChild(alljs[i])
									
								}
								
							}
						}
					this.LoadJs("/final/monitor/jharviewer/scripts/require.js");
				}
				//set Har log info into javascript variable in jsp page
				setHarData(logData);
				setContentElement("content");
			}
			else
			{
				if((!Ext.isEmpty(json.errscreen) || !Ext.isEmpty(json.errorkey) )){
					this.showHidePieWaterFallCharts(false,false,true,false);
					this.getWaterFallChart().getDockedComponent('waterfallTitle').update(screenShotTitle);
					errorImgUrl = json.errscreen;
					this.getWaterFallChart().update('<a href="javascript:void(0)" onclick="popupWindow()"><div id="content" title="Click on image to maximize" ><img src="'+json.errscreen+'"/></div></a>');
					this.showHidePieWaterFallCharts(false,true,false,false);
				}
				else if(Ext.isEmpty(panel.jsonData.errorkey))
				{
					this.showHidePieWaterFallCharts(false,true,false,false);
				}
				else
				{
					this.showHidePieWaterFallCharts(false,true,false,false);
				}
			}
		}
	},
	getColumnValues:function(json,paramInfo, transactionoverview){
		var me = this;
		var allPositions = {};
		var ajaxRes = '';
		var actionName = 'summary';
		if( !Ext.isEmpty(json) )
		{
			actionName = ( !Ext.isEmpty( json.harlog ) )?'success':'failure';
			actionName = (paramInfo == "summary")?'summary':actionName;
		}
		Ext.Ajax.request({
			url:'/final/monitor/externalMonitorsSessionState.jsp',
			params:{getPosition:true,viewName:'transactionoverview',actionName:actionName},
			disableCaching:false,
			success:function(response){
				var jsonRes = Ext.decode(response.responseText);
				ajaxRes = (!Ext.isEmpty(jsonRes.position))?jsonRes.position:'';
				if( Ext.isEmpty(ajaxRes) )
				{
					var columnPanels = "panel";
					var panelNames = "step";
					var graphs = json.graphs;
					var noOfGraphs = graphs.length;
					var count = 0;
					if(!Ext.isEmpty(json) && !Ext.isEmpty(json.harlog))
					{
						columnPanels = columnPanels+",panel,panel";
						panelNames = panelNames+",waterfall,pie2";
					}
					else if(!Ext.isEmpty(json) && !Ext.isEmpty(json.errscreen)){
						columnPanels = columnPanels+",panel";
						panelNames = panelNames+",waterfall";
					}
					if( !Ext.isEmpty(graphs) && count < noOfGraphs )
					{
						columnPanels = columnPanels+",panel,alarms";
						panelNames = panelNames+",highchart,alarms";
						count = count+1;
					}
					if(paramInfo == "summary")
					{
						columnPanels = columnPanels+",panel";
						panelNames = panelNames+",gauge";
					}
					if(!Ext.isEmpty(json) && !Ext.isEmpty(json.harlog))
					{
						columnPanels = columnPanels+",panel,panel,panel";
						panelNames = panelNames+",gauge,pie1,pie3";
					}
					if( !Ext.isEmpty(graphs) && count < noOfGraphs )
					{
						columnPanels = columnPanels+",panel";
						panelNames = panelNames+",highchart";
						count = count+1;
					}
					
					if(!Ext.isEmpty(json.grid.fields))
					{
						columnPanels = columnPanels+",overviewgrid";
						panelNames = panelNames+",overviewgrid";
					}
					if(!Ext.isEmpty(json.alarms)){
					
					}
					var splitedColumn = columnPanels.split(",");
					var splitedPanelNames = panelNames.split(",");
					var spLen = splitedColumn.length;
					var colLen = 0;
					var isOdd = false;
					var colPositionsObj = {};
					var panelPositionsObj = {};
					if( spLen % 2 == 0)
					{
						 colLen = spLen/2;
						 // column panels
						var colOne = [];
						var colTwo = [];
						// name of the panel to render
						var colPanelOne = [];
						var colPanelTwo = [];

						for(var a=0;a<colLen;a++)
						{
							colOne[a]=splitedColumn[a];
							colPanelOne[a]=splitedPanelNames[a];
						}
						var inc = 0;
						for(var a=colLen;a<splitedColumn.length;a++)
						{
							colTwo[inc]=splitedColumn[a];
							colPanelTwo[inc]=splitedPanelNames[a];
							inc = inc+1;
						}
						colPositionsObj ={ 'col-1':colOne,'col-2':colTwo}
						panelPositionsObj ={ 'col-1':colPanelOne,'col-2':colPanelTwo}
					}
					else
					{
						isOdd = true;
						colLen = spLen/2;
						colLen = Math.round(colLen);
						var colOne = [];
						var colTwo = [];
						// name of the panel to render
						var colPanelOne = [];
						var colPanelTwo = [];
						for(var a=0;a<colLen;a++)
						{
							colOne[a]=splitedColumn[a];
							colPanelOne[a]=splitedPanelNames[a];
						}
						var inc = 0;
						for(var a=colLen; a < splitedColumn.length;a++)
						{
							colTwo[inc]=splitedColumn[a];
							colPanelTwo[inc]=splitedPanelNames[a];
							inc = inc+1;
						}
						colPositionsObj ={ 'col-1':colOne,'col-2':colTwo}
						panelPositionsObj ={ 'col-1':colPanelOne,'col-2':colPanelTwo}
					}
					allPositions = {'columns':colPositionsObj,'panels':panelPositionsObj};
					me.loadSyntheticPanels(allPositions,json,transactionoverview,paramInfo);
				}
				else
				{
					allPositions = {'columns':ajaxRes,'panels':ajaxRes};
					summaryViewPositions = {'panels':ajaxRes};
					me.loadSyntheticPanels(allPositions,json,transactionoverview,paramInfo);
				}
			}
		});
	},
	loadPage:function(transactionoverview,eOpts,combo){
		if( !Ext.isEmpty(this.getTransactionOverview() ) )
		{
			var me = this;
			hiddenData = this.getTransactionOverview().selectedData;
			transHiddenData = this.getTransactionOverview().healthKey;
			var allItems = this.getTransactionOverview().items.items;
			for(z=0;z<allItems.length;z++){
				var innerItems = allItems[z].items.items;
				for(k=innerItems.length-1;k>-1;k--){
					if(innerItems[k].getId().indexOf("graphPanel_")>-1){
						innerItems[k].destroy();
					}
				}
			}
			if(!Ext.isEmpty(Ext.getCmp("firstCon")))
				Ext.getCmp("firstCon").removeAll(false);
			if(!Ext.isEmpty(Ext.getCmp("secCon")))
				Ext.getCmp("secCon").removeAll(false);
			if(!Ext.isEmpty(this.getAlarmsStore()))
				this.getAlarmsStore().removeAll(false);
			var json = this.getTransactionOverview().jsonData;
			var paramInfo = json.paramComponentName;
			paramInfo = paramInfo.substring(paramInfo.indexOf("+")+1);
			paramInfo = paramInfo.trim();
			this.getColumnValues(json,paramInfo,transactionoverview);
		}
	},
	loadSyntheticPanels:function(overAllPositions,json,monitoroverview,paramInfo){
		if( !Ext.isEmpty( overAllPositions ) )
		{
			var me = this;
			var testName = json.summary.title;
			testName = testName.substring(testName.indexOf("- ")+2,testName.indexOf("from"));
			var titleNameStr = testName.trim();
			titleNameStr = (paramInfo == "summary")?"Transaction Details":"Step Details";
			setTestName(titleNameStr);
			var columnPositions = overAllPositions['columns'];
			var panelPositions = overAllPositions['panels'];
			var currentPanels = new Ext.util.HashMap();
			if(!Ext.isEmpty(json) && !Ext.isEmpty(json.harlog)){
				setPanel(json);
			}
			this.items = [];
			var chartCount = 0;
			for(var key in columnPositions){
				var columnItems = columnPositions[key];
				var columnPanelItems = panelPositions[key];
				var column = {
					xtype:'portalcolumn',
					columnWidth:.50,
					id:key
				};
				var insertItems = [];
				for(j=0;j<columnItems.length;j++){
					var panelNameStr = columnPanelItems[j];
					currentPanels.add(panelNameStr,panelNameStr);
					if( panelNameStr == 'gauge' )
					{
						if(!Ext.isEmpty(json.gauge))
							setFusionData(json.gauge);
						insertItems.push({
						xtype:'panel',
						frame:true,
						padding:0,
						//style:{'background':'#fff'},
						title:'Response Time',
						cls:'emdDatapanel',
						margin:'0 12 12 0',
						id:'gaugeId',
						height:250,
						columnWidth: .50,
						draggable: {moveOnDrag: false},
						html:'<div id="monitorGauge" style=" width:100%;height:auto!important;"></div><center><div id="graphTxt"></div></center>',
						listeners:{
							'afterrender': function () {
								gaugeTitle = json.totResTimeDesc;
								EMDashboard.app.getController("TransactionOverview").loadGaugeChart();
							}
						}
						});
					}
					else if( panelNameStr == 'step' )
					{
						insertItems.push({
							xtype:'panel',
							cls:'emdDatapanel',
							margin:'0 12 12 0',
							draggable: {moveOnDrag: false},
							//style:{'background':'#fff'},
							id:'stepId',
							frame:true,
							title:'',
							padding:0,
							width:'100%',
							bodyPadding:10,
							columnWidth: .50,
							html:'',
							height:'auto',
							padding:'0 0 10 0',
							listeners: {
									"afterrender": function () {
										var stepCon = Ext.getCmp('stepId');
										if(!Ext.isEmpty(stepCon))
										{
											stepCon.update(json.stepDetails);
											stepCon.setTitle(titleNameStr);
										}
									}
							}
						});
					}
					else if( panelNameStr == 'pie1' )
					{
						insertItems.push({
							xtype:'panel',
							cls:'emdDatapanel',
							style:{'border':'0px solid red'},
							itemId:'summaryTypeId',
							margin:'0 12 12 0',
							frame:true,
							padding:0,
							scroll:false,
							autoScroll:false,
							columnWidth: .50,
							title:'Summary of content types',
							style:{'border':'0px solid blue'},
							html:"<div id ='summaryContent' style='width:100%;'></div>",
							hidden:false,
							height:300,
							scroll:false,
							autoScroll:false,
							draggable: {moveOnDrag: false},
							items:[
									{
										xtype:'container',
										id:'summaryType',
										scroll:false,
										autoScroll:false
									}
								],
							listeners:{
								'afterrender': function (curObj) {
									EMDashboard.app.getController("TransactionOverview").loadPieChart('summaryType',curObj);
								}
							}
						});
					}
					else if( panelNameStr == 'pie2' )
					{
						insertItems.push({
							xtype:'panel',
							cls:'emdDatapanel',
							style:{'border':'0px solid red'},
							itemId:'reqTimeId',
							margin:'0 12 12 0',
							frame:true,
							padding:0,
							style:{'border':'0px solid violet'},
							html:"<div id ='reqTimeContent' style='width:100%;border:0px solid blue'></div>",
							hidden:false,
							height:300,
							title:'Summary of request times',
							scroll:false,
							autoScroll:false,
							draggable: {moveOnDrag: false},
							items:[
									{
										xtype:'container',
										id:'reqTime',
										scroll:false,
										autoScroll:false
									}
								],
							columnWidth: .50,
							listeners:{
								'afterrender': function (curObj) {
									EMDashboard.app.getController("TransactionOverview").loadPieChart('reqTime',curObj);
								}
							}
						});
					}
					else if( panelNameStr == 'pie3' )
					{
						insertItems.push({
							xtype:'panel',
							cls:'emdDatapanel',
							style:{'border':'0px solid orange'},
							itemId:'summaryHeaderId',
							margin:'0 12 12 0',
							frame:true,
							padding:0,
							style:{'border':'0px solid orange'},
							html:"<div id ='headerContent' style='width:100%;'></div>",
							hidden:false,
							height:'auto',
							title:'Summary of send and received bodies & headers',
							scroll:false,
							autoScroll:false,
							draggable: {moveOnDrag: false},
							items:[
									{
										xtype:'container',
										id:'summaryHeader',
										scroll:false,
										autoScroll:false
									}
								],
							columnWidth: .50,
							listeners:{
								'afterrender': function (curObj) {
									EMDashboard.app.getController("TransactionOverview").loadPieChart('summaryHeader',curObj);
								}
							}
						});
					}
					else if(panelNameStr == 'waterfall')
					{
						insertItems.push({
							xtype:'panel',
							cls:'emdDatapanel',
							//style:{'background':'#fff'},
							itemId:'waterFallChart',
							hidden:false,
							frame:true,
							padding:0,
							margin:'0 12 12 0',
							height:300,
							title:'Waterfall Chart',
							autoScroll:true,
							columnWidth: .50,
							draggable: {moveOnDrag: false},
							listeners: {
								"afterrender": function (obj) {
									if(!Ext.isEmpty(json) && !Ext.isEmpty(json.harlog)){
										me.getWaterFallChart().update('<div id="content"></div>');
										me.getWaterFallChart().jsonData = json;
										me.getWaterFallChart().fireEvent('loadwaterfall',me.getWaterFallChart());
									}
									else
									{
										me.getWaterFallChart().show();
										me.getWaterFallChart().setTitle(screenShotTitle);
										if(!Ext.isEmpty(json.errscreen))
										{
											errorImgUrl = json.errscreen;
											me.getWaterFallChart().update('<a href="javascript:void(0)" onclick="popupWindow()"><div id="content" title="Click on image to maximize"><img src="'+json.errscreen+'"/></div></a>');
										}
										else
										{
											me.getWaterFallChart().update('<center><div style="margin:10% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div class="commonErrorMsgText">No data found</div></div></center>');
										}
									}
								}
							}
						});
					}
					else if( panelNameStr == 'highchart' || panelNameStr.indexOf('highchart') > -1)
					{
						chartCount = ( panelNameStr.indexOf('highchart_') > -1 )?panelNameStr.substring(10):chartCount;
						var chartObj = me.loadChartGraph(json,chartCount);
						insertItems.push(chartObj);
						chartCount = chartCount+1;
					}
					else if( panelNameStr == 'alarms' )
					{
						insertItems.push({
							xtype:'alarms',
							frame:true,
							padding:0,
							cls:'emdGrid',
							itemId:'syntheticAlarm',
							margin:'0 12 12 0',
							padding:'0 0 10 0',
							draggable: {moveOnDrag: false},
							//style:{'background':'#fff'},
							columnWidth: .50,
							height:'auto'
						});
					}
					else
					{
						insertItems.push({
							xtype:'overviewgrid',
							frame:true,
							padding:0,
							cls:'emdGrid',
							hidden:true,
							margin:'0 12 12 0',
							padding:'0 0 10 0',
							itemId:'syntheticGrid',
							draggable: {moveOnDrag: false},
							//style:{'background':'#fff'},
							columnWidth: .50,
							height:'auto',
							html:''
						});
					}
				}
				column.items = insertItems;
				if(key=='col-1' || key =='transFirstCon' )
				{
					Ext.getCmp("transFirstCon").add(insertItems);
				}
				if(key=='col-2' || key =='transSecCon' )
				{
					Ext.getCmp("transSecCon").add(insertItems);
				}
			}

			if(!Ext.isEmpty(json.alarms)){
				this.getAlarmsStore().loadRawData(json.alarms);
			}
			if(!Ext.isEmpty(json) && !Ext.isEmpty(json.grid) && !Ext.isEmpty(json.grid.fields) && !Ext.isEmpty(json.grid.data) && !Ext.isEmpty(json.grid.columns))
			{
				var store = Ext.create('Ext.data.Store',{
					fields:json.grid.fields,
					data:json.grid.data
				});
				this.getSyntheticGrid().reconfigure(store,json.grid.columns);
				this.getSyntheticGrid().show();
				this.getSyntheticGrid().setTitle('Step Details');
			}

			if(!Ext.isEmpty(json) && !Ext.isEmpty(json.summary)){
				this.getTransactionOverview().setTitle(json.summary.title);
				this.getTransactionOverview().setIconCls(json.summary.state);
			}
		}
	},
	LoadJs:function(url){
	  var js = document.createElement('script');
	  js.type = "text/javascript";
	  js.setAttribute("data-main", "/final/monitor/jharviewer/scripts/harViewer.js");
	  js.setAttribute("expand", "true");
	  js.setAttribute("id", "scriptId");
	  js.setAttribute("async", "true");
	  js.src = url;
	  document.body.appendChild(js);
	},
	unLoadWaterFallScripts:function(){
		// remove require.js file from page when we go back .
		var reqId = document.getElementById("scriptId");
		if(!Ext.isEmpty(reqId))
		{
			var alljs = document.getElementsByTagName("script");
			for (var i = alljs.length; i >= 0; i--) {
				if (alljs[i] && alljs[i].getAttribute('src')!= null)
				{
					var mainDataStr = alljs[i].getAttribute("data-main");
					var as = alljs[i].getAttribute("src");
					if(as == "/final/monitor/jharviewer/scripts/require.js")
					{
						alljs[i].parentNode.removeChild(alljs[i])
						
					}
					
				}
			}
			reqId.remove();
		}
	},
	loadChartGraph:function(json,i){
		if(!Ext.isEmpty(json) && !Ext.isEmpty(json.graphs))
		{
			var graphs = json.graphs;
			var panelId = 'graphPanel_'+i;
			var timeLineId = 'timelineFilter_'+i;
			var selectedTimeArray = json.allTimeline;
			var graphTitleContainerId = 'graphPanelTitleContainer_'+i; 
			var selectedTime = '1 hour';
			var graphPanelTitle = (Ext.isEmpty(graphs[i].panelTitle))?'':graphs[i].panelTitle;
			graphPanelTitle = ( Ext.isEmpty(graphPanelTitle) )?graphs[i].tempTitle:graphPanelTitle;
			if( !Ext.isEmpty(selectedTimeArray) )
				selectedTime = selectedTimeArray[i];
			var graphItem =  {
				xtype:'panel',
				frame:true,
				padding:0,
				margin:'0 12 12 0',
				cls:'emdDatapanel',
				height: 300,
				style:{'border':'1px solid blue'},
				draggable: {moveOnDrag: false},
				layout:{type:'vbox',align:'stretch'},
				id:panelId,
				title:graphPanelTitle,
				columnWidth:.5,
				tools:[
						{
							xtype:'combo',	
							cls:'dropdown',
							id:timeLineId,
							index: i,
							measureName: graphs[i].realMeasuareName,
							location: json.locations.selected,
							component:json.paramComponentName,
							fieldLabel:'Show',
							margin:'15 5 0 0',
							labelWidth:35,
							queryMode:'local',
							width:120,
							displayField:'display',
							valueField:'value',
							value:selectedTime,
							editable:false,
							store:Ext.create('Ext.data.Store',{
								fields:['display','value'],
								data:[
									{display:'1 hour',value:'1 hour'},
									{display:'3 hours',value:'3 hours'},
									{display:'6 hours',value:'6 hours'},
									{display:'12 hours',value:'12 hours'},
									{display:'18 hours',value:'18 hours'},
									{display:'24 hours',value:'24 hours'},
									{display:'2 days',value:'2 days'},
									{display:'3 days',value:'3 days'},
									{display:'4 days',value:'4 days'},
									{display:'5 days',value:'5 days'},
									{display:'6 days',value:'6 days'},
									{display:'1 week',value:'1 week'},
									{display:'2 weeks',value:'2 weeks'},
									{display:'3 weeks',value:'3 weeks'},
									{display:'4 weeks',value:'4 weeks'},
									{display:'1 month',value:'1 month'}
								]							
							}),
							listeners: {
									"afterrender": function (obj) {
											updateGraph(obj.index, obj.measureName, obj.location, "fromTransaction",obj.component);
										},
								"select": function (obj) {
									updateGraph(obj.index, obj.measureName, obj.location, "fromTransaction",obj.component);
								}
							}
									
						}	
				],
				items:[{
					xtype:'graph',
					height:250,
					columnWidth:.50,
					data:graphs[i],
					parent:'locationoverview',
					realMeasure:graphs[i].realMeasuareName
				}],
			};
			return graphItem;
		}
		else
		{
			var graphItem =  {
				xtype:'container',
				itemId:'errorPanel',
				frame:true,
				padding:0,
				draggable: {moveOnDrag: false},
				columnWidth:1,
				html:'<div style="font-weight:bold;text-align:center;margin:25% 0 auto 0"><img class="x-grid-empty-image" src="eg_images/gray/exclamation-icon.gif"/><br/>No data found</div>'
			};
			return graphItem;
		}
	},
	backHandler:function(button){
		clearInterval(transRefreshVal);
		var locationParent = this.getTransactionOverview().parent;
		if(locationParent == 'componentoverview')
		{
			var test = this.getTransactionOverview().comTest;
			var component = this.getTransactionOverview().comComponent;
			var site = this.getTransactionOverview().comSite;
			if(!Ext.isEmpty(this.getTransactionOverview()))
				this.getTransactionOverview().destroy();
			
			var items = this.getMain().items.items;
			for(i=items.length-1;i>-1;i--){
				items[i].destroy();
			}
			redirectToComponentOverview(component,test,site);
		}
		else if(locationParent == 'monitoroverview')
		{
			var loc = this.getTransactionOverview().monLocation;
			var test = this.getTransactionOverview().monTest;
			var agent = this.getTransactionOverview().monAgent;
			var title = this.getTransactionOverview().monTitle;
			var state = this.getTransactionOverview().monState;
			if(!Ext.isEmpty(this.getTransactionOverview()))
				this.getTransactionOverview().destroy();

			var items = this.getMain().items.items;
			for(i=items.length-1;i>-1;i--){
				items[i].destroy();
			}
			redirectToMonitorOverview(loc,title,state,test,agent);
		}
		else if(locationParent == 'summary')
		{
			var loc = this.getTransactionOverview().summaryLocation;
			var test = this.getTransactionOverview().summaryTest;
			var component = this.getTransactionOverview().summaryComponent;
			var site = this.getTransactionOverview().summarySite;
			var parent = this.getTransactionOverview().fromParent;
			var monTest = this.getTransactionOverview().monTest;
			var monLocation = this.getTransactionOverview().monLocation;
			var monAgent = this.getTransactionOverview().monAgent;
			var monTitle = this.getTransactionOverview().monTitle;
			var monState = this.getTransactionOverview().monState;
			
			if(!Ext.isEmpty(this.getTransactionOverview()))
				this.getTransactionOverview().destroy();

			var items = this.getMain().items.items;
			for(i=items.length-1;i>-1;i--){
				items[i].destroy();
			}
			redirectToSummaryTransactionOverview(loc,component,test,site,parent,monTest,monLocation,monAgent,monTitle,monState);
		}
		else if(locationParent == 'base')
		{
			if(!Ext.isEmpty(this.getTransactionOverview()))
				this.getTransactionOverview().destroy();
			
			var items = this.getMain().items.items;
			for(i=items.length-1;i>-1;i--){
				items[i].destroy();
			}
			this.getMain().add(this.getBase());
			EMDashboard.app.getController('BaseController').getBaseRefresh(hiddenData, transHiddenData);
		}
		else
		{
			if(!Ext.isEmpty(this.getTransactionOverview()))
				this.getTransactionOverview().destroy();
			var items = this.getMain().items.items;
			for(i=items.length-1;i>-1;i--){
				items[i].destroy();
			}
			this.getMain().add(this.getBase());
			EMDashboard.app.getController('BaseController').getBaseRefresh(hiddenData, transHiddenData);
		}
	},
	alarmChanged:function(combo,record,eOpts){
		var me = this;
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgExtMonDashController',
			method:'GET',
			params:{
				alarmsTimeline:combo.getValue(),
				component:me.getTransactionOverview().component,
				test:me.getTransactionOverview().test,
				site:me.getTransactionOverview().site,
				specificLocation:me.getTransactionOverview().specificLocation
			},
			disableCaching:false,
			success:function(response){
				var alarms = Ext.decode(response.responseText);
				me.getAlarmsStore().loadRawData(alarms);
			}
		});
	},
	hideLocations:function(combo,eOpts){
		var parentName = combo.up('graph').parent;
		var locationName = combo.up('transactionoverview').specificLocation;
		if(parentName == 'transactionoverview'){
			combo.setValue(locationName);
			combo.hide();
		}
	},
	showHidePieWaterFallCharts:function(showAll,hideAll,onlyWaterfall,onlyPies){
		var me = this;
		var waterFallChartObj = '';
		var pie1Obj = '';
		var pie2Obj = '';
		var pie3Obj = '';
		if(!Ext.isEmpty(me.getTransactionOverview().down('panel[itemId=waterFallChart]')))
		{
			waterFallChartObj = me.getTransactionOverview().down('panel[itemId=waterFallChart]')
		}
		if(!Ext.isEmpty(me.getTransactionOverview().down('panel[id=summaryHeader]')))
		{
			pie3Obj = me.getTransactionOverview().down('panel[id=summaryHeader]')
		}
		if(!Ext.isEmpty(me.getTransactionOverview().down('panel[id=reqTime]')))
		{
			pie2Obj = me.getTransactionOverview().down('panel[id=reqTime]')
		}
		if(!Ext.isEmpty(me.getTransactionOverview().down('panel[id=summaryType]')))
		{
			pie1Obj = me.getTransactionOverview().down('panel[id=summaryType]')
		}
		if(showAll)
		{
			if(!Ext.isEmpty(waterFallChartObj))
			{
				waterFallChartObj.show();
			}
		}
		if(hideAll)
		{
			if(!Ext.isEmpty(waterFallChartObj))
			{
				waterFallChartObj.hide();
			}
		}
		if(onlyWaterfall)
		{
			if(!Ext.isEmpty(waterFallChartObj))
			{
				waterFallChartObj.show();
			}
		}
		if(onlyPies)
		{
			if(!Ext.isEmpty(waterFallChartObj))
			{
				waterFallChartObj.hide();
			}
		}
	},
	refreshWaterFallChart:function(jsonData){
		//setPanel(panel);
		var me = this;
		var content = document.getElementById("content");
		if(!Ext.isEmpty(jsonData))
		{
			var waterFallChartObj = '';
			if(!Ext.isEmpty(me.getTransactionOverview().down('panel[itemId=waterFallChart]')))
			{
				waterFallChartObj = me.getTransactionOverview().down('panel[itemId=waterFallChart]')
			}
			var logData = jsonData.harlog;
			if(!Ext.isEmpty(jsonData.harlog)){
				waterFallChartObj.setTitle(jsonData.logPanelTitle);
				this.showHidePieWaterFallCharts(true,false,false,false);
				var reqId = document.getElementById("scriptId");
				if(Ext.isEmpty(reqId))
				{
					this.LoadJs("/final/monitor/jharviewer/scripts/require.js");
				}
				else
				{
					var alljs = document.getElementsByTagName("script");
					for (var i = alljs.length; i >= 0; i--) {
						if (alljs[i] && alljs[i].getAttribute('src')!= null)
						{
							var mainDataStr = alljs[i].getAttribute("data-main");
							var as = alljs[i].getAttribute("src");
							if(as == "/final/monitor/jharviewer/scripts/require.js")
							{
								alljs[i].parentNode.removeChild(alljs[i])
							}
						}
					}
					this.LoadJs("/final/monitor/jharviewer/scripts/require.js");
				}
				//set Har log info into javascript variable in jsp page
				setHarData(logData);
				setContentElement("content");
			}
			else
			{
				if(!Ext.isEmpty(jsonData.errscreen)){
					this.showHidePieWaterFallCharts(false,false,true,false);
					waterFallChartObj.getDockedComponent('waterfallTitle').update(screenShotTitle);
					var imgUrl = '<a href="javascript:void(0)" onclick="popupWindow()"><div id="content" title="Click on image to maximize"><img src="'+jsonData.errscreen+'"/></div></a>';
					$("#content").html(imgUrl);
				}
				else if(Ext.isEmpty(jsonData.errorkey))
				{
					this.showHidePieWaterFallCharts(false,true,false,false);
				}
				else
				{
					this.showHidePieWaterFallCharts(false,true,false,false);
				}
			}
		}
	},
	refreshTransactionPage:function(){
		var me = this;
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgExtMonDashController',
			method:'GET',
			params:{
				eventTimeline:this.getAlarmContainer().getValue(),
				component:me.getTransactionOverview().component,
				test:me.getTransactionOverview().test,
				site:me.getTransactionOverview().site,
				specificLocation:me.getLocationContainer2().getValue(),
				//graphTimelineChange:me.getTimelineContainer().getValue(),
				graphLocationChange:me.getLocationContainer2().getValue(),
				timelineGraph:'no'
			},
			disableCaching:false,
			success:function(response){
				var json = Ext.decode(response.responseText);
				var syntheticGridObj = '';
				var waterFallChartObj = '';
				var pie1Obj = '';
				var pie2Obj = '';
				var pie3Obj = '';
				var stepObj = '';
				var gaugeObj = '';
				if(!Ext.isEmpty(me.getTransactionOverview().down('overviewgrid[itemId=syntheticGrid]')))
				{
					syntheticGridObj = me.getTransactionOverview().down('overviewgrid[itemId=syntheticGrid]')
				}
				if(!Ext.isEmpty(me.getTransactionOverview().down('panel[itemId=waterFallChart]')))
				{
					waterFallChartObj = me.getTransactionOverview().down('panel[itemId=waterFallChart]')
				}
				if(!Ext.isEmpty(me.getTransactionOverview().down('panel[id=summaryHeader]')))
				{
					pie3Obj = me.getTransactionOverview().down('panel[id=summaryHeader]')
				}
				if(!Ext.isEmpty(me.getTransactionOverview().down('panel[id=reqTime]')))
				{
					pie2Obj = me.getTransactionOverview().down('panel[id=reqTime]')
				}
				if(!Ext.isEmpty(me.getTransactionOverview().down('panel[id=summaryType]')))
				{
					pie1Obj = me.getTransactionOverview().down('panel[id=summaryType]')
				}
				if(!Ext.isEmpty(me.getTransactionOverview().down('panel[id=stepId]')))
				{
					stepObj = me.getTransactionOverview().down('panel[id=stepId]')
				}
				if(!Ext.isEmpty(me.getTransactionOverview().down('panel[id=gaugeId]')))
				{
					gaugeObj = me.getTransactionOverview().down('panel[id=gaugeId]')
				}

				if(!Ext.isEmpty(json) && !Ext.isEmpty(json.grid) && !Ext.isEmpty(json.grid.fields) && !Ext.isEmpty(json.grid.data) && !Ext.isEmpty(json.grid.columns))
				{
					var store = Ext.create('Ext.data.Store',{
						fields:json.grid.fields,
						data:json.grid.data
					});
					if(!Ext.isEmpty( syntheticGridObj ) )
					{
						syntheticGridObj.reconfigure(store,json.grid.columns);
						syntheticGridObj.show();
					}
				}
				else{
					if(!Ext.isEmpty( syntheticGridObj ) )
						syntheticGridObj.hide();
				}
				if(!Ext.isEmpty(json) && !Ext.isEmpty(json.summary)){
				var content = document.getElementById("content");
				}
				var stepCon = Ext.getCmp('stepId');
				
				if(!Ext.isEmpty(stepObj))
				{
					stepObj.update(json.stepDetails);
				}
				var gaugePanelId = Ext.getCmp('gaugeId');
				if(!Ext.isEmpty(gaugeObj))
				{
					setFusionData(json.gauge);
					gaugeTitle = json.totResTimeDesc;
					me.loadGaugeChart();
				}
				if(!Ext.isEmpty(json) && (!Ext.isEmpty(json.errscreen) || !Ext.isEmpty(json.errorkey) ) )
				{
					waterFallChartObj.show();
					me.getWaterFallChart().update('<div id="content"><a href="javascript:void(0)" onclick="popupWindow()"><div id="content" title="Click on image to maximize"><img src="'+json.errscreen+'"/></div></a></div>');
				}
				me.getTransactionOverview().setLoading(false);
				var dynamicStore = Ext.create('Ext.data.Store',{
					autoLoad:true,
					fields:json.locations
				});
				if(!Ext.isEmpty(me.getLocationContainer2()))
				{
					var as = me.getLocationContainer2().getStore();
				}
				var graphs = json.graphs;
				var panelItems = me.getTransactionOverview().items.items;
				var graphItems = new Array();
				for(z=0;z<panelItems.length;z++){
					var innerItems = panelItems[z].items.items;
					for(j=0;j<innerItems.length;j++){
						if(innerItems[j].getId().indexOf("graphPanel_")>-1){
							graphItems.push(innerItems[j]);
						}
					}
				}
				var allTimeline = new Array();
				for(k=0;k<graphItems.length;k++){
					allTimeline.push(Ext.getCmp('timelineFilter_'+k).getValue());
				}
				json["allTimeline"] = allTimeline;
				for(i=0;i<graphs.length;i++){
					var panelId = 'graphPanel_'+i;
					var timeLineId = 'timelineFilter_'+i;
					var graphPanel = Ext.getCmp(panelId);
					var graphInstance = graphPanel.items.items[0];
					graphInstance.data = graphs[i];
					graphInstance.fireEvent('boxready',graphInstance);
					var timeLineCombo = Ext.getCmp(timeLineId);
					timeLineCombo.setValue(allTimeline[i]);
					updateGraph(timeLineCombo.index, timeLineCombo.measureName, timeLineCombo.location, "fromTransaction",json.paramComponentName);
				}
				if(!Ext.isEmpty(json) && !Ext.isEmpty(json.harlog))
				{
					me.getSummaryType().jsonData = json;
					me.loadPieChart('summaryType');
					me.loadPieChart('reqTime');
					me.loadPieChart('summaryHeader');
					me.refreshWaterFallChart(json);
				}
				else if(!Ext.isEmpty(json) && !Ext.isEmpty(json.errscreen))
				{
					waterFallChartObj.update('<a href="javascript:void(0)" onclick="popupWindow()"><div id="content" title="Click on image to maximize"><img src="'+json.errscreen+'"/></div></a>');
					me.getWaterFallChart().show();
				}
				else
				{
					waterFallChartObj.hide();
				}
			}
		});
	},

	fiteringOverview:function(combo,record,eOpts){
		var me =this;
		var test = this.getMonitorOverview().test;
		var agent = this.getMonitorOverview().agent;
		var location = this.getLocationCombo().getRawValue();
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgExtMonDashController',
			method:'GET',
			scope:this,
			params:{
				drillDown:'monitors',
				test:test,
				agent:agent,
				location:location
			},
			success:function(response){
				var data = Ext.decode(response.responseText);	
				this.updateTransactionOverviewData(data);
			}
		});
	},
	updateTransactionOverviewData:function(data){
		var me =this;
		if(!Ext.isEmpty(data.grid) && !Ext.isEmpty(data.grid.fields) && !Ext.isEmpty(data.grid.data) && !Ext.isEmpty(data.grid.columns)){
			var store = Ext.create('Ext.data.Store',{
				fields:data.grid.fields,
				data:data.grid.data
			});
			me.getMonitorOverview().down('overviewgrid[itemId=comparisionGrid]').reconfigure(store,data.grid.columns);
		}
		if(!Ext.isEmpty(this.getLocationCombo()) && !Ext.isEmpty(data.locations)){
			this.getLocationCombo().getStore().loadRawData(data.locations.options);
			this.getLocationCombo().setValue(this.getLocationCombo().getValue());
		}
		var panelItems = me.getMonitorOverview().items.items;
		var graphItems = new Array();
		for(z=0;z<panelItems.length;z++){
			var innerItems = panelItems[z].items.items;
			for(j=0;j<innerItems.length;j++){
				if(innerItems[j].getId().indexOf("graphPanel_")>-1){
					graphItems.push(innerItems[j]);
				}
			}
		}
		var length = graphItems.length;
		var timeLineArray = new Array();
		for(x=0;x<length;x++){
			timeLineArray.push(Ext.getCmp('timelineFilter_'+x).getValue());
		}
		var graphs = data.graphs;
		for(i=0;i<graphs.length;i++){
			var panelId = 'graphPanel_'+i;
			var timeLineId = 'timelineFilter_'+i;
			var graphPanel = Ext.getCmp(panelId);
			var graphInstance = graphPanel.items.items[0];
			graphInstance.data = graphs[i];
			graphInstance.fireEvent('boxready',graphInstance);
			var timeLineCombo = Ext.getCmp(timeLineId);
			timeLineCombo.setValue(timeLineArray[i]);
			updateGraph(timeLineCombo.index, timeLineCombo.measureName, timeLineCombo.location, "fromMonitor");
		}
	},
	savePositions:function(obj){
		var panelMapping = new Ext.util.HashMap();
		panelMapping.add('waterFallChart', 'waterfall');
		panelMapping.add('summaryHeader', 'pie3');
		panelMapping.add('summaryHeaderId', 'pie3');
		panelMapping.add('reqTime', 'pie2');
		panelMapping.add('reqTimeId', 'pie2');
		panelMapping.add('summaryType', 'pie1');
		panelMapping.add('summaryTypeId', 'pie1');
		panelMapping.add('stepId', 'step');
		panelMapping.add('gaugeId', 'gauge');
		panelMapping.add('graphPanel_0', 'highchart_0');
		panelMapping.add('graphPanel_1', 'highchart_1');
		var me = this;
		var panelPositions = {};
		var panelItems = this.getTransactionOverview().items.items;
		var actionObj = obj.portal.jsonData;
		var actionName = 'summary';
		if( !Ext.isEmpty(actionObj) )
		{
			actionName = ( !Ext.isEmpty( actionObj.harlog ) )?'success':'failure';
			var paramInfo = actionObj.paramComponentName;
			paramInfo = paramInfo.substring(paramInfo.indexOf("+")+1);
			paramInfo = paramInfo.trim();
			actionName = (paramInfo == "summary")?'summary':actionName;
		}
		for(i=0;i<panelItems.length;i++){
			if(panelItems[i].getXType() == 'container'){
				var innerXTypes = [];
				var innerItems = panelItems[i].items.items;
				for(j=0;j<innerItems.length;j++){
					var itemXtype = innerItems[j].getXType();
					if(itemXtype == 'panel')
					{
						var panelId = innerItems[j].id;
						if ( panelMapping.containsKey(panelId) )
						{
							panelId = panelMapping.get(panelId);
						}
						else
						{
							panelId = innerItems[j].itemId;
							panelId = panelMapping.get(panelId);
						}
						innerXTypes.push(panelId);
					}
					else
						innerXTypes.push(innerItems[j].getXType());
				}
				panelPositions[panelItems[i].getId()] = innerXTypes;
			}
		}
		Ext.Ajax.request({
			url:'/final/monitor/externalMonitorsSessionState.jsp',
			params:{
				position:Ext.encode(panelPositions),
				viewName:'transactionoverview',
				actionName:actionName
			},
			disableCaching:false
		});
	},
	specificLocation:function(object){
		var me = this;
		var mask = new Ext.LoadMask(me.getTransactionOverview(), {msg:"Loading...",cls:'maskDashUpperGrid'});
		mask.show();
		var compName = object.getAttribute("component");
		var compInfoName = object.getAttribute("info");
		var loc = me.getTransactionOverview().jsonData.locations.selected;
		var component = compName+":"+compInfoName;
		var test = me.getTransactionOverview().test;
		var site = me.getTransactionOverview().site;
		var summaryLocation = me.getTransactionOverview().summaryLocation;
		var summaryComponent = me.getTransactionOverview().summaryComponent;
		var summaryTest = me.getTransactionOverview().summaryTest;
		var summarySite = me.getTransactionOverview().summarySite;
		var monLocation = me.getTransactionOverview().monLocation;
		var monAgent = me.getTransactionOverview().monAgent;
		var monTitle = me.getTransactionOverview().monTitle;
		var monState = me.getTransactionOverview().monState;
		var monTest = me.getTransactionOverview().monTest;
		var fromParent = me.getTransactionOverview().fromParent;
		site = (Ext.isEmpty(site))?"NULL":site;
		var synPanels = new Ext.util.HashMap();
		synPanels.add('waterfall','waterFallChart');
		synPanels.add('pie3','summaryHeader');
		synPanels.add('pie2','reqTime');
		synPanels.add('pie1','summaryType');
		synPanels.add('step','stepId');
		synPanels.add('gauge','gaugeId');
		synPanels.add('highchart_0','graphPanel_0');
		synPanels.add('highchart_1','graphPanel_1');
		synPanels.add('alarms','alarms');
		synPanels.add('overviewgrid','overviewgrid');
		var panelItems2 = this.getTransactionOverview().items.items;
		var panelItems12 = me.getTransactionOverview().items.items;
		var panelPositions = summaryViewPositions['panels'];
			for(var key in panelPositions){
				var columnPanelItems = panelPositions[key];
				for(j=0;j<columnPanelItems.length;j++){
					var keyName = columnPanelItems[j];
					//if( !currentPanels.containsKey(keyName) )
					{
						if( keyName != 'alarms' && keyName != 'overviewgrid')
						{
							var panelId = synPanels.get(keyName);
							if( !Ext.isEmpty( me.getTransactionOverview().down('panel[itemId='+panelId+']')) )
							{
								me.getTransactionOverview().down('panel[itemId='+panelId+']').destroy();
							}
							else if( !Ext.isEmpty( me.getTransactionOverview().down('panel[id='+panelId+']')) )
							{
								me.getTransactionOverview().down('panel[id='+panelId+']').destroy();
							}
						}
						else
						{
							if( keyName == 'alarms' && !Ext.isEmpty(me.getTransactionOverview().down('alarms[itemId=syntheticAlarm]')))
							{
								 me.getTransactionOverview().down('alarms[itemId=syntheticAlarm]').destroy();
							}
							else if( keyName == 'overviewgrid' && !Ext.isEmpty(me.getTransactionOverview().down('overviewgrid[itemId=overviewgrid]')))
							{
								 me.getTransactionOverview().down('overviewgrid[itemId=overviewgrid]').destroy();
							}
						}
					}
				}
			}
		for(z=0;z<panelItems2.length;z++){
			var innerItems = panelItems2[z].items.items;
			
			for(j=0;j<innerItems.length;j++){
				innerItems[j].destroy();
			}
		}
		this.getMain().removeAll(false);
		var locStr;
		Ext.Ajax.request({
			url:'/final/servlet/com.eg.EgExtMonDashController',
			method:'GET',
			params:{
				specificLocation:loc,
				component:component,
				test:test,
				site:site
			},
			disableCaching:false,
			success:function(response){
				var json = Ext.decode(response.responseText);
				locStr = json;
				var iconClsText = '';
				if(!Ext.isEmpty(json.summary))
					 iconClsText = 'state_'+json.summary.state;
				else
					iconClsText = 'state_GOOD';
				if( !Ext.isEmpty(test) && test == 'SyntheticTransTest' )
				{
					if(Ext.isEmpty(me.getTransactionOverview())){
						me.getMain().add({
							xtype:'transactionoverview',
							iconCls:iconClsText,
							component:component,
							test:test,
							site:site,
							monTest:monTest,
							monLocation:monLocation,
							monAgent:monAgent,	
							monTitle:monTitle,
							monState:monState,
							summaryLocation:summaryLocation,
							summaryComponent:summaryComponent,
							summaryTest:summaryTest,
							summarySite:summarySite,
							fromParent:fromParent,
							jsonData:json,
							parent:'summary'
						});
					}
					else{
						me.getTransactionOverview().setIconCls(iconClsText);
						me.getTransactionOverview().component = component;
						me.getTransactionOverview().test = test;
						me.getTransactionOverview().site = site;
						me.getTransactionOverview().parent = 'summary';
						me.getTransactionOverview().summaryLocation=summaryLocation;
						me.getTransactionOverview().summaryComponent=summaryComponent;
						me.getTransactionOverview().summaryTest=summaryTest;
						me.getTransactionOverview().summarySite=summarySite;
						me.getTransactionOverview().monLocation = monLocation;
						me.getTransactionOverview().monAgent = monAgent;
						me.getTransactionOverview().monTitle = monTitle;
						me.getTransactionOverview().monState = monState;
						me.getTransactionOverview().monTest = monTest;
						me.getTransactionOverview().fromParent = fromParent;
						me.getTransactionOverview().jsonData = json;
						me.getMain().add(me.getTransactionOverview());
					}
				}
			}
			
		});
		if(!Ext.isEmpty(mask)){
        			mask.hide();
        		}
	}
});