Ext.define('EMDashboard.view.Base',{
	extend:'Ext.panel.Panel',
	title:'External Monitors Dashboard',
	requires:['EMDashboard.view.SubOptimals'],
	alias:'widget.base',
	autoDestroy:true,
	autoScroll:true,
	margin:'10 10 10 10',
	bodyPadding:'11 0 11 11',
	cls:'emdOuterpanel',
	tools:[
		{
			xtype:'toolbar',
			cls:'emdOuterDocked',
			//margin:'0 0 10 0',
			padding:'5 0 5 0',
			
			style:{'border':'0px solid red'},
			layout:'hbox',
			items:[
					{
				xtype:'combo',
				cls:'dropdown',
				itemId:'monitors',
				labelSeparator:'',
				padding:'0 15 0 0',
				fieldLabel:'Monitors',
				width:200,
				labelWidth:50,
				editable:false,
				displayField:'display',
				valueField:'value',
				queryMode:'local',
				store:Ext.create('Ext.data.Store',{
					fields:['display','value']
				})
			},{
				xtype:'combo',
				cls:'dropdown',
				itemId:'filters',
				padding:'0 5 0 5',
				fieldLabel:'Filters',
				width:200,
				labelWidth:35,
				fieldStyle:{
					lineHeight:'18px !important'
				},
				labelSeparator:'',
				editable:false,
				displayField:'display',
				valueField:'value',
				queryMode:'local',
				store:Ext.create('Ext.data.Store',{
					fields:['display','value']
				})
			},{
				xtype:'combo',
				cls:'dropdown',
				itemId:'subFilters',
				padding:'0 5 0 0',
				labelSeparator:'',
				hidden:true,
				width:220,
				editable:false,
				displayField:'display',
				valueField:'value',
				queryMode:'local',
				store:Ext.create('Ext.data.Store',{
					fields:['display','value']
				})
			}	
			
			]
		}	
	],
	width:'100%',
	height:'100%',
    defaultType: 'portalcolumn',

	defaults:{
		height:'auto',
		columnWidth:.5
	},
	items:[
	{xtype:''}
	
	],
    initComponent : function() {
        var me = this;
        // Implement a Container beforeLayout call from the layout to this Container
        this.layout = {
            type : 'column'
        };
		this.items = [];
		var flg=false;
		var mgsty="0 8 0 0";
			if(flg)
			{
				mgsty="0 0 0 0";
				flg=false;
			}
			else 
				flg=true;
		for(var key in positionsObj){
			var columnItems = positionsObj[key];
			var column = {
				xtype:'portalcolumn',
				padding:mgsty,
				id:key
			};
			var insertItems = [];
			for(j=0;j<columnItems.length;j++){
				insertItems.push({
					xtype:columnItems[j]
				});
			}
			column.items = insertItems;
			this.items.push(column);
		}
		this.callParent();
        this.addEvents({
            validatedrop: true,
            beforedragover: true,
            dragover: true,
            beforedrop: true,
            drop: true
        });
        this.on('drop', this.doLayout, this);
    },
    // Set columnWidth, and set first and last column classes to allow exact CSS targeting.
    beforeLayout: function() {
        var items = this.layout.getLayoutItems(),
            len = items.length,
            i = 0,
            item;

        for (; i < len; i++) {
            item = items[i];
            item.columnWidth = 1 / len;
        }
        items[0].addCls('x-portal-column-first');
        items[len - 1].addCls('x-portal-column-last');
        return this.callParent(arguments);
    },
    // private
    initEvents : function(){
        this.callParent();
        this.dd = Ext.create('EMDashboard.dd.PortalDropZone', this, this.dropConfig);
    },
    // private
    beforeDestroy : function() {
        if (this.dd) {
            this.dd.unreg();
        }
        this.callParent();
    },
	setData:function(json){
		if(Ext.isEmpty(json))
			return false;
		if(!Ext.isEmpty(json.monitors)){
			this.down('combo[itemId=monitors]').getStore().loadRawData(json.monitors.options);
			this.down('combo[itemId=monitors]').setValue(json.monitors.selected);
		}

		if(!Ext.isEmpty(json.filters)){
			this.down('combo[itemId=filters]').getStore().loadRawData(json.filters.options);
			this.down('combo[itemId=filters]').setValue(json.filters.selected);
		}

		if(!Ext.isEmpty(json.subFilters)){
			this.down('combo[itemId=subFilters]').getStore().loadRawData(json.subFilters.options);
			this.down('combo[itemId=subFilters]').setValue(json.subFilters.selected);
		}
	},
	setPanelToBase:function(panel){
		var columns = this.items.items;
		var insertPosition = 0;
		if(columns.length != 0){
			var previousLength = columns[0].length;
			for(i=0;i<columns.length;i++){
				if(columns[i].length < previousLength)
				{
					insertPosition = i;
					break;
				}
				previousLength = columns[i].length;
			}
		}
		columns[insertPosition].add(panel);
	}
});