Ext.define('EMDashboard.view.ComponentOverviewStatusSummary',{
	extend:'Ext.panel.Panel',
	alias:'widget.componentoverviewstatussummary',
	tile:'Summary',
	frame:false,
	layout:'vbox',
	padding:0,
	margin:'0 8 12 0',
	width:'100%',
	cls:'emdPanelWithoutHeader',
	viewConfig:{
		emptyText:'<center><div style="margin:4% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div class="commonErrorMsgText">No data found</div></div></center>',
		deferEmptyText:false
	},
	bodyPadding:10,
	hidden:false,
	defaults:{
		padding:5,
		labelWidth:180
	},
	items:[{
		xtype:'displayfield',
		fieldLabel:'Current Status',
		itemId:'currentStatus',
		cls:'emd-block-head',
		baseCls:'emdDividerLine',
		labelSeparator:'',
		labelAlign:'left',
		padding:5,
		width:'100%',
		frame:false,
	}],
		
	initComponent:function(){
		this.callParent();
	},

	setData:function(json){
		var summaryItems = this.items.items;
		for(x=summaryItems.length-1;x>-1;x--){
			if(summaryItems[x].getItemId()!='currentStatus'){
				summaryItems[x].destroy();
			}
		}
		var colorClass = "GOOD";
		colorClass = json.statusColor;
		var labelStyle='<div class="'+colorClass+'_bg f11-bold" style="width:70px;float:left;margin:0 0 5 0;padding:1px 3px 1px 3px;height:18px;font-weight:bold;"><b>'+json.currentStatus+'</b></div>';
		this.down('displayfield[itemId=currentStatus]').setValue(labelStyle);
		for (var key in json){
			if(key.indexOf("measure")>-1){
				if(typeof(json[key].value)=='object'){
					this.add(					
						{
							xtype:'container',
							padding:'2 0 4 0',
							width:'100%',
							cls:'emdDividerLine',

						},{
						xtype:'container',
						width:'100%',
						//style:{'border-bottom':'1px solid #222222','font-weight':'bold'},
						padding:'2 0 2 0',
						layout:'hbox',
						cls:'emd-block-head emdDividerLine',
						items:[{
							xtype:'component',
							itemId:'measureValue2',
							html:json[key].name,
							margin:0,
							padding:'6 0 0 0',
							width:180,
							labelCls:'emd-block-head',
						},{
							xtype:'container',
							margin:'0 0 0 0',
							padding:0,
							
							//style:{'border':'0px solid red'},
							layout:'vbox',
							items:[{
								xtype:'displayfield',
								itemId:'averageValue',
								labelCls:'emd-block-text',
								margin:0,
								labelSeparator:'',
								labelAlign:'left',
								value:'<div class="emd-block-text" style="height:21px">Avg:&nbsp;<b>'+((json[key].value.average!="-")?json[key].href+json[key].value.average+'</a>':json[key].value.average)+'</b></div>'
							},{
								xtype:'container',
								margin:0,
								padding:'0 20 0 20',
							},{
								xtype:'displayfield',
								itemId:'maximumValue',
								labelCls:'emd-block-text',
								padding:0,
								labelSeparator:'',
								labelAlign:'left',
								value:'<div class="emd-block-text">Max:&nbsp;<b>'+((json[key].value.maximum!="-")?json[key].href+json[key].value.maximum+'</a>':json[key].value.maximum)+'</b></div>'
							}]
						}]
					}
				);
				}
				else {
					this.add({
						xtype:'displayfield',
						fieldLabel:json[key].name,
						labelSeparator:'',
						cls:'emd-block-head',
						labelAlign:'left',
						width:'100%',
						padding:'5 0 0 0',
						margin:'8 0 0 0',
						//style:{'border-top':'1px solid #222222'},
						value:'<b>'+(json[key].value!="-")?json[key].href+json[key].value+"</a>":json[key].value+'</b>'
					});
				}				
			}
		}
	}
});