var centerMap = new google.maps.LatLng(40.3780, 10.4359);
Ext.define('EMDashboard.view.LocationsMap',{
	extend:'Ext.ux.GMapPanel',
	alias:'widget.locationsmap',
	autoDestroy:true,
	layout: 'fit',
	anchor: '100%',
	mapData:null,
	style:{'border':'0px solid red'},
    cls: 'emdOuterpanel',
	bodyPadding:'0 10 10 10',
	margin:'0 0 0 0',
	gmapType: 'map',
	xtype: 'gmappanel',
	itemId:'mapIds',
	id:'mapIds',
	markers:null,
	height:370,
	/*mapOptions: {
		zoom:1,
		minZoom:1,
		center:new google.maps.LatLng(0,0),
		mapTypeId:google.maps.MapTypeId.ROADMAP
	},*/
	mapOptions: {
			center: centerMap,
			minZoom:1,
			zoom: 1,
			draggable: false,
			scrollwheel: false,
			backgroundColor:rumSkin,
			navigationControl: false,
			mapTypeControl:false,
			zoomControl: false,
			scaleControl:false,
			panControl: false,
			streetViewControl:false,
			disableDoubleClickZoom: false,
			drawingControl: false,
			mapTypeControlOptions: 
			{
			  mapTypeIds: [google.maps.MapTypeId.ROADMAP]
			},
			mapTypeId: MY_MAPTYPE_ID
		},
	setMapMarkers:function(markersArray){
		this.mapData = [];
		this.mapData = markersArray;
		this.fireEvent('mark',this);
	},
	clearMapMarkers:function(){
		return this.fireEvent('clearmark',this);
	},
	initialize:function(markersArray) {
    },
	
	setMarkers:function(map, locations) {
    var bounds = new google.maps.LatLngBounds();
    for (var i = 0; i < locations.length; i++) 
    {
            var beach = locations[i];
            var coords = new google.maps.LatLng(beach[1], beach[2]);
            var contentString = '<div id="content">'+
                'Info Window Test:' +  beach[0] + 
                '</div>';
            var infowindow = new google.maps.InfoWindow({content: contentString});
            var markerImage = new google.maps.MarkerImage
            (
                "http://www.alawar.com/games_img/games/sky-bubbles/sky-bubbles-deluxe-logosmall.gif"
            );
            var marker = new google.maps.Marker({
                position: coords,
                map: map,
                icon: markerImage,
                title: beach[0],
                zIndex: beach[3]
            });
            google.maps.event.addListener(marker, 'click', 
                function (infowindow, marker) {
                    return function () {
                        infowindow.open(map, marker);
                    };
                }(infowindow, marker)
            );
            bounds.extend(coords);
    }
},
	initComponent:function(){
		//google.maps.visualRefresh = true;
		this.callParent();
		this.initialize();
	}
});