
Ext.define('EMDashboard.view.LocationsTree',{
	extend:'Ext.tree.Panel',
	alias:'widget.locationstree',
	autoDestroy:true,
	cls:'emdTree',
	autoScroll:false,
	rootVisible:false,
	useArrows:true,
	stateId:'locationTree',
	stateful:true,
	frame:true,
	stateEvents:[,'itemexpand','itemcollapse'],
	layout: 'fit',
    anchor: '100%',
	margin:'0 4 12 0',
	bodyPadding:'0 10 10 10',
	emptyRoot:{children: [],text: '.'},
	viewConfig:{
		emptyText:'<center><div style="margin:10% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div class="commonErrorMsgText">No data found</div></div></center>',
		deferEmptyText:false
	},
    draggable: {
        moveOnDrag: false,
    },
	store:'Tree',
	dockedItems:[
	{
		xtype:'toolbar',
		cls:'emdDocked',
		dock:'top',
		padding:'13 8 0 10',
		items:[
			{
				xtype:'container',
				cls:'emdDatapanelHeader',
				html:'All Monitors grouped by location'
				
			},
			{
				xtype:'button',
				cls:'treeButton',
				itemId:'expandAll',
				iconCls:'iconTreeExpand',
				listeners: {
					click: function() {
						var curClass = this.iconCls;
						if(curClass != null && curClass != undefined){
							if(curClass == 'iconTreeExpand')
								this.setIconCls('iconTreeCollapse');
							else if(curClass == 'iconTreeCollapse')
								this.setIconCls('iconTreeExpand');
						}
					}
				}
			},'->',
			{
				xtype:'combo',
				cls:'dropdown',
				labelSeparator:'',
				itemId:'severity',
				labelSeparator:'',
				padding:'0 0 0 0',
				fieldLabel:'Severity',
				width:'35%',
				minWidth:150,
				labelWidth:55,
				editable:false,
				displayField:'display',
				valueField:'value',
				queryMode:'local',
				store:Ext.create('Ext.data.Store',{
					fields:['display','value']
				})
			}
		]
	}
	],
	setData:function(json){
		if(Ext.isEmpty(json.locationPanel)){
			var newRoot = this.setRootNode("");
			return false;
		}
		else if(Ext.isEmpty(json.locationPanel.treeData)){
			//this.setEmptyPanel();
			//return false;
		}
		else{
			var newRoot = this.setRootNode(json.locationPanel.treeData);
			if(!newRoot.hasChildNodes()){
				//this.setEmptyPanel();
				//return false;
			}
			this.down('combo[itemId=severity]').getStore().loadRawData(json.locationPanel.severity.options);
			this.down('combo[itemId=severity]').setValue(json.locationPanel.severity.selected);
		}
		this.setLoading(false);
	},
	initComponent:function(){
		this.setLoading(true,true);
		Ext.state.Manager.setProvider(new Ext.state.CookieProvider({
			expires: new Date(new Date().getTime()+(1000*60*60*24*7)), //7 days from now
		}));
		this.callParent();

	},
});