Ext.define('EMDashboard.view.MonitorOverview',{
	extend:'Ext.panel.Panel',
	alias:'widget.monitoroverview',
	title:'Monitors Overview',
	iconCls:'',
	autoDestroy:true,
	cls:'emdOuterpanel',
	margin:'10 10 10 10',
	bodyPadding:'11 0 11 11',
	layout:'column',
	columns:2,
	autoScroll:true,
	padding:0,
	scroll:true,
	bodyStyle:{'border':'0px solid blue','background-color':'none'},
	border:true,
	tools:[
	{
		xtype:'container',
		margin:'0 0 10 0',
		padding:0,
		style:{'border':'0px solid red'},
		layout:'hbox',
		items:[{
				xtype:'tbfill'
			},{
				xtype:'combo',
				labelSeparator:'',
				cls:'dropdown',
				itemId:'monitorGraphsLocationFilter',
				padding:'0 10 0 0',
				fieldLabel:'Location',
				width:220,
				style:{'color':'#fff'},
				labelWidth:50,
				editable:false,
				displayField:'display',
				valueField:'value',
				queryMode:'local',
				store:Ext.create('Ext.data.Store',{
					fields:['display','value'],
					data:[]
				})
			},{
				xtype:'button',
				cls:'backbutton',
				iconCls:'iconBack',
				text:'Back',
				action:'back',
			}]
	}
	],
	items:[
	{
		xtype:'container',
		id:'monFirstCon',
		layout:'anchor',
		padding:'0 0 0 0',
		style:{'border':'0px solid red'},
		columnWidth:.50,
	},
	{
		xtype:'container',
		id:'monSecCon',
		layout:'anchor',
		padding:'0 0 0 0',
		style:{'border':'0px solid red'},
		columnWidth:.50,
	}
	],

	initComponent:function(){
		this.callParent();
		var me = this;
       this.addEvents({
            validatedrop: true,
            beforedragover: true,
            dragover: true,
            beforedrop: true,
            drop: true
        });
        this.on('drop', this.doLayout, this);
	},
	 initEvents : function(){
        this.callParent();
        this.dd = Ext.create('EMDashboard.dd.PortalDropZone', this, this.dropConfig);
    }
});