Ext.define('EMDashboard.view.MonitorTree',{
	extend:'Ext.tree.Panel',
	alias:'widget.monitortree',
	autoDestroy:true,
	autoScroll:false,
	rootVisible:false,
	useArrows:true,
	stateId:'monitorTree',
	stateful:true,
	frame:true,
	cls:'emdTree',	
	stateEvents:[,'itemexpand','itemcollapse'],
	layout: 'fit',
    anchor: '100%',
	bodyPadding:'0 10 10 10',
	margin:'0 4 12 0',
	emptyRoot:{children: [],text: '.'},
	viewConfig:{
		emptyText:'<center><div style="margin:10% 0 auto 0"><img class="iconInformation" src="/final/images/spacer.gif"/><div class="commonErrorMsgText">No data found</div></div></center>',
		deferEmptyText:false
	},
    draggable: {
        moveOnDrag: false    
    },
	store:'MonTree',
	dockedItems:[
	{
		xtype:'toolbar',
		cls:'emdDocked',
		dock:'top',
		padding:'13 8 0 10',
		items:[{
			xtype:'container',
			cls:'emdDatapanelHeader',
			html:'All Locations grouped by monitors'
			
		},
			{
			xtype:'button',
			cls:'treeButton',
			itemId:'monitorExpandAll',
			iconCls:'iconTreeExpand',
			listeners: {
				click: function() {
					var curClass = this.iconCls;
					if(curClass != null && curClass != undefined){
						if(curClass == 'iconTreeExpand')
							this.setIconCls('iconTreeCollapse');
						else if(curClass == 'iconTreeCollapse')
							this.setIconCls('iconTreeExpand');
					}
				}
			}
		},'->',{
		xtype:'combo',
		cls:'dropdown',
		itemId:'monitorSeverity',
		padding:'0 0 0 0',
		fieldLabel:'Severity',
		//width:220,
		width:'35%',
		minWidth:150,
		labelWidth:55,
		labelSeparator:'',
		editable:false,
		displayField:'display',
		valueField:'value',
		queryMode:'local',
		store:Ext.create('Ext.data.Store',{
			fields:['display','value']
		})
	}
	]
	}
	],
	setData:function(json){
		if(Ext.isEmpty(json.monitorGroupBy)){
			 this.setRootNode("");
			return false;
		}
		else{
			var newRoot = this.setRootNode(json.monitorGroupBy);
			if(!Ext.isEmpty(json.locationPanel.severity))
			{
				this.down('combo[itemId=monitorSeverity]').getStore().loadRawData(json.locationPanel.monSeverity.options);
				this.down('combo[itemId=monitorSeverity]').setValue(json.locationPanel.monSeverity.selected);
			}
			else
				this.down('combo[itemId=monitorSeverity]').setValue("All");

			if(!newRoot.hasChildNodes()){
				//this.setEmptyPanel();
				return false;
			}
		}
	},
	initComponent:function(){
		Ext.state.Manager.setProvider(new Ext.state.CookieProvider({
			expires: new Date(new Date().getTime()+(1000*60*60*24*7)), //7 days from now
		}));
		this.callParent();
	},

	setEmptyPanel:function(){
		this.body.update('<div style="font-weight:bold;text-align:center;padding:100px 0px"><img class="x-grid-empty-image" src="eg_images/gray/exclamation-icon.gif"/><br/>No data found</div>');
	}
});