Ext.define('EMDashboard.view.StatusSummary',{
	extend:'Ext.panel.Panel',
	alias:'widget.statussummary',
	tile:'Summary',
	cls:'emdDatapanel',
	layout:{type:'vbox',align:'stretch'},
	frame:false,
	bodyPadding:10,
	margin:'0 0 0 0',
	width:'100%',
	defaults:{labelWidth:180},
	items:[{
		xtype:'displayfield',
		fieldLabel:'Current Status',
		itemId:'currentStatus',
		labelSeparator:'',
		labelAlign:'left',
	},
	{
		xtype:'container',
		cls:'emdDividerLine',
		style:{'padding-bottom':'2px'}

	}
],
		
	initComponent:function(){
		this.callParent();
	},

	setData:function(json){
		var summaryItems = this.items.items;
		for(x=summaryItems.length-1;x>-1;x--){
			if(summaryItems[x].getItemId()!='currentStatus'){
				summaryItems[x].destroy();
			}
		}
		var colorClass = "GOOD";
		colorClass = json.statusColor;

		var currStat='<div class="'+colorClass+'_bg" style="padding:1px 3px 1px 3px;height:18px;color:#fff;font-weight:bold"><b>'+json.currentStatus+'</b></div>';
		this.down('displayfield[itemId=currentStatus]').setValue(currStat);
		var measSize = 0;
		for (var key in json){
			if(key.indexOf("measure")>-1){measSize = measSize+1;}
		}
		var itr = 0;
		for (var key in json){
			if(key.indexOf("measure")>-1){
				itr =itr+1;
				var measState = "<div style='float:left;padding-top:2px'><img style='margin-top:1px;margin-right:2px;' src='data:image/gif;base64,R0lGODlhAQABAID/AMDAwAAAACH5BAEAAAAALAAAAAABAAEAAAICRAEAOw==' class=";
				measState = measState+"state_"+json[key].iconCls+"></div>";
				var measureKeyValue = json[key].value;
				var measDispVal = "";

				if( !Ext.isEmpty(measureKeyValue.average))
				{
					measDispVal = measState+'<div style="float:left;width:120px" class="emd-block-text">Avg:&nbsp;'+((measureKeyValue.average!="-")?json[key].href+measureKeyValue.average+'</a>':measureKeyValue.average)+'</div>';
				
					if( !Ext.isEmpty(measureKeyValue.maximum))
					{
						measDispVal = measDispVal+'<div style="float:left;width:120px" class="emd-block-text">Max:&nbsp;'+((measureKeyValue.maximum!="-")?json[key].href+measureKeyValue.maximum+'</a>':measureKeyValue.maximum)+'</div>';
					}
				}
				else
				{
					measDispVal = measState+"<div style='float:left;padding-top:5px'>"+((json[key].value!="-")?json[key].href+json[key].value+'</a>':json[key].value)+"</div>";
				}
				this.add(
					{
						xtype:'container',
						cls:'emdDividerLine',
						style:{'margin-bottom':'5px'}

					},{
						xtype:'displayfield',
						fieldLabel:json[key].name,
						labelSeparator:'',
						labelAlign:'left',
						value:measDispVal,
					}
				);
				if(measSize == itr)
				{
					this.add(
						{
							xtype:'container',
							cls:'emdDividerLine',
							style:{'padding-bottom':'2px'}
						});
				}

				
			}
		}
	}
});