Ext.define('EMDashboard.view.TransactionOverview',{
	extend:'Ext.panel.Panel',
	alias:'widget.transactionoverview',
	autoDestroy:true,
	cls:'emdOuterpanel',
	margin:'10 10 10 10',
	bodyPadding:'11 0 11 11',
	//padding:'0 10 0 0',
	autoScroll:true,
	scroll:true,
	layout:'column',
	columns:2,
	bodyStyle:{'border':'0px solid blue'},
	tools:[
			{
				xtype:'container',
				//margin:'0 0 5 0',
				padding:'5 0 5 0',
				style:{'border':'0px solid red'},
				layout:'hbox',
				items:[{
						xtype:'combo',
						labelSeparator:'',
						cls:'dropdown',
						itemId:'locationFilter',
						fieldLabel:'Filter by',
						style:{'color':'#fff'},
						labelWidth:50,
						queryMode:'local',
						width:220,
						displayField:'display',
						valueField:'value',
						value:'ALL',
						store:Ext.create('Ext.data.Store',{
							fields:['display','value']
						})
					},
					{
						xtype:'button',
						cls:'backbutton',
						iconCls:'iconBack',
						text:'Back',
						margin:'0 0 0 10',
						action:'back',
					}
				]
		},
		
	],
	items:[{
		xtype:'container',
		id:'transFirstCon',
		layout:'anchor',
		padding:'0 0 0 0',
		style:{'border':'0px solid red'},
		columnWidth:.50,
	},
	{
		xtype:'container',
		id:'transSecCon',
		layout:'anchor',
		padding:'0 0 0 0',
		style:{'border':'0px solid red'},
		columnWidth:.50,
	}],
	
	 initComponent : function() {
		this.callParent();
		 var me = this;
       this.addEvents({
            validatedrop: true,
            beforedragover: true,
            dragover: true,
            beforedrop: true,
            drop: true
        });
        this.on('drop', this.doLayout, this);
    },
	 initEvents : function(){
        this.callParent();
        this.dd = Ext.create('EMDashboard.dd.PortalDropZone', this, this.dropConfig);
    },
	
});