var timerId = null;
Ext.Loader.setConfig({
	enabled: true,
	disableCaching: false,
	preserveScripts: false,
	garbageCollect: true,
	paths: {
		'Ext.ux': '/final/scripts/ux',
		'utilities': '/final/scripts/utilities',
		'widgets': '/final/scripts/widgets',
	}
});

Ext.require('Ext.ux.form.ItemSelector');
Ext.require('Ext.ux.form.MultiSelectSI');
Ext.application({
	name: 'EgCitrixDashCloud',
	controllers: ['Main'],
	requires: ['EgCitrixDashCloud.view.Main', 'EgCitrixDashCloud.config.Runtime','utilities.Multiselector','Ext.ux.form.MultiSelectSI'],
	//requires:['EgCitrixDashCloud.view.Main'],
	autoCreateViewport: true,
	appFolder: '../monitor/eg_scripts/EgCitrixDashCloud',
	launch: function () {
		EgCitrixDashCloud.app = this
	}
});

Highcharts.setOptions({
	global: {
		useUTC: true,
		timezoneOffset: timeZoneOffsetVal
	}
});

Highcharts.Point.prototype.highlight = function (event) {
	event = this.series.chart.pointer.normalize(event);
	this.onMouseOver(); // Show the hover marker
	this.series.chart.tooltip.refresh(this); // Show the tooltip
	this.series.chart.xAxis[0].drawCrosshair(event, this); // Show the crosshair
};

/*Highcharts.Pointer.prototype.reset = function () {
    return undefined;
};*/

function syncExtremes(e) {
	var thisChart = this.chart;

	if (e.trigger !== 'syncExtremes') { // Prevent feedback loop
		Highcharts.each(Highcharts.charts, function (chart) {
			if (chart !== thisChart) {
				if (chart.xAxis[0].setExtremes) { // It is null while updating
					chart.xAxis[0].setExtremes(e.min, e.max, undefined, false, {
						trigger: 'syncExtremes'
					});
				}
			}
		});
	}
}

function executee() {
	EgCitrixDashCloud.app.getController('Main').updatePage();
}

function goToSessionsPage()
{
	EgCitrixDashCloud.app.getController('Main').goToSessionsPage();	
}

function goToLogonPage()
{
	EgCitrixDashCloud.app.getController('Main').goToLogonPage();	
}

function goToLatencyPage()
{
	EgCitrixDashCloud.app.getController('Main').goToLatencyPage();	
}

function goToHomePage()
{
	EgCitrixDashCloud.app.getController('Main').goToHomePage();	
}

function goToUxImproveAlarmPage()
{
	EgCitrixDashCloud.app.getController('Main').goToAlarmsPage();	
}
function goToZoneList(componentType,allCompTypes,listPageTitle)
{
	//var url = '/final/servlet/com.eg.EgMonitorController?monCmd=componentList&from=componentList&action=&searchIndComps=checked&view=metric&viewId=components&viewPageTitle=&viewTreeTitle=Component&componentType='+componentType+'&fromPageView=Menu&filterBy=zone&subFilter='+queryReqParams.zoneName+'&zoneName='+queryReqParams.zoneName+'&fromHomepage=&userName=&stateName=&selectedState=';

	var url = '/final/servlet/com.eg.EgMonitorController?monCmd=componentList&from=componentList&action=&searchIndComps=checked&view=List&viewId=components&viewPageTitle=&viewTreeTitle=Component&componentType=&fromPageView=Menu&filterBy=zone&subFilter='+queryReqParams.zoneName+'&zoneName='+queryReqParams.zoneName+'&fromHomepage=&userName=&stateName=&selectedState=&manyComponentTypes='+encodeURI(allCompTypes)+'&manyComponentTitle='+listPageTitle+"&selTypeString="+encodeURI(allCompTypes);

	location.href = url;
}

function get_browser_info()
{
	var ua=navigator.userAgent,tem,M=ua.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i) || []; 
	if(/trident/i.test(M[1])){
		tem=/\brv[ :]+(\d+)/g.exec(ua) || []; 
		return {name:'IE ',version:(tem[1]||'')};
		}   
	if(M[1]==='Chrome'){
		tem=ua.match(/\bOPR\/(\d+)/)
		if(tem!=null)   {return {name:'Opera', version:tem[1]};}
		}   
	M=M[2]? [M[1], M[2]]: [navigator.appName, navigator.appVersion, '-?'];
	if((tem=ua.match(/version\/(\d+)/i))!=null) {M.splice(1,1,tem[1]);}
	return {
	  name: M[0],
	  version: M[1]
	};
}

function callDDwindow(time)
{
	if(time != null && time.indexOf("|"))
		time = time.substring(0,time.indexOf("|"));

	var url = '/final/monitor/EgDiagnosis.jsp?site=NULL&host='+queryReqParams.host+'&port='+queryReqParams.port+'&test='+queryReqParams.test+'&info='+queryReqParams.info+'&msmt_host='+queryReqParams.msmt_host+'&from=0&comptype='+queryReqParams.comptype+'&measure='+queryReqParams.measName+'&flag=1&firsttime=true&fromAlarmDetails=true';
	var ddUrl = showDDDataForThisTime(url,time);
	try
	{
		Ext.create('Ext.window.Window', {
			resizable:false,
			title:'Detailed Diagnosis',
			width:'95%',
			draggable: true,
			ghost:false,
			flex:1,
			layout:{
					type:'fit',
					align:'stretch'
			},
			modal:true,
			constrain:true,
			renderTo:Ext.getBody(),
			height:'95%',
			items:[{
				xtype:'panel',
				layout:'fit',
				listeners:{
					afterrender:function(e)
					{
						var me = this;
						Ext.Ajax.request({
							url: ddUrl,
							scope:this,
							method: 'POST',
							timeout:280000,
							success: function( response )
							{
								if ( response.status == 200 && !Ext.isEmpty(response.responseText))
								{
									var jsonText = response.responseText;
									var jsonData = Ext.decode(jsonText);
									
									if(!Ext.isEmpty(jsonData))
									{										
										if(!Ext.isEmpty(jsonData.gridInfo))
										{
											var fields = [];
											for(var l=0;l<jsonData.gridInfo.headers.length;l++){
												var dataIndexVal = jsonData.gridInfo.headers[l].dataIndex;
												fields.push(dataIndexVal);
											}
											var groupingFeature = Ext.create('Ext.grid.feature.Grouping',{
												groupHeaderTpl:'{groupValue}',
												collapsible:false
											});
											var groupFiled = 'time';
											jsonData.gridInfo.headers[0].hidden = true;
											me.add({
												xtype:'grid',
												forceFit:true,
												viewConfig: {
													deferEmptyText:false,
													emptyText:'<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No data found!</div></div></div>'
												},
												cls:'gridSkin ddGridView',
												features:[groupingFeature],
												plugin:Ext.create('Ext.ux.AutoColumnWithLockingPlugin'),
												columns:jsonData.gridInfo.headers,
												store:Ext.create('Ext.data.Store',{
													fields:fields,
													data:jsonData.gridInfo.data,
													groupField:groupFiled
												})
											});
										}
										else
											me.update('<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No data found!</div></div></div>');
									}
									//Ext.getCmp('latencyDonut').loadChart(jsonData.result[0]);
								}
							}
						});
					},
				}
			}],
			listeners:
			{
				show: function(win)
				{
					if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');								
						var el = Ext.fly(dom[dom.length-1]);								
						el.addCls('windowModal');
					}
				},
				hide: function(win)
				{
					if (this.modal)
					{
						var dom = Ext.dom.Query.select('.x-mask');
						var el = Ext.fly(dom[dom.length-1]);
						el.removeCls('windowModal');
					}
				},
				afterrender: function()
				{
					Ext.EventManager.onWindowResize(function()
					{
						var me = this;
						me.center();
					}, this);
				}
			}
		}).show();
	}
	catch (e)
	{
	}
}
