Ext.define('EgCitrixDashCloud.config.Runtime', {
    singleton: true,
    axisFontSize: '9px',
    noDataText: "No Data",
    noDataFontSize: "20px",
    noDataFontSize_12: "12px",
    noDataMsg: function (string) {
        return '<span style="margin:auto;display:inline-block" class="iconInformation"></span><br><span style="margin:auto;display:inline-block;font-weight: normal;" >' + string + '</span>';
    },
    legendFontColor: (strSkin == "Light") ? "#2a292a" : "#2a292a",
    titleFontColor: (strSkin == "Light") ? "#414141" : "#fff",
    axisFontColor: (strSkin == "Light") ? "#969696" : "#fff",
    gridLineColor: (strSkin == "Light") ? "#e1e1e1" : "#e1e1e1",
    noDataBg: (strSkin == "Light") ? "#fff" : "#fff",
    config: {
		simpleareaChart: function (selector, _chartData, timeline) {
            //console.log("_chartData=-=-=-=-areaChart>>",_chartData)
			var arrSum = 1;
            var plotBackgroundColor = null;
            if (Ext.isEmpty(_chartData.data)) {
                plotBackgroundColor = this.noDataBg;
				arrSum = null;
            }
			if(!Ext.isEmpty(_chartData.data))
			{
				if(_chartData.data.length == 1)
				{
					var _checkData = _chartData.data[0].data;
					if(_checkData.length > 0)
					{
						for(var yc=0;yc<_checkData.length;yc++)
						{
							if(_checkData[yc].y > 0)
								arrSum = null;
						}
					}
					else
						arrSum = null;
				}
			}
			var markerEnabled = false;
			if(arrSum != null && arrSum == 1)
				markerEnabled = true;

            var chartData = {
                chart: {
                    type: 'area',
                    backgroundColor: null,
                    style: {
                        fontFamily: 'Roboto',
                        lineHeight: '20px',
                        fontWeight: 'normal'
                    },
                    plotBackgroundColor: plotBackgroundColor,
                    styledMode: true,
                    reflow:true,
                    spacing: [20, 0, 10, 0]
                },
                lang: {
                    noData: this.noDataMsg(this.noDataText)
                },
                noData: {
                    useHTML: true,
                    style: {
                        fontSize: this.noDataFontSize_12
                    }
                },
                exporting: {
                    enabled: false
                },
                navigator: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                title: {
                    useHTML: true,
                    align: !Ext.isEmpty(_chartData.isPanel) ? 'left' : 'center',
                    style: {
                        "color": this.titleFontColor,
                        "lineHeight": "24px",
                        "fontSize": !Ext.isEmpty(_chartData.isPanel) ? "16px" : "12px",
                        "fontWeight": !Ext.isEmpty(_chartData.isPanel) ? "400" : "500"
                    },
                    text:'',

                },
                xAxis: {
                    type: 'datetime',
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    dateTimeLabelFormats: {
                        hour: '%H:%M'
                    },
                    allowDecimals: false,
                    tickLength: 0,
                    labels: {
                        useHTML: true,
                        style: {
                            "color": this.axisFontColor,
                            "fontSize": "11px"
                        }
                    },
                    title: {
                        text: _chartData.xaxisLabel,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                },
                yAxis: {
                    min: 0,
					max:arrSum,
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    title: {
                        text: _chartData.yaxisLabel,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                    labels: {
                        useHTML: true,
                        style: {
                            "color": this.axisFontColor,
                            "fontSize": "11px"
                        },
                        formatter: function () {
                            return this.value;
                        }
                    }
                },
                tooltip: {
                    headerFormat: '{series.name} <br/>',
                    pointFormat: '{point.info} {point.y}',				
                },
                plotOptions: {					
					series: {
						turboThreshold:0,
						connectNulls: connectNullsFlag,
						lineWidth: 0,
						states: {
							hover: {
								enabled: false,
								lineWidth: 0
							}
						},
					    marker: {
							enabled: markerEnabled
						}
					},
                    area: {
                        //stacking: 'percent',
                        marker: {
                            enabled: false,
                            symbol: 'circle',
                            radius: 2,
                            states: {
                                hover: {
									lineWidth: 0,
                                    enabled: true
                                }
                            }
                        }
                    }
                },
                legend: {
					enabled:false,
                    useHTML: true,
                    itemStyle: {
                        fontSize: '11px',
                        fontWeight: 500,
                        color: this.legendFontColor

                    },
                    padding: 0,
                    symbolHeight: 6,
                    symbolPadding: 2,
                    symbolRadius: 6,
                    symbolWidth: 6,
                    verticalAlign: 'top',
                    maxHeight: 35,
                    navigation: {
                        activeColor: '#3E576F',
                        animation: true,
                        arrowSize: 9,
                        inactiveColor: '#CCC',
                        style: {
                            fontWeight: 'bold',
                            color: '#333',
                            fontSize: '12px'
                        }
                    }
                },
                series: _chartData.data
            }
			//overriding config
            if (!Ext.isEmpty(timeline)) {
				//console.log("_chartData.data==--==->>",_chartData.data)
                chartData = Ext.apply(chartData, {
					tooltip: {
						shared: false,
						formatter: function () {
							return Highcharts.dateFormat("%A, %b %e, %H:%M:%S", new Date(this.point.realTime)) + "<br/>" + this.point.y;
						}
					},
					series: [_chartData.data[1],_chartData.data[0]]
                });
            }
            return chartData;
        },
		areaPlotChart: function (selector, _chartData, timeline) {
            //console.log("_chartData=-=-=-=-areaPlotChart>>",_chartData)
            var plotBackgroundColor = null;
            if (Ext.isEmpty(_chartData.DataSet)) {
                plotBackgroundColor = this.noDataBg;
            }
			if(_chartData.DataSet != null)
			{
				for(let t=0;t<_chartData.DataSet.length;t++)
				{
					if(_chartData.DataSet[t].dashStyle == "line")
					{
						_chartData.DataSet[t].events={
							click: function(e) {
								var datas = _chartData.DataSet[t].data;
								for (var a in datas)
								{
									var points = datas[a];
									if(points[0] == e.point.category )
									{
										if(queryReqParams.ddEnabled)
											callDDwindow(points[2]);
									}
								}
							}
						}
					}
				}
			}
            var chartData = {
                chart: {
                    //type: 'area',
                    backgroundColor: null,
                    style: {
                        fontFamily: 'Roboto',
                        lineHeight: '20px',
                        fontWeight: 'normal'
                    },
                    plotBackgroundColor: plotBackgroundColor,
                    styledMode: true,
                    spacing: [0, 0, 30, 0]					
                },
                lang: {
                    noData: this.noDataMsg(this.noDataText)
                },
                noData: {
                    useHTML: true,
                    style: {
                        fontSize: this.noDataFontSize_12
                    }
                },
                exporting: {
                    enabled: false
                },
                navigator: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                title: {
					useHTML: true,
                    align: !Ext.isEmpty(_chartData.isPanel) ? 'left' : 'center',
                    style: {
                        "color": this.titleFontColor,
                        "lineHeight": "24px",
                        "fontSize": !Ext.isEmpty(_chartData.isPanel) ? "16px" : "12px",
                        "fontWeight": !Ext.isEmpty(_chartData.isPanel) ? "400" : "500"
                    },
                    //text: _chartData.title
                    text:''
                },
                xAxis: {
                    type: 'datetime',
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    dateTimeLabelFormats: {
                        hour: '%H:%M'
                    },
                    allowDecimals: false,
                    tickLength: 0,
                    labels: {
                        useHTML: true,
                        style: {
                            "color": this.axisFontColor,
                            "fontSize": "11px"
                        }
                    },
                    title: {
                        text: _chartData.axislabel,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
					//plotLines: [{
						//value: _chartData.maxPlotTime,
						////to: 1556682755000,
						////color: '#f99d9e',
						//color: '#ffba00',
						//dashStyle: 'line',
						//width: 2,
						////color: 'rgba(241,111,113,0.5)',
						//zIndex: 4
					//}]
                },
                yAxis: {
                    min: 0,
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    title: {
                        text: _chartData.yAxisLabel,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                    labels: {
                        useHTML: true,
                        style: {
                            "color": this.axisFontColor,
                            "fontSize": "11px"
                        },
                        formatter: function () {
                            return this.value;
                        }
                    }
                },
                tooltip: {
                    pointFormat: '{series.name} : {point.y}'
                },
                plotOptions: {					
					series: {
						turboThreshold:0,
						connectNulls: connectNullsFlag,
						lineWidth: 0
					},
                    area: {
                        //stacking: 'percent',
                        marker: {
                            enabled: false,
                            symbol: 'circle',
                            radius: 2,
                            states: {
                                hover: {
                                    enabled: true
                                }
                            }
                        }
                    }
                },
                legend: {
                    useHTML: true,
                    itemStyle: {
                        fontSize: '11px',
                        fontWeight: 500,
                        color: this.legendFontColor

                    },
                    padding: 0,
                    symbolHeight: 6,
                    symbolPadding: 2,
                    symbolRadius: 6,
                    symbolWidth: 6,
                    verticalAlign: 'top',
                    maxHeight: 35,
                    navigation: {
                        activeColor: '#3E576F',
                        animation: true,
                        arrowSize: 9,
                        inactiveColor: '#CCC',
                        style: {
                            fontWeight: 'bold',
                            color: '#333',
                            fontSize: '12px'
                        }
                    }
                },
                series: _chartData.DataSet
            }
			//overriding config
            if (!Ext.isEmpty(timeline)) {
				//console.log("_chartData.data==--==->>",_chartData.data)
                chartData = Ext.apply(chartData, {
					tooltip: {
						shared: false,
						formatter: function () {
							return Highcharts.dateFormat("%A, %b %e, %H:%M:%S", new Date(this.point.realTime)) + "<br/>" + this.point.y;
						}
					},
					series: [_chartData.data[1],_chartData.data[0]]
                });
            }
            return chartData;
        },
        areaRangeLine: function (selector, _chartData) {
			var firstName = 'Logon Duration';
			var secondName = 'Min - Max Logon Duration';
			if(_chartData.yaxisLabel.indexOf("Latency") > -1)
			{
				firstName = 'Latency';
				secondName = 'Min - Max Latency';
			}
			else if(_chartData.yaxisLabel.indexOf("Sessions") > -1)
			{
				firstName = 'Sessions';
				secondName = 'Min - Max Sessions';
			}
            var plotBackgroundColor = null;
            if (Ext.isEmpty(_chartData.dataArray) && Ext.isEmpty(_chartData.rangeArray)) {
                plotBackgroundColor = this.noDataBg;
            }

            var chartProps = {
                chart: {
                    backgroundColor: null,
                    style: {
                        fontFamily: 'Roboto',
                        lineHeight: '18px',
                        fontWeight: 'normal'
                    },
                    plotBackgroundColor: plotBackgroundColor,
                    styledMode: true,
                    spacing: [0, 0, 10, 0]
                },
                exporting: {
                    enabled: false
                },
                navigator: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                lang: {
                    noData: this.noDataMsg(this.noDataText)
                },
                noData: {
                    useHTML: true,
                    style: {
                        fontSize: this.noDataFontSize_12
                    }
                },
                title: {
                    useHTML: true,
                    margin: 40,
                    style: {
                        "color": this.titleFontColor,
                        "lineHeight": "24px",
                        "fontSize": !Ext.isEmpty(_chartData.isPanel) ? "16px" : "12px",
                        "fontWeight": "500"
                    },
                    text: _chartData.title
                },
                xAxis: {
                    labels: {
                        useHTML: true,
                        style: {
                            "color": this.axisFontColor,
                            "fontSize": "11px",
                        }
                    },
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    title: {
                        text: _chartData.xaxisLabel,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                    type: 'datetime',
                    tickLength: 0
                },
                yAxis: {
                    min: 0,
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    labels: {
                        useHTML: true,
                        style: {
                            "color": this.axisFontColor,
                            "fontSize": "11px",
                        }
                    },
                    title: {
                        text: _chartData.yaxisLabel,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    }
                },
                tooltip: {
                    crosshairs: true,
                    shared: true
                },
                legend: {
                    enabled: false,
                    useHTML: true,
                    itemStyle: {
                        fontSize: '11px',
                        fontWeight: 500,
                        color: this.legendFontColor
                    },
                    padding: 0,
                    symbolHeight: 6,
                    symbolPadding: 2,
                    symbolRadius: 6,
                    symbolWidth: 6,
                    verticalAlign: 'top'
                },
				plotOptions: {
					series: {
						connectNulls: connectNullsFlag
					}
				},
                series: [{
                    name:firstName,
                    data: _chartData.dataArray,
                    zIndex: 1,
                    marker: {
                        fillColor: 'white',
                        lineWidth: 1,
                        lineColor: '#61a6f3'
                    }
                }, {
                    name:secondName,
                    data: _chartData.rangeArray,
                    type: 'arearange',
                    lineWidth: 0,
                    linkedTo: ':previous',
                    color: '#61a6f3',
                    fillOpacity: 0.5,
                    zIndex: 0,
                    lineWidth: 1,
                    lineColor: '#bccce3',
                    marker: {
                        enabled: false
                    }
                }]
            };
            return chartProps;

        },
        areaChart: function (selector, _chartData, timeline) {
            //console.log("_chartData=-=-=-=-areaChart>>",_chartData)
            var plotBackgroundColor = null;
            if (Ext.isEmpty(_chartData.data)) {
                plotBackgroundColor = this.noDataBg;
            }
            var chartData = {
                chart: {
                    type: 'area',
                    backgroundColor: null,
                    style: {
                        fontFamily: 'Roboto',
                        lineHeight: '20px',
                        fontWeight: 'normal'
                    },
                    plotBackgroundColor: plotBackgroundColor,
                    styledMode: true,
                    spacing: [0, 0, 10, 0]
                },
                lang: {
                    noData: this.noDataMsg(this.noDataText)
                },
                noData: {
                    useHTML: true,
                    style: {
                        fontSize: this.noDataFontSize_12
                    }
                },
                exporting: {
                    enabled: false
                },
                navigator: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                title: {
                    useHTML: true,
                    align: !Ext.isEmpty(_chartData.isPanel) ? 'left' : 'center',
                    style: {
                        "color": this.titleFontColor,
                        "lineHeight": "24px",
                        "fontSize": !Ext.isEmpty(_chartData.isPanel) ? "16px" : "12px",
                        "fontWeight": !Ext.isEmpty(_chartData.isPanel) ? "400" : "500"
                    },
                    text: _chartData.title,

                },
                xAxis: {
                    type: 'datetime',
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    dateTimeLabelFormats: {
                        hour: '%H:%M'
                    },
                    allowDecimals: false,
                    tickLength: 0,
                    labels: {
                        useHTML: true,
                        style: {
                            "color": this.axisFontColor,
                            "fontSize": "11px"
                        }
                    },
                    title: {
                        text: _chartData.xaxisLabel,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                },
                yAxis: {
                    min: 0,
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    title: {
                        text: _chartData.yaxisLabel,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                    labels: {
                        useHTML: true,
                        style: {
                            "color": this.axisFontColor,
                            "fontSize": "11px"
                        },
                        formatter: function () {
                            return this.value;
                        }
                    }
                },
                tooltip: {
                    pointFormat: '{series.name} : {point.y}'
                },
                plotOptions: {					
					series: {
						turboThreshold:0,
						connectNulls: connectNullsFlag,
						lineWidth: 0
					},
                    area: {
                        //stacking: 'percent',
                        marker: {
                            enabled: false,
                            symbol: 'circle',
                            radius: 2,
                            states: {
                                hover: {
                                    enabled: true
                                }
                            }
                        }
                    }
                },
                legend: {
                    useHTML: true,
                    itemStyle: {
                        fontSize: '11px',
                        fontWeight: 500,
                        color: this.legendFontColor

                    },
                    padding: 0,
                    symbolHeight: 6,
                    symbolPadding: 2,
                    symbolRadius: 6,
                    symbolWidth: 6,
                    verticalAlign: 'top',
                    maxHeight: 35,
                    navigation: {
                        activeColor: '#3E576F',
                        animation: true,
                        arrowSize: 9,
                        inactiveColor: '#CCC',
                        style: {
                            fontWeight: 'bold',
                            color: '#333',
                            fontSize: '12px'
                        }
                    }
                },
                series: _chartData.data
            }
			//overriding config
            if (!Ext.isEmpty(timeline)) {
				//console.log("_chartData.data==--==->>",_chartData.data)
                chartData = Ext.apply(chartData, {
					tooltip: {
						shared: false,
						formatter: function () {
							return Highcharts.dateFormat("%A, %b %e, %H:%M:%S", new Date(this.point.realTime)) + "<br/>" + this.point.y;
						}
					},
					series: [_chartData.data[1],_chartData.data[0]]
                });
            }
            return chartData;
        },
        timelineChart: function (selector, _chartData) {
            var plotBackgroundColor = null;
            if (Ext.isEmpty(_chartData.data)) {
                plotBackgroundColor = this.noDataBg;
            }
            chartProps = {
                chart: {
                    zoomType: 'xy',
                    backgroundColor: null,
                    reflow: true,
                    style: {
                        fontFamily: 'Roboto',
                        lineHeight: '20px',
                        fontWeight: 'normal'
                    },
                    styledMode: true,
                    plotBackgroundColor: plotBackgroundColor,
                    spacing: [0, 0, 10, 0]
                },
                lang: {
                    noData: this.noDataMsg(this.noDataText)
                },
                noData: {
                    useHTML: true,
                    style: {
                        fontSize: this.noDataFontSize_12
                    }
                },
                title: {
                    margin: 25,
                    useHTML: true,
                    align: !Ext.isEmpty(_chartData.isPanel) ? 'left' : 'center',
                    style: {
                        "color": this.titleFontColor,
                        "fontSize": !Ext.isEmpty(_chartData.isPanel) ? "16px" : "12px",
                        "lineHeight": "24px",
                        "fontWeight": "400"
                    },
                    text: _chartData.title
                },
                exporting: {
                    enabled: false
                },
                navigator: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },

                xAxis: [{
                    type: 'datetime',
                    dateTimeLabelFormats: {
                        hour: '%H:%M'
                    },
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    labels: {
                        useHTML: true,

                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                    crosshair: false,
                    tickLength: 0
                }],
                yAxis: [{
                    max: _chartData.maxVal,
                    labels: {
                        useHTML: true,
                        format: '{value}',
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    tickLength: 0,
                    tickWidth: 1,
                    tickPosition: 'outside',
                    lineWidth: 1,
                    title: {
                        text: _chartData.xaxisLabel,
                        useHTML: true,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    }
                }],
                tooltip: {
                    shared: false,
                    formatter: function () {
                        return Highcharts.dateFormat("%A, %b %e, %H:%M:%S", new Date(this.point.realTime)) + "<br/>" + this.point.y;
                    }
                },
                plotOptions: {
					column: {
                        pointWidth: 20
                    },
					series: {
						turboThreshold:0,
						connectNulls: connectNullsFlag,
                        marker: {
                            enabled: false
                        }
                    }
                },
                legend: {
                    enabled: true,
                    useHTML: true,
					y:-10,
                    itemStyle: {
                        fontSize: '11px',
                        fontWeight: 500,
                        color: this.legendFontColor
                    },
                    padding: 0,
                    symbolHeight: 6,
                    symbolPadding: 2,
                    symbolRadius: 6,
                    symbolWidth: 6,
                    verticalAlign: 'top'
                },
                series: _chartData.data.reverse(),
                rawData: _chartData.data.reverse()
            }
            return chartProps;
        },
        lineChart: function (selector, _chartData) {
            //console.log("_chartData=-=-=-=-lineChart>>",_chartData)
            var plotBackgroundColor = null;
            if (Ext.isEmpty(_chartData.data)) {
                plotBackgroundColor = this.noDataBg;
            }
            chartProps = {
                chart: {
                    plotBackgroundColor: plotBackgroundColor,
                    zoomType: 'xy',
                    backgroundColor: null,
                    reflow: true,
                    style: {
                        fontFamily: 'Roboto',
                        lineHeight: '20px',
                        fontWeight: 'normal'
                    },
                    styledMode: true,
                    spacing: [0, 0, 10, 0]
                },
                lang: {
                    noData: this.noDataMsg(this.noDataText)
                },
                noData: {
                    useHTML: true,
                    style: {
                        fontSize: this.noDataFontSize_12
                    }
                },
                title: {
                    useHTML: true,
                    margin: 25,
                    align: !Ext.isEmpty(_chartData.isPanel) ? 'left' : 'center',
                    style: {
                        "color": this.titleFontColor,
                        "fontSize": !Ext.isEmpty(_chartData.isPanel) ? "16px" : "12px",
                        "lineHeight": "24px",

                        "fontWeight": "400"
                    },
                    text: _chartData.title
                },
                exporting: {
                    enabled: false
                },
                navigator: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },

                xAxis: [{
                    type: 'datetime',
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    dateTimeLabelFormats: {
                        hour: '%H:%M'
                    },
                    labels: {
                        useHTML: true,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                    crosshair: false,
                    tickLength: 0
                }],
                yAxis: [{
                    // Secondary yAxis
                    allowDecimals: false,
                    max: _chartData.maxVal,
                    labels: {
                        useHTML: true,
                        format: '{value}',
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                    title: {
                        text: _chartData.xaxisLabel,
                        useHTML: true,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                    tickLength: 0,
                    tickWidth: 1,
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    tickPosition: 'outside',
                    lineWidth: 1,

                }, {
                    // Primary yAxis
                    opposite: true,
                    allowDecimals: false,
                    labels: {
                        useHTML: true,
                        format: '{value}',
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                    tickLength: 0,
                    tickWidth: 1,
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    //tickPosition: 'outside',
                    lineWidth: 1,
                    title: {
                        text: '<span style="display:none">' + _chartData.xaxisLabel + '<span>',
                        useHTML: true,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    }
                }],
                tooltip: {
                    shared: true
                },
                plotOptions: {
                    column: {
                        pointWidth: 20
                    },
                    series: {
						connectNulls: connectNullsFlag,
                        marker: {
                            enabled: false
                        }
                    }
                },
                legend: {
                    enabled: false,
                    useHTML: true,
                    itemStyle: {
                        fontSize: '11px',
                        fontWeight: 500,
                        color: this.legendFontColor
                    },
                    padding: 0,
                    symbolHeight: 6,
                    symbolPadding: 2,
                    symbolRadius: 6,
                    symbolWidth: 6,
                    verticalAlign: 'top'
                },
                series: _chartData.data
            }
            return chartProps;
        },
        spLineChart: function (selector, _chartData) {
            //console.log("_chartData=-=-=-=-spLineChart>>",_chartData)
            var plotBackgroundColor = null;
            if (Ext.isEmpty(_chartData.dataArray)) {
                plotBackgroundColor = this.noDataBg;
            }
			var yaxisLabelEnable = Ext.isEmpty(_chartData.isYaxisLabel) ?true:false;
            var chartProps = {
                chart: {
                    zoomType: 'xy',
                    plotBackgroundColor: plotBackgroundColor,
                    backgroundColor: null,
                    reflow: true,
                    style: {
                        fontFamily: 'Roboto',
                        lineHeight: '20px',
                        fontWeight: 'normal'
                    },
                    styledMode: true,
                    spacing: [0, 0, 10, 0]
                },
                lang: {
                    noData: this.noDataMsg(this.noDataText)
                },
                noData: {
                    useHTML: true,
                    style: {
                        fontSize: this.noDataFontSize_12
                    }
                },
                title: {
                    useHTML: true,
                    align: !Ext.isEmpty(_chartData.isPanel) ? 'left' : 'center',
                    style: {
                        "color": this.titleFontColor,
                        "fontSize": !Ext.isEmpty(_chartData.isPanel) ? "16px" : "12px",
                        "lineHeight": "24px",
                        "fontWeight": "400"
                    },
                    text: _chartData.valueText
                },
                exporting: {
                    enabled: false
                },
                navigator: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                xAxis: [{
                    labels: {
                        useHTML: true,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                    crosshair: true,
                    tickLength: 0,
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    categories: _chartData.catagories
                }],
                yAxis: [{
                    // Secondary yAxis
                    allowDecimals: false,
                    title: {
						rotation:270,
                        text: _chartData.xaxisLabelOp,
                        useHTML: true,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
					tickLength: 0,
                    tickWidth: 1,
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    tickPosition: 'outside',
                    lineWidth: 1,
                    labels: {
						enabled:yaxisLabelEnable,
                        format: '{value}',
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                    opposite: true
                }, {
                    // Primary yAxis
                    allowDecimals: false,
					labels: {
                        useHTML: true,
                        format: '{value}',
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                    tickLength: 0,
                    tickWidth: 1,
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    //tickPosition: 'outside',
                    lineWidth: 1,
                    title: {
                        text: _chartData.xaxisLabel,
                        useHTML: true,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    }
                }],
                tooltip: {
                    shared: true
                },
                plotOptions: {
                    column: {
                        //pointWidth:20
                    },
                    series: {
						connectNulls: connectNullsFlag,
                        marker: {
                            enabled: false
                        }
                    }
                },
                legend: {
                    useHTML: true,
                    itemStyle: {
                        fontSize: '11px',
                        fontWeight: 500,
                        color: this.legendFontColor
                    },
                    padding: 0,
                    symbolHeight: 6,
                    symbolPadding: 2,
                    symbolRadius: 6,
                    symbolWidth: 6,
                    verticalAlign: 'top'
                },
                series: [{
                    name: _chartData.name,
                    type: 'column',
                    color: _chartData.color,
                    yAxis: 1,
                    data: _chartData.dataArray
                }, {
                    name: _chartData.splineName,
                    type: 'spline',
                    color: _chartData.splineColor,
                    data: _chartData.splineDataArray
                }]
            }
            return chartProps;
        },
        stackedColumnChart: function (selector, _chartData) {
            //console.log("_chartData=-=-=stackedColumnChart-=->>",_chartData)
            var plotBackgroundColor = null;
            if (Ext.isEmpty(_chartData.data)) {
                plotBackgroundColor = this.noDataBg;
            }
            var chartProps = {
                chart: {
                    type: 'column',
                    plotBackgroundColor:plotBackgroundColor,
                    backgroundColor: null,
                    style: {
                        fontFamily: 'Roboto',
                        lineHeight: '20px',
                        fontWeight: 'normal'
                    },
                    styledMode: true,
                    spacing: [0, 0, 10, 0]
                },
                lang: {
                    noData: this.noDataMsg(this.noDataText)
                },
                noData: {
                    useHTML:true,
                    style: {
                        fontSize: this.noDataFontSize_12
                    }
                },
                exporting: {
                    enabled: false
                },
                navigator: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                title: {
                    text: _chartData.title,
                    margin: 25,
                    useHTML: true,
                    align: !Ext.isEmpty(_chartData.isPanel) ? 'left' : 'center',
                    style: {
                        "color": this.titleFontColor,
                        "fontSize": !Ext.isEmpty(_chartData.isPanel) ? "16px" : "12px",
                        "fontWeight": "400",
                        "lineHeight": "24px",

                    }
                },
                xAxis: {
                    tickWidth: 0,
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    labels: {
                        useHTML: true,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                    categories: _chartData.categories
                },
                yAxis: [{
                    // Secondary yAxis
                    allowDecimals: false,
                    stackLabels: {
                        enabled: true,
                        style: {
                            fontWeight: 'bold',
                            color: (Highcharts.theme && Highcharts.theme.textColor) || '#000000'
                        },
                        formatter: function () {
                            if (this.total > 0)
                                return this.total;
                        }
                    },
                    labels: {
                        useHTML: true,
                        format: '{value}',
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                    title: {
                        text: _chartData.xaxisLabel,
                        useHTML: true,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                    tickLength: 0,
                    tickWidth: 1,
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    tickPosition: 'outside',
                    lineWidth: 1,

                }, {
                    // Primary yAxis
                    opposite: true,
                    allowDecimals: false,
                    labels: {
                        enabled: false,
                        format: '{value}',
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                    title: {
                        text: '<span style="display:none">' + _chartData.xaxisLabel + '<span>',
                        useHTML: true,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                    tickLength: 0,
                    tickWidth: 1,
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    //tickPosition: 'outside',
                    lineWidth: 1
                }],
                legend: {
                    useHTML: true,
                    enabled: false,
                    itemStyle: {
                        fontSize: '11px',
                        fontWeight: 500,
                        color: this.legendFontColor
                    },
                    padding: 0,
                    symbolHeight: 6,
                    symbolPadding: 2,
                    symbolRadius: 6,
                    symbolWidth: 6,
                    verticalAlign: 'top'
                },
                tooltip: {
                    headerFormat: '<b>{point.x}</b><br/>',
                    pointFormat: '{series.name}: {point.y}<br/>Total: {point.stackTotal}'
                },
                plotOptions: {
                    series: {
						connectNulls: connectNullsFlag,
                        dataLabels: {
                            style: {
                                textShadow: false,
                                textOutline: false
                            }
                        }
                    },
                    column: {
                        edgeWidth: 0,
                        borderWidth: 0,
                        stacking: _chartData.stacking,
                        style: {
                            textShadow: false,
                            textOutline: false
                        },
                        dataLabels: {
                            enabled: true,
                            formatter: function () {
                                if (this.y > 0)
                                    return this.y;
                            },
                            color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || 'white'
                        }
                    }
                },
                series: _chartData.data
            };
            //overriding config
            if (Ext.isEmpty(_chartData.stacking)) {
                chartProps = Ext.apply(chartProps, {
                    legend: {
                        useHTML: true,
                        enabled: false,
                        itemStyle: {
                            fontSize: '11px',
                            fontWeight: 500,
                            color: this.legendFontColor
                        },
                        padding: 0,
                        symbolHeight: 6,
                        symbolPadding: 2,
                        symbolRadius: 6,
                        symbolWidth: 6,
                        verticalAlign: 'top'
                    },
					tooltip: {
						headerFormat: '<b>{point.x}</b><br/>',
						pointFormat: '{series.name}: {point.y}'
					},
                    plotOptions: {
                        series: {
							connectNulls: connectNullsFlag,
                            dataLabels: {
                                style: {
                                    textShadow: false,
                                    textOutline: false
                                }
                            }
                        },
                        column: {
                            edgeWidth: 0,
                            borderWidth: 0,
                            pointPadding: 0,
                            groupPadding: 0.1,
                            stacking: null,
                            dataLabels: {
                                style: {
                                    textShadow: false,
                                    textOutline: false
                                },
                                enabled: true,
                                color: (Highcharts.theme && Highcharts.theme.dataLabelsColor) || '#000',
                                formatter: function () {
                                    if (this.y > 0)
                                        return this.y;
                                }
                            }
                        }
                    }

                });

            }
            return chartProps;
        },
        barChart: function (selector, _chartData) {
            //console.log("_chartData=-=-=barChart-=->>",_chartData)
            
            var plotBackgroundColor = null;
            if (Ext.isEmpty(_chartData.categories)) {
                plotBackgroundColor = this.noDataBg;
            }
            var chartData = {
                chart: {
                    type: 'bar',
                    backgroundColor: null,
                    style: {
                        fontFamily: 'Roboto',
                        lineHeight: '20px',
                        fontWeight: 'normal'
                    },
                    plotBackgroundColor:plotBackgroundColor,
                    styledMode: true,
                    spacing: [0, 0, 10, 0]
                },
                lang: {
                    noData: this.noDataMsg(this.noDataText)
                },
                noData: {
                    useHTML:true,
                    style: {
                        fontSize: this.noDataFontSize_12
                    }
                },
                exporting: {
                    enabled: false
                },
                navigator: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                title: {
                    useHTML: true,
                    margin: 25,
                    align: !Ext.isEmpty(_chartData.isPanel) ? 'left' : 'center',
                    style: {
                        "color": this.titleFontColor,
                        "fontSize": !Ext.isEmpty(_chartData.isPanel) ? "16px" : "12px",
                        "lineHeight": "24px",

                        "fontWeight": "400"
                    },
                    text: _chartData.title
                },
                xAxis: {
                    categories: _chartData.categories,
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    allowDecimals: false,
                    tickLength: 0,
                    labels: {
                        useHTML: true,
                        style: {
                            "color": this.axisFontColor,
                            "fontSize": "11px",
                        }
                    },
                    title: {
                        text: _chartData.xaxisLabel,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor,
                        }
                    },
                },
                yAxis: {
                    min: 0,
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    title: {
                        text: _chartData.yaxisLabel,
                        style: {
                            fontSize: "11px",
                            "color": this.axisFontColor
                        }
                    },

                    labels: {
                        formatter: function () {
                            return this.value;
                        }
                    }
                },
                tooltip: {
                    formatter: function () {
                        return this.point.category + " : " + this.point.y;
                    },
                    //pointFormat: '{series.name} {point.y}'
                },
                plotOptions: {
                    series: {
                        lineWidth: 0,
                        dataLabels: {
                            enabled: true
                        }
                    },
                    area: {
                        pointStart: 1940,
                        marker: {
                            enabled: false,
                            symbol: 'circle',
                            radius: 2,
                            states: {
                                hover: {
                                    enabled: true
                                }
                            }
                        }
                    },
                    bar: {
                        pointWidth: 20
                    }
                },
                legend: {
                    useHTML: true,
                    enabled: false,
                    itemStyle: {
                        fontSize: '11px',
                        fontWeight: 500,
                        color: this.legendFontColor
                    },
                    padding: 0,
                    symbolHeight: 6,
                    symbolPadding: 2,
                    symbolRadius: 6,
                    symbolWidth: 6,
                    verticalAlign: 'top'
                },
                series: _chartData.DataSet
            }
            return chartData;
        },
        getDialMeterGraphData: function (data) {
            function setCustomLabel() {
                var chart = this;
                var width = (chart.plotWidth / 2) + 56;
                var height = (chart.plotHeight / 2) + 62;
                chart.renderer.text('<span class="gauagematerTooltipBg">' + data.tool_tip + '</span>', width, height, -50, -50).add();
            }
            var chartData = {
                chart: {
                    backgroundColor: null,
                    style: {
                        fontFamily: 'Roboto',
                        fontWeight: 'normal'
                    },
                    styledMode: true,
                    type: 'solidgauge',
                    margin: [0, 0, -5, 0]
                },
                rangeSelector: {
                    enabled: false
                },
                global: {
                    useUTC: true
                },
                exporting: {
                    enabled: false
                },
                navigator: {
                    enabled: false
                },

                title: '',
                credits: {
                    enabled: false
                },
                pane: {
                    startAngle: -145,
                    endAngle: 145,
                    background: {
                        backgroundColor: 'transparent',
                        borderWidth: 0,
                        innerradius: '10%'
                    }
                },
                yAxis: [{
                    min: 0,
                    max: 100,
                    lineColor: this.gridLineColor,
                    gridLineColor: this.gridLineColor,
                    minorTickWidth: 0,
                    minorTickLength: 0,
                    tickWidth: 0,
                    tickLength: 0,
                    tickPosition: 'inside',
                    tickColor: 'red',
                    tickInterval: 10,
                    minorTickInterval: 10,
                    labels: {
                        enabled: false,
                        distance: 1,
                        useHTML: true,
                        style: {
                            fontWeight: '400',
                            fontSize: '11px',
                            textShadow: '0',
                            color: this.axisFontColor
                        }
                    }
                }, {
                    linkedTo: 0,
                    lineWidth: 1,
                    tickLength: 0,
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    minorTickLength: 0,
                    tickPositions: [95],
                    min: 0,
                    max: 100,
                    tickInterval: 10,
                    minorTickInterval: 10,
                    labels: {
                        useHTML: true,
                        formatter: function () {
                            return '<span class="gauagematerTooltipBg" style="bottom: -37px;left: 18px;">Industry (' + this.value + '%)</span>';
                        }
                    }
                }],
                tooltip: {
                    enabled: false,
                    useHTML: true,
                    followPointer: true,
                    style: {
                        color: '#494848',
                        fontSize: '10px',
                        fontWeight: 500
                    },
                    formatter: function () {
                        return data.tool_tip;
                    }
                },
                plotOptions: {
                    gauge: {
                        pivot: {
                            radius: 2,
                            backgroundColor: '#5e5f5f',
                            borderWidth: 1.75,
                            borderColor: '#5e5f5f'
                        },
                        dial: {
                            baseLength: '10%',
                            baseWidth: 6,
                            backgroundColor: '#5e5f5f',
                            radius: '60%',
                            rearLength: '1%',
                            borderWidth: 1,
                            topWidth: 1
                        }
                    },
                    solidgauge: {
                        dataLabels: {
                            enabled: false
                        },
                        linecap: 'round',
                        stickyTracking: false,
                        rounded: true
                    }
                },
                series: [{
                    name: 'HIGH',
                    animation: false,
                    data: [{
                        color: '#39bda6',
                        radius: '112%',
                        innerRadius: '85%',
                        y: 150,
                    }]
                }, {
                    name: 'INTERMEDIATE',
                    animation: false,
                    data: [{
                        color: '#f99d21',
                        radius: '112%',
                        innerRadius: '85%',
                        y: 65
                    }]
                }, {
                    name: 'GOOD',
                    animation: false,
                    data: [{
                        color: '#f35248',
                        radius: '112%',
                        innerRadius: '85%',
                        y: 30
                    }]
                }, {
                    type: 'gauge',
                    name: 'Speed',
                    data: [data.dataArray.value],
                    dataLabels: {
                        borderWidth: 0,
                        enabled: false,
                        useHTML: true
                    }
                }]
            };
            //chartData= jQuery.extend(true,chartData,getUserThemeFor(strSkin));
            return chartData;
        },
        getGaugeMeterGraphData: function (data) {

            function setCustomLabel() {
                var chart = this;
                var width = (chart.plotWidth / 2) + 56;
                var height = (chart.plotHeight / 2) + 62;
                chart.renderer.text('<span class="gauagematerTooltipBg">' + data.tool_tip + '</span>', width, height, -50, -50).add();
            }
            var chartData = {
                chart: {
                    backgroundColor: null,
                    style: {
                        fontFamily: 'Roboto',
                        fontWeight: 'normal'
                    },
                    styledMode: true,
                    type: 'solidgauge'
                },
                rangeSelector: {
                    enabled: false
                },
                global: {
                    useUTC: true
                },
                exporting: {
                    enabled: false
                },
                navigator: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                title: {
                    text: ''
                },
                pane: {
                    startAngle: -145,
                    endAngle: 145,
                    background: {
                        backgroundColor: 'transparent',
                        borderWidth: 0,
                        innerradius: '10%'
                    }
                },
                yAxis: {
                    min: 0,
                    max: 100,
                    minorTickWidth: 1,
                    minorTickLength: 10,
                    tickWidth: 0,
                    tickLength: 0,
                    tickPosition: 'inside',
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    tickInterval: 10,
                    minorTickInterval: 10,
                    labels: {
                        distance: 1,
                        useHTML: true,
                        style: {
                            fontWeight: '400',
                            fontSize: '8px',
                            textShadow: '0',
                            color: '#fff'
                        }
                    }
                },
                tooltip: {
                    enabled: false,
                    useHTML: true,
                    followPointer: true,
                    style: {
                        color: '#494848',
                        fontSize: '10px',
                        fontWeight: 500
                    },
                    formatter: function () {
                        return data.tool_tip;
                    }
                },
                plotOptions: {
                    gauge: {
                        pivot: {
                            radius: 3,
                            backgroundColor: '#5e5f5f',
                            borderWidth: 1.75,
                            borderColor: '#5e5f5f'
                        },
                        dial: {
                            baseLength: '10%',
                            baseWidth: 8,
                            backgroundColor: '#5e5f5f',
                            radius: '60%',
                            rearLength: '1%',
                            borderWidth: 1,
                            topWidth: 1
                        }
                    },
                    solidgauge: {
                        dataLabels: {
                            enabled: false
                        },
                        linecap: 'round',
                        stickyTracking: false,
                        rounded: true
                    }
                },
                series: [{
                    name: 'HIGH',
                    animation: false,
                    data: [{
                        color: '#39bda6',
                        radius: '112%',
                        innerRadius: '90%',
                        y: 150,
                    }]
                }, {
                    name: 'INTERMEDIATE',
                    animation: false,
                    data: [{
                        color: '#f99d21',
                        radius: '112%',
                        innerRadius: '90%',
                        y: 65
                    }]
                }, {
                    name: 'GOOD',
                    animation: false,
                    data: [{
                        color: '#f35248',
                        radius: '112%',
                        innerRadius: '90%',
                        y: 30
                    }]
                }, {
                    type: 'gauge',
                    name: 'Speed',
                    data: [data.dataArray.value],
                    dataLabels: {
                        borderWidth: 0,
                        enabled: true,
                        useHTML: true
                    }
                }]
            };
            //chartData= jQuery.extend(true,chartData,getUserThemeFor(strSkin));
            return chartData;
        },
        getgradientCombinationGraphData: function (selector, data, xaxisLabel) {
            var chartData = {
                chart: {
                    spacingRight: 0,

                    backgroundColor: null,
                    style: {
                        fontFamily: 'Roboto',
                        fontWeight: 'normal'
                    },
                    styledMode: true
                },
                rangeSelector: {
                    enabled: false
                },
                global: {
                    useUTC: true
                },
                exporting: {
                    enabled: false
                },
                navigator: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                title: "",
                tooltip: {
                    shared: true,
                    shape: "square",
                    useHTML: true,
                    style: {
                        color: '#494848',
                        fontSize: '10px',
                        fontWeight: 500,
                        fontFamily: 'Roboto'
                    },
                    formatter: function () {
                        var points = this.points;
                        var pointsLength = points.length;
                        var tooltipMarkup = pointsLength ? '<span style="font-size: 10px">' + Highcharts.dateFormat("%H:%M%p", new Date(this.x)) + '</span><br/>' : '';
                        var index;
                        var y_value;

                        for (index = 0; index < pointsLength; index += 1) {
                            y_value = points[index].y;

                            tooltipMarkup += '<span style="color:' + points[index].series.color + '">\u25CF</span> ' + points[index].series.name + ': <b>' + y_value + '</b><br/>';
                        }

                        return tooltipMarkup;
                    }
                },
                xAxis: {
                    events: {
                        setExtremes: syncExtremes
                    },
                    crosshair: {
                        width: 1.5,
                        color: 'gray',
                        dashStyle: 'shortdot'
                    },
                    labels: {
                        enabled: xaxisLabel,
                        style: {
                            color: this.axisFontColor,
                            fontSize: this.axisFontSize
                        }
                    },
                    type: 'datetime',
                    dateTimeLabelFormats: {
                        hour: '%H:%M %P'
                    },
                    opposite: true,
                    lineWidth: 0,
                    minorGridLineWidth: 0,
                    minorTickLength: 0,
                    tickLength: 0
                },
                lang: {
                    noData: this.noDataText
                },
                noData: {
                    style: {
                        fontSize: this.noDataFontSize,
                        height: 60
                    }

                },
                yAxis: {
                    offset: -10,
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    labels: {
                        enabled: false,
                        style: {
                            color: this.axisFontColor,
                            fontSize: this.axisFontSize
                        }
                    },
                    min: 0,
                    enabled: false,
                    max: data.maxVal,
                    tickInterval: 2
                },
                legend: {
                    enabled: false
                },
                plotOptions: {
                    series: {
						connectNulls: connectNullsFlag,
                        states: {
                            hover: {
                                halo: {
                                    size: 1,
                                }
                            }
                        },
                    },
                    area: {
                        fillColor: {
                            linearGradient: {
                                x1: 0,
                                y1: 0,
                                x2: 0,
                                y2: 1
                            },
                            stops: [
                                [0, Highcharts.Color(data.color).setOpacity(0.5).get('rgba')],
                                [1, Highcharts.Color(data.color).setOpacity(0).get('rgba')],
                            ]
                        },
                        marker: {
                            enabled: false
                        },
                        lineWidth: 2,
                        states: {
                            hover: {
                                lineWidth: 2
                            }
                        },
                        threshold: null
                    }
                },

                series: [{
                    name: data.name,
                    type: 'column',
                    color: data.color,
                    data: data.dataArray
                }, {
                    name: data.splineName,
                    type: 'area',
                    color: data.splineColor,
                    data: data.splineDataArray
                }]
            };
            // check for no data
            if (Ext.isEmpty(data.dataArray) && Ext.isEmpty(data.splineDataArray)) {
                $(selector).addClass('highchartNoData');
            } else {
                $(selector).removeClass('highchartNoData');
            }
            //chartData= jQuery.extend(true,chartData,getUserThemeFor(strSkin));
            return chartData;
        },
        getgradientLineGraphData: function (selector, data, xaxisLabel) {
            var chartData = {
                chart: {
                    type: 'area',
                    //spacing:[10,0,0,10],
                    backgroundColor: null,
                    spacingRight: 0,
                    style: {
                        fontFamily: 'Roboto',
                        fontWeight: 'normal'
                    },
                    styledMode: true,
                },
                rangeSelector: {
                    enabled: false
                },
                global: {
                    useUTC: true
                },
                exporting: {
                    enabled: false
                },
                title: {
                    text: ''
                },
                navigator: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                tooltip: {
                    shape: "square",
                    useHTML: true,
                    style: {
                        color: '#494848',
                        fontSize: '10px',
                        fontWeight: 500,
                        fontFamily: 'Roboto'
                    },
                    formatter: function () {
                        var tooltip = '<span style="padding-right:10px">  ' + this.y + '</span><span>' + Highcharts.dateFormat("%H:%M%p", new Date(this.x)) + '</span>';
                        return tooltip;
                    }
                },
                xAxis: {
                    events: {
                        setExtremes: syncExtremes
                    },
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    crosshair: {
                        width: 1.5,
                        color: 'gray',
                        dashStyle: 'shortdot'
                    },
                    labels: {
                        enabled: xaxisLabel,
                        style: {
                            color: this.axisFontColor,
                            fontSize: this.axisFontSize
                        }
                    },
                    type: 'datetime',
                    dateTimeLabelFormats: {
                        hour: '%H:%M %P'
                    },
                    opposite: true,
                    lineWidth: 0,
                    minorGridLineWidth: 0,
                    minorTickLength: 0,
                    tickLength: 0
                },
                lang: {
                    noData: this.noDataText
                },
                noData: {
                    style: {
                        fontSize: this.noDataFontSize,
                        height: 60
                    }

                },
                yAxis: {
                    offset: -10,
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    labels: {
                        style: {
                            color: this.axisFontColor,
                            fontSize: this.axisFontSize
                        }
                    },
                    min: 0,
                    max: data.maxVal,

                    tickInterval: 2,
                    title: {
                        text: ''
                    }
                },
                legend: {
                    enabled: false
                },
                plotOptions: {
                    series: {
						connectNulls: connectNullsFlag,
                        states: {
                            hover: {
                                halo: {
                                    size: 1,
                                }
                            }
                        },
                    },
                    area: {
                        fillColor: {
                            linearGradient: {
                                x1: 0,
                                y1: 0,
                                x2: 0,
                                y2: 1
                            },
                            stops: [
                                [0, Highcharts.Color(data.color).setOpacity(0.5).get('rgba')],
                                [1, Highcharts.Color(data.color).setOpacity(0).get('rgba')],
                            ]
                        },
                        marker: {
                            enabled: false
                        },
                        lineWidth: 2,
                        states: {
                            hover: {
                                lineWidth: 2
                            }
                        },
                        threshold: null
                    }
                },

                series: [{
                    type: 'area',
                    color: data.color,
                    data: data.dataArray
                }]
            };
            // check for no data
            if (Ext.isEmpty(data.dataArray)) {
                $(selector).addClass('highchartNoData');
            } else {
                $(selector).removeClass('highchartNoData');
            }
            //chartData= jQuery.extend(true,chartData,getUserThemeFor(strSkin));
            return chartData;
        },
        getlineareaGraphData: function (selector, data) {
            var chartData = {
                chart: {
                    type: 'area',
                    backgroundColor: null,
                    style: {
                        fontFamily: 'Roboto',
                        fontWeight: 'normal'
                    },
                    styledMode: true,
                    spacing: [10, 55, 10, 10]
                },
                lang: {
                    noData: this.noDataText
                },
                title: "",
                noData: {
                    style: {
                        fontSize: this.noDataFontSize
                    }
                },
                rangeSelector: {
                    enabled: false
                },
                global: {
                    useUTC: true
                },
                exporting: {
                    enabled: false
                },
                tooltip: {
                    shape: "square",
                    useHTML: true,
                    style: {
                        color: '#494848',
                        fontSize: '10px',
                        fontWeight: 500
                    },
                    formatter: function () {
                        var tooltip = '<span style="padding-right:10px">' + this.y + '</span><span>' + Highcharts.dateFormat("%H:%M%p", new Date(this.x)) + '</span>';
                        return tooltip;
                    }
                },
                navigator: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                xAxis: {
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    crosshair: {
                        width: 1.5,
                        color: 'gray',
                        dashStyle: 'shortdot'
                    },
                    labels: {
                        align: 'right',
                        enabled: false,
                        style: {
                            color: this.axisFontColor,
                            fontSize: this.axisFontSize
                        }
                    },
                    title: {
                        style: {
                            color: this.axisFontColor,
                            fontSize: this.axisFontSize
                        }
                    },
                    type: 'datetime',
                    dateTimeLabelFormats: {
                        hour: '%H:%M %P'
                    },
                    lineWidth: 0,
                    minorGridLineWidth: 0,
                    minorTickLength: 0,
                    tickLength: 0
                },
                yAxis: {
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    offset: -10,
                    min: 0,
                    max: data.maxVal,
                    tickInterval: 60,
                    title: {
                        text: data.yAxistitle,
                        style: {
                            color: this.axisFontColor,
                            fontSize: this.axisFontSize,
                        }
                    },
                    labels: {
                        style: {
                            color: this.axisFontColor,
                            fontSize: this.axisFontSize
                        }
                    }
                },
                legend: {
                    enabled: false
                },
                plotOptions: {
                    series: {
						connectNulls: connectNullsFlag,
                        states: {
                            hover: {
                                halo: {
                                    size: 1,
                                }
                            }
                        },
                    },
                    area: {
                        fillColor: {
                            linearGradient: {
                                x1: 0,
                                y1: 0,
                                x2: 0,
                                y2: 1
                            },
                            stops: [
                                [0, Highcharts.Color(data.color).setOpacity(0.5).get('rgba')],
                                [1, Highcharts.Color(data.color).setOpacity(0).get('rgba')],
                            ]
                        },
                        marker: {
                            enabled: false
                        },
                        lineWidth: 2,
                        states: {
                            hover: {
                                lineWidth: 2
                            }
                        },
                        threshold: null
                    }
                },

                series: [{
                    type: 'area',
                    color: data.color,
                    data: data.dataArray
                }]
            };
            // check for no data
            if (Ext.isEmpty(data.dataArray)) {
                $(selector).addClass('highchartNoData');
            } else {
                $(selector).removeClass('highchartNoData');
            }
            //chartData= jQuery.extend(true,chartData,getUserThemeFor(strSkin));
            return chartData;
        },
        getBigDonutGraphData: function (selector, data) {
			//console.log("data=--=-getBigDonutGraphData==--=>>",data)
            //making title in center
            function setTitle() {
                var chart = this;
                if (chart.title) {
                    chart.title.destroy();
                }
                var r = chart.renderer,
                    x = chart.series[0].center[0] + chart.plotLeft,
                    y = chart.series[0].center[1] + chart.plotTop;
                chart.title.useHTML = true;
                chart.title = r.html('<span class="f28-light" style="font-family:Roboto">'+data.chartTitle+'</span><span class="f14-light">' + data.chartTitleUnit + '</span>').hide().add();
				var bbox = chart.title.getBBox();
				var minusVal = 4;
				if(data.chartTitle.length == 4)
					minusVal = 3;
				else if(data.chartTitle.length == 3)
					minusVal = 2;
				else if(data.chartTitle.length == 2)
					minusVal = 1;
				else if(data.chartTitle.length == 1)
					minusVal = 0;

                this.title.attr({
                    x: x - (bbox.width / 2) - minusVal,
                    y: y - 5
                }).show();

                $.each(data.dataArray, function (index, seriesData) {
                    if (seriesData.name === "No Users found") {
                        $('div.highcharts-color-' + index).remove();
                        $('g.highcharts-color-' + index).remove();
                    }
                });

            }
            //console.log('isLegendEnabled', !Ext.isEmpty(data.isLegendEnabled));
            var spacing = [10, 20, 10, 20],
                size = '90%',
                innerSize = '80%';
            if (!Ext.isEmpty(data.isLegendEnabled)) {
                //in showCase
                spacing = [20, 20, 10, 20];
                size = '145%';
                innerSize = '80%';
            }
            var chartData = {
                chart: {
                    type: 'pie',
                    backgroundColor: null,
                    style: {
                        fontFamily: 'Roboto',
                        fontWeight: 'normal',


                    },
                    spacing: spacing,
                    align: 'left',
                    styledMode: true,
                    events: {
                        load: setTitle,
                        redraw: setTitle
                    }
                },
                title: {
                    verticalAlign: 'middle',
                    floating: false,
                    useHTML: true,
                    //text: '<span class="f40-light" >'+data.chartTitle+'</span><span class="f14-light">'+data.chartTitleUnit+'</span>'
                },
                exporting: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                plotOptions: {
					pie: {
						showInLegend: true,
						allowPointSelect: false,
						point:{
							events : {
								legendItemClick: function(e){
									e.preventDefault();
								}
							}
						},
						startAngle: 0,
						endAngle: 360,
						borderWidth: 0,
						size: size,
						innerSize: innerSize,
						dataLabels: {
							enabled: !Ext.isEmpty(data.isLegendEnabled) ? false : true,
							alignTo: 'connectors',
							style: {
								fontWeight: '500',
								'font-family': 'Roboto',
								fontSize: '12px',
								textShadow: false,
								textOutline: false,
								width:200
							}
						}
					},
					series: {
						cursor: 'pointer',
						point: {
							events: {
								click: function () {
									if(!Ext.isEmpty(this.method))
									{
										if(this.method == "goToSessionsPage")
											goToSessionsPage();
										else if(this.method == "goToLogonPage")
											goToLogonPage();
										else if(this.method == "goToLatencyPage")
											goToLatencyPage();
									}
								}
							}
						}
					}
                },
                legend: {
                    enabled: !Ext.isEmpty(data.isLegendEnabled),
                    symbolWidth: 6,
                    symbolHeight: 6,
                    // useHTML: true,
                    margin: 30,
                    verticalAlign: 'bottom',
                    itemMarginTop: 6,
                    itemMarginBottom: 6,
                    itemStyle: {
                        fontSize: "12px"
                    },
                    y: 20,
                    labelFormatter: function () {
                        var nameN = Ext.String.htmlDecode(this.name);
                        if (nameN.trim().length > 0) {
                            return '<span data-qtip="' + nameN + '" style="position:relative;">' + nameN + '</span>';
                        }
                    }
                },
                tooltip: {
                    enabled: false,
                    formatter: function () {
                        if (this.point.name == "Empty")
                            return null;

                        return Ext.String.htmlDecode(this.point.name) + '</b>: ' + Math.round(this.percentage * 100) / 100 + ' %';
                    }
                },
                series: [{
                    data: data.dataArray
                }]
            };
            //chartData= jQuery.extend(true,chartData,getUserThemeFor(strSkin));
            return chartData;
        },
        getEulerGraphData: function (data) {
            var chartData = {
                chart: {
                    type: 'pie',
                    backgroundColor: null,
                    style: {
                        fontFamily: 'Roboto',
                        fontWeight: 'normal'
                    },
                    styledMode: true
                },
                title: {
                    text: ''
                },
                exporting: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                plotOptions: {
                    pie: {
                        borderWidth: 0,

                    },
                    series: {
                        dataLabels: {
                            enabled: false
                        }
                    }
                },
                tooltip: {
                    enabled: false
                },
                series: data.dataArray
            };
            //chartData= jQuery.extend(true,chartData,getUserThemeFor(strSkin));
            return chartData;
        },
        getDonutGraphData: function (data, legEnabled, componenetType,allCompTypes,compTypeLayer) {
            if (legEnabled == undefined || legEnabled == null)
                legEnabled = false;

			var setTielel = '<span style="display:block;text-align:center;margin-left:0px"><span onClick="javascript:goToZoneList('+componenetType+','+allCompTypes+','+compTypeLayer+')" class="handSymbol font_normal45" style="font-Family:Roboto;line-height: 47px;letter-spacing:-2px">' + data.chartTitle + '</span><span onClick="javascript:goToZoneList('+componenetType+','+allCompTypes+','+compTypeLayer+')" class="handSymbol f14-normal">' + data.chartTitleUnit + '</span><br><span class="layer' + data.chartSubTitleState + '" style="display:inline-block;margin:0px 3px;"></span><span class="f12-normal" style="margin-top:0px;">' + data.chartSubTitle + '</span></span>';

			if(data.chartSubTitle != null && data.chartSubTitle == "0%")
				setTielel = '<span style="display:block;text-align:center;margin-left:0px;margin-top:5px;"><span onClick="javascript:goToZoneList('+componenetType+','+allCompTypes+','+compTypeLayer+')" class="handSymbol font_normal45" style="font-Family:Roboto;line-height: 47px;letter-spacing:-2px">' + data.chartTitle + '</span><span onClick="javascript:goToZoneList('+componenetType+','+allCompTypes+','+compTypeLayer+')" class="handSymbol f14-normal">' + data.chartTitleUnit + '</span>';

            var chartData = {
                chart: {
                    type: 'pie',
                    backgroundColor: null,
                    style: {
                        fontFamily: 'Roboto',
                        fontWeight: 'normal'
                    },
                    styledMode: true,
                    margin: [50, 50, 50, 50],
                    spacing: [50, 50, 50, 50],
                    align: 'left'
                },
                title: {
                    y: -15,
                    x: 50,
                    verticalAlign: 'middle',
                    floating: true,
                    useHTML: true,
                    width: 100,
                    text: setTielel
                },
                exporting: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                plotOptions: {
                    pie: {
                        showInLegend: true,
                        startAngle: 0,
                        endAngle: 360,
                        borderWidth: 1,
                        size: '121',
                        innerSize: '80%',
                        dataLabels: {
                            distance: -16,
                            enabled: false,
                            formatter: function () {
                                var dataLabelVal = Math.round(this.percentage * 100 / 100);
                                if (dataLabelVal < 5)
                                    return null;
                                else
                                    return dataLabelVal + '%';
                            },
                            style: {
                                fontWeight: '500',
                                color: '#FFFFFF',
                                fontSize: '10px',
                                textShadow: false,
                                textOutline: false
                            }
                        }
                    }
                },
                legend: {
                    enabled: legEnabled,
                    symbolWidth: 8,
                    symbolHeight: 8,
                    itemMarginBottom: 5,
                    useHTML: true,
                    itemDistance: 10,
                    itemHoverStyle: {
                        "color": "#84b8e4"
                    },
                    itemStyle: {
                        fontSize: '11px',
                        fontWeight: 500,
                        color: this.legendFontColor
                    },
                    labelFormatter: function () {
                        var nameN = Ext.String.htmlDecode(this.name);
                        return nameN;
                    }
                },
                tooltip: {
                    enabled: false,
                    formatter: function () {
                        if (this.point.name == "Empty")
                            return null;

                        return Ext.String.htmlDecode(this.point.name) + '</b>: ' + Math.round(this.percentage * 100) / 100 + ' %';
                    }
                },
                series: [{
                    data: data.dataArray
                }]
            };
            chartData = jQuery.extend(true, chartData, getUserThemeFor(strSkin));
            return chartData;
        },
        getareaColumnGraphData: function (selector, data, xaxisEnableFlag) {
            var chartData = {
                chart: {
                    type: data.chartType,
                    backgroundColor: null,
                    spacing: [10, 0, 10, 0],
                    styledMode: true,
                    style: {
                        fontFamily: 'Roboto',
                        fontWeight: 'normal'
                    }
                },
                lang: {
                    noData: this.noDataText
                },
                noData: {
                    style: {
                        fontSize: this.noDataFontSize
                    }
                },
                title: "",
                rangeSelector: {
                    enabled: false
                },
                global: {
                    useUTC: true
                },
                exporting: {
                    enabled: false
                },
                navigator: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                tooltip: {
                    shape: "square",
                    useHTML: true,
                    style: {
                        color: '#494848',
                        fontSize: '10px',
                        fontWeight: 500,
                        fontFamily: 'Roboto'
                    },
                    formatter: function () {
                        var tooltip = '<span style="padding-right:10px">  ' + this.y + '</span><span>' + Highcharts.dateFormat("%H:%M%p", new Date(this.x)) + '</span>';
                        return tooltip;
                    }
                },
                xAxis: {
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    crosshair: {
                        width: 1.5,
                        color: 'gray',
                        dashStyle: 'shortdot'
                    },
                    labels: {
                        enabled: xaxisEnableFlag,
                        style: {
                            color: this.axisFontColor
                        }
                    },
                    title: {
                        text: data.xAxistitle
                    },
                    opposite: true,
                    type: 'datetime',
                    dateTimeLabelFormats: {
                        hour: '%H:%M%P'
                    },
                    lineWidth: 0,
                    minorGridLineWidth: 0,
                    minorTickLength: 0,
                    tickLength: 0
                },
                yAxis: {
                    min: 0,
                    align: 'right',
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    max: data.maxVal,
                    tickInterval: 2,
                    title: {
                        text: data.yAxistitle
                    },
                    labels: {
                        style: {
                            color: this.axisFontColor

                        }
                    }
                },
                legend: {
                    enabled: false
                },
                plotOptions: {
                    series: {
						connectNulls: connectNullsFlag,
                        states: {
                            hover: {
                                halo: {
                                    size: 1,
                                }
                            }
                        },
                    },
                    area: {
                        fillColor: {
                            linearGradient: {
                                x1: 1,
                                y1: 1,
                                x2: 1,
                                y2: 1
                            },
                            stops: [
                                [0, Highcharts.Color(data.color).setOpacity(1).get('rgba')],
                                [1, Highcharts.Color(data.color).setOpacity(0.9).get('rgba')],
                            ]
                        },
                        marker: {
                            enabled: false
                        },
                        lineWidth: 0,
                        states: {
                            hover: {
                                lineWidth: 1
                            }
                        },
                        threshold: null
                    }
                },

                series: [{
                    color: data.color,
                    data: data.dataArray
                }]
            };
            //chartData= jQuery.extend(true,chartData,getUserThemeFor(strSkin));
            // check for no data
            if (Ext.isEmpty(data.dataArray)) {
                $(selector).addClass('highchartNoData');
            } else {
                $(selector).removeClass('highchartNoData');
            }
            return chartData;
        },
        getgradientLineGraphPlain: function (selector, data, xaxisLabel) {
			//console.log("data-=-=-=getgradientLineGraphPlain-=>>",data)
            var chartData = {
                chart: {
                    type: 'area',

                    //spacing:[10,0,0,10],
                    backgroundColor: null,
                    spacingRight: 0,
                    style: {
                        fontFamily: 'Roboto',
                        fontWeight: 'normal'
                    },
                    styledMode: true,
                },
                rangeSelector: {
                    enabled: false
                },
                global: {
                    useUTC: true
                },
                exporting: {
                    enabled: false
                },
                title: {
                    text: ''
                },
                navigator: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                tooltip: {
                    shape: "square",
                    useHTML: true,
                    style: {
                        color: '#494848',
                        fontSize: '10px',
                        fontWeight: 500,
                        fontFamily: 'Roboto'
                    },
                    formatter: function () {
                        var tooltip = '<span style="padding-right:10px">'+this.y+' '+data.suffix.toUpperCase()+'</span>';
                        return tooltip;
                    }
                },
                xAxis: {
                    gridLineWidth: 0,
                    events: {
                        setExtremes: syncExtremes
                    },
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    crosshair: {
                        width: 1.5,
                        color: 'gray',
                        dashStyle: 'shortdot'
                    },
                    labels: {
                        enabled: false,
                        style: {
                            color: this.axisFontColor,
                            fontSize: this.axisFontSize
                        }
                    },
                    type: 'datetime',
                    dateTimeLabelFormats: {
                        hour: '%H:%M %P'
                    },
                    opposite: true,
                    lineWidth: 0,
                    minorGridLineWidth: 0,
                    minorTickLength: 0,
                    tickLength: 0
                },
                lang: {
                    noData: this.noDataText
                },
                noData: {
                    style: {
                        fontSize: this.noDataFontSize,
                        height: 60
                    }

                },
                yAxis: {
                    offset: -10,
                    lineWidth: 0,
                    gridLineWidth: 0,
                    gridLineColor: this.gridLineColor,
                    lineColor: this.gridLineColor,
                    labels: {
                        enabled: false,
                        style: {
                            color: this.axisFontColor,
                            fontSize: this.axisFontSize
                        }
                    },
                    min: 0,
                    max: data.maxVal,

                    tickInterval: 2,
                    title: {
                        text: ''
                    }
                },
                legend: {
                    enabled: false
                },
                plotOptions: {
                    series: {
						connectNulls: connectNullsFlag,
                        states: {
                            hover: {
                                halo: {
                                    size: 1,
                                }
                            }
                        },
                    },
                    area: {
                        fillColor: {
                            linearGradient: {
                                x1: 0,
                                y1: 0,
                                x2: 0,
                                y2: 1
                            },
                            stops: [
                                [0, Highcharts.Color('#f88a96').setOpacity(0.5).get('rgba')],
                                [1, Highcharts.Color('#f88a96').setOpacity(0).get('rgba')],
                            ]
                        },
                        marker: {
                            enabled: false
                        },
                        lineWidth: 2,
                        states: {
                            hover: {
                                lineWidth: 2
                            }
                        },
                        threshold: null
                    }
                },

                series: [{
                    type: 'area',
					color:'#f88a96',
                    data: data.data
                }]
            };
            // check for no data
            if (Ext.isEmpty(data.data)) {
                $(selector).addClass('highchartNoData');
            } else {
                $(selector).removeClass('highchartNoData');
            }
            //chartData= jQuery.extend(true,chartData,getUserThemeFor(strSkin));
            return chartData;
        }
    },
    constructor: function (config) {
        this.initConfig(config);
    }
});