Ext.define('EgCitrixDashCloud.controller.Main', {
	extend: 'Ext.app.Controller',
	requires: [
		'EgCitrixDashCloud.view.Main',
		'EgCitrixDashCloud.view.UxView',
		'EgCitrixDashCloud.view.LayerView',
		
		'EgCitrixDashCloud.view.Sessions.SessionsTopView',
		'EgCitrixDashCloud.view.Sessions.SessionsIssues',

		'EgCitrixDashCloud.view.Logon.LogonsTopView',
		'EgCitrixDashCloud.view.Logon.LogonsChartView',
		'EgCitrixDashCloud.view.Logon.LogonsIssues',

		'EgCitrixDashCloud.view.Latency.LatencyTopView',
		'EgCitrixDashCloud.view.Latency.LatencyChartView',
		'EgCitrixDashCloud.view.Latency.LatencyIssues',

		'EgCitrixDashCloud.view.Alerts.BandChart',
		'EgCitrixDashCloud.view.Alerts.ComponentsVisuals',
		'EgCitrixDashCloud.view.Alerts.Recommendations',
		
		'EgCitrixDashCloud.view.AcknowledgementPanel',

		'EgCitrixDashCloud.view.Alarms.AlarmsFilter',
		'EgCitrixDashCloud.view.Alarms.AlarmsGroupedView'
	],
	refs: [{
		ref: 'main',
		selector: 'main'
	},{
		ref:'acknowledgementpanel',
		selector:'acknowledgementpanel'
	}],
	init: function () {
		timerId=window.setInterval("executee()",60000);
		this.control({
			'main': {
				afterrender: this.onLoad
			},
			'slider[action=sliderchange]': {
				changecomplete: function (slider, newValue, thumb, eOpts) {
					this.ajaxChangeUrl(newValue, slider.id);
					this.updatePage(newValue);
				}
			},
			'acknowledgementpanel button[id="submitBtn"]':
			{
				'click' : this.alarmAckSubmit
			},
			'acknowledgementpanel button[id="unAckBtn"]':
			{
				'click' : this.goToUnAcknowledge
			},
			'acknowledgementpanel button[id="clearBtn"]':
			{
				'click' : this.clearAckDescription
			},
		});
	},
	checkSpecialCharacter: function (name) {
        var splChar = "=\"";
        for (var i = 0; i < name.length; i++) {
            check_char = splChar.indexOf(name.charAt(i))
            //Returns value 1 if the special character listed in splChar is found
            if (check_char >= 0) {
                return true;
            }
        }
        return false;
    },
	clearAckDescription : function()
	{
		Ext.getCmp('textaraObj').setValue('');
	},
	goToUnAcknowledge : function()
	{
		var des = Ext.getCmp('textaraObj').getValue();

		if(!checkblankVal(des))
		{
			Ext.MessageBox.show({
				title: 'Alert',
				//msg: unAckAlertMsg,
				msg: unAckDescriptionAlert,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		else
		{
			Ext.MessageBox.confirm('Confirm', unAckDeleteConfirmAlert,this.unAcknowledgeAlarm,this);
		}
	},
	unAcknowledgeAlarm : function(btn)
	{
		if(btn=="yes")
		{
			var des = Ext.getCmp('textaraObj').getValue();
			/*var ackAlarmIDs = alarmAckHiddenParams['ackAlarmIDs'];

			if(ackAlarmIDs.indexOf("#")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.substring(ackAlarmIDs.indexOf("#")+1);
			}

			if(ackAlarmIDs.indexOf("#")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.substring(ackAlarmIDs.indexOf("#")+1);
			}
		//	EgAckForm.hiddesc.value=des;
			while(ackAlarmIDs.indexOf("+")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.replace("+","|plus|");
			}
			while(ackAlarmIDs.indexOf("&")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.replace("&","|amp|");
			}
			while(ackAlarmIDs.indexOf("%")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.replace("%","|pct|");
			}*/
			var userAck = alarmAckHiddenParams['userAck'];
			var alarmId = alarmAckHiddenParams['alarmId'];
			var ackAlarmDB = "Unacknowledge";
			try
			{
				des = window.opener.filterEncode(des);
			}
			catch (e)
			{
				des = parent.filterEncode(des);
			}
			//var QStr = "desc="+encodeURIComponent(des)+"&hiddesc="+encodeURIComponent(des)+"&userID=" +encodeURIComponent(userId) + "&alarmID=" + alarmId+ "&userAck=" + userAck + "&ackAlarmIDs=" +encodeURI(ackAlarmIDs)+ "&ackAlarmDB="+ackAlarmDB;
			var QStr = "desc="+encodeURIComponent(des)+"&hiddesc="+encodeURIComponent(des)+"&userID=" +encodeURIComponent(userId) + "&alarmID=" + alarmId+ "&userAck=" + userAck + "&ackAlarmDB="+ackAlarmDB;

			Ext.getCmp('ackWindowObj').destroy();
			var meController = this;
			var emtText = Ext.get("emptyTextTb");
			try
			{
				if(emtText != null)
				Ext.get("emptyTextTb").hide();
			}
			catch (e)
			{
			}
			var alarmLoadMask = new Ext.LoadMask(Ext.getBody(), {
				msg : "Loading ..."
			});
			alarmLoadMask.show();
			var browser=get_browser_info();
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgCurrentAlarmsC',
				method : 'POST',
				params: QStr+'&doAlarmAcknowledgementEvent=true&acknowledgementEvent=unAcknowledge&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height)+'&isBro='+browser.name+"&isFromQuickLink="+isFromQuickLink,
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					var acknowledge = jsonData['unacknowledge'];

					alarmLoadMask.hide();
					location.reload(true);
				}
			});
		}
		else
		{
			return false;
		}
	},
	alarmAckSubmit : function(buttonObj)
	{
		var alarmAckEvent =  alarmAckHiddenParams['alarmAckEvent'];

		if(alarmAckEvent!=null)
		{
			if(alarmAckEvent=="Delete_Alarm")
			{
				this.alarmDelete(buttonObj);
			}
			else if(alarmAckEvent=="AckOrUnack")
			{
				this.alarmAcknowledge(buttonObj);
			}
		}
	},
	alarmAcknowledge : function(buttonObj)
	{
		var des = Ext.getCmp('textaraObj').getValue();
		var description=true;
		if(isDoubleByteEnabled=="false")
			description = validateSingleByte(des);
		if(!checkblankVal(des))
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: ackDescriptionAlert,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		else if (this.checkSpecialCharacter(des)) {
                Ext.Msg.show({
                    title: "Alert",
                    msg: ackDescriptionSplCharAlert,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                return;
		}
		else if(!description)
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: ackdbyteAlert,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		else
		{
			if(isDoubleByteEnabled && isOracleDB)
			{
				if(des!=null && des!='' && des.length>1024)
				{
					Ext.MessageBox.show({
						title: 'Alert',
						msg: maxAcknowledgeDescForDByte,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}
			else if(des!=null && des!='' && des.length>2048)
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: maxAcknowledgeDescForSByte,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}

			if(des==null || des=='')
				des = "-";

			/*var ackAlarmIDs = alarmAckHiddenParams['ackAlarmIDs'];

			if(ackAlarmIDs.indexOf("#")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.substring(ackAlarmIDs.indexOf("#")+1);
			}
		//	EgAckForm.hiddesc.value=des;
			while(ackAlarmIDs.indexOf("+")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.replace("+","|plus|");
			}
			while(ackAlarmIDs.indexOf("&")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.replace("&","|amp|");
			}
			while(ackAlarmIDs.indexOf("%")>-1)
			{
				ackAlarmIDs=ackAlarmIDs.replace("%","|pct|");
			}*/
			var userAck = alarmAckHiddenParams['userAck'];
			var alarmId = alarmAckHiddenParams['alarmId'];
			var ackAlarmDB = alarmAckHiddenParams['ackAlarmDB'];

			try
			{
				des = window.opener.filterEncode(des);
			}
			catch (e)
			{
				des = parent.filterEncode(des);
			}
			
			//var QStr = "desc="+encodeURIComponent(des)+"&hiddesc="+encodeURIComponent(des)+"&userID=" +encodeURIComponent(userId) + "&alarmID=" + alarmId+ "&userAck=" + userAck + "&ackAlarmIDs=" +encodeURI(ackAlarmIDs)+ "&ackAlarmDB="+ackAlarmDB;
			var QStr = "desc="+encodeURIComponent(des)+"&hiddesc="+encodeURIComponent(des)+"&userID=" +encodeURIComponent(userId) + "&alarmID=" + alarmId+ "&userAck=" + userAck + "&ackAlarmDB="+ackAlarmDB;
			Ext.getCmp('ackWindowObj').destroy();
			var meController = this;
			var emtText = Ext.get("emptyTextTb");
			try
			{
				if(emtText != null)
				Ext.get("emptyTextTb").hide();
			}
			catch (e)
			{
			}
			var alarmLoadMask = new Ext.LoadMask(Ext.getBody(), {
				msg : "Loading ..."
			});
			alarmLoadMask.show();

			var browser=get_browser_info();
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgCurrentAlarmsC',
				method : 'POST',
				params: QStr+'&doAlarmAcknowledgementEvent=true&acknowledgementEvent=acknowledge&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height)+'&isBro='+browser.name+"&isFromQuickLink="+isFromQuickLink,
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					//console.log(jsonText);
					var jsonData=Ext.decode(jsonText);
					var acknowledge = jsonData['acknowledge'];
					alarmLoadMask.hide();
					location.reload();					
				}
			});
		}
	},
	alarmDelete : function(button)
	{
		var des = Ext.getCmp('textaraObj').getValue();

		var description=true;

		if(isDoubleByteEnabled=="false")
			description = validateSingleByte(des);


		if (this.checkSpecialCharacter(des)) {
                Ext.Msg.show({
                    title: "Alert",
                    msg: ackDescriptionSplCharAlert,
                    buttons: Ext.MessageBox.OK,
                    icon: Ext.MessageBox.WARNING
                });
                return;
		}
		else if(!description)
		{
			Ext.MessageBox.show({
				title: 'Alert',
				msg: ackdbyteAlert,
				buttons: Ext.MessageBox.OK,
				icon: Ext.MessageBox.WARNING
			});
			return false;
		}
		else
		{
			if(isDoubleByteEnabled && isOracleDB)
			{
				if(des!=null && des!='' && des.length>1024)
				{
					Ext.MessageBox.show({
						title: 'Alert',
						msg: maxAcknowledgeDescForDByte,
						buttons: Ext.MessageBox.OK,
						icon: Ext.MessageBox.WARNING
					});
					return false;
				}
			}
			else if(des!=null && des!='' && des.length>2048)
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: maxAcknowledgeDescForSByte,
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return false;
			}

			if(des==null || des=='')
				des = "-";
			
			try
			{
				des = window.opener.filterEncode(des);
			}
			catch (e)
			{
				des = parent.filterEncode(des);
			}
			var strDeleteView=alarmAckHiddenParams['ackdelAlarmDb'];
			if(false && !Ext.isEmpty(strDeleteView) && strDeleteView!=undefined && strDeleteView!='undefined' && strDeleteView=='Delete Alarm')
			{
				var optionVal=Ext.getCmp('option').getValue();
				if(!Ext.isEmpty(optionVal) && optionVal!=undefined && optionVal=='All')
				{
					//publicJson['hiddenParams']['deleteOptions'] = optionVal;
				}
				else if(!Ext.isEmpty(optionVal) && optionVal!=undefined && optionVal=='Selected')
				{
					//publicJson['hiddenParams']['deleteOptions'] = optionVal;

					var selectedInfos = '';
					var descriptorsObj=null;
					if(eventGrpDeleteFlag)
					{
						descriptorsObj = Ext.getCmp('selEventDescriptors');
					}
					else
					{
						descriptorsObj = Ext.getCmp('selDescriptors');
					}

					if(!Ext.isEmpty(descriptorsObj))
					{
						var splitDescriptorsNames=descriptorsObj.getValue();
						var store_data=descriptorsObj.getStore();
						if(!Ext.isEmpty(store_data) && !Ext.isEmpty(splitDescriptorsNames))
						{
							for(var m=0;m<splitDescriptorsNames.length;m++)
							{
								var selected_info=splitDescriptorsNames[m];
								for(var k=0;k<store_data.getCount();k++)
								{
									var store_info=store_data.getAt(k).data.value;
									if(store_info==selected_info)
									{
										if(selectedInfos=="")
										{
											selectedInfos=selected_info;
										}
										else
										{
											selectedInfos=selectedInfos+"~!~"+selected_info;
										}
									}
								}
							}
						}
					}
					//publicJson['hiddenParams']['deleteSelectedInfos'] = selectedInfos;
				}
			}

			var QStr = this.updateQueryString(button.getId());
			Ext.getCmp('ackWindowObj').destroy();
			var meController = this;
			var emtText = Ext.get("emptyTextTb");
			try
			{
				if(emtText != null)
				Ext.get("emptyTextTb").hide();
			}
			catch (e)
			{
			}
			var alarmLoadMask = new Ext.LoadMask(Ext.getBody(), {
				msg : "Loading ..."
			});
			alarmLoadMask.show();
			var browser=get_browser_info();
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgCurrentAlarmsC',
				method : 'POST',
				params: QStr+'&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height)+'&isBro='+browser.name+"&isFromQuickLink="+isFromQuickLink,
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					alarmLoadMask.hide();
					window.location.href = "/final/servlet/com.eg.EgMonitorController?monCmd=dashboard";					
				}
			});
		}
	},
	updateQueryString : function(objId)
	{
		var des = Ext.getCmp('textaraObj').getValue();
		var QStr = '';// "&compsearch="+searchText+"&selectedSearchByOption="+searchByCombo;
		QStr += 'alarmType=CurrentAlarms&userID=admin&alarmID='+queryReqParams.alarmId+'&isDelAlarms=true&ackAlarmDbDelete=Delete%20Alarm&isFromDashBoard=false&desc='+des;

		return QStr;
	},
	ajaxChangeUrl: function (newValue, sliderId) {
		var sliderTimelineVal;
		if (sliderId == "logon_slider") {
			sliderTimelineVal = logon_timelinecombo.items[newValue].value;
			logon_timelinecombo.selectIntvalue = newValue;
			logon_timelinecombo.selectvalue = sliderTimelineVal;
		} else if (sliderId == "session_slider") {
			sliderTimelineVal = session_timelinecombo.items[newValue].value;
			session_timelinecombo.selectIntvalue = newValue;
			session_timelinecombo.selectvalue = sliderTimelineVal;
		} else {
			sliderTimelineVal = latency_timelinecombo.items[newValue].value;
			latency_timelinecombo.selectIntvalue = newValue;
			latency_timelinecombo.selectvalue = sliderTimelineVal;
		}

		Ext.getCmp(sliderId).setFieldLabel("Showing Data for last: " + sliderTimelineVal);
		setSession('', sliderTimelineVal, sliderId);
	},
	updatePage: function (newValue) {
		var sliderTimelineVal;
		if (!Ext.isEmpty(Ext.getCmp('uxview'))) {
			Ext.getCmp('uxview').updatePage();
			Ext.getCmp('layerview').updatePage();
		} else if (!Ext.isEmpty(Ext.getCmp('sessionstopview'))) {
			if(Ext.isEmpty(newValue))
				newValue = Ext.getCmp('session_slider').getValue();
			sliderTimelineVal = session_timelinecombo.items[newValue].value;
			Ext.getCmp('sessionstopview').updatePage(sliderTimelineVal);
			Ext.getCmp('sessionsissues').updatePage(sliderTimelineVal);
		} else if (!Ext.isEmpty(Ext.getCmp('logonstopview'))) {
			if(Ext.isEmpty(newValue))
				newValue = Ext.getCmp('logon_slider').getValue();
			sliderTimelineVal = logon_timelinecombo.items[newValue].value;
			Ext.getCmp('logonstopview').updatePage(sliderTimelineVal);
			Ext.getCmp('logonschartview').updatePage(sliderTimelineVal);
			Ext.getCmp('logonsissues').updatePage(sliderTimelineVal);
		} else if (!Ext.isEmpty(Ext.getCmp('latencytopview'))) {
			if(Ext.isEmpty(newValue))
				newValue = Ext.getCmp('latency_slider').getValue();
			sliderTimelineVal = latency_timelinecombo.items[newValue].value;
			Ext.getCmp('latencytopview').updatePage(sliderTimelineVal);
			Ext.getCmp('latencychartview').updatePage(sliderTimelineVal);
			Ext.getCmp('latencyissues').updatePage(sliderTimelineVal);
		} else if (!Ext.isEmpty(Ext.getCmp('alarmsgroupedview')))
		{
			//Ext.getCmp('latencytopview').updatePage();
			Ext.getCmp('alarmsgroupedview').updatePage();
		}

	},
	onLoad: function () {
		var me = this;
		if (activeView == "homePage")
			me.goToHomePage();
		else if (activeView == "sessionPage")
			me.goToSessionsPage();
		else if (activeView == "logonPage")
			me.goToLogonPage();
		else if (activeView == "latencyPage")
			me.goToLatencyPage();
		else if (activeView == "alertsPage")
			me.goToAlertsPage();
		else if (activeView == "alarmPage")
			me.goToAlarmsPage();
	},
	goToHomePage: function () {
		var me = this,
		card = Ext.getCmp('home_ground');
		window.clearInterval(timerId);
		timerId=window.setInterval("executee()",60000);
		for (var i = 0; i < Ext.getCmp('home_ground').items.length; i++) {
			Ext.destroy(card.items.items[0].items.items[i])
		}

		card.removeAll(true);
		card.suspendLayouts();

		if (!Ext.isEmpty(card.header)) {
			card.header.hide();
		}

		card.add({
			xtype: 'uxview',
			titleAlign: 'center',
			title: 'USER EXPERIENCE<span style="float:right;margin-top:2px"><a href="/final/servlet/com.eg.EgMonitorController?monCmd=dashboard" mouse="default" class="panelHeaderLink">Infrastructure Overview</a></span>',
			id: 'uxview'
		}, {
			xtype: 'layerview',
			id: 'layerview'
		});
		card.resumeLayouts(true);
		setSession("homePage");
	},
	goToSessionsPage: function () {
		var me = this,
		card = Ext.getCmp('home_ground');
		window.clearInterval(timerId);
		timerId=window.setInterval("executee()",60000);
		for (var i = 0; i < Ext.getCmp('home_ground').items.length; i++) {
			Ext.destroy(card.items.items[0].items.items[i])
		}
		for (let t = 0; t < card.tools.length; t++) {
			Ext.destroy(card.tools[t]);
		}
		card.removeAll(true);
		card.suspendLayouts();
		card.setTitle('<span id="backMain" onClick="javascript:goToHomePage()" style="display:inline-block;vertical-align: middle;" class="iconLeftArrow handSymbol"></span><span style="margin-left:2px;vertical-align: middle;" class="whiteColorText f16-bold">UX ANALYSIS - SESSIONS<span>');
		if (Ext.isEmpty(Ext.getCmp('sliderObj'))) {
			card.addTool({
				xtype: 'slider',
				id: 'session_slider',
				cls: 'mesrslider',
				width: 300,
				margin: '0 20 0 0',
				itemList: session_timelinecombo.items,
				value: session_timelinecombo.selectIntvalue,
				selectvalue: session_timelinecombo.selectvalue,
				plugins: [Ext.create('Ext.ux.FillSlider', {
					clicksToEdit: 1
				})],
				increment: 1,
				minValue: 0,
				maxValue: session_timelinecombo.items.length - 1,
				constrainThumbs: false,
				fieldLabel: "Showing Data for last: " + session_timelinecombo.selectvalue,
				labelWidth: 180,
				labelSeparator: '',
				labelAlign: 'left',
				labelStyle:"color:#ffffff",
				animation: true,
				action: 'sliderchange',
				tipText: function (t) {
					return Ext.String.format('{0}', session_timelinecombo.items[t.value].value)
				}
			});
		}
		card.header.show();
		card.header.setHeight(37);
		card.add({
			xtype: 'panel',
			flex:1,
			scroll:true,
			autoScroll:true,
			items:[{
				xtype: 'sessionstopview',
				id: 'sessionstopview'
			},{
				xtype: 'sessionsissues',
				id: 'sessionsissues'
			}]
		});
		card.doComponentLayout();
		card.resumeLayouts(true);
		setSession("sessionPage");
		//console.log("session_timelinecombo=--==->>", session_timelinecombo)
		me.ajaxChangeUrl(session_timelinecombo.selectIntvalue, 'session_slider');
	},
	goToLogonPage: function () {
		var me = this,
		card = Ext.getCmp('home_ground');
		window.clearInterval(timerId);
		timerId=window.setInterval("executee()",60000);
		for (var i = 0; i < Ext.getCmp('home_ground').items.length; i++) {
			Ext.destroy(card.items.items[0].items.items[i])
		}
		for (let t = 0; t < card.tools.length; t++) {
			Ext.destroy(card.tools[t]);
		}
		card.removeAll(true);
		card.suspendLayouts();
		card.setTitle('<span id="backMain" onClick="javascript:goToHomePage()" style="display:inline-block;vertical-align: middle;" class="iconLeftArrow handSymbol"></span><span style="margin-left:2px;vertical-align: middle;" class="whiteColorText f16-bold">UX ANALYSIS - LOGONS<span>');
		if (Ext.isEmpty(Ext.getCmp('sliderObj'))) {
			card.addTool({
				xtype: 'slider',
				id: 'logon_slider',
				cls: 'mesrslider',
				width: 300,
				margin: '0 20 0 0',
				itemList: logon_timelinecombo.items,
				value: logon_timelinecombo.selectIntvalue,
				selectvalue: logon_timelinecombo.selectvalue,
				plugins: [Ext.create('Ext.ux.FillSlider', {
					clicksToEdit: 1
				})],
				increment: 1,
				minValue: 0,
				maxValue: logon_timelinecombo.items.length - 1,
				constrainThumbs: false,
				fieldLabel: "Showing Data for last: " + logon_timelinecombo.selectvalue,
				labelWidth: 180,
				labelSeparator: '',
				labelAlign: 'left',
				animation: true,
				labelStyle:"color:#ffffff",
				action: 'sliderchange',
				tipText: function (t) {
					return Ext.String.format('{0}', logon_timelinecombo.items[t.value].value)
				}
			});
		}
		card.header.show();
		card.header.setHeight(37);
		card.add({
			xtype: 'panel',
			flex:1,
			scroll:true,
			autoScroll:true,
			items:[{
				xtype: 'logonstopview',
				id: 'logonstopview'
			}, {
				xtype: 'logonschartview',
				id: 'logonschartview'
			}, {
				xtype: 'logonsissues',
				id: 'logonsissues'
			}]
		});
		card.doComponentLayout();
		card.resumeLayouts(true);
		setSession("logonPage");
		me.ajaxChangeUrl(logon_timelinecombo.selectIntvalue, 'logon_slider');
	},
	goToLatencyPage: function () {
		var me = this,
		card = Ext.getCmp('home_ground');
		window.clearInterval(timerId);
		timerId=window.setInterval("executee()",60000);
		for (var i = 0; i < Ext.getCmp('home_ground').items.length; i++) {
			Ext.destroy(card.items.items[0].items.items[i])
		}
		for (let t = 0; t < card.tools.length; t++) {
			Ext.destroy(card.tools[t]);
		}
		card.removeAll(true);
		card.suspendLayouts();
		card.setTitle('<span id="backMain" onClick="javascript:goToHomePage()" style="display:inline-block;vertical-align: middle;" class="iconLeftArrow handSymbol"></span><span style="margin-left:2px;vertical-align: middle;" class="whiteColorText f16-bold">UX ANALYSIS - LATENCY<span>');
		if (Ext.isEmpty(Ext.getCmp('sliderObj'))) {
			card.addTool({
				xtype: 'slider',
				id: 'latency_slider',
				cls: 'mesrslider',
				width: 300,
				margin: '0 20 0 0',
				itemList: latency_timelinecombo.items,
				value: latency_timelinecombo.selectIntvalue,
				selectvalue: logon_timelinecombo.selectvalue,
				plugins: [Ext.create('Ext.ux.FillSlider', {
					clicksToEdit: 1
				})],
				increment: 1,
				minValue: 0,
				maxValue: latency_timelinecombo.items.length - 1,
				constrainThumbs: false,
				fieldLabel: "Showing Data for last: " + latency_timelinecombo.selectvalue,
				labelWidth: 180,
				labelSeparator: '',
				labelAlign: 'left',
				labelStyle:"color:#ffffff",
				animation: true,
				action: 'sliderchange',
				tipText: function (t) {
					return Ext.String.format('{0}', latency_timelinecombo.items[t.value].value)
				}
			});
		}
		card.header.show();
		card.header.setHeight(37);
		card.add({
			xtype: 'panel',
			flex:1,
			scroll:true,
			autoScroll:true,
			items:[{
				xtype: 'latencytopview',
				id: 'latencytopview'
			}, {
				xtype: 'latencychartview',
				id: 'latencychartview'
			}, {
				xtype: 'latencyissues',
				id: 'latencyissues'
			}]
		});
		card.doComponentLayout();
		card.resumeLayouts(true);
		setSession("latencyPage");
		me.ajaxChangeUrl(latency_timelinecombo.selectIntvalue, 'latency_slider');
	},
	goToAlertsPage: function () {
		var me = this,
		card = Ext.getCmp('home_ground');
		for (var i = 0; i < Ext.getCmp('home_ground').items.length; i++) {
			Ext.destroy(card.items.items[0].items.items[i])
		}
		for (let t = 0; t < card.tools.length; t++) {
			Ext.destroy(card.tools[t]);
		}
		card.removeAll(true);
		card.suspendLayouts();
		if(queryReqParams.backTo == "alarmsPage")
			card.setTitle('<span id="backMain" onClick="javascript:goToUxImproveAlarmPage()" style="display:inline-block;vertical-align: middle;" class="iconLeftArrow handSymbol"></span><span style="margin-left:2px;vertical-align: middle;" class="whiteColorText f16-bold">ALERT DETAILS<span>');
		else
			card.setTitle('<span style="margin-left:2px;vertical-align: middle;" class="whiteColorText f16-bold">ALERT DETAILS<span>');

		card.header.show();
		card.header.setHeight(37);
		
		var browser=get_browser_info();
		var param_qstr = 'showAlarms=HIGH%7Camp%7CINTERMEDIATE%7Camp%7CLOW&alarmType=CurrentAlarms&selectedFilterOption=zones&selectedSubFilterOption='+queryReqParams.zoneName+'&fromPage=SAASHome&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height)+'&isBro='+browser.name+'&isFromQuickLink=false';

		card.add({
			xtype: 'panel',
			flex:1,
			scroll:true,
			autoScroll:true,
			items: [{
					xtype: 'bandchart',
					param_qstr:param_qstr
				},
				{
					xtype: 'componentsvisuals'				
				}
			]
		});
		card.doComponentLayout();
		card.resumeLayouts(true);
	},
	goToAlarmsPage: function () {
		var me = this,
		card = Ext.getCmp('home_ground');
		window.clearInterval(timerId);
		timerId=window.setInterval("executee()",60000);
		for (var i = 0; i < Ext.getCmp('home_ground').items.length; i++) {
			Ext.destroy(card.items.items[0].items.items[i]);
		}
		for (let t = 0; t < card.tools.length; t++) {
			Ext.destroy(card.tools[t]);
		}
		card.removeAll(true);
		card.suspendLayouts();
		
		card.setTitle('<span id="backMain" onClick="javascript:goToHomePage()" style="display:inline-block;vertical-align: middle;" class="iconLeftArrow handSymbol"></span><span style="margin-left:2px;vertical-align: middle;" class="whiteColorText f16-bold">CURRENT ALERTS IN THE CITRIX ENVIRONMENT<span>');
		card.header.show();
		card.header.setHeight(37);
		//var header = ['type', 'componentName', 'description', 'layer', 'startTime'];
		var header = ['COLUMN_2', 'COLUMN_3', 'COLUMN_4', 'COLUMN_5', 'COLUMN_6'];
		var storeHeader = Ext.create('Ext.data.Store', {
			fields: header,
			data: []
		});
		

		var browser=get_browser_info();
		var param_qstr = 'showAlarms=HIGH%7Camp%7CINTERMEDIATE%7Camp%7CLOW&alarmType=CurrentAlarms&selectedFilterOption=zones&selectedSubFilterOption='+queryReqParams.zoneName+'&fromPage=SAASHome&screenWidth='+(Ext.getBody().getViewSize().width)+'&screenHeight='+(Ext.getBody().getViewSize().height)+'&isBro='+browser.name+'&isFromQuickLink=false';
				
		card.add([{
			xtype:'panel',
			ui: 'round-corners',
			bodyPadding: 20,
			margin:'0 0 10 0',
			flex: 1,
			layout:{
				type:'vbox',
				align:'stretch'
			},
			dockedItems: [{
				xtype: 'toolbar',
				hidden:true,
				dock: 'bottom',
				border:false,
				ui:'plaintoolbar',
				padding:'0 0 20 0',
				buttonAlign: 'center',
				items: ['->',{
					xtype:'toolbar',
					ui:'footer',
					items:[
						{
							xtype:'button',
							ui:'newButtonMediumBlue-medium ',
							text:'Delete Alarm',
						},
						{
							xtype:'button',
							ui:'newButtonMediumBlue-medium ',
							text:'Acknowledge',
						}
					]
				},'->']
			}],
			items:[{
				xtype:'alarmsfilters',
				id:'alarmsfilters',
				ui:'borderContainer',
				height:65,
				padding:20,
				hidden:true,
				margin:'0 0 10 0'
			}, {
				xtype: 'alarmsgroupedview',
				id: 'alarmsgroupedview',
				param_qstr:param_qstr,
				flex:1
			}]
		}]);
		card.doComponentLayout();
		setSession("alarmPage");
		card.resumeLayouts(true);		
	}
});