Ext.define('AlarmModel', {
    extend: 'Ext.data.Model',
    //fields: ['type', 'componentName', 'description', 'layer', 'startTime', 'group', 'state','hidden','subType','childID','parentID','isParent']
    fields: ['COLUMN_0','COLUMN_2', 'COLUMN_3', 'COLUMN_4', 'COLUMN_5', 'COLUMN_6', 'group', 'state','hidden','subType','childID','parentID','isParent','COLUMN_MeasGraph_url','COLUMN_DD_url','mouseOverUrl']
});
var AlarmStore = Ext.create('Ext.data.Store', {
    storeId: 'AlarmStore',
    model: 'AlarmModel',
    groupField: 'group',
    groupDir: 'DESC', // or 'ASC' 
	data:[],
});
//'{[values.rows[0].group]}'
var headerCol = [{
    "group": "User Impacting Alerts",
    "count": "24",
    "criticalCount": 125,
    "majorCount": 25,
    "minorCount": 2
}, {
    "group": "Potentially User Impacting Alerts",
    "count": "2134",
    "majorCount": 25,
    "minorCount": 2
}];


var groupingFeature = Ext.create('Ext.grid.feature.Grouping', {
    groupHeaderTpl: [
        '<tpl for=".">',
        //'<div style="display:none">{[values.rows[0].group]}</div>',
        '<div dataAttr="{[values.rows[0].group]}"></div>',
        '</tpl>',

    ],
    getFeatureTpl: function (values, parent, x, xcount) {
        return [
            '<tpl if="typeof rows !== \'undefined\'">',
            // group row tpl
            '<tr id="{groupHeaderId}" class="' + Ext.baseCSSPrefix + 'grid-group-hd {hdCollapsedCls} {collapsibleClass}"><td class="' + Ext.baseCSSPrefix + 'grid-cell" colspan="' + parent.columns.length + '" {[this.indentByDepth(values)]}><div class="' + Ext.baseCSSPrefix + 'grid-cell-inner"><div>{collapsed}{[this.renderGroupHeaderTpl(values, parent)]}</div></div></td></tr>',
            // this is the rowbody
            '<tr id="{groupBodyId}" class="' + Ext.baseCSSPrefix + 'grid-group-body {collapsedCls}"><td colspan="' + parent.columns.length + '">{[this.recurse(values)]}</td></tr>',
            '</tpl>'
        ].join('');
    },
    hideGroupedHeader: false,
    startCollapsed: false
});

var scrollTimer = null,cls = "odd";

Ext.define('EgCitrixDashCloud.view.Alarms.AlarmsGroupedView', {
    extend: 'Ext.grid.Panel',
	requires:['Ext.ux.RowExpander'],
    alias: 'widget.alarmsgroupedview',
	id:'SAAS_alarm_grid',
    flex: 1,
    scroll: true,
    autoScroll: true,
    ui: "groupGrid",
    store: AlarmStore,
    rowLines: false,
    alarmDetails:null,
    features: [groupingFeature],
    selModel: {
        checkOnly: false,
        injectCheckbox: 'first',
        mode: 'SINGLE'
    },
    plugins: [
        {
            ptype: 'rowexpander',
            expandOnEnter:false,
            id:'rowexpander',
            selectRowOnExpand:false,
            expandOnDblClick:false,
            rowBodyTpl: [
                '<div class="htmlTemplate"></div>'
            ],
            toggleRow: function(rowIdx,record,orgin) {
                var view = this.view,
                    rowNode = view.getNode(rowIdx),
                    row = Ext.get(rowNode),
                    nextBd = Ext.get(row).down(this.rowBodyTrSelector),
                    record = view.getRecord(rowNode),
                    grid = this.getCmp();
        
                
                if(Ext.isEmpty(orgin)){
                    //alert('plus')
                    if (row.hasCls(this.rowCollapsedCls)) {
                        row.removeCls(this.rowCollapsedCls);
                        nextBd.addCls(this.rowBodyHiddenCls);
                        this.recordsExpanded[record.internalId] = true;
                        view.refreshSize();
                        view.fireEvent('expandColsBody', rowNode, record, nextBd.dom);
                        $('.htmlTemplate').html('');
                    } else {
                        row.addCls(this.rowCollapsedCls);
                        nextBd.addCls(this.rowBodyHiddenCls);
                        this.recordsExpanded[record.internalId] = false;
                        view.refreshSize();
                        view.fireEvent('collapseColsBody', rowNode, record, nextBd.dom);
                    }
                }else{
                    //from action column
                    //alert('orgin')
                    if (row.hasCls(this.rowCollapsedCls) || nextBd.hasCls(this.rowBodyHiddenCls)) {
                        row.addCls(this.rowCollapsedCls);
                        nextBd.removeCls(this.rowBodyHiddenCls);
                       
                        this.recordsExpanded[record.internalId] = true;
                        view.refreshSize();
                        //view.fireEvent('expandbody', rowNode, record, nextBd.dom);
                       $('.htmlTemplate').html('');
                    $(nextBd.dom).find('.htmlTemplate').html('<div class="htmlTemplateheader"><img src="/final/images/clear.png" data-qtip="Close Details" class="iconAlarmClose mouse"/></div>' + record.alarmDetails.mouseOverDiv);
                    view.fireEvent('collapseColsBody', rowNode, record, nextBd.dom);
                    //CLOSE Details
                    $('.iconAlarmClose').on('click', function () {
                        $('.htmlTemplate').html('');
                        view.fireEvent('collapsebody', rowNode, record, nextBd.dom);
                    });
                      // alert('orgin if')
                    } else {
                       // alert('orgin else')
                        
                        row.removeCls(this.rowCollapsedCls);
                        nextBd.addCls(this.rowBodyHiddenCls);
                        this.recordsExpanded[record.internalId] = false;
                        view.refreshSize();
                        view.fireEvent('collapsebody', rowNode, record, nextBd.dom);
                        //$(nextBd.dom).find('.htmlTemplate').html('');
                        

                    }
                }
                
            },
            getHeaderConfig: function() {
                var me                = this,
                    toggleRow         = Ext.Function.bind(me.toggleRow, me),
                    selectRowOnExpand = me.selectRowOnExpand;
        
                return {
                    id: this.getHeaderId(),
                    width: 24,
                    sortable: false,
                    resizable: false,
                    draggable: false,
                    hideable: false,
                    menuDisabled: true,
                    cls: Ext.baseCSSPrefix + 'grid-header-special',
                    renderer: function(value, metadata,record) {
                        metadata.tdCls = Ext.baseCSSPrefix + 'grid-cell-special';
                        if(record.data.hidden || (!record.data.isParent)){
							return '<div>&#160;</div>';
						}else{
							return '<div class="' + Ext.baseCSSPrefix + 'grid-row-expander">&#160;</div>';
						}
                    },
                    processEvent: function(type, view, cell, recordIndex, cellIndex, e) {
                        if (type == "mousedown" && e.getTarget('.x-grid-row-expander')) {
                            var row = e.getTarget('.x-grid-row');
                            toggleRow(row);
                            return selectRowOnExpand;
                        }
                    }
                };
            }
        }
    ],
    viewConfig: {
        stripeRows: false,
		emptyText:'',
		deferEmptyText:false,
        preserveScrollOnRefresh: true,
        getRowClass: function(record, index) {
            //console.log("record.get('parentID')",record.data.parentID )
            if (record.get('hidden') == true) {
                return 'display-false '+record.get('childID')+'';
            }else{
                return 'display-true '+record.get('childID')+'';
            } 
        },
        listeners: {
            expandColsBody: function (rowNode, record, expandRow, eOpts) {
                var rows = this.getStore().getRange();
                for (var i = 0; i < rows.length; i++) { 
                    if(record.data.parentID == rows[i].data.childID){

                        if (!Ext.isEmpty(record.data.parentID)) {
                            $(rowNode).siblings('tr.' + record.data.parentID + '').removeClass('display-false');
                        }

                    }

                }
            },
            collapseColsBody: function (rowNode, record, expandRow, eOpts) {
                var rows = this.getStore().getRange();
                for (var i = 0; i < rows.length; i++) {
                    if (record.data.parentID == rows[i].data.childID) {
                        if (!Ext.isEmpty(record.data.parentID)) {

                            $(rowNode).siblings('tr.' + record.data.parentID + '').addClass('display-false');

                        }

                    }

                }
            },
            viewready: function (view) {
                scrollFunction(view);
                $("#" + view.id).scroll(function () {
                    if (scrollTimer) {
                        clearTimeout(scrollTimer); // clear any previous pending timer
                    }
                    scrollTimer = setTimeout(function () {
                        scrollFunction(view);
                    }, 50);

                });
            },
            resize: function (view, width, height, oldWidth, oldHeight, eOpts) {
                if (!Ext.isEmpty(oldWidth)) {
                    scrollFunction(view);
                }
            },
            refresh: function (view) {
                $('.x-grid-group-hd').each(function (index, el) {
                    if (index % 2 == 0) {
                        $(el).addClass('oddCls');
                        $(el).next('.x-grid-group-body').addClass('oddCls');

                    } else {
                        $(el).addClass('evenCls');
                        $(el).next('.x-grid-group-body').addClass('evenCls');
                    }
                });
                if(Ext.isEmpty(headerCol)){
                    headerCol.forEach(function (element, index, array) {
                        //var width = $("#" + view.id).find('.x-grid-table').width();
                        var t = new Ext.XTemplate([
                            '<div style="height:40px;vertical-align: middle;line-height: 40px;padding: 0px 8px;">',
                            '<div style="float:left">',
                            '<span class="groupTitle">{group}<span class="groupCount"> - {count}</span></span>',
                            '</div>',
                            '<div  style="float:right">',
                            '<tpl if="values.criticalCount">',
                            '<span class="badge criticalBadge">{criticalCount}</span><span style="margin-left:5px;margin-right:15px;font-size:12px">Critical</span>',
                            '</tpl>',
                            '<tpl if="values.majorCount">',
                            '<span class="badge majorBadge">{majorCount}</span><span style="margin-left:5px;margin-right:15px;font-size:12px">Major</span>',
                            '</tpl>',
                            '<tpl if="values.minorCount">',
                            '<span class="badge minorBadge">{minorCount}</span><span style="margin-left:5px;margin-right:5px;font-size:12px">Minor</span>',
                            '</tpl>',
                            '</div>',
                            '<div style="clear:both"></div>',
                            '</div>',
                        ]);
						if(!Ext.isEmpty(Ext.query("[dataAttr=" + element.group + "]")[0])){
							t.compile();
							t.overwrite(Ext.query("[dataAttr=" + element.group + "]")[0], element);
							Ext.destroy(t);
						}
    
                    });
                }
                
            },
            groupcollapse: function (v, n, groupName) {
                //   scrollFunction(v);
            },
            groupexpand: function (v, n, groupName) {
                //  scrollFunction(v);
            }
        }
    },
    columns: [{
        text: 'group',
        flex: 1,
        hidden: true,
        id: 'group',
        sortable:false,
        menuDisabled: true,
        dataIndex: 'group'
    },{
		xtype:'actioncolumn',
		hideable : false,
		sortable:false,
		resizable:false,
		enableColumnHide : true,
		align: 'left',
		width:38,
		layout:'hbox',
		dataIndex:'COLUMN_0',
		items:[
		{
			icon: '',
			style:{'display':'block !important'},
			id:'stateID_0',
			getClass: function(Value, metaData, record){
				var state_icon = record.get('COLUMN_0');
				if(Ext.isEmpty(state_icon) || state_icon==null || state_icon=="-")
					return 'x-hide-visibility';
				else
					return state_icon
			}
		}],
		renderer: function(value, metaData, record, row, col, store, gridView)
		{
			var mouseOverAckDiv = record.get('mouseOverAckDiv');
			if(mouseOverAckDiv!=null && (mouseOverAckDiv!="-" && mouseOverAckDiv!=""))
			{
				metaData.tdCls = 'egShowTip';
			}
		},
		listeners: {
			'click':function(grid, rowIndex, colIndex, item, event, record, row)
			{
				var href = record.get('mouseOverUrl');
				if(!Ext.isEmpty(href) && href!=null && href!="-" )
					wayToLayerModel(href);
				return;
			}
		}
	}, {
        text: 'type',
        flex: 1,
        menuDisabled: true,
        sortable:false,
        dataIndex: 'COLUMN_2',
      
		listeners:{
			'click':function(grid, rowIndex, colIndex, item, event, record, row)
			{
				var href = record.get('mouseOverUrl');
				if(!Ext.isEmpty(href) && href!=null && href!="-" )
					wayToLayerModel(href);
				return;
			}
		}
    }, {
        text: 'componentName',
        flex: 1,
        menuDisabled: true,
        sortable:false,
        dataIndex: 'COLUMN_3',
		listeners:{
			'click':function(grid, rowIndex, colIndex, item, event, record, row)
			{
				var href = record.get('mouseOverUrl');
				if(!Ext.isEmpty(href) && href!=null && href!="-" )
					wayToLayerModel(href);
				return;
			}
		}
    }, {
        text: 'description',
        flex: 1,
        menuDisabled: true,
        sortable:false,
        dataIndex: 'COLUMN_4',
		listeners:{
			'click':function(grid, rowIndex, colIndex, item, event, record, row)
			{
				var href = record.get('mouseOverUrl');
				if(!Ext.isEmpty(href) && href!=null && href!="-" )
					wayToLayerModel(href);
				return;
			}
		}
    }, {
        text: 'layer',
        flex: 1,
        menuDisabled: true,
        sortable:false,
        dataIndex: 'COLUMN_5',
		listeners:{
			'click':function(grid, rowIndex, colIndex, item, event, record, row)
			{
				var href = record.get('mouseOverUrl');
				if(!Ext.isEmpty(href) && href!=null && href!="-" )
					wayToLayerModel(href);
				return;
			}
		}
    }, {
        text: 'startTime',
        flex: 1,
        menuDisabled: true,
        sortable:false,
        dataIndex: 'COLUMN_6',
		listeners:{
			'click':function(grid, rowIndex, colIndex, item, event, record, row)
			{
				var href = record.get('mouseOverUrl');
				if(!Ext.isEmpty(href) && href!=null && href!="-" )
					wayToLayerModel(href);
				return;
			}
		}
    }, {
        xtype: 'actioncolumn',
        width: 105,
        sortable:false,
        menuDisabled: true,
        items: [{
            iconcls: 'iconAlarmDetails',
            getClass: function () {
                return 'iconAlarmDetails actioncolumngap';
            },
            tooltip: 'Alarm Details',
            handler:function(view, rowIndex, colIndex){
               var record = view.getStore().getAt(rowIndex);
                //console.log(rowIndex,'alarmDetails',view.up('gridpanel').alarmDetails[rowIndex])
                record.alarmDetails = view.up('gridpanel').alarmDetails[rowIndex];
                view.up('gridpanel').plugins[0].toggleRow(rowIndex, record,"actionColumn")
            }

        }, {
            iconcls: 'iconLineChart',
			getClass: function (Value, metaData, record) {
				var graphUrl = record.get('COLUMN_MeasGraph_url');
				if(Ext.isEmpty(graphUrl) || graphUrl==null || graphUrl=="-")
	                return 'iconSpacer actionIcon mouseOverRemove';
				else
	                return 'iconLineChart actioncolumngap';
            },
            tooltip: 'Chart ',
            handler: function (grid, rowIndex, colIndex) {
                var rec = grid.getStore().getAt(rowIndex);
				var graphUrl = rec.get('COLUMN_MeasGraph_url');
				if(!Ext.isEmpty(graphUrl) && graphUrl!=null && graphUrl!="-")
				{
					graphUrl = decodeURIComponent(graphUrl);
					this.fireEvent('itemClick', loadPopup(graphUrl));
				}
            }
        }, {
            iconcls: 'iconDiagnosis',
            getClass: function(Value, metaData, record){
				var ddhref = record.get('COLUMN_DD_url');
				if(Ext.isEmpty(ddhref) || ddhref==null || ddhref=="-")
	                return 'iconSpacer actionIcon mouseOverRemove';
				else
	                return 'iconDiagnosis actioncolumngap';
            },
            tooltip: 'Diagnosis',
            handler: function (grid, rowIndex, colIndex) {
                var rec = grid.getStore().getAt(rowIndex);
				var ddhref = rec.get('COLUMN_DD_url');
				if(!Ext.isEmpty(ddhref) && ddhref!=null && ddhref!="-")
				{
					ddhref = decodeURIComponent(ddhref);
					this.fireEvent('itemClick', loadPopup(ddhref));
				}
				
            }
        }]
    }],
	updatePage:function()
	{
        var me = this;
        var alarmLoadMask = new Ext.LoadMask(Ext.getBody(), {
				msg : "Loading ..."
			});
			alarmLoadMask.show();
		
			try
			{
				Ext.Ajax.request({
					url : '/final/servlet/com.eg.EgCurrentAlarmsC',
					method : 'POST',
					params: this.param_qstr,
					scope:this,
					success: function(response)
					{
						var jsonText = response.responseText;
						var jsonData=Ext.decode(jsonText);
						if(Ext.isEmpty(jsonData.gridJson))
						{
							jsonData.gridJson = [];
							jsonData.gridJson.gridData = [];
							jsonData.gridJson.groupHeaderArray = [];
							jsonData.gridJson.gridData = [];
						}
						var gridData = jsonData.gridJson.gridData;
						var mouseDivGridData = jsonData.gridJson.mouseDivGridData;
						var groupHeaderArray = jsonData.gridJson.groupHeaderArray;
						me.alarmDetails = jsonData.gridJson.mouseDivGridData;
						alarmLoadMask.hide();
						if(gridData.length == 0)
						{
							this.getView().emptyText = '<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconNoalarms"></div><div>No alarms found!</div></div></div>';
							this.getView().refresh();
						}
						me.getStore().loadRawData(gridData);
						//headerCol = groupHeaderArray;

						groupHeaderArray.forEach(function (element, index, array) {
							//var width = $("#" + view.id).find('.x-grid-table').width();
							var t = new Ext.XTemplate([
								'<div style="height:40px;vertical-align: middle;line-height: 40px;padding: 0px 8px;">',
								'<div style="float:left">',
								'<span class="groupTitle">{group}<span class="groupCount"> - {count}</span></span>',
								'</div>',
								'<div  style="float:right">',
								'<tpl if="values.criticalCount">',
								'<span class="badge criticalBadge">{criticalCount}</span><span style="margin-left:5px;margin-right:15px;font-size:12px">Critical</span>',
								'</tpl>',
								'<tpl if="values.majorCount">',
								'<span class="badge majorBadge">{majorCount}</span><span style="margin-left:5px;margin-right:15px;font-size:12px">Major</span>',
								'</tpl>',
								'<tpl if="values.minorCount">',
								'<span class="badge minorBadge">{minorCount}</span><span style="margin-left:5px;margin-right:5px;font-size:12px">Minor</span>',
								'</tpl>',
								'</div>',
								'<div style="clear:both"></div>',
								'</div>',
							]);
							if(!Ext.isEmpty(Ext.query("[dataAttr=" + element.group + "]")[0])){
								t.compile();
								t.overwrite(Ext.query("[dataAttr=" + element.group + "]")[0], element);
								Ext.destroy(t);
							}
                            
                        });
						//this.loadgrid(jsonData);
					}
				});

			}
			catch (e)
			{
				alarmLoadMask.hide();
			}
	},
	listeners:{
		afterrender:function(e)
		{
            var me = this;
			var alarmLoadMask = new Ext.LoadMask(Ext.getBody(), {
				msg : "Loading ..."
			});
			alarmLoadMask.show();
		
			try
			{
				Ext.Ajax.request({
					url : '/final/servlet/com.eg.EgCurrentAlarmsC',
					method : 'POST',
					params: this.param_qstr,
					scope:this,
					success: function(response)
					{
						var jsonText = response.responseText;
						//console.log(jsonText);
                        var jsonData=Ext.decode(jsonText);
                        if(Ext.isEmpty(jsonData.gridJson))
						{
							jsonData.gridJson = [];
							jsonData.gridJson.gridData = [];
							jsonData.gridJson.groupHeaderArray = [];
							jsonData.gridJson.gridData = [];
						}
						var gridData = jsonData.gridJson.gridData;
						var mouseDivGridData = jsonData.gridJson.mouseDivGridData;
						var groupHeaderArray = jsonData.gridJson.groupHeaderArray;
                        e.alarmDetails = jsonData.gridJson.mouseDivGridData;
						alarmLoadMask.hide();
						if(gridData.length == 0)
						{
							this.getView().emptyText = '<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconNoalarms"></div><div>No alarms found!</div></div></div>';
							this.getView().refresh();
						}
						this.getStore().loadRawData(gridData);
						//headerCol = groupHeaderArray;
						
						groupHeaderArray.forEach(function (element, index, array) {
							//var width = $("#" + view.id).find('.x-grid-table').width();
							var t = new Ext.XTemplate([
								'<div style="height:40px;vertical-align: middle;line-height: 40px;padding: 0px 8px;">',
								'<div style="float:left">',
								'<span class="groupTitle">{group}<span class="groupCount"> - {count}</span></span>',
								'</div>',
								'<div  style="float:right">',
								'<tpl if="values.criticalCount">',
								'<span class="badge criticalBadge">{criticalCount}</span><span style="margin-left:5px;margin-right:15px;font-size:12px">Critical</span>',
								'</tpl>',
								'<tpl if="values.majorCount">',
								'<span class="badge majorBadge">{majorCount}</span><span style="margin-left:5px;margin-right:15px;font-size:12px">Major</span>',
								'</tpl>',
								'<tpl if="values.minorCount">',
								'<span class="badge minorBadge">{minorCount}</span><span style="margin-left:5px;margin-right:5px;font-size:12px">Minor</span>',
								'</tpl>',
								'</div>',
								'<div style="clear:both"></div>',
								'</div>',
							]);
							if(!Ext.isEmpty(Ext.query("[dataAttr=" + element.group + "]")[0])){
								t.compile();
								t.overwrite(Ext.query("[dataAttr=" + element.group + "]")[0], element);
								Ext.destroy(t);
							}

						});
						//this.loadgrid(jsonData);
					}
				});

			}
			catch (e)
			{
				alarmLoadMask.hide();
			}
		}
	},
	loadgrid:function(jsonData)
	{
		
	}
});

function scrollFunction(view) {

    var appendToId = view.up('grid').body.id,
        viewHeight = $("#" + view.id).innerHeight();
    $('.x-grid-group-hd').each(function (index, el) {
        var $innerHTML = $(el).html(),
            offsetTop = $(el).next('.x-grid-group-body').offset().top;
        if (index % 2 == 0) {
            cls = "even";
        } else {
            cls = "odd";
        }
        // top 
        if ((offsetTop - ((index + 1) * 41)) < $("#" + view.id).offset().top) {
            if ($('#fakeheader-' + index + '')) {
                $('#fakeheader-' + index + '').remove();
            }
            if (!$('#fakeheader-' + index + '').length) {
                var toppos = index * 41;
                $('#' + appendToId).append('<table class="fakeheader top ' + cls + '" id="fakeheader-' + index + '" style="top:' + toppos + 'px">' + $innerHTML + '</table>');
                //click on header
                $('#fakeheader-' + index + '').on('click', function () {
                    var groupName = $('.groupHeader').eq(index).html();
                    if (groupingFeature.isExpanded(groupName)) {
                        var scrollTop = toppos + (index * 41);
                        $("#" + view.id).animate({
                            scrollTop: scrollTop
                        }, 1000);
                        delete scrollTop;
                    } else {
                        groupingFeature.expand( groupName, true);
                    }

                });
                delete toppos;
                delete $innerHTML;
            }
        }
        // top 
        else if ((offsetTop - $(el).next('.x-grid-group-body').height()) > viewHeight) {
            if ($('#fakeheader-' + index + '')) {
                $('#fakeheader-' + index + '').remove();
            }

            if (!$('#fakeheader-' + index + '').length) {

                var toppos = $("#" + view.id).height() - (index * 41);
                $('.x-grid-body').append('<table class="fakeheader bottom ' + cls + '" id="fakeheader-' + index + '" style="top:' + toppos + 'px">' + $innerHTML + '</table>');

                //click on header
                $('#fakeheader-' + index + '').on('click', function () {
                    var groupName = $('.groupHeader').eq(index).html();
                    if (groupingFeature.isExpanded(groupName)) {
                        var scrollTop = $(el).eq(index - 1).offset().top;
                        $("#" + view.id).animate({
                            scrollTop: scrollTop
                        }, 1000);
                        delete scrollTop;
                    }else{
                        groupingFeature.expand( groupName, true);
                    }


                });
                delete toppos;
                delete $innerHTML;
            }
        } else {
            $('#fakeheader-' + index + '').remove();
        }

    });
}


function loadPopup(qUrl){
	try
	{
		parent.openWindow(encodeURI(qUrl),'GRAPHS','toolbar=no,menubar=no,location=no,status=no,width=1014,height=603,left=0,top=80,screenx=0,screeny=0,resizable=yes,scrollbars=yes');
	}
	catch (e)
	{
	}
	
}