Ext.define('EgCitrixDashCloud.view.Alerts.BandChart', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.bandchart',
    requires: [
        'EgCitrixDashCloud.view.Alerts.AlertsHeaderView',
        'EgCitrixDashCloud.view.BorderPanel',
        'EgCitrixDashCloud.view.Alerts.OccuranceDetails',
        'EgCitrixDashCloud.view.Alerts.GroupedGrid'
    ],
    layout: {
        align: 'stretch',
        type: 'vbox'
    },
    margin:'0 0 10 0',
    dockedItems: [{
        xtype: 'toolbar',
		id:'ackdelToolBar',
		hidden:true,
        dock: 'bottom',
        ui:'roundtoolbar',
        padding:'15 0',
        buttonAlign: 'center',
        items: ['->',{
            xtype:'toolbar',
            ui:'footer',            
			items:[
                {
                    xtype:'button',
					id:'ackToolBtn',
					hidden:true,
                    ui:'newButtonMediumBlue-medium ',
                    text:'Acknowledge',
					listeners:{
						click:function()
						{
							var ackAlarmDb="Acknowledge";
							var height = Ext.getBody().getViewSize().height - 150;
							var qStrParams1 ="doAlarmAcknowledgementEvent=true&acknowledgementEvent=loadAcknowledgementUI&userID=" + userId + "&alarmID=" + queryReqParams.alarmId + "&ackAlarmDB="+encodeURI(ackAlarmDb)+"&ackorDelTitle=Acknowledge&isForAck=true";
							Ext.widget('window', {
								title: '',
								height: height,
								width:550,
								shadow:'sides',
								cls:'lightbox',
								padding:'0 10 10 10',
								modal:true,
								bodyCls:'alarmsbg',
								id : 'ackWindowObj',
								name : 'ackWindowObj',
								closeAction : 'destroy',
								items:[{
									xtype:'acknowledgementpanel',
									qStrParams : qStrParams1,
									len:1
								}],
								listeners : {
									show: function(win) {
										if (this.modal) {
											var dom = Ext.dom.Query.select('.x-mask');
											var el = Ext.get(dom[0]);
											el.addCls('windowModal');
										}
										},
										 hide:  function(win) {
										if (this.modal) {
											var dom = Ext.dom.Query.select('.x-mask');
											var el = Ext.get(dom[0]);
											el.removeCls('windowModal');
										}
										}
								}
								//closeAction: 'destory'
							}).show();							
						}
					}
                }/*,{
                    xtype:'button',
                    text:'Resolve/Correct',
                    ui:'newButtonMediumBlue-medium '
                }*/,{
                    xtype:'button',
					id:'delToolBtn',
					hidden:true,
                    ui:'newButtonMediumBlue-medium ',
                    text:'Delete Alert',
					listeners:{
						click:function(e)
						{
							var ackdelAlarmDb="Delete Alarm";
							var isVM = false;
							var height = Ext.getBody().getViewSize().height - 150;
							var qStrParams1 = "doAlarmAcknowledgementEvent=true&acknowledgementEvent=loadAcknowledgementUI&userID=" +userId + "&alarmID=" + queryReqParams.alarmId + "&ackdelAlarmDb="+encodeURIComponent(ackdelAlarmDb)+"&ackorDelTitle=Delete Alarm&isVM="+encodeURI(isVM);
							Ext.widget('window', {
								title: 'Delete Alarm ',
								height: height,
								width: 500,
								modal:true,
								scroll:true,
								autoScroll:true,
								padding:'0 10 10 10',
								shadow:'sides',
								cls:'lightbox',
								bodyCls:'alarmsbg',
								id : 'ackWindowObj',
								name : 'ackWindowObj',
								closeAction : 'destroy',
								items:[{
									xtype:'acknowledgementpanel',
									qStrParams : qStrParams1,
									len:1
								}],
								listeners : {
									show: function(win) {
										if (this.modal) {
											var dom = Ext.dom.Query.select('.x-mask');
											var el = Ext.get(dom[0]);
											el.addCls('windowModal');
										}
										},
										 hide:  function(win) {
										if (this.modal) {
											var dom = Ext.dom.Query.select('.x-mask');
											var el = Ext.get(dom[0]);
											el.removeCls('windowModal');
										}
										}
								}
							//	closeAction: 'destory'
							}).show();
						}
					}
                }
            ]
        },'->']
    }],
    ui: 'round-corners',
    bodyPadding: 20,
    flex: 1,
    items: [{
            xtype: 'alertsheaderview',
			id: 'alertsheaderview',
            flex: 1,
        }, {
            xtype: 'borderpanel',
			id:'measId',
			height:563,
            layout:{
                type:'vbox',
                align:'stretch'
            },
            //title: 'CITRIX XA USERS/ SCREEN REFRESH LATENCY - LAST (SECOND)',
            title: '<span style="display:none;"></span>',
            header: {
                margin: '0 20',
                padding: '15 0'
            },
            items: [{
                    xtype: 'container',
                    flex:1,
                    margin:'0 0 20 0',
					id:'measGraphId'
                },
                {
                    xtype: 'grid',
					id:'measGridId',
                    ui: 'newGridPanel medium',
                    scroll: false,
                    autoScroll: false,                    
                    columns: [],
                    store: Ext.create('Ext.data.Store', {
						fields:["MeasuresDisplay","MeasureAvgDisplay","MeasureMaxDisplay","MeasureMinDisplay"],
                        data: []                        
                    })
                }
            ]
        },
		{
            xtype: 'borderpanel',
			margin: '20 0 0 0',
            header: {
                margin: '0 20',
                padding: '15 0'
            },
            bodyPadding: '10 20 20 20',
            title: 'Logon Details',
			id:'logonPanelId',
			hidden:true,
			height:580,
            items:[]
        },
		{
			xtype:'recommendations',
			id:'recommendationsId'
		},
		{
            xtype: 'borderpanel',
			margin: '20 0 0 0',
            header: {
                margin: '0 20',
                padding: '15 0'
            },
            bodyPadding: '0 20 20 20',
            title: 'Acknowledgement Details',
			id:'acknowledgePanelId',
            items:[]
        },
        {
            xtype: 'borderpanel',
            margin: '20 0 20 0',
            title: 'Threshold Details',
            header: {
                margin: '0 20',
                padding: '15 0'
            },
            bodyPadding: '0 20 20 20',
            items: [{
                    xtype: 'grid',
					id:'thresholdGridId',
                    ui: 'newGridPanel medium',
                    scroll: false,
                    autoScroll: false,
                    flex: 1,
					columns: [],                   
                    store: Ext.create('Ext.data.Store', {
                        fields: [{sortType: "asText", name: "MeasureValue"},{sortType: "asText", name: "MinMax"},{sortType: "asText", name: "Critical"},{sortType: "asText", name: "Major"},{sortType: "asText", name: "Minor"},{sortType: "asText", name: "AlarmPolicy"}],
                        data: []
                    })
                },
                {
                    xtype: 'occurancedetails'
                }
               
            ]
        },
        {
            xtype: 'borderpanel',
            header: {
                margin: '0 20',
                padding: '15 0'
            },
            bodyPadding: '0 20 20 20',
            title: '<span style="display:none;"></span>',
			id:'softwareChangePanel',
            items:[{
                xtype:'groupedgrid',
				id:'softwareChangeGrid'
            }]
        }

    ],
	listeners:{
		boxready:function()
		{
			Ext.Ajax.request({
				url : '/final/servlet/com.eg.EgCurrentAlarmsC',
				method : 'POST',
				params: this.param_qstr,
				scope:this,
				success: function(response)
				{
					var jsonText = response.responseText;
					var jsonData=Ext.decode(jsonText);
					if(!Ext.isEmpty(jsonData.pageParams))
					{
						var showAckBtn = false;
						if(!Ext.isEmpty(jsonData.pageParams.showAcknowledgeBtn) && jsonData.pageParams.showAcknowledgeBtn == "true")
							showAckBtn = true;

						var showDelBtn = false;
						if(!Ext.isEmpty(jsonData.pageParams.showDeleteBtn) && jsonData.pageParams.showDeleteBtn == "true")
							showDelBtn = true;


						if(showAckBtn === false && showDelBtn === false)
							Ext.getCmp('ackdelToolBar').hide();
						else 
						{
							Ext.getCmp('ackdelToolBar').show();
							if(showAckBtn)
								Ext.getCmp('ackToolBtn').show();
							if(showDelBtn)
								Ext.getCmp('delToolBtn').show();								
						}
					}
				}
			});

			var uirl = '/final/monitor/dispComponentGraphs.jsp?site='+queryReqParams.site+'&host='+queryReqParams.host+'&port='+queryReqParams.port+'&layer='+queryReqParams.layer+'&test='+queryReqParams.test+'&comptype='+queryReqParams.comptype+'&isVM='+queryReqParams.isVM+'&info='+queryReqParams.info+'&gtype=1&measure='+queryReqParams.measure+'&msmt_host='+queryReqParams.msmt_host+'&state='+queryReqParams.tstate+'&mode=3D&showRange=Range&monitorSkin=Light&timeLine=Any&starttime='+queryReqParams.starttime+'&starthr='+queryReqParams.starthr+'&startmin='+queryReqParams.startmin+'&endtime='+queryReqParams.endtime+'&endhr='+queryReqParams.endhr+'&endmin='+queryReqParams.endmin+'&tabSetPage=true';
			Ext.Ajax.request({
				url: uirl,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						
						Ext.Ajax.request({
							url: jsonData.GraphUrl+"&isFromKpi=true&alarmStartDateTime="+queryReqParams.alarmStartDateTime+'&comp_info='+queryReqParams.comp_info+'&compAlarmState='+queryReqParams.tstate+"&ddEnabled="+queryReqParams.ddEnabled,
							scope:this,
							method: 'POST',
							timeout:280000,
							success: function( response )
							{
								if ( response.status == 200 && !Ext.isEmpty(response.responseText))
								{
									var jsonText = response.responseText;
									var jsonData = Ext.decode(jsonText);
									Ext.getCmp('measId').setTitle(jsonData.title);
									Ext.getCmp('alertsheaderview').update(jsonData.headerDetails);
									var retChartData = EgCitrixDashCloud.config.Runtime.areaPlotChart('#'+this.body.id,jsonData);
									$('#measGraphId').highcharts(retChartData);
								}
							}
						});

						
						if(!Ext.isEmpty(jsonData.GridData.MeasureGridData)) 
						{
							Ext.getCmp('measGridId').columns = [{
								header: jsonData.GridData.MeasureGridColumns.MeasureLabel,
								menuDisabled:true,
								dataIndex: 'MeasuresDisplay',
								flex: 1,
								renderer: function (value, metaData, record, rowIndex) {
									if (!Ext.isEmpty(jsonData.GridData.MeasureGridData)) {
										for (i = 0; i < jsonData.GridData.MeasureGridData.length; i++) // Kaliraj
										{
											var returnValue = value + " " +
												record.raw.MeasuresDisplayUnit; // Kaliraj				
										}
										return returnValue;
									} else {
										return value;
									}
								}
							}, {
								header: jsonData.GridData.MeasureGridColumns.MeasureAvgLabel,
								menuDisabled:true,
								dataIndex: 'MeasureAvgDisplay',
								flex: 1
							}, {
								header: jsonData.GridData.MeasureGridColumns.MeasureMaxLabel,
								menuDisabled:true,
								dataIndex: 'MeasureMaxDisplay',
								flex: 1
							}, {
								header: jsonData.GridData.MeasureGridColumns.MeasureMinLabel,
								menuDisabled:true,
								dataIndex: 'MeasureMinDisplay',
								flex: 1
							}];

							Ext.getCmp('measGridId').getStore().loadData(jsonData.GridData.MeasureGridData);
							Ext.getCmp('measGridId').reconfigure(Ext.getCmp('measGridId').getStore(), Ext.getCmp('measGridId').columns);
							Ext.getCmp('measGridId').getView().refresh();
						}
					}
				}
			});
			
			///final/monitor/egDashBoardDispCompMeasure.jsp?site=NULL&host=VAD-XA-RDSH2:1494&layer=CTX_USERS&qctr=2&comptype=Citrix_XcXenApp_server&fromalarm=null&msmt_host=&test=CtxXcXAUserTest-+egin%255Cegdev1&tstate=INTERMEDIATE&searchString=&backButton=true&subtitle=true&searchBox=true
			//add Logon Iframe
			Ext.Ajax.request({
				url: '/final/monitor/egDashBoardDispCompMeasure.jsp?site='+queryReqParams.site+'&host='+queryReqParams.host+':'+queryReqParams.port+'&layer='+queryReqParams.layer+'&qctr=2&comptype='+queryReqParams.comptype+'&fromalarm=null&msmt_host='+queryReqParams.msmt_host+'&test='+queryReqParams.testName+'&tstate='+queryReqParams.site+'&searchString=&backButton=true&subtitle=true&searchBox=true',
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						if(!Ext.isEmpty(jsonData.Logon_Details_Support)){
							Ext.getCmp('logonPanelId').show();
							Ext.getCmp('logonPanelId').add({
								xtype : 'container',
								margin : 0,
								id : 'logonframeId',
								bodyPadding :0,
								padding:0,
								autoScroll:false,
								scroll:false,
								border : false,
								frame : false,
								layout:'fit',
								autoEl : {
									tag : 'iframe',
									name : 'perMainIframe',
									id:'logonIframeId',
									frameborder : '0',
									style:{'top':'0px','left':'0px'},
									marginLeft:0,
									marginTop:0,
									height : '100%',
									width : '100%',
									src:jsonData.Logon_Details_Support.urlParam1+"&isFromXenVdi=true"
								}
							});
						}
					}
				}
			});			

			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Alerts_KPI_Page&variable=getRecomendationData&time_line=&isUserBased=true&host='+queryReqParams.host+'&port='+queryReqParams.port+'&layer='+queryReqParams.layer+'&test='+queryReqParams.test+'&comptype='+queryReqParams.comp_info+'&info='+queryReqParams.info+'&measure='+queryReqParams.measName+'&msmt_host='+queryReqParams.msmt_host+'&state='+queryReqParams.tstate+'&monitorSkin=Light&timeLine=Any&starttime='+queryReqParams.starttime+'&starthr='+queryReqParams.starthr+'&startmin='+queryReqParams.startmin+'&endtime='+queryReqParams.endtime+'&endhr='+queryReqParams.endhr+'&endmin='+queryReqParams.endmin+'&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						//console.log("jsonData=--==--=@@@@@@=-=--getRecomendationData=>>"+jsonData)
						if(Ext.isEmpty(jsonData.data))
							Ext.getCmp('recommendationsId').destroy();
						else
							Ext.getCmp('recommendationsId').body.update("<div style='font-size:14px;font-weight:500;'>"+jsonData.data+"</div>");
					}
				}
			});
			
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Alerts_KPI_Page&variable=getAcknowledgementData&alarmId='+queryReqParams.alarmId+'&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						//console.log("jsonData=-=-=-@@@@-=-==-=-getAcknowledgementData>>",jsonData)
						if(!Ext.isEmpty(jsonData))
						{
							try
							{
								if(jsonData.data.items.length > 0)
								{
									Ext.getCmp('acknowledgePanelId').add({
										xtype: 'grid',
										id:'ackGridId',
										ui: 'newGridPanel medium',
										scroll: false,
										autoScroll: false,
										flex: 1,
										columns: jsonData.columns,                   
										store: Ext.create('Ext.data.Store', {
											fields: jsonData.fields,
											data: jsonData.data.items
										})
									});
								}
								else
									Ext.getCmp('acknowledgePanelId').destroy();
							}
							catch (e)
							{
								Ext.getCmp('acknowledgePanelId').destroy();
							}
						}
					}
				}
			});			

			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Alerts_KPI_Page&variable=getthresholdData&time_line=&isUserBased=true&host='+queryReqParams.host+'&port='+queryReqParams.port+'&layer='+queryReqParams.layer+'&test='+queryReqParams.test+'&comptype='+queryReqParams.comptype+'&info='+queryReqParams.info+'&measure='+queryReqParams.measName+'&msmt_host='+queryReqParams.msmt_host+'&state='+queryReqParams.tstate+'&monitorSkin=Light&timeLine=Any&starttime='+queryReqParams.starttime+'&starthr='+queryReqParams.starthr+'&startmin='+queryReqParams.startmin+'&endtime='+queryReqParams.endtime+'&endhr='+queryReqParams.endhr+'&endmin='+queryReqParams.endmin+'&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						//console.log("jsonData-=-==-@@@@-==-=-getthresholdData>>",jsonData)
						Ext.getCmp('thresholdGridId').columns = jsonData.columns;
						Ext.getCmp('thresholdGridId').getStore().loadData(jsonData.data.items);
						Ext.getCmp('thresholdGridId').reconfigure(Ext.getCmp('thresholdGridId').getStore(), Ext.getCmp('thresholdGridId').columns);
						Ext.getCmp('thresholdGridId').getView().refresh();
					}
				}
			});
			
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Alerts_KPI_Page&time_line=&isUserBased=true&host='+queryReqParams.host+'&port='+queryReqParams.port+'&layer='+queryReqParams.layer+'&test='+queryReqParams.test+'&comptype='+queryReqParams.comptype+'&info='+queryReqParams.infoPlus+'&measure='+queryReqParams.measName+'&msmt_host='+queryReqParams.msmt_host+'&state='+queryReqParams.state+'&monitorSkin=Light&timeLine=24 hours&starttime='+queryReqParams.starttime+'&starthr='+queryReqParams.starthr+'&startmin='+queryReqParams.startmin+'&endtime='+queryReqParams.endtime+'&endhr='+queryReqParams.endhr+'&endmin='+queryReqParams.endmin+'&onlyCount=true&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						//console.log("jsonData-=-==-@@@@-==-=-Last 24 hours>>",jsonData)
						var cmpObj = Ext.getCmp('last24hourId');
						cmpObj.fireEvent('updateTpl', jsonData);
					}
				}
			});

			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Alerts_KPI_Page&time_line=&isUserBased=true&host='+queryReqParams.host+'&port='+queryReqParams.port+'&layer='+queryReqParams.layer+'&test='+queryReqParams.test+'&comptype='+queryReqParams.comptype+'&info='+queryReqParams.infoPlus+'&measure='+queryReqParams.measName+'&msmt_host='+queryReqParams.msmt_host+'&state='+queryReqParams.state+'&monitorSkin=Light&timeLine=30 days&graphWithCount=true&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						//console.log("jsonData-=-==-@@@@-==-=-Last 30 days>>",jsonData)
						var cmpObj = Ext.getCmp('last30daysId');
						cmpObj.fireEvent('updateTpl', jsonData);
					}
				}
			});		
			
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Alerts_KPI_Page&time_line=&isUserBased=true&host='+queryReqParams.host+'&port='+queryReqParams.port+'&layer='+queryReqParams.layer+'&test='+queryReqParams.test+'&comptype='+queryReqParams.comptype+'&info='+queryReqParams.infoPlus+'&measure='+queryReqParams.measName+'&msmt_host='+queryReqParams.msmt_host+'&state='+queryReqParams.tstate+'&monitorSkin=Light&timeLine=Current&starttime='+queryReqParams.starttime+'&starthr='+queryReqParams.starthr+'&startmin='+queryReqParams.startmin+'&endtime='+queryReqParams.endtime+'&endhr='+queryReqParams.endhr+'&endmin='+queryReqParams.endmin+'&barChart=true&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						//console.log("jsonData-=-==-@@@@-==-=-barChart>>",jsonData)
						var cmpObj = Ext.getCmp('topHostAlert');
						cmpObj.fireEvent('updateTpl', jsonData);
					}
				}
			});	
			
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Alerts_KPI_Page&time_line=&isUserBased=true&host='+queryReqParams.host+'&port='+queryReqParams.port+'&layer='+queryReqParams.layer+'&test='+queryReqParams.test+'&comptype='+queryReqParams.comptype+'&info='+queryReqParams.infoPlus+'&measure='+queryReqParams.measName+'&msmt_host='+queryReqParams.msmt_host+'&state='+queryReqParams.tstate+'&monitorSkin=Light&timeLine=Any&starttime='+queryReqParams.starttime+'&starthr='+queryReqParams.starthr+'&startmin='+queryReqParams.startmin+'&endtime='+queryReqParams.endtime+'&endhr='+queryReqParams.endhr+'&endmin='+queryReqParams.endmin+'&sameCompAlramGrid=true&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						//console.log("jsonData-=-==-@@@@-==-=-sameCompAlramGrid>>",jsonData)
						Ext.getCmp('otherHostAlert').columns = jsonData.columns;
						Ext.getCmp('otherHostAlert').getStore().loadData(jsonData.data.items);
						Ext.getCmp('otherHostAlert').reconfigure(Ext.getCmp('otherHostAlert').getStore(), Ext.getCmp('otherHostAlert').columns);
						Ext.getCmp('otherHostAlert').getView().refresh();
					}
				}
			});	
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Alerts_KPI_Page&variable=getSoftwareChangesData&time_line=&isUserBased=true&host='+queryReqParams.host+'&port='+queryReqParams.port+'&layer='+queryReqParams.layer+'&test='+queryReqParams.test+'&comptype='+queryReqParams.comptype+'&info='+queryReqParams.info+'&measure='+queryReqParams.measName+'&msmt_host='+queryReqParams.msmt_host+'&state='+queryReqParams.tstate+'&monitorSkin=Light&timeLine=Any&starttime='+queryReqParams.starttime+'&starthr='+queryReqParams.starthr+'&startmin='+queryReqParams.startmin+'&endtime='+queryReqParams.endtime+'&endhr='+queryReqParams.endhr+'&endmin='+queryReqParams.endmin+'&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						//console.log("jsonData==-=-@@@@@@@@+_=--=>>",jsonData)
						try
						{
							if(jsonData.columns[0].text.toLowerCase() == "descriptor")
							{
								jsonData.columns[0].renderer = function (value, meta, record, rowIndex, colIndex, store) {
									//console.log(!rowIndex);
									var first = !rowIndex || value !== store.getAt(rowIndex - 1).get('Descriptor'),
										last = rowIndex >= store.getCount() - 1 || value !== store.getAt(rowIndex + 1).get('Descriptor');
									
									if (first) {
										var i = rowIndex + 1,
											span = 1;
										while (i < store.getCount() && value === store.getAt(i).get('Descriptor')) {
											i++;
											span++;
										}
										/*var rowHeight = 25,
											padding = 6,
											height = (rowHeight * (i - rowIndex) - padding) + 'px';
										//meta.style = 'height:' + height + ';line-height:' + height + ';';*/
										meta.tdAttr = 'rowspan='+span+';';
										meta.tdCls = 'borderRight';
									} else {
										meta.tdAttr = 'style="display:none;"';									
									}
									return first ? value : '';
								};
							}	
						}
						catch (e)
						{
						}
						
						Ext.getCmp('softwareChangePanel').setTitle(jsonData.title);
						Ext.getCmp('softwareChangeGrid').columns = jsonData.columns;
						Ext.getCmp('softwareChangeGrid').getStore().loadData(jsonData.data.items);
						Ext.getCmp('softwareChangeGrid').reconfigure(Ext.getCmp('softwareChangeGrid').getStore(), Ext.getCmp('softwareChangeGrid').columns);
						Ext.getCmp('softwareChangeGrid').getView().refresh();
					}
				}
			});	
		}
	}

});