Object.defineProperty(Array.prototype, 'chunk_inefficient', {
    value: function(chunkSize) {
        var array=this;
        return [].concat.apply([],
            array.map(function(elem,i) {
                return i%chunkSize ? [] : [array.slice(i,i+chunkSize)];
            })
        );
    }
});
Ext.define('EgCitrixDashCloud.view.Alerts.ComponentsVisuals', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.componentsvisuals',
	id:'componentsvisuals',
    padding: 0,
	margin: '10 0 10 0',
	//flex:1,
	//layout:'column',
	//manageOverflow:2,
    layout: {
		type: 'vbox',
		align:'stretch'
     },
     header:{
        padding:'15 0',
        margin:'0 20 0 20'
	},
	minHeight:295,
    bodyPadding:20,
    title:'Performance Graphs',
    ui:'round-corners',
    initComponent:function(){
		
		this.callParent();
	},
    items:[],
	listeners:{
		boxready:function(e)
		{
			this.body.mask("Loading...");
		},
		afterrender:function(e)
		{
			var me = this;
			var margin= "";
			var chartArray = [];
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Alerts_KPI_Page&variable=getChartMeasureData&time_line=&isUserBased=true&host='+queryReqParams.host+'&port='+queryReqParams.port+'&layer='+queryReqParams.layer+'&test='+queryReqParams.test+'&comptype='+queryReqParams.comp_info+'&info='+queryReqParams.info+'&measure='+queryReqParams.measName+'&msmt_host='+queryReqParams.msmt_host+'&state='+queryReqParams.tstate+'&monitorSkin=Light&timeLine=Any&starttime='+queryReqParams.starttime+'&starthr='+queryReqParams.starthr+'&startmin=09&endtime='+queryReqParams.endtime+'&endhr='+queryReqParams.endhr+'&endmin='+queryReqParams.endmin+'&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						//console.log("jsonData-=-==-@@@@@@@@@@@=-=-=-=-ComponentVisulas>>",jsonData)
						if(!Ext.isEmpty(jsonData) && jsonData.result.length > 0)
						{
								for(let u=0;u<jsonData.result.length;u++)
								{
								if(u%2 == 0){
									margin = '0 40 0 0';
									bodyPadding = '0 20 0 20';
								   
								}else{
									margin = '0 0 0 20';
									bodyPadding = '0 20 0 20';
								}
								chartArray.push({
									xtype:'panel',
									id:'chartArray'+u,
									//flex:0.5,
									height:295,
									columnWidth:0.5,
									ui:'tablechart',
									padding:margin,
									//bodyPadding:bodyPadding,
									title:jsonData.result[u].title,
									listeners:{
										resize:function(container, width, height, oldWidth, oldHeight, eOpts){	
											if(!Ext.isEmpty(oldWidth)){
											
												if($('#'+container.body.id).highcharts()){
													var chart = $('#'+container.body.id).highcharts();
													chart.reflow();
												}
											
											}
							
										},
										boxready:function(cmp)
										{
											if(!Ext.isEmpty(jsonData.result))
											{
												//Ext.defer(function(){
												var retChartData = EgCitrixDashCloud.config.Runtime.simpleareaChart('#'+cmp.body.id,jsonData.result[u]);
												//$('#'+this.id+'-body').highcharts(retChartData);
												$('#'+cmp.body.id).highcharts(retChartData);
												//},500);
												
												
											}
										}
									}
								});
							}
							
							var chuckdata = chartArray.chunk_inefficient(2),
							parent=[],cls='',marginParent="";
							
							chuckdata.forEach(function(val,index){
								if(index == 0){
									cls="first";
									
								}else if(index == (chuckdata.length-1)){
									cls="last";
									
								}else{
									cls="nonecol";
									
								}
								//console.log('chuckdata',val)
								parent.push({
									xtype:"panel",
									ui:'plus',
									padding:marginParent,
									cls:cls,
									layout:{
										type:'column',
										//align:'stretch',

									},
									items:val
								});
								/*val.forEach(function(val1,index){
									console.log('HI',val1);
								});*/
							});
							//console.log('chuckdata',parent)
							/*
							for(var i=0;i<chuckdata.length;i++){
									if(i=0){
										cls="firstCol";
									}else if(i = chuckdata.length-1){
										cls="lastCol";
									}
									parent.push({
										xtype:"panel",
										ui:'plus',
										cls:'firstCol',
										flex:1,
										layout:{
											type:'hbox',
											align:'stretch',
	
										},
										items:chuckdata[i]
									});
							}*/
							//console.log('parent',parent)
							//me.suspendLayouts();
							//me.setHeight(340*chuckdata.length);
							me.add(parent);
							me.doComponentLayout();

						}
						else
							this.destroy();						
					}
					this.body.unmask();
				}				
			});
						
		}
	}
});