var store = Ext.create('Ext.data.Store', {
    // store configs
    storeId: 'Companies',
    // reader configs
    fields: [{sortType: "asText", name: "Descriptor"},{sortType: "asText", name: "Measure"},{sortType: "asText", name: "Date"},{sortType: "asText", name: "Previous Value"},{sortType: "asText", name: "Present Value"}],
    data: []
});

Ext.define('EgCitrixDashCloud.view.Alerts.GroupedGrid', {
    extend: 'Ext.grid.Panel',
    xtype: 'groupedgrid',
    store: 'Companies',
    flex: 1,
	maxHeight:250,
    ui: 'newGridPanel medium',
    viewConfig: {
        enableTextSelection: true,
		emptyText: '<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No data found!</div></div></div>',
		deferEmptyText: false
    },
    initComponent: function () {

        this.columns = [{
		}];
        /*this.columns = [{
                text: 'descriptor',
                flex: 3,
                sortable: false,
                dataIndex: 'descriptor',
                renderer: function (value, meta, record, rowIndex, colIndex, store) {

                    console.log(!rowIndex);
                    var first = !rowIndex || value !== store.getAt(rowIndex - 1).get('descriptor'),
                        last = rowIndex >= store.getCount() - 1 || value !== store.getAt(rowIndex + 1).get('descriptor');

                    if (first) {
                        var i = rowIndex + 1,
                            span = 1;
                        while (i < store.getCount() && value === store.getAt(i).get('descriptor')) {
                            i++;
                            span++;
                        }
                        /*var rowHeight = 25,
                            padding = 6,
                            height = (rowHeight * (i - rowIndex) - padding) + 'px';
                        //meta.style = 'height:' + height + ';line-height:' + height + ';';*/
                        /*meta.tdAttr = 'rowspan='+span+';';
                        meta.tdCls = 'borderRight';
                    } else {
                        meta.tdAttr = 'style="display:none;"';
                        
                    }
                    return first ? value : '';
                }
            },

            {
                text: 'measure',
                flex: 1,
                sortable: true,
                dataIndex: 'measure'
            },
            {
                text: 'changeDate',
                flex: 1,
                sortable: true,
                dataIndex: 'changeDate'
            },
            {
                text: 'previoueValue',
                flex: 1,
                sortable: true,
                dataIndex: 'previoueValue'
            },
            {
                text: 'presentValue',
                flex: 1,
                sortable: true,
                dataIndex: 'presentValue'
            }
        ];*/

        this.callParent();

        // this.getView().on('refresh', this.updateRowSpan, this);
    },

    updateRowSpan: function () {
        var columns = this.columns;
        view = this.getView();
        store = this.getStore();
        rowCount = store.getCount();
       // console.log(rowCount);
        column = columns[0];
        //console.log(column);
        dataIndex = column.dataIndex;
        //console.log(dataIndex);

        spanCell = null;
        spanCount = null;
        spanValue = null;
        columnCount = 2;
        for (var row = 0; row < rowCount; ++row) {

            var cell = view.getCellByPosition({
                row: row,
                column: 0
            }).dom;
            record = store.getAt(row);
            value = record.get(dataIndex); //3m co

            if (spanValue != value) {
                if (spanCell !== null) {
                    spanCell.rowSpan = spanCount;
                }

                Ext.fly(cell).setStyle('display', '');
                spanCell = cell;
                spanCount = 1;
                spanValue = value;
            } else {
                spanCount++;
                Ext.fly(cell).setStyle('display', 'none');
            }

        }

        if (spanCell !== null) {
            spanCell.rowSpan = spanCount;
        }
    }
});