Ext.define('EgCitrixDashCloud.view.Alerts.OccuranceDetails', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.occurancedetails',
    padding: 0,
    margin: '20 0 10 0',
    layout: {
        type: 'hbox',
        align: 'stretch'
    },
    height: 225,
    items: [{
            xtype: 'panel',

            layout: {
                type: 'vbox',
                align: 'stretch'
            },
            header: {
                padding: '0',
                margin: 0,
                ui: 'plainHeader'
            },
            width: 235,
            title: 'Past Occurrences',
            items: [{
                    xtype: 'container',
					id:'last24hourId',
                    padding: '20 0 25 0',
                    height: 60,
					listeners: {
                        updateTpl: function (data) {
							this.update(data);
                        },                        
                    },
                    tpl: [
                        '<div>',
                        '<tpl for=".">',
                        '<div class="font_normal12" style="text-transform: uppercase;">',
                        '<img src="../images/Light/icon-duration.png" style="vertical-align: middle;margin-right:10px;">',
                        '{duration}',
                        '</div>',
                        '<div class="font_bold15" style="padding-left:30px;">',
                        '{occurances}',
                        '</div>',
                        '</tpl>',
                        '</div>',
                    ]					
                },
                {
                    xtype: 'tbseparator',
                    ui: 'tbseparator-horizontal',
                    margin: '0 0 0 0'
                },
                {
                    xtype: 'container',
					id:'last30daysId',
                    padding: '20 0',
					flex: 1,
                    listeners: {
                        updateTpl: function (data) {
							this.update(data);
							this.chart(data);
                        },                        
                    },
					chart: function (data) {
                        var chartProps = EgCitrixDashCloud.config.Runtime.getgradientLineGraphPlain('#occurancesChart', data, true);
                        $('#occurancesChart').highcharts(chartProps);
                    },
					tpl: [
                        '<div>',
                        '<tpl for=".">',
                        '<div class="font_normal12" style="text-transform: uppercase;">',
                        '<img src="../images/Light/icon-duration.png" style="vertical-align: middle;margin-right:10px;">',
                        '{duration}',
                        '</div>',
                        '<div class="font_bold15" style="padding-left:30px;">',
                        '<span>{occurances}</span>',
                        '<span class="font_bold13">{unit}</span>',
                        '</div>',
                        '<div id="occurancesChart" style="height:92px"></div>',
                        '</tpl>',
                        '</div>'
                    ]
                }				
            ]
        },
        {
            xtype: 'tbseparator',
            margin: '0 20 0 20'
        },
        {
            xtype: 'panel',
			id:'topHostAlert',
            //flex: 1,
            width: 400,
            header: {
                padding: '0',
                margin: 0,
                ui: 'plainHeader'
            },
            height: 225,
            bodyPadding: '20 0 0 0',
            title: 'Top Hosts with this alert',
            chart: function (selector, data) {
                var chartProps = EgCitrixDashCloud.config.Runtime.barChart('#' + selector, data);
                $('#' + selector).highcharts(chartProps);
            },
            listeners: {
                updateTpl: function (data) {
                    this.update(data);
                    this.chart(this.body.id, data);
                }
			}
        },
        {
            xtype: 'tbseparator',
            margin: '0 20 0 20'
        }, {
            xtype: 'grid',
			id:'otherHostAlert',
            header: {
                padding: '0 0 15 0',
                margin: 0,
                ui: 'plainHeader'
            },
            ui: 'newGridPanel medium',
            scroll: true,
            autoScroll: true,
            title: 'Other Alerts in this Host',
            height: 225,
            flex: 1,
            columns: [],
            store: Ext.create('Ext.data.Store', {
                fields: ['DESCRIPTION', 'START TIME'],
                data: []               
            }),
			viewConfig: {
				enableTextSelection: true,
				emptyText: '<div style="display:table;height:98%;width:100%" ><div style="display:table-cell;vertical-align:middle;text-align:center;"><div style="margin:auto;" class="iconInformation"></div><div>No data found!</div></div></div>',
				deferEmptyText: false
			}
        }
    ]
});