Ext.define('EgCitrixDashCloud.view.Latency.LatencyChartView', {
    extend: 'Ext.container.Container',
	alias: 'widget.latencychartview',
    margin:'0 0 0 0',
    border: false,
    autoScroll: false,
    scroll: false,
    layout: {
        type: 'column'		
    },
	initComponent:function(){
		for (var i=0;i<this.items.length ;i++ )
		{
			if(i%2 == 0){
						this.items[i].margin = '5 5 5 0';
				}else{
						this.items[i].margin = '5 0 5 5';
			}
			this.items[i]
		}
		this.callParent();
	},
	defaults:{
		columnWidth:0.5,
		height:296,
		bodyPadding:20,
		ui:'round-corners'
	},	
	items:[
	{
		xtype:'panel',
		id:'latencyTrend',
		bodyPadding:'20px 20px 0px 20px',
		listeners:{
			resize:function(container, width, height, oldWidth, oldHeight, eOpts){	
				if(!Ext.isEmpty(oldWidth)){
					var chart = $('#'+container.body.id).highcharts();
					chart.reflow();
				}
			}			
		},
		loadChart:function(chartdata){				
			//TODO
			chartdata.isPanel = true;
			retChartData = EgCitrixDashCloud.config.Runtime.timelineChart('#'+this.body.id,chartdata);
			$('#'+this.body.id).highcharts(retChartData);
		}
	},
	{
		xtype:'panel',
		id:'sessionVslatency',
		bodyPadding:'20px 20px 10px 20px',
		listeners:{
			resize:function(container, width, height, oldWidth, oldHeight, eOpts){	
				if(!Ext.isEmpty(oldWidth)){
					var chart = $('#'+container.body.id).highcharts();
					chart.reflow();
				}

			}			
		},
		loadChart:function(chartdata)
		{
			chartdata.isPanel = true;
			ChartProps = EgCitrixDashCloud.config.Runtime.spLineChart('#'+this.body.id,chartdata);
			$('#'+this.body.id).highcharts(ChartProps);
		}
		
	},
	{
		xtype:'panel',
		id:'hdxLatency',
		bodyPadding:'20px 20px 10px 20px',
		listeners:{
			resize:function(container, width, height, oldWidth, oldHeight, eOpts){	
				if(!Ext.isEmpty(oldWidth)){
					var chart = $('#'+container.body.id).highcharts();
					chart.reflow();
				}
			}			
		},
		loadChart:function(chartdata){				
			chartdata.isPanel = true;				
			retChartData = EgCitrixDashCloud.config.Runtime.areaChart('#'+this.body.id,chartdata);
			$('#'+this.body.id).highcharts(retChartData);
		}
	},
	{
		xtype:'panel',
		id:'clientNetworkLatency',
		bodyPadding:'20px 20px 10px 20px',
		listeners:{
			resize:function(container, width, height, oldWidth, oldHeight, eOpts){	
				if(!Ext.isEmpty(oldWidth)){
					var chart = $('#'+container.body.id).highcharts();
					chart.reflow();
				}
			}			
		},
		loadChart:function(chartdata){				
			chartdata.isPanel = true;				
			retChartData = EgCitrixDashCloud.config.Runtime.areaChart('#'+this.body.id,chartdata);
			$('#'+this.body.id).highcharts(retChartData);
		}
	}
	],
	updatePage:function(sliderTimelineVal)
	{
		var me = this;
		
		//Logon Activity
		var myMask1 = new Ext.LoadMask(Ext.getCmp('latencyTrend'), {msg:"Loading..."});
		myMask1.show();	
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Latency_Performance_KPI_Page&time_line=&isUserBased=true&variable=One_Week_Latency_Widget&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
			scope:this,
			method: 'POST',
			timeout:280000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					me.loadLatencyTrend(jsonData)
				}
				myMask1.destroy();
			}
		});

		//Logon BreakDown Time
		var myMask2 = new Ext.LoadMask(Ext.getCmp('sessionVslatency'), {msg:"Loading..."});
		myMask2.show();	
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Latency_Performance_KPI_Page&time_line=&isUserBased=true&variable=Active_Sessions_Vs_Latency_Widget&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
			scope:this,
			method: 'POST',
			timeout:280000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					//console.log("jsonData=--==-@@@@@@-==-=-Session Vs Latency>>",jsonData)
					me.logonSessionVsLatency(jsonData)
				}
				myMask2.destroy();
			}
		});

		//Logon Duration & Activity by Delivery Group
		var myMask3 = new Ext.LoadMask(Ext.getCmp('hdxLatency'), {msg:"Loading..."});
		myMask3.show();	
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Latency_Performance_KPI_Page&time_line=&isUserBased=true&variable=Session_Latency_Trend_Widget&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
			scope:this,
			method: 'POST',
			timeout:280000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					me.loadHdxLatency(jsonData)
				}
				myMask3.destroy();
			}
		});			

		//Network Latency
		var myMask5 = new Ext.LoadMask(Ext.getCmp('clientNetworkLatency'), {msg:"Loading..."});
		myMask5.show();	
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Latency_Performance_KPI_Page&time_line=&isUserBased=true&variable=Network_Latency_Trend_Widget&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
			scope:this,
			method: 'POST',
			timeout:280000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					me.loadClientNetworkLatency(jsonData)
				}
				myMask5.destroy();
			}
		});	
	},
	listeners:{
		boxready:function()
		{
			var me = this;
			var sliderTimelineVal = null;
			try
			{
				sliderTimelineVal = latency_timelinecombo.items[latency_timelinecombo.selectIntvalue].value;
			}
			catch (e)
			{
			}
			
			//One Week Trend
			var myMask1 = new Ext.LoadMask(Ext.getCmp('latencyTrend'), {msg:"Loading..."});
			myMask1.show();	
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Latency_Performance_KPI_Page&time_line=&isUserBased=true&variable=One_Week_Latency_Widget&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						//console.log("jsonData=--==-@@@@@@-==-=-One week Trend>>",jsonData)
						me.loadLatencyTrend(jsonData)
					}
					myMask1.destroy();
				}
			});

			//Session Vs Latency
			var myMask2 = new Ext.LoadMask(Ext.getCmp('sessionVslatency'), {msg:"Loading..."});
			myMask2.show();	
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Latency_Performance_KPI_Page&time_line=&isUserBased=true&variable=Active_Sessions_Vs_Latency_Widget&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						me.logonSessionVsLatency(jsonData)
					}
					myMask2.destroy();
				}
			});

			var myMask3 = new Ext.LoadMask(Ext.getCmp('hdxLatency'), {msg:"Loading..."});
			myMask3.show();	
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Latency_Performance_KPI_Page&time_line=&isUserBased=true&variable=Session_Latency_Trend_Widget&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						//console.log("jsonData=--==-@@@@@@-==-=-Hdx Latency>>",jsonData)
						me.loadHdxLatency(jsonData)
					}
					myMask3.destroy();
				}
			});			

			//Network Latency
			var myMask5 = new Ext.LoadMask(Ext.getCmp('clientNetworkLatency'), {msg:"Loading..."});
			myMask5.show();	
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Latency_Performance_KPI_Page&time_line=&isUserBased=true&variable=Network_Latency_Trend_Widget&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						//console.log("jsonData=--==-@@@@@@-==-=-Network Latency>>",jsonData)
					myMask5.destroy();
						me.loadClientNetworkLatency(jsonData)
					}
				}
			});			
		}
	},
	loadLatencyTrend:function(jsonData)
	{
		var me = this;
		//console.log("jsonData=-=-=-loadLatencyTrend>>",jsonData)
		if(!Ext.isEmpty(jsonData.result))
		{
			var dataChart = jsonData.dataArr;
			Ext.getCmp('latencyTrend').loadChart(jsonData.result[0]);			
		}
	},
	logonSessionVsLatency:function(jsonData)
	{
		var me = this;
		//console.log("jsonData=-=-=-logonBreakDownTime>>",jsonData)
		if(!Ext.isEmpty(jsonData.result))
		{
			var dataChart = jsonData.dataArr;
			Ext.getCmp('sessionVslatency').loadChart(jsonData.result[0]);			
		}
	},
	loadHdxLatency:function(jsonData)
	{
		var me = this;
		//console.log("jsonData=-=-=-loadHdxLatency>>",jsonData)
		if(!Ext.isEmpty(jsonData.result))
		{
			var dataChart = jsonData.dataArr;
			Ext.getCmp('hdxLatency').loadChart(jsonData.result[0]);			
		}
	},
	loadClientNetworkLatency:function(jsonData)
	{
		var me = this;
		//console.log("jsonData=-=-=-loadHdxLatency>>",jsonData)
		if(!Ext.isEmpty(jsonData.result))
		{
			var dataChart = jsonData.dataArr;
			Ext.getCmp('clientNetworkLatency').loadChart(jsonData.result[0]);			
		}
	}		
});