Ext.define('EgCitrixDashCloud.view.Logon.LogonsChartView', {
    extend: 'Ext.container.Container',
	alias: 'widget.logonschartview',
    margin:'0 0 0 0',
    border: false,
    autoScroll: false,
    scroll: false,
    layout: {
        type: 'column'		
    },
	initComponent:function(){
		for (var i=0;i<this.items.length ;i++ )
		{
			if(i%2 == 0){
						this.items[i].margin = '5 5 5 0';
				}else{
						this.items[i].margin = '5 0 5 5';
			}
			this.items[i]
		}
		this.callParent();
	},
	defaults:{
		columnWidth:0.5,
		height:296,
		bodyPadding:20,
		ui:'round-corners'
	},	
	items:[
	{
		xtype:'panel',
		id:'loadLogonActivity',
		bodyPadding:'20px 20px 10px 20px',
		listeners:{
			resize:function(container, width, height, oldWidth, oldHeight, eOpts){	
				if(!Ext.isEmpty(oldWidth)){
					var chart = $('#'+container.body.id).highcharts();
					chart.reflow();
				}

			}			
		},
		loadChart:function(chartdata)
		{
			chartdata.isPanel = true;
			ChartProps = EgCitrixDashCloud.config.Runtime.spLineChart('#'+this.body.id,chartdata);
			$('#'+this.body.id).highcharts(ChartProps);
		}
		
	},
	{
		xtype:'panel',
		id:'logonBreakDownTime',
		bodyPadding:'20px 20px 0px 20px',
		listeners:{
			resize:function(container, width, height, oldWidth, oldHeight, eOpts){	
				if(!Ext.isEmpty(oldWidth)){
					var chart = $('#'+container.body.id).highcharts();
					chart.reflow();
				}
			}			
		},
		loadChart:function(chartdata){				
			//TODO
			chartdata.isPanel = true;
			retChartData = EgCitrixDashCloud.config.Runtime.areaChart('#'+this.body.id,chartdata);
			$('#'+this.body.id).highcharts(retChartData);
		}
	},	
	{
		xtype:'panel',
		id:'logonDeliveryGrp0',
		bodyPadding:'20px 20px 10px 20px',
		listeners:{
			resize:function(container, width, height, oldWidth, oldHeight, eOpts){	
				if(!Ext.isEmpty(oldWidth)){
					var chart = $('#'+container.body.id).highcharts();
					chart.reflow();
				}
			}			
		},
		loadChart:function(chartdata){	
			chartdata.isPanel = true;				
			retChartData = EgCitrixDashCloud.config.Runtime.lineChart('#'+this.body.id,chartdata);
			$('#'+this.body.id).highcharts(retChartData);
		}
	},
	{
		xtype:'panel',
		id:'logonDeliveryGrp1',
		bodyPadding:'20px 20px 10px 20px',
		listeners:{
			resize:function(container, width, height, oldWidth, oldHeight, eOpts){	
				if(!Ext.isEmpty(oldWidth)){
					var chart = $('#'+container.body.id).highcharts();
					chart.reflow();
				}
			}			
		},
		loadChart:function(chartdata){				
			chartdata.isPanel = true;				
			retChartData = EgCitrixDashCloud.config.Runtime.stackedColumnChart('#'+this.body.id,chartdata);
			$('#'+this.body.id).highcharts(retChartData);
		}
	},
	{
		xtype:'panel',
		id:'virtualDesktopFailure',
		bodyPadding:'20px 20px 10px 20px',
		listeners:{
			resize:function(container, width, height, oldWidth, oldHeight, eOpts){	
				if(!Ext.isEmpty(oldWidth)){
					var chart = $('#'+container.body.id).highcharts();
					chart.reflow();
				}
			}			
		},
		loadChart:function(chartdata){
			//TODO
			chartdata.isPanel = true;
			retChartData = EgCitrixDashCloud.config.Runtime.stackedColumnChart('#'+this.body.id,chartdata);
			$('#'+this.body.id).highcharts(retChartData);
		}
	},
	{
		xtype:'panel',
		id:'logonvsSlowLogins',
		listeners:{
			resize:function(container, width, height, oldWidth, oldHeight, eOpts){	
				if(!Ext.isEmpty(oldWidth)){
					var chart = $('#'+container.body.id).highcharts();
					chart.reflow();
				}
			}			
		},
		loadChart:function(data){	
			//TODO
			data.isPanel = true;
			data.isYaxisLabel = false;
			ChartProps = EgCitrixDashCloud.config.Runtime.spLineChart('#'+this.body.id,data);
			$('#'+this.body.id).highcharts(ChartProps);
		}
	},
	{
		xtype:'panel',
		id:'topUsers0',
		bodyPadding:'20px 20px 10px 20px',
		listeners:{
			resize:function(container, width, height, oldWidth, oldHeight, eOpts){	
				if(!Ext.isEmpty(oldWidth)){
					var chart = $('#'+container.body.id).highcharts();
					chart.reflow();
				}
			}			
		},
		loadChart:function(chartdata)
		{
			chartdata.isPanel = true;
			retChartData = EgCitrixDashCloud.config.Runtime.barChart('#'+this.body.id,chartdata);
			$('#'+this.body.id).highcharts(retChartData);			
		}
	},
	{
		xtype:'panel',
		id:'topUsers1',
		bodyPadding:'20px 20px 10px 20px',
		listeners:{
			resize:function(container, width, height, oldWidth, oldHeight, eOpts){	
				if(!Ext.isEmpty(oldWidth)){
					var chart = $('#'+container.body.id).highcharts();
					chart.reflow();
				}
			}			
		},
		loadChart:function(chartdata)
		{
			chartdata.isPanel = true;
			retChartData = EgCitrixDashCloud.config.Runtime.barChart('#'+this.body.id,chartdata);
			$('#'+this.body.id).highcharts(retChartData);			
		}
	}
	],
	updatePage:function(sliderTimelineVal)
	{		
		var me = this;
		
		//Logon Activity
		var myMask1 = new Ext.LoadMask(Ext.getCmp('loadLogonActivity'), {msg:"Loading..."});
		myMask1.show();	
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Logon_Performance_KPI_Page&time_line=&isUserBased=true&variable=Logon_Activity_Widget&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
			scope:this,
			method: 'POST',
			timeout:280000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					me.loadLogonActivity(jsonData)
				}
				myMask1.destroy();
			}
		});

		//Logon BreakDown Time
		var myMask2 = new Ext.LoadMask(Ext.getCmp('logonBreakDownTime'), {msg:"Loading..."});
		myMask2.show();	
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Logon_Performance_KPI_Page&time_line=&isUserBased=true&variable=Logon_Breakdown_Over_Time_Widget&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
			scope:this,
			method: 'POST',
			timeout:280000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					me.logonBreakDownTime(jsonData)
				}
				myMask2.destroy();
			}
		});

		//Logon Duration & Activity by Delivery Group
		var myMask3 = new Ext.LoadMask(Ext.getCmp('logonDeliveryGrp0'), {msg:"Loading..."});
		myMask3.show();	
		var myMask4 = new Ext.LoadMask(Ext.getCmp('logonDeliveryGrp1'), {msg:"Loading..."});
		myMask4.show();	
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=KPI_UX_ANALYSIS&time_line=&isUserBased=true&variable=Delivery_Group_Logon_Duration&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
			scope:this,
			method: 'POST',
			timeout:280000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					me.loadLogonActvityDuration(jsonData)
				}
				myMask3.destroy();
				myMask4.destroy();
			}
		});

		//Virtual Desktop Failures
		var myMask5 = new Ext.LoadMask(Ext.getCmp('virtualDesktopFailure'), {msg:"Loading..."});
		myMask5.show();	
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Logon_Performance_KPI_Page&time_line=&isUserBased=true&variable=Virtual_Desktop_Failures&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
			scope:this,
			method: 'POST',
			timeout:280000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					me.loadVirtualDesktopFailure(jsonData)
				}
				myMask5.destroy();
			}
		});

		//Logon Activity vs Slow Logons
		var myMask6 = new Ext.LoadMask(Ext.getCmp('logonvsSlowLogins'), {msg:"Loading..."});
		myMask6.show();	
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Logon_Performance_KPI_Page&time_line=&isUserBased=true&variable=Logon_Activity_vs_Slow_Logins_Widget&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
			scope:this,
			method: 'POST',
			timeout:280000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					me.loadLogonvsSlowLogins(jsonData)
				}
				myMask6.destroy();
			}
		});

		//Top Users by Profile & GPO
		var myMask7 = new Ext.LoadMask(Ext.getCmp('topUsers0'), {msg:"Loading..."});
		myMask7.show();	
		var myMask8 = new Ext.LoadMask(Ext.getCmp('topUsers1'), {msg:"Loading..."});
		myMask8.show();	
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=KPI_UX_ANALYSIS&time_line=&isUserBased=true&variable=Top_Users_Analysis&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
			scope:this,
			method: 'POST',
			timeout:280000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					me.loadTopUsersProfileGpo(jsonData)
				}
				myMask7.destroy();
				myMask8.destroy();
			}
		});
	},
	listeners:{
		boxready:function()
		{
			var me = this;
			var sliderTimelineVal = null;
			try
			{
				sliderTimelineVal = logon_timelinecombo.items[logon_timelinecombo.selectIntvalue].value;
			}
			catch (e)
			{
			}
			//Logon Activity
			var myMask1 = new Ext.LoadMask(Ext.getCmp('loadLogonActivity'), {msg:"Loading..."});
			myMask1.show();	
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Logon_Performance_KPI_Page&time_line=&isUserBased=true&variable=Logon_Activity_Widget&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						me.loadLogonActivity(jsonData)
					}
					myMask1.destroy();
				}
			});

			//Logon BreakDown Time
			var myMask2 = new Ext.LoadMask(Ext.getCmp('logonBreakDownTime'), {msg:"Loading..."});
			myMask2.show();	
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Logon_Performance_KPI_Page&time_line=&isUserBased=true&variable=Logon_Breakdown_Over_Time_Widget&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						me.logonBreakDownTime(jsonData)
					}
					myMask2.destroy();
				}
			});

			//Logon Duration & Activity by Delivery Group
			var myMask3 = new Ext.LoadMask(Ext.getCmp('logonDeliveryGrp0'), {msg:"Loading..."});
			myMask3.show();	
			var myMask4 = new Ext.LoadMask(Ext.getCmp('logonDeliveryGrp1'), {msg:"Loading..."});
			myMask4.show();	
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=KPI_UX_ANALYSIS&time_line=&isUserBased=true&variable=Delivery_Group_Logon_Duration&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						me.loadLogonActvityDuration(jsonData)
					}
					myMask3.destroy();
					myMask4.destroy();
				}
			});

			//Virtual Desktop Failures
			var myMask5 = new Ext.LoadMask(Ext.getCmp('virtualDesktopFailure'), {msg:"Loading..."});
			myMask5.show();	
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Logon_Performance_KPI_Page&time_line=&isUserBased=true&variable=Virtual_Desktop_Failures&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						me.loadVirtualDesktopFailure(jsonData)
					}
					myMask5.destroy();
				}
			});

			//Logon Activity vs Slow Logons
			var myMask6 = new Ext.LoadMask(Ext.getCmp('logonvsSlowLogins'), {msg:"Loading..."});
			myMask6.show();	
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Logon_Performance_KPI_Page&time_line=&isUserBased=true&variable=Logon_Activity_vs_Slow_Logins_Widget&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						me.loadLogonvsSlowLogins(jsonData)
					}
					myMask6.destroy();
				}
			});

			//Top Users by Profile & GPO
			var myMask7 = new Ext.LoadMask(Ext.getCmp('topUsers0'), {msg:"Loading..."});
			myMask7.show();	
			var myMask8 = new Ext.LoadMask(Ext.getCmp('topUsers1'), {msg:"Loading..."});
			myMask8.show();	
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=KPI_UX_ANALYSIS&time_line=&isUserBased=true&variable=Top_Users_Analysis&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						me.loadTopUsersProfileGpo(jsonData)
					}
					myMask7.destroy();
					myMask8.destroy();
				}
			});
		}
	},
	loadLogonActivity:function(jsonData)
	{
		var me = this;
		//console.log("jsonData=-=-=-loadLogonActivity>>",jsonData)
		if(!Ext.isEmpty(jsonData.result))
		{
			var dataChart = jsonData.dataArr;
			Ext.getCmp('loadLogonActivity').loadChart(jsonData.result[0]);			
		}
	},
	logonBreakDownTime:function(jsonData)
	{
		var me = this;
		//console.log("jsonData=-=-=-logonBreakDownTime>>",jsonData)
		if(!Ext.isEmpty(jsonData.result))
		{
			var dataChart = jsonData.dataArr;
			Ext.getCmp('logonBreakDownTime').loadChart(jsonData.result[0]);			
		}
	},
	loadLogonActvityDuration:function(jsonData)
	{
		var me = this;
		//console.log("jsonData=-=-=-loadLogonActvityDuration>>",jsonData)
		if(!Ext.isEmpty(jsonData.dataArr))
		{
			var dataChart = jsonData.dataArr;
			for(var t=0;t<dataChart.length;t++)
			{
				//console.log("dataChart[t]-==-=->>",dataChart[t].chartType)
				if(dataChart[t].chartType == "line")
				{
					Ext.getCmp('logonDeliveryGrp'+t).loadChart(dataChart[t]);
				}
				else if(dataChart[t].chartType == "stackedBar")
				{
					Ext.getCmp('logonDeliveryGrp'+t).loadChart(dataChart[t]);
				}
			}
		}
	},
	loadVirtualDesktopFailure:function(jsonData)
	{
		var me = this;
		//console.log("jsonData=-=-=-loadVirtualDesktopFailure>>",jsonData)
		if(!Ext.isEmpty(jsonData.result))
		{
			var dataChart = jsonData.dataArr;
			Ext.getCmp('virtualDesktopFailure').loadChart(jsonData.result[0]);			
		}
	},
	loadLogonvsSlowLogins:function(jsonData)
	{
		var me = this;
		//console.log("jsonData=-=-=-loadLogonvsSlowLogins>>",jsonData)
		if(!Ext.isEmpty(jsonData.result))
		{
			var dataChart = jsonData.dataArr;
			Ext.getCmp('logonvsSlowLogins').loadChart(jsonData.result[0]);			
		}
	},
	loadTopUsersProfileGpo:function(jsonData)
	{
		var me = this;
		if(!Ext.isEmpty(jsonData.dataArr))
		{
			var dataChart = jsonData.dataArr;
			for(var t=0;t<dataChart.length;t++)
			{
				Ext.getCmp('topUsers'+t).loadChart(dataChart[t]);
			}
		}
	}
});