Ext.define('EgCitrixDashCloud.view.Sessions.SessionsTopView', {
	extend: 'Ext.panel.Panel',
	alias: 'widget.sessionstopview',
	margin: '0 0 5 0',
	bodyPadding: '20 20 10 20',
	height: 322,
	//header: {
		//margin: '0 20'
	//},
	titleAlign: "center",
	ui: 'round-corners',
	border: false,
	autoScroll: false,
	scroll: false,
	layout: {
		type: 'hbox',
		align: 'stretch'
	},
	//title: '<div id="backMain" style="float:left;" class="iconRoundLeftArrow handSymbol"></div>LOGON TOP VIEW',
	//title: '',
	updatePage:function(sliderTimelineVal)
	{
		var me = this;
		var myMaskTop1 = new Ext.LoadMask(Ext.getCmp('sessionDonut'), {msg:"Loading..."});
		myMaskTop1.show();	
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=Active_Problemtic_Session&time_line=&isUserBased=true&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
			scope:this,
			method: 'POST',
			timeout:280000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					Ext.getCmp('sessionDonut').loadChart(jsonData);
				}
				myMaskTop1.destroy();
			}
		});
		
		var myMaskTop2 = new Ext.LoadMask(Ext.getCmp('sessionWeeklyReport'), {msg:"Loading..."});
		myMaskTop2.show();
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Active_Sessions_Performance_KPI_Page&time_line=&isUserBased=true&variable=Weekly_Compare_Session_Widget&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
			scope:this,
			method: 'POST',
			timeout:280000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					Ext.getCmp('sessionWeeklyReport').loadChart(jsonData.result[0]);
				}
				myMaskTop2.destroy();
			}
		});
		
		var myMaskTop3 = new Ext.LoadMask(Ext.getCmp('sessionDurationTrend'), {msg:"Loading..."});
		myMaskTop3.show();
		Ext.Ajax.request({
			url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Active_Sessions_Performance_KPI_Page&time_line=&isUserBased=true&variable=Session_Trend_Widget&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
			scope:this,
			method: 'POST',
			timeout:280000,
			success: function( response )
			{
				if ( response.status == 200 && !Ext.isEmpty(response.responseText))
				{
					var jsonText = response.responseText;
					var jsonData = Ext.decode(jsonText);
					Ext.getCmp('sessionDurationTrend').loadChart(jsonData.result[0]);
				}
				myMaskTop3.destroy();
			}
		});			
	},
	listeners: {
		boxready: function () {
			var me = this;
			var myMaskTop1 = new Ext.LoadMask(Ext.getCmp('sessionDonut'), {msg:"Loading..."});
			myMaskTop1.show();	
			var sliderTimelineVal = null;
			try
			{
				sliderTimelineVal = logon_timelinecombo.items[logon_timelinecombo.selectIntvalue].value
			}
			catch (e)
			{
			}
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=Active_Problemtic_Session&time_line=&isUserBased=true&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						Ext.getCmp('sessionDonut').loadChart(jsonData);
					}
					myMaskTop1.destroy();
				}
			});
			
			var myMaskTop2 = new Ext.LoadMask(Ext.getCmp('sessionWeeklyReport'), {msg:"Loading..."});
			myMaskTop2.show();
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Active_Sessions_Performance_KPI_Page&time_line=&isUserBased=true&variable=Weekly_Compare_Session_Widget&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						Ext.getCmp('sessionWeeklyReport').loadChart(jsonData.result[0]);
					}
					myMaskTop2.destroy();
				}
			});
			
			var myMaskTop3 = new Ext.LoadMask(Ext.getCmp('sessionDurationTrend'), {msg:"Loading..."});
			myMaskTop3.show();
			Ext.Ajax.request({
				url: '/final/servlet/com.eg.EgCommonDashboardController?isFrom=KPIHome&iniName=&user_name='+queryReqParams.userName+'&action=loadViewData&subject=SAAS_Active_Sessions_Performance_KPI_Page&time_line=&isUserBased=true&variable=Session_Trend_Widget&sliderTimeline='+sliderTimelineVal+'&zoneName='+queryReqParams.zoneName,
				scope:this,
				method: 'POST',
				timeout:280000,
				success: function( response )
				{
					if ( response.status == 200 && !Ext.isEmpty(response.responseText))
					{
						var jsonText = response.responseText;
						var jsonData = Ext.decode(jsonText);
						Ext.getCmp('sessionDurationTrend').loadChart(jsonData.result[0]);
					}
					myMaskTop3.destroy();
				}
			});			
		}
	},
	items: [{
		xtype: 'panel',
		title:'',
		ui:'ui-x-panel',
		style:{'box-shadow':'none !important'},
		flex:0.6,
		margin: '0 20 10 20',
		bodyPadding: '20px 0 0 0',
		id:'sessionDonut',
		listeners: {
			resize: function (container, width, height, oldWidth, oldHeight, eOpts) {
				if (!Ext.isEmpty(oldWidth)) {
					var chart = $('#' + container.body.id).highcharts();
					chart.reflow();
				}
			}			
		},
		loadChart:function(data) {
			this.setTitle('<div style="text-align:center;font-weight:500;font-family: Roboto;font-size: 12px;">'+data.title+'</div>');
			data.isLegendEnabled = true;
			retChartData = EgCitrixDashCloud.config.Runtime.getBigDonutGraphData('#' + this.body.id, data, false);
			$('#' + this.body.id).highcharts(retChartData);
		}
	},{
		xtype: 'tbseparator',
		margin: '20 5 10 10'
	},{
		xtype: 'container',
		id:'sessionWeeklyReport',
		flex: 1,
		margin: '0 20',
		listeners: {
			resize: function (container, width, height, oldWidth, oldHeight, eOpts) {
				if (!Ext.isEmpty(oldWidth)) {
					var chart = $('#' + container.id).highcharts();
					try
					{
						chart.reflow();	
					}
					catch (e)
					{
					}
					
				}
			}			
		},
		loadChart: function (chartdata) {
			retChartData = EgCitrixDashCloud.config.Runtime.areaChart('#' + this.id, chartdata,true);
			$('#' + this.id).highcharts(retChartData);			
		}
	},
	{
		xtype: 'tbseparator',
		margin: '20 5 10 10'
	},
	{
		xtype: 'container',
		id:'sessionDurationTrend',
		flex: 1,
		margin: '0 20',
		listeners: {
			resize: function (container, width, height, oldWidth, oldHeight, eOpts) {
				if (!Ext.isEmpty(oldWidth)) {
					var chart = $('#' + container.id).highcharts();
					chart.reflow();
				}
			}			
		},
		loadChart: function (chartData) {

			retChartData = EgCitrixDashCloud.config.Runtime.areaRangeLine('#'+this.id,chartData);
			$('#'+this.id).highcharts(retChartData);
			
		}
	}]
});