Ext.define('monitorhealth.controller.InfrastructureHealthView', {
    extend: 'Ext.app.Controller',
    views:['monitorhealth.view.InfrastructureHealthView','ErrorPanel'],
    jsonData:null,
    
    refs:[{
    	ref:'healthViewMenu',
		selector:'infrastructurehealthviewmenu'
    },{
    	ref:'healthViewData',
    	selector:'infrastructurehealthviewdata'
    },{
    	ref:'infrastructureHealthView',
    	selector:'infrastructurehealthview'
    },{
		ref:'main',
		selector:'main'
	}],
    
    init: function() {
		this.control({
			'infrastructurehealthviewmenu > button':{
				//'click':this.healthViewMenuClick,
				'afterrender':function(button){
					var htmlContent = '<a href="javascript:void(0);" class="infra-health mouse"><span class="left" >'
						  +'<div id = "menuItem'+button.itemNumber+'" class="flashobj"></div>'
						  +'</span>'
						  +'<span class="right menu-title">'+button.contentText+'<br/>'+button.contentTotal+'</span></a>';

					FusionCharts.setCurrentRenderer('javascript');

					button.update(htmlContent);

					FusionCharts.debugMode.enable = true;
					FusionCharts.debugMode.outputTo(console.log);

					if(FusionCharts("infraItemId_"+button.itemNumber))
						FusionCharts("infraItemId_"+button.itemNumber).dispose();
					var healthChart = new FusionCharts('/final/FusionCharts/swf/Doughnut2D.swf','infraItemId_'+button.itemNumber, '90', '60', '0', '1');
					healthChart.setDataXML(button.xmlData);
					healthChart.setTransparent(true);
					healthChart.render(button.idString);

					htmlContent = null ;
					delete htmlContent;

					healthChart = null;
					delete healthChart;
				}
			}
		});
	},
	
	infrastructureHealthViewRender:function(jsonData){
		this.jsonData=jsonData;
		if(!Ext.isEmpty(jsonData) && !Ext.isEmpty(jsonData.healthView) && !Ext.isEmpty(jsonData.healthView.componentslist)){
			if(this.getInfrastructureHealthView().query('errorpanel')){
				this.getInfrastructureHealthView().removeAll(false);
				this.getInfrastructureHealthView().add([
					this.getHealthViewMenu(),this.getHealthViewData()
				]);
			}
			this.getHealthViewMenu().createMenuItems(jsonData.healthView.componentslist);

			if(!Ext.isEmpty(jsonData.screenLabels)){
				//this.getInfrastructureHealthView().setTitle(jsonData.screenLabels["Infrastructure Health"]);
				this.getInfrastructureHealthView().setTitle("Components At-A-Glance");
			} 

			if (lasInfrastructureMenuSelection == 'components' )
			{
				this.getHealthViewData().createMenuItems("components",jsonData.healthView.components,jsonData.screenLabels);	//default show components view
			}
			else if ( lasInfrastructureMenuSelection == 'zones' )
			{
				this.getHealthViewData().createMenuItems("zones",jsonData.healthView.zones,jsonData.screenLabels);	//default show components view
			}
			else if ( lasInfrastructureMenuSelection == 'services' )
			{
				this.getHealthViewData().createMenuItems("services",jsonData.healthView.services,jsonData.screenLabels);	//default show components view
			}
			else if ( lasInfrastructureMenuSelection == 'serviceGroups' )
			{
				this.getHealthViewData().createMenuItems("serviceGroups",jsonData.healthView.serviceGroups,jsonData.screenLabels);	//default show components view
			}
			else if ( lasInfrastructureMenuSelection == 'segments' )
			{
				this.getHealthViewData().createMenuItems("segments",jsonData.healthView.segments,jsonData.screenLabels);	//default show components view
			}
			else if ( lasInfrastructureMenuSelection == 'aggregates' )
			{
				this.getHealthViewData().createMenuItems("aggregates",jsonData.healthView.aggregates,jsonData.screenLabels);	//default show components view
			}
			else
			{
				var selectedInfraStructure = jsonData['selectedInfraStructure'];
				if(!Ext.isEmpty(selectedInfraStructure))
				{
					var healthViewMenu = this.getHealthViewMenu();
					for(var menu=0;menu<healthViewMenu.items.getCount();menu++){
						var menuBtn=healthViewMenu.items.getAt(menu);
						if(!Ext.isEmpty(menuBtn.id) && menuBtn.action==selectedInfraStructure)
						{
							menuBtn.removeCls('non-selected-menu');
							menuBtn.addCls('selected-menu');
						}
						else
						{
							menuBtn.removeCls('selected-menu');
							menuBtn.addCls('non-selected-menu');
						}
						menuBtn = null;
						delete menuBtn;
						
					}
					healthViewMenu = null;
					delete healthViewMenu;

					var healthViewData = null;
					switch(selectedInfraStructure){
					case "zones": healthViewData=this.jsonData.healthView.zones;
								  break;
					case "services": healthViewData=this.jsonData.healthView.services;
									 break;
					case "serviceGroups" : healthViewData=this.jsonData.healthView.serviceGroups;
									 break;
					case "segments": healthViewData=this.jsonData.healthView.segments;
									 break;
					case "aggregates": healthViewData=this.jsonData.healthView.aggregates;
									 break;
					case "components": healthViewData=this.jsonData.healthView.components;
									 break;
					}
					if(healthViewData!=null)
						this.getHealthViewData().createMenuItems(selectedInfraStructure,healthViewData,this.jsonData.screenLabels);
					this.getMain().doLayout();

					healthViewData = null;
					delete healthViewData;
				}

				selectedInfraStructure = null;
				delete selectedInfraStructure;
			}
		}
		jsonData = null;
		Ext.destroy(jsonData);
	},
	
	healthViewMenuClick:function(btn){
		lasInfrastructureMenuSelection = btn.action;
		var jsonData=null;
		var healthViewMenu=this.getHealthViewMenu();
		for(var menu=0;menu<healthViewMenu.items.getCount();menu++){
			var menuBtn=healthViewMenu.items.getAt(menu);
			menuBtn.removeCls('selected-menu');
			menuBtn.addCls('non-selected-menu');
		
			menuBtn = null;
			delete menuBtn;

		}
		
		switch(btn.action){
		case "zones": jsonData=this.jsonData.healthView.zones;
					  break;
		case "services": jsonData=this.jsonData.healthView.services;
						 break;
		case "serviceGroups" : jsonData=this.jsonData.healthView.serviceGroups;
						 break;
		case "segments": jsonData=this.jsonData.healthView.segments;
		 				 break;
		case "aggregates": jsonData=this.jsonData.healthView.aggregates;
		 				 break;
		case "components": jsonData=this.jsonData.healthView.components;
						 break;
		case "virtual_components": jsonData=this.jsonData.healthView.virtual_components;
						 break;
		}
		btn.addCls('selected-menu');
		this.getHealthViewData().createMenuItems(btn.action,jsonData,this.jsonData.screenLabels);
		this.getMain().doLayout();

		jsonData = null;
		Ext.destroy(jsonData);

		healthViewMenu = null;
		delete healthViewMenu;
	}
});