Ext.define('monitorhealth.controller.Main', {
    extend: 'Ext.app.Controller',
    //views:['monitor.view.Main','utilities.ErrorPanel','monitor.view.DashboardSummary','monitor.view.DashboardSummaryChart','monitor.view.MeasureAndAnalysisTab','monitor.view.InfrastructureHealthView'],
	views:['monitorhealth.view.Main','utilities.ErrorPanel','monitorhealth.view.InfrastructureHealthView'],
    refs:[{
    	ref:'main',
		selector:'main'
    },{
    	ref:'infrastructureHealthView',
		selector:'infrastructurehealthview'
    },
	{
    	ref:'healthViewData',
    	selector:'infrastructurehealthviewdata'
    }],

    init: function() {
		setInterval("execute()",monitorRefreshFrequency);
		   this.control({
			   'main':{
				    scope:this,
					beforerender: this.refreshDashboard
			   },
				'infrastructurehealthview trigger':{
					specialkey: this.searchKeyPress,
					click : this.searchData
				}
		   });
	},

	searchKeyPress:function(field,e){
		if (e.getKey() == e.ENTER) {
			this.searchData(field);
		}
	},
	searchData:function(field){
		if(field == null || field == undefined || field.value == null || field.value == undefined)
			return;

		var searchText = field.value;
		if(!Ext.isEmpty(searchText) && searchText != null && searchText != undefined)
		{
			if(searchText == '(' || searchText == ')' || searchText == '\\' || searchText == '?' || searchText == '[')
			{
				Ext.MessageBox.show({
					title: 'Alert',
					msg: 'Please enter the valid search pattern',
					buttons: Ext.MessageBox.OK,
					icon: Ext.MessageBox.WARNING
				});
				return;
			}
			else
			{
				var jsondata = this.getController('InfrastructureHealthView').jsonData;

				var selectedInfraStructure = "";
				if(!Ext.isEmpty(lasInfrastructureMenuSelection) && lasInfrastructureMenuSelection != null && lasInfrastructureMenuSelection != undefined)
					selectedInfraStructure = lasInfrastructureMenuSelection;
				else
					selectedInfraStructure = jsondata['selectedInfraStructure'];
				if(!Ext.isEmpty(selectedInfraStructure))
				{
					var healthViewData = null;
					if(selectedInfraStructure == 'components')
					{
						healthViewData = jsondata.healthView.components;
					}
					else if(selectedInfraStructure == 'aggregates')
					{
						healthViewData = jsondata.healthView.aggregates;
					}
					else if(selectedInfraStructure == 'segments')
					{
						healthViewData = jsondata.healthView.segments;
					}
					else if(selectedInfraStructure == 'serviceGroups')
					{
						healthViewData = jsondata.healthView.serviceGroups;
					}
					else if(selectedInfraStructure == 'services')
					{
						healthViewData = jsondata.healthView.services;
					}
					else if(selectedInfraStructure == 'zones')
					{
						healthViewData = jsondata.healthView.zones;
					}

					if(!Ext.isEmpty(healthViewData) && healthViewData != null && healthViewData != undefined){
						var finalHealthViewData = new Array();
						var value = null;
						for(var k=0;k<healthViewData.length;k++)
						{
							if(selectedInfraStructure == 'components' || selectedInfraStructure == 'aggregates')
								value = healthViewData[k].compType;
							else
								value = healthViewData[k].displayName;

							value = value.toLowerCase();
							if((value == searchText.toLowerCase()) || (value.indexOf(searchText.toLowerCase()) >= 0))
							{
								finalHealthViewData.push(healthViewData[k]);
							}
						}
						if(!Ext.isEmpty(finalHealthViewData) && finalHealthViewData != null)
							this.getHealthViewData().createMenuItems(selectedInfraStructure,finalHealthViewData,jsondata.screenLabels);
						else{
							Ext.MessageBox.show({
								title: 'Alert',
								msg: 'No '+selectedInfraStructure+' Found for the search text - '+searchText,
								buttons: Ext.MessageBox.OK,
								icon: Ext.MessageBox.WARNING
							});
							field.setValue('');
							field.focus();
						}

					}
				}
			}
		}
		else
		{
			var jsondata = this.getController('InfrastructureHealthView').jsonData;

			var selectedInfraStructure = "";
			if(!Ext.isEmpty(lasInfrastructureMenuSelection) && lasInfrastructureMenuSelection != null && lasInfrastructureMenuSelection != undefined)
				selectedInfraStructure = lasInfrastructureMenuSelection;
			else
				selectedInfraStructure = jsondata['selectedInfraStructure'];

			if(!Ext.isEmpty(selectedInfraStructure))
			{
				var healthViewData = null;
				if(selectedInfraStructure == 'components')
				{
					healthViewData = jsondata.healthView.components;
				}
				else if(selectedInfraStructure == 'aggregates')
				{
					healthViewData = jsondata.healthView.aggregates;
				}
				else if(selectedInfraStructure == 'segments')
				{
					healthViewData = jsondata.healthView.segments;
				}
				else if(selectedInfraStructure == 'serviceGroups')
				{
					healthViewData = jsondata.healthView.serviceGroups;
				}
				else if(selectedInfraStructure == 'services')
				{
					healthViewData = jsondata.healthView.services;
				}
				else if(selectedInfraStructure == 'zones')
				{
					healthViewData = jsondata.healthView.zones;
				}

				if(!Ext.isEmpty(healthViewData) && healthViewData != null && healthViewData != undefined){
					this.getHealthViewData().createMenuItems(selectedInfraStructure,healthViewData,jsondata.screenLabels);
				}
			}
		}
	},
	refreshDashboard:function(){
		var dataURL = '../servlet/com.eg.EgMonitorController?monCmd=jsonResponse&healthView=yes';
		var jsonData;
		var me = this;
		Ext.Ajax.request({
			url : dataURL,
			success: function(response){
				jsonData = Ext.decode(response.responseText);
				
				if(!Ext.isEmpty(me.getInfrastructureHealthView()) && !Ext.isEmpty(jsonData.infraHealth) && !Ext.isEmpty(jsonData.infraHealth.healthView) && !Ext.isEmpty(jsonData.infraHealth.healthView.componentslist))
				{
					Ext.getCmp('errorId').hide();
					Ext.getCmp('infrastructurehealthview').show();
					me.getMain().show();

					var infHealthController=me.getController('InfrastructureHealthView');
					infHealthController.infrastructureHealthViewRender(jsonData.infraHealth);

					infHealthController = null;
					delete infHealthController;

					me.getMain().doLayout();
					var searchField = Ext.getCmp('searchBox');
					if(!Ext.isEmpty(searchField.getValue())){
						me.searchData(searchField);
					}
				}
				else{

					me.getMain().show();
					Ext.getCmp('errorId').show();
					Ext.getCmp('infrastructurehealthview').hide();
					me.getMain().doLayout();
				}
				
			},
			failure : function(){
				window.parent.location.href="/final/servlet/com.egurkha.Logout";
			}
		});

		dataURL=null;
		delete dataURL;

		jsonData = null;
		Ext.destroy(jsonData);

		delete me;
	}
});