// Altered by Premkumar. A for FusionChart change
//FusionCharts.setCurrentRenderer('javascript');
Ext.define('monitorhealth.view.InfrastructureHealthViewMenu', {
	extend: 'Ext.panel.Panel',
	alias:'widget.infrastructurehealthviewmenu',
	id:'infrastructurehealthviewmenu',
	scroll:true,	//
	autoScroll:true,
	internalScrollPosition:0,
	initialInnerHeight:0,
	border:true,
	cls:'border-right',
	dockedItems: [{
		xtype: 'toolbar',
		dock: 'bottom',
		id:'menuDock',
		buttonAlign:'center',
		padding:'0 0 0 80',
	}],

	layout: {
		type: 'vbox',
		align: 'stretch',
		defaultMargins:0,
		pack:'start'
	},
	createMenuItems:function(componentList){
		if(!Ext.isEmpty(componentList)){
			this.items.removeAll();
			this.removeAll();
			itemsArray = new Array();
			var menu = null;
			for(var item = 0; item < componentList.length; item++){
				var xmlData = componentList[item].xmlData;

				var placeHolder = Ext.fly('infrastructurehealthviewmenu-body'),
				containerInner = placeHolder.getComputedHeight( ),
				containerWidth = placeHolder.getComputedWidth( ),
				setButtonHeight = containerInner/3, // Setting height of button dynamically
				menu={
					xtype:'button',
					cls:'menu-button non-selected-menu',
					height:Math.round(setButtonHeight),
					width:containerWidth,
					padding:'0 0 0 0',
					overCls:'hover-menu',
					xmlData:xmlData,
					itemNumber:item,
					contentText:"<div style='float:left;margin-left:-8px'>"+componentList[item].text+"</div> <div style='float:right'>"+componentList[item].total+"</div>",
					contentTotal:'',
					//contentText:componentList[item].text,
					//contentTotal:componentList[item].total,
					idString:'menuItem'+item,
					action:componentList[item].id,
					onMouseDown:function(){				// For InfraStructure Menu Button Click
						monitor.app.getController('InfrastructureHealthView').healthViewMenuClick(this);
					},
					
				};

				//delete menu, itemsArray;
				if ( componentList[item].id == lasInfrastructureMenuSelection )
				{
					menu.cls = 'menu-button selected-menu';
				}
				else if(item==componentList.length-1 && lasInfrastructureMenuSelection == '' ){
					menu.cls='menu-button selected-menu';
				}
				itemsArray.push(menu);

				xmlData = null;
				delete xmlData;

				placeHolder = null;
				delete placeHolder;

				containerWidth = null;
				delete containerWidth;

				setButtonHeight = null;
				delete setButtonHeight;
			}
			this.suspendEvents(true);
			this.add(itemsArray);
			this.resumeEvents();
			//this.doLayout();

			itemsArray = null;
			delete itemsArray;

			menu = null;
			delete menu;
		}
	},
	initComponent: function () {
		this.callParent();
	},
});